/*
 * Decompiled with CFR 0.152.
 */
package com.idtechproducts.device.audiojack.tasks;

import com.idtechproducts.device.Common;
import com.idtechproducts.device.IDT_Device;
import com.idtechproducts.device.ReaderInfo;
import com.idtechproducts.device.audiojack.ReaderCommunication;
import com.idtechproducts.device.audiojack.UMLog;
import com.idtechproducts.device.audiojack.io.IOManager;
import com.idtechproducts.device.audiojack.io.ToneType;
import com.idtechproducts.device.audiojack.tasks.Task;
import com.idtechproducts.device.audiojack.tasks.TaskManager;

public class ConnectTask
extends Task {
    private final boolean a;
    private IDT_Device.TaskExport b;
    private Common.PUSType c;

    public ConnectTask(TaskManager taskManager, ReaderCommunication readerCommunication, boolean bl, IDT_Device.TaskExport taskExport) {
        super(taskManager, readerCommunication);
        this.a = bl;
        this.b = taskExport;
    }

    public ConnectTask(TaskManager taskManager, ReaderCommunication readerCommunication, Common.PUSType pUSType) {
        super(taskManager, readerCommunication);
        this.a = false;
        this.b = null;
        this.c = pUSType;
    }

    @Override
    public TaskManager.TaskType getType() {
        return TaskManager.TaskType.Connect;
    }

    @Override
    protected void taskCleanup() {
        if (this._ioManager != null) {
            this._ioManager.notifyTaskFinished();
        }
    }

    @Override
    protected Runnable taskMain() {
        Object object;
        if (this.c != null) {
            UMLog.i(this.TAG, "connected " + this.c.name);
            if (this._config.getVolumeLevelAdjust() > 1) {
                this._ioManager.setDeviceMediaVolumeToMaxMinusArg(1);
            }
            Common.PUSType pUSType = this.c;
            return new Runnable(this, pUSType){
                private /* synthetic */ ConnectTask a;
                private final /* synthetic */ Common.PUSType b;
                {
                    this.a = connectTask;
                    this.b = pUSType;
                }

                @Override
                public final void run() {
                    if (this.b.readerType != null) {
                        this.a._readerCommunication.readerType_set(this.b.readerType);
                    }
                    Common.coverAllBaudRate = false;
                    this.a._readerCommunication.cxn_setConnected(ToneType.T_2000Hz);
                    Common.beginTimeEachCmd = Common.getCurrentTime();
                }
            };
        }
        Common.PUSType pUSType = null;
        Common.beginTimeEachCmd = Common.getCurrentTime();
        if (this.b.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_UNKNOWN) {
            this.b.setReaderType(ReaderInfo.DEVICE_TYPE.DEVICE_UNIMAG);
            this._ioManager.resetPlayer();
        }
        if (this.b.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ || this.b.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V) {
            String string = Common.packageCommandForVendi("5669564F7465636832000501000092EF");
            ConnectTask connectTask = this;
            object = this._readerCommunication.sendCommand(Common.getBytesFromHexString(string), 1.5, connectTask, connectTask);
            if (object != null && ((IOManager.RPDResult)object).data != null) {
                ((IOManager.RPDResult)object).data.clear();
            }
            object = Common.packageCommandForVendi("5669564F7465636832002C01000100380D");
            ConnectTask connectTask2 = this;
            object = this._readerCommunication.sendCommand(Common.getBytesFromHexString((String)object), 1.5, connectTask2, connectTask2);
            IDT_Device.isPassthroughModeOn = false;
            if (object != null && ((IOManager.RPDResult)object).data != null) {
                ((IOManager.RPDResult)object).data.clear();
            }
        }
        int n = 1;
        while (n <= 6) {
            if (n == 6 && this.b.getReaderType() != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ && this.b.getReaderType() != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V) {
                UMLog.i(this.TAG, "Connect Task: changing output wave direction");
                this._config.setDirectionOutputWave((short)(this._config.getDirectionOutputWave() != 1 ? 1 : 0));
                this._ioManager.setConfig(this._config);
            }
            if (this.a) {
                UMLog.i(this.TAG, "set baud rate and channel level. baudrate = " + this._config.getBaudRate() + " , level = " + this._config.getShuttleChannel());
                if (this.b.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_UNIMAG) {
                    UMLog.i(this.TAG, "Try to connect for UNIMAG with " + this._config.getBaudRate() + " baud rate");
                    ConnectTask connectTask = this;
                    object = this._readerCommunication.connect(Common.makeSetBaudCommand(this._config), 1.5, connectTask, connectTask);
                } else if (this.b.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_UNIJACK) {
                    UMLog.i(this.TAG, "Try to connect for UNIJACK with " + this._config.getBaudRate() + " baud rate");
                    ConnectTask connectTask = this;
                    object = this._readerCommunication.connect(Common.makeSetBaudCommandForUniJack(this._config), 1.0, connectTask, connectTask);
                } else if (this.b.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ || this.b.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V) {
                    UMLog.i(this.TAG, "Try to connect for VP3300 AJ with " + this._config.getBaudRate() + " baud rate");
                    ConnectTask connectTask = this;
                    object = this._readerCommunication.connect(Common.makeSetBaudAndLevelCommand(this._config, this._config.getBaudRate()), 1.5, connectTask, connectTask);
                    if (object != null && ((IOManager.RPDResult)object).data != null && ((IOManager.RPDResult)object).data.size() > 0 && ((IOManager.RPDResult)object).data.get(0) != null && (Common.getHexStringFromBytes(((IOManager.RPDResult)object).data.get(0)).equalsIgnoreCase("5669564F74656368320030000000480E") || Common.getHexStringFromBytes(((IOManager.RPDResult)object).data.get(0)).equalsIgnoreCase("4500550304030000007F6D"))) {
                        UMLog.i(this.TAG, "connected");
                        return new Runnable(this){
                            private /* synthetic */ ConnectTask a;
                            {
                                this.a = connectTask;
                            }

                            @Override
                            public final void run() {
                                this.a._readerCommunication.cxn_setConnected(null);
                            }
                        };
                    }
                } else {
                    UMLog.i(this.TAG, "Try to connect for UNIPAY with " + this._config.getBaudRate() + " baud rate");
                    ConnectTask connectTask = this;
                    object = this._readerCommunication.connect(Common.makeSetBaudAndLevelCommand(this._config, this._config.getBaudRate()), 3.0, connectTask, connectTask);
                }
                if (((IOManager.RPDResult)object).isCanceledOrFailed()) {
                    return null;
                }
                if (((IOManager.RPDResult)object).isParsed() && (pUSType = Common.PUSType.parse(((IOManager.RPDResult)object).data)) != Common.PUSType.INVALID) {
                    break;
                }
            } else {
                UMLog.i(this.TAG, "tone");
                this._tonePlayer.setPlayingTone(ToneType.T_2400Hz);
                this._ioManager.setDeviceMediaVolumeToMax();
                ConnectTask connectTask = this;
                object = this._readerCommunication.sendCommand(null, 2.0, connectTask, connectTask);
                this._tonePlayer.setPlayingTone(null);
                if (((IOManager.RPDResult)object).isCanceledOrFailed()) {
                    return null;
                }
                if (((IOManager.RPDResult)object).isParsed() && (pUSType = Common.PUSType.parse(((IOManager.RPDResult)object).data)) != Common.PUSType.INVALID) break;
            }
            if (this.safeWait(0.4)) {
                return null;
            }
            ++n;
        }
        if (this.isCanceled()) {
            return null;
        }
        if (pUSType == null || this.b.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ || this.b.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V) {
            UMLog.i(this.TAG, "timed out");
            return new Runnable(this){
                private /* synthetic */ ConnectTask a;
                {
                    this.a = connectTask;
                }

                @Override
                public final void run() {
                    Common.beginTimeEachCmd = Common.getCurrentTime();
                    this.a._umrMsg.timeout(23);
                }
            };
        }
        UMLog.i(this.TAG, "connected " + pUSType.name);
        if (this._config.getVolumeLevelAdjust() > 1) {
            this._ioManager.setDeviceMediaVolumeToMaxMinusArg(1);
        }
        Common.PUSType pUSType2 = pUSType;
        return new Runnable(this, pUSType2){
            private /* synthetic */ ConnectTask a;
            private final /* synthetic */ Common.PUSType b;
            {
                this.a = connectTask;
                this.b = pUSType;
            }

            @Override
            public final void run() {
                if (this.b.readerType != null) {
                    this.a._readerCommunication.readerType_set(this.b.readerType);
                }
                Common.coverAllBaudRate = false;
                this.a._readerCommunication.cxn_setConnected(ToneType.T_2000Hz);
                Common.beginTimeEachCmd = Common.getCurrentTime();
            }
        };
    }
}

