/*
 * Decompiled with CFR 0.152.
 */
package com.zeamster.paymentsdk.transaction;

import android.app.Activity;
import com.idtechproducts.device.IDT_VP3300;
import com.idtechproducts.device.ReaderInfo;
import com.zeamster.paymentsdk.resthandler.HttpMethod;
import com.zeamster.paymentsdk.resthandler.RestServiceClient;
import com.zeamster.paymentsdk.service.IDTECHBLEService;
import com.zeamster.paymentsdk.transaction.ICallbackEMV;
import com.zeamster.paymentsdk.transaction.Transaction;
import com.zeamster.paymentsdk.transaction.TransactionAction;
import java.util.ArrayList;
import java.util.HashMap;

public class EMVTransaction
extends Transaction {
    private IDTECHBLEService idTechBLEService;

    public boolean isPluginRequest() {
        return this.idTechBLEService.isPluginRequest();
    }

    public void isPluginRequest(boolean pluginRequest) {
        this.idTechBLEService.isPluginRequest(pluginRequest);
    }

    public IDTECHBLEService getIdTechBLEService() {
        return this.idTechBLEService;
    }

    public ReaderInfo.DEVICE_TYPE getDeviceType() {
        return this.idTechBLEService.getDeviceType();
    }

    public void setDeviceType(ReaderInfo.DEVICE_TYPE deviceType) {
        this.idTechBLEService.setDeviceType(deviceType);
    }

    public IDT_VP3300 getIdt_vp3300() {
        return this.idTechBLEService.getIdt_vp3300();
    }

    public EMVTransaction(RestServiceClient restServiceClient, ICallbackEMV callbackEMV, Activity context, ReaderInfo.DEVICE_TYPE deviceType) {
        super(restServiceClient);
        this.idTechBLEService = new IDTECHBLEService(callbackEMV, context, deviceType);
    }

    public ArrayList scanForDevices() {
        return this.scanForDevices(0L);
    }

    public ArrayList scanForDevices(long timeout) {
        return this.scanForDevices("*", timeout);
    }

    public ArrayList scanForDevices(String searchString, long timeout) {
        return this.idTechBLEService.scanForDevices(searchString, timeout);
    }

    public void stopScanForDevices() {
        this.idTechBLEService.stopScanForDevices();
    }

    public boolean connectDeviceByName(String deviceName) {
        return this.idTechBLEService.connectDeviceByName(deviceName);
    }

    public boolean connectDeviceByAddress(String address) {
        return this.idTechBLEService.connectDeviceByAddress(address);
    }

    public void getFirmwareDetail() {
        this.idTechBLEService.getFirmwareDetail();
    }

    public void getSerialNumber() {
        this.idTechBLEService.getSerialNumber();
    }

    public void getAIDSettings() {
        this.idTechBLEService.getAIDSettings();
    }

    public void getCAPKSettings() {
        this.idTechBLEService.getCAPKSettings();
    }

    public void getTerminalSettings() {
        this.idTechBLEService.getTerminalSettings();
    }

    public void performSale(HashMap<String, Object> payLoad) {
        this.idTechBLEService.startEMVTransaction();
    }

    public void cancelSale() {
        this.idTechBLEService.cancelEMVTransaction();
    }

    public void performMSRSale(TransactionAction transactionAction, HashMap<String, Object> payLoad) {
        this.idTechBLEService.setEmvTransaction(this);
        this.idTechBLEService.setTransactionAction(transactionAction);
        this.idTechBLEService.setPayLoad(payLoad);
        this.idTechBLEService.startMSRTransaction();
    }

    public void cancelMSRSwipe() {
        this.idTechBLEService.cancelMSRSwipe();
    }

    public void performRefund(HashMap<String, Object> payLoad) {
        this.restServiceClient.setRequestBody(this.convertToTransactionPayload(payLoad));
        this.perform(HttpMethod.POST);
    }

    public void performAuthOnly(HashMap<String, Object> payLoad) {
        this.restServiceClient.setRequestBody(this.convertToTransactionPayload(payLoad));
        this.perform(HttpMethod.POST);
    }

    public void performAVSOnly(HashMap<String, Object> payLoad) {
        this.restServiceClient.setRequestBody(this.convertToTransactionPayload(payLoad));
        this.perform(HttpMethod.POST);
    }
}

