/*
 * Decompiled with CFR 0.152.
 */
package com.idtechproducts.device.bluetooth;

import android.app.Activity;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothSocket;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.util.Log;
import com.idtechproducts.device.Common;
import com.idtechproducts.device.IDTMSRData;
import com.idtechproducts.device.IDT_Device;
import com.idtechproducts.device.ReaderInfo;
import com.idtechproducts.device.ResDataStruct;
import com.idtechproducts.device.audiojack.UMLog;
import com.idtechproducts.device.bluetooth.BluetoothControllerMsg;
import com.idtechproducts.device.bluetooth.IDTechBluetoothMsg;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Set;
import java.util.UUID;

public class BluetoothController
extends Activity {
    private BluetoothDevice a = null;
    private static boolean b = false;
    private Context c = null;
    private static IDTechBluetoothMsg d = null;
    private a e;
    private Set<BluetoothDevice> f;
    private BluetoothAdapter g;
    private BroadcastReceiver h = null;
    private static boolean i = false;
    private InputStream j = null;
    private OutputStream k = null;
    private BluetoothSocket l = null;
    private boolean m = false;
    private int n;
    private int o = 0;
    private b p;
    private byte[] q;
    private byte[] r;
    private boolean s = false;
    private boolean t = false;
    private boolean u = false;

    public BluetoothController(Context context, IDTechBluetoothMsg iDTechBluetoothMsg, BluetoothControllerMsg bluetoothControllerMsg) {
        this.c = context;
        d = iDTechBluetoothMsg;
        this.q = new byte[1024];
        this.n = 200;
    }

    public static boolean isBTEnabled() {
        return i;
    }

    public boolean isConnected() {
        return b;
    }

    public boolean initWithThread() {
        Object object;
        if (b) {
            return true;
        }
        this.g = BluetoothAdapter.getDefaultAdapter();
        if (this.g == null) {
            return false;
        }
        if (!this.g.isEnabled()) {
            i = false;
            return false;
        }
        if (Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_BTPAY || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_BTMAG) {
            i = true;
            this.a = null;
            this.f = this.g.getBondedDevices();
            object = null;
            if (Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_BTPAY) {
                object = "BTPay";
            } else if (Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_BTMAG) {
                object = "BT MAG";
            }
            for (BluetoothDevice uUID2 : this.f) {
                if (!uUID2.getName().startsWith((String)object)) continue;
                this.a = uUID2;
                break;
            }
        }
        if (this.a == null) {
            return false;
        }
        object = this;
        UUID uUID = UUID.fromString("00001101-0000-1000-8000-00805f9b34fb");
        boolean bl = false;
        try {
            object.l = object.a.createInsecureRfcommSocketToServiceRecord(uUID);
            object.l.connect();
        }
        catch (IOException iOException) {
            bl = true;
        }
        if (bl) {
            object.j = null;
            object.k = null;
            if (object.l != null) {
                try {
                    object.l.close();
                }
                catch (IOException iOException) {}
            }
            object.l = null;
        } else {
            try {
                object.j = object.l.getInputStream();
                object.k = object.l.getOutputStream();
            }
            catch (IOException iOException) {
                object.j = null;
                object.k = null;
            }
        }
        return true;
    }

    public void startCheckingConnection() {
        UMLog.i("SDK::BT Controller", "SDK starts monitoring if reader is connected.");
        this.e = new a(this, 0);
        this.e.start();
    }

    public boolean isRegistered() {
        return this.s;
    }

    public void registerReceiver() {
        UMLog.i("SDK::BT Controller", "Register a Broadcast receiver to get BluetoothDevice.ACTION_FOUND.");
        this.h = new BroadcastReceiver(this){

            public final void onReceive(Context object, Intent intent) {
                object = intent.getAction();
                if ("android.bluetooth.device.action.FOUND".equals(object)) {
                    intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
                    return;
                }
                if ("android.bluetooth.device.action.ACL_CONNECTED".equals(object)) {
                    b = true;
                    d.bt_onReceiveMsgConnected();
                    return;
                }
                if ("android.bluetooth.device.action.ACL_DISCONNECTED".equals(object)) {
                    b = false;
                    d.bt_onReceiveMsgDisconnected();
                }
            }
        };
        IntentFilter intentFilter = new IntentFilter("android.bluetooth.device.action.FOUND");
        this.c.registerReceiver(this.h, intentFilter);
        intentFilter = new IntentFilter("android.bluetooth.device.action.ACL_CONNECTED");
        IntentFilter intentFilter2 = new IntentFilter("android.bluetooth.device.action.ACL_DISCONNECTED");
        this.c.registerReceiver(this.h, intentFilter);
        this.c.registerReceiver(this.h, intentFilter2);
        this.s = true;
    }

    public void unregisterReceiver() {
        UMLog.i("SDK::BT Controller", "A Broadcast receiver unregistered.");
        this.c.unregisterReceiver(this.h);
        BluetoothController bluetoothController = this;
        if (b) {
            bluetoothController.b();
            b = false;
        }
        System.gc();
        this.s = false;
    }

    public boolean enableSwipe() {
        if (!b || this.m) {
            return false;
        }
        UMLog.i("SDK::BT Controller", "SDK starts polling card data from reader.");
        if (this.p != null) {
            this.p.a();
        }
        this.p = new b(this, 0);
        this.m = true;
        this.o = 0;
        this.p.start();
        return true;
    }

    public boolean enableRead(int n, ResDataStruct resDataStruct) {
        if (!b) {
            return false;
        }
        long l = System.currentTimeMillis();
        UMLog.i("SDK::BT Controller", "SDK starts polling data from reader.");
        byte[] byArray = new byte[3];
        byArray[1] = 13;
        resDataStruct.resData = byArray;
        while (System.currentTimeMillis() - l < (long)((n + 10) * 1000)) {
            BluetoothController bluetoothController = this;
            int n2 = bluetoothController.a(bluetoothController.q);
            if (n2 > 0) {
                if (this.q[0] != 6) {
                    return false;
                }
                resDataStruct.resData = new byte[n2 - 1];
                System.arraycopy(this.q, 1, resDataStruct.resData, 0, n2 - 1);
                UMLog.i("SDK::BT Controller", "got: " + Common.getByteArrDesc(this.q));
                break;
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                InterruptedException interruptedException2 = interruptedException;
                interruptedException.printStackTrace();
            }
            if (n != 0) continue;
            l = System.currentTimeMillis();
        }
        return true;
    }

    public boolean readMessage(int n, long l, ResDataStruct resDataStruct) {
        if (!b) {
            return false;
        }
        byte[] byArray = new byte[3];
        byArray[1] = 13;
        resDataStruct.resData = byArray;
        byte[] byArray2 = new byte[2048];
        int n2 = 0;
        long l2 = System.currentTimeMillis();
        while (l2 - l <= (long)(n * 1000)) {
            Exception exception;
            if (IDT_Device.isTransactionRead && (IDT_Device.emvCancelTransaction || IDT_Device.cancelTransaction)) {
                Log.i((String)"SDK::BT Controller", (String)"## Transaction Cancelled ");
                return false;
            }
            try {
                n2 = this.j.available();
            }
            catch (IOException iOException) {
                exception = iOException;
                iOException.printStackTrace();
            }
            if (n2 > 0) {
                try {
                    n2 = this.j.read(byArray2);
                }
                catch (IOException iOException) {
                    exception = iOException;
                    iOException.printStackTrace();
                }
            }
            if (n2 > 0) break;
            try {
                Thread.sleep(300L);
            }
            catch (InterruptedException interruptedException) {
                exception = interruptedException;
                interruptedException.printStackTrace();
            }
            l2 = System.currentTimeMillis();
        }
        BluetoothController.a(this.j);
        IDT_Device.isTransactionRead = false;
        if (l2 - l > (long)(n * 1000)) {
            return false;
        }
        if (n2 > 0) {
            UMLog.i("**getResponse**", Common.base16Encode(resDataStruct.resData));
            d.bt_onReceiveMsgGetResponse(resDataStruct.resData);
            if (n2 > 6) {
                resDataStruct.resData = null;
                resDataStruct.resData = new byte[n2 - 6];
                System.arraycopy(byArray2, 3, resDataStruct.resData, 0, n2 - 6);
                return true;
            }
        }
        return false;
    }

    public void disableSwipe() {
        UMLog.i("SDK::BT Controller", "SDK stops polling card data from reader.");
        if (this.p != null) {
            this.p.a();
        }
        this.m = false;
    }

    public void setTimeoutOfSwipeCard(int n) {
        UMLog.i("SDK::BT Controller", "Timeout for card swipe changed to " + n + " seconds.");
        this.n = n;
    }

    public int cancelTransaction() {
        if (!this.u) {
            return 10;
        }
        this.t = true;
        return 0;
    }

    public byte[] sendCommand(byte[] object, int n) {
        if (!b || this.m) {
            UMLog.i("SDK::BT Controller", "Failed to send a command: ");
            this.m = false;
            return null;
        }
        try {
            Thread.sleep(300L);
        }
        catch (InterruptedException interruptedException) {
            InterruptedException interruptedException2 = interruptedException;
            interruptedException.printStackTrace();
        }
        long l = System.currentTimeMillis();
        byte[] byArray = new byte[2048];
        int n2 = 0;
        BluetoothController.a(this.j);
        try {
            this.k.write((byte[])object);
        }
        catch (IOException iOException) {
            object = iOException;
            iOException.printStackTrace();
        }
        try {
            Thread.sleep(300L);
        }
        catch (InterruptedException interruptedException) {
            object = interruptedException;
            interruptedException.printStackTrace();
        }
        this.t = false;
        while (System.currentTimeMillis() - l < (long)((n + 3) * 1000)) {
            this.u = true;
            if (this.t) {
                this.t = false;
                try {
                    this.k.write(Common.grsiP2Command((byte)5, (byte)1, new byte[0]));
                }
                catch (IOException iOException) {
                    object = iOException;
                    iOException.printStackTrace();
                }
            }
            try {
                n2 = this.j.available();
            }
            catch (IOException iOException) {
                object = iOException;
                iOException.printStackTrace();
            }
            if (n2 > 0) {
                try {
                    n2 = this.j.read(byArray);
                }
                catch (IOException iOException) {
                    object = iOException;
                    iOException.printStackTrace();
                }
            }
            if (Common.getDeviceType() != ReaderInfo.DEVICE_TYPE.DEVICE_BTPAY ? n2 > 0 : n2 > 0 && byArray[0] == 2 && (byArray[3] == 6 || byArray[3] == 21)) break;
            try {
                Thread.sleep(700L);
            }
            catch (InterruptedException interruptedException) {
                object = interruptedException;
                interruptedException.printStackTrace();
            }
            if (n != 0) continue;
            l = System.currentTimeMillis();
        }
        this.u = false;
        BluetoothController.a(this.j);
        if (n2 > 0) {
            object = new byte[n2];
            System.arraycopy(byArray, 0, object, 0, n2);
            this.m = false;
            UMLog.i("**getResponse**", Common.base16Encode(object));
            d.bt_onReceiveMsgGetResponse((byte[])object);
            return object;
        }
        this.m = false;
        return null;
    }

    public byte[] sendCommandOnly(byte[] byArray, int n) {
        if (!b || this.m) {
            UMLog.i("SDK::BT Controller", "Failed to send a command: ");
            this.m = false;
            return null;
        }
        try {
            Thread.sleep(300L);
        }
        catch (InterruptedException interruptedException) {
            InterruptedException interruptedException2 = interruptedException;
            interruptedException.printStackTrace();
        }
        BluetoothController.a(this.j);
        try {
            this.k.write(byArray);
        }
        catch (IOException iOException) {
            IOException iOException2 = iOException;
            iOException.printStackTrace();
        }
        this.m = false;
        return null;
    }

    private static void a(InputStream inputStream) {
        IOException iOException;
        int n = 0;
        byte[] byArray = new byte[2048];
        try {
            n = inputStream.available();
        }
        catch (IOException iOException2) {
            iOException = iOException2;
            iOException2.printStackTrace();
        }
        if (n > 0) {
            try {
                inputStream.read(byArray);
                return;
            }
            catch (IOException iOException3) {
                iOException = iOException3;
                iOException3.printStackTrace();
            }
        }
    }

    public byte[] sendCommandFw(byte[] object) {
        Object object2;
        if (!b || this.m) {
            UMLog.i("SDK::BT Controller", "Failed to send a command: ");
            this.m = false;
            return null;
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            object2 = interruptedException;
            interruptedException.printStackTrace();
        }
        byte[] byArray = new byte[2048];
        int n = 0;
        BluetoothController.a(this.j);
        try {
            this.k.write((byte[])object, 0, ((byte[])object).length);
        }
        catch (IOException iOException) {
            object = iOException;
            iOException.printStackTrace();
        }
        try {
            Thread.sleep(300L);
        }
        catch (InterruptedException interruptedException) {
            object = interruptedException;
            interruptedException.printStackTrace();
        }
        int n2 = 0;
        while (n2 < 5) {
            try {
                n = this.j.available();
            }
            catch (IOException iOException) {
                object2 = iOException;
                iOException.printStackTrace();
            }
            if (n > 0) {
                try {
                    this.j.read(byArray);
                }
                catch (IOException iOException) {
                    object2 = iOException;
                    iOException.printStackTrace();
                }
            }
            if (n > 0) break;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                object2 = interruptedException;
                interruptedException.printStackTrace();
            }
            ++n2;
        }
        BluetoothController.a(this.j);
        if (n > 0) {
            object2 = new byte[n];
            System.arraycopy(byArray, 0, object2, 0, n);
            this.m = false;
            return object2;
        }
        this.m = false;
        return null;
    }

    private int a(byte[] object) {
        Object object2;
        if (!b) {
            return 0;
        }
        this.r = new byte[1024];
        int n = 0;
        try {
            Thread.sleep(300L);
        }
        catch (InterruptedException interruptedException) {
            object2 = interruptedException;
            interruptedException.printStackTrace();
        }
        try {
            n = this.j.available();
        }
        catch (IOException iOException) {
            object2 = iOException;
            iOException.printStackTrace();
        }
        if (n == 0) {
            return 0;
        }
        do {
            try {
                n = this.j.read(this.r);
            }
            catch (IOException iOException) {
                object2 = iOException;
                iOException.printStackTrace();
            }
            try {
                Thread.sleep(150L);
            }
            catch (InterruptedException interruptedException) {
                object2 = interruptedException;
                interruptedException.printStackTrace();
            }
        } while (n <= 5 || this.r[0] != 2);
        if (n > 0) {
            if (Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_BTMAG) {
                System.arraycopy(this.r, 1, object, 0, n -= 2);
            } else {
                n = (this.r[1] & 0xFF) + ((this.r[2] & 0xFF) << 8);
                System.arraycopy(this.r, 3, object, 0, n);
                object2 = new byte[n];
                System.arraycopy(this.r, 3, object2, 0, n);
                try {
                    Thread.sleep(30L);
                }
                catch (InterruptedException interruptedException) {
                    object = interruptedException;
                    interruptedException.printStackTrace();
                }
            }
            return n;
        }
        return 0;
    }

    private void b() {
        try {
            if (this.l != null) {
                this.l.close();
            }
        }
        catch (IOException iOException) {}
        this.l = null;
        this.j = null;
        this.k = null;
        b = false;
    }

    private final class a
    extends Thread {
        private boolean a = false;
        private /* synthetic */ BluetoothController b;

        private a(BluetoothController bluetoothController) {
            this.b = bluetoothController;
        }

        @Override
        public final void run() {
            InterruptedException interruptedException;
            try {
                com.idtechproducts.device.bluetooth.BluetoothController$a.sleep(300L);
            }
            catch (InterruptedException interruptedException2) {
                interruptedException = interruptedException2;
                interruptedException2.printStackTrace();
            }
            while (!this.a) {
                this.a = this.b.initWithThread();
                try {
                    com.idtechproducts.device.bluetooth.BluetoothController$a.sleep(2000L);
                }
                catch (InterruptedException interruptedException3) {
                    interruptedException = interruptedException3;
                    interruptedException3.printStackTrace();
                }
            }
        }

        /* synthetic */ a(BluetoothController bluetoothController, byte by) {
            this(bluetoothController);
        }
    }

    private final class b
    extends Thread {
        private boolean a = false;
        private /* synthetic */ BluetoothController b;

        private b(BluetoothController bluetoothController) {
            this.b = bluetoothController;
        }

        @Override
        public final void run() {
            while (this.b.o < this.b.n && !this.a) {
                Object object;
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    InterruptedException interruptedException2 = interruptedException;
                    interruptedException.printStackTrace();
                }
                int n = this.b.a(this.b.q);
                if (n > 0) {
                    this.a = true;
                    object = new IDTMSRData();
                    byte[] byArray = new byte[n];
                    System.arraycopy(this.b.q, 0, byArray, 0, n);
                    if (byArray[0] == 2 && (byArray[3] == -128 || byArray[3] == -127 || byArray[3] == -125 || byArray[3] == -124 || byArray[3] == -123 || byArray[3] == -122 || byArray[3] == -64)) {
                        Common.Response.parseCardData(byArray, (IDTMSRData)object, 3);
                    } else if (byArray[1] == 2 && (this.b.r[4] == -128 || byArray[4] == -127 || byArray[4] == -125 || byArray[4] == -124 || byArray[4] == -123 || byArray[4] == -122 || byArray[4] == -64)) {
                        Common.Response.parseCardDataUniPay(byArray, (IDTMSRData)object);
                    } else {
                        Common.Response.parseCardClearData(byArray, (IDTMSRData)object);
                    }
                    UMLog.i("SDK::BT Controller", "got: " + Common.getByteArrDesc(this.b.q));
                    d.bt_onReceiveMsgCardData((IDTMSRData)object);
                    break;
                }
                BluetoothController bluetoothController = this.b;
                bluetoothController.o = bluetoothController.o + 1;
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    object = interruptedException;
                    interruptedException.printStackTrace();
                }
            }
            if (this.b.o >= this.b.n) {
                b b2 = this;
                this.a = true;
                d.bt_onReceiveMsgSwipeTimeout();
            }
            this.b.m = false;
            IDT_Device.isCommandRunning = false;
        }

        public final void a() {
            this.a = true;
        }

        /* synthetic */ b(BluetoothController bluetoothController, byte by) {
            this(bluetoothController);
        }
    }
}

