/*
 * Decompiled with CFR 0.152.
 */
package com.idtechproducts.device.audiojack;

import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.media.AudioManager;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import com.idtechproducts.device.Common;
import com.idtechproducts.device.ICCReaderStatusStruct;
import com.idtechproducts.device.IDTMSRData;
import com.idtechproducts.device.IDT_Device;
import com.idtechproducts.device.OnReceiverListener;
import com.idtechproducts.device.ReaderInfo;
import com.idtechproducts.device.ResDataStruct;
import com.idtechproducts.device.StructConfigParameters;
import com.idtechproducts.device.audiojack.ReaderCommunication;
import com.idtechproducts.device.audiojack.UMLog;
import com.idtechproducts.device.audiojack.config.UniMagConfigHelper;
import com.idtechproducts.device.audiojack.io.IOManager;
import com.idtechproducts.device.audiojack.io.ToneType;
import com.idtechproducts.device.audiojack.tasks.TaskManager;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class CommManagerAudio
implements ReaderCommunication {
    private volatile boolean a;
    private volatile boolean b;
    private volatile boolean c;
    private volatile ReaderInfo.DEVICE_TYPE d;
    private final OnReceiverListener e;
    private final Context f;
    private final BroadcastReceiver g;
    private final IOManager h;
    private final UniMagConfigHelper i;
    private final Object j;
    private StructConfigParameters k;
    private String l;
    private IDT_Device.TaskExport m;
    public static IDT_Device audioDevice = null;
    private b n = null;

    public CommManagerAudio(OnReceiverListener onReceiverListener, Context context, IDT_Device.TaskExport taskExport) {
        if (onReceiverListener == null || context == null) {
            throw new NullPointerException();
        }
        this.m = taskExport;
        this.a = false;
        this.c = false;
        this.b = false;
        this.d = null;
        this.e = onReceiverListener;
        this.f = context;
        Common.context = context;
        this.g = new a(this, 0);
        this.h = new IOManager(this.e, context, this.m);
        this.i = new UniMagConfigHelper(this.e, this.f, 4, 0);
        this.j = new Object();
        this.k = null;
        this.l = null;
        UMLog.i("SDK::CommManager", "initialized");
        this.a();
    }

    public void release() {
        UMLog.i("SDK::CommManager", "un-initializing");
        this.h.stopRecordThread();
        if (this.h != null) {
            this.h.release();
        }
        this.listener_unregister();
        UMLog.close();
        this.a = false;
        this.c = false;
        this.b = false;
        this.d = null;
        this.k = null;
        this.l = null;
    }

    public void listener_register() {
        if (this.a) {
            return;
        }
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.HEADSET_PLUG");
        intentFilter.addAction("android.intent.action.MEDIA_BUTTON");
        intentFilter.addAction("android.media.AUDIO_BECOMING_NOISY");
        this.f.registerReceiver(this.g, intentFilter);
        this.a(true);
        this.a = true;
        UMLog.i("SDK::CommManager", "registered broadcast listener");
    }

    public void listener_unregister() {
        if (!this.a) {
            return;
        }
        this.f.unregisterReceiver(this.g);
        this.a(false);
        this.a = false;
        UMLog.i("SDK::CommManager", "un-registered broadcast listener");
    }

    private void a(boolean bl) {
        if (Build.VERSION.SDK_INT >= 8) {
            AudioManager audioManager = (AudioManager)this.f.getSystemService("audio");
            Exception exception = null;
            try {
                Method method = AudioManager.class.getMethod(bl ? "registerMediaButtonEventReceiver" : "unregisterMediaButtonEventReceiver", ComponentName.class);
                method.invoke((Object)audioManager, new ComponentName(this.f, this.g.getClass()));
            }
            catch (SecurityException securityException) {
                SecurityException securityException2 = securityException;
                exception = securityException;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                NoSuchMethodException noSuchMethodException2 = noSuchMethodException;
                exception = noSuchMethodException;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                IllegalArgumentException illegalArgumentException2 = illegalArgumentException;
                exception = illegalArgumentException;
            }
            catch (IllegalAccessException illegalAccessException) {
                IllegalAccessException illegalAccessException2 = illegalAccessException;
                exception = illegalAccessException;
            }
            catch (InvocationTargetException invocationTargetException) {
                InvocationTargetException invocationTargetException2 = invocationTargetException;
                exception = invocationTargetException;
            }
            if (exception != null) {
                UMLog.w("SDK::CommManager", String.valueOf(bl ? "register" : "unregister") + " media button receiver failed: " + exception);
            }
        }
    }

    @Override
    public boolean getState_isAttached() {
        return this.c;
    }

    @Override
    public boolean getState_isConnected() {
        return this.b;
    }

    public String getInfo_SDKVersionString() {
        return "IDTech Universal SDK Ver 1.00.161";
    }

    public String getInfo_Manufacturer() {
        return this.i.getManufacture();
    }

    public String getInfo_Model() {
        return this.i.getModel();
    }

    public ReaderInfo.SupportStatus getInfo_supportStatus(ReaderInfo.DEVICE_TYPE dEVICE_TYPE) {
        if (dEVICE_TYPE == null) {
            return null;
        }
        if (this.k == null) {
            UMLog.w("SDK::CommManager", "get mobile device support status: no config loaded");
            return ReaderInfo.SupportStatus.UNSUPPORTED;
        }
        return this.k.querySupportStatus(dEVICE_TYPE);
    }

    public String getInfo_loadedXmlVersion() {
        return this.l;
    }

    @Override
    public OnReceiverListener getIntern_uniMagReaderMsg() {
        return this.e;
    }

    @Override
    public IOManager getIntern_IOManager() {
        return this.h;
    }

    @Override
    public StructConfigParameters getIntern_StructConfigParameters() {
        return this.k;
    }

    public boolean setCfg_config(StructConfigParameters structConfigParameters) {
        UMLog.w("SDK", "setting config: config not set, SDK busy running task");
        if (structConfigParameters == null) {
            return false;
        }
        this.k = structConfigParameters.clone();
        this.h.setConfig(this.k);
        this.l = null;
        return true;
    }

    public StructConfigParameters getCfg_config() {
        return this.k;
    }

    public void log_setEnableVerbose(boolean bl) {
        UMLog.setEnableVerbose(bl);
    }

    public void log_setEnableSave(boolean bl) {
        if (bl) {
            File file = Common.getDir_externalOrSandbox(this.f);
            UMLog.open(file, "IDT_Log_Txt_");
            this.a();
        } else {
            UMLog.close();
        }
        this.h.setSaveLog(bl);
    }

    public int log_delete() {
        int n = UMLog.deleteLogs(this.f.getFilesDir(), "IDT_Log_Txt_");
        int n2 = 0;
        if (Common.isStorageExist()) {
            n2 = UMLog.deleteLogs(new File(Common.getSDRootFilePath()), "IDT_Log_Txt_");
        }
        int n3 = this.h.deleteLogs();
        return n + n2 + n3;
    }

    private void a() {
        UMLog.i("SDK::CommManager", "IDTech Universal SDK Ver 1.00.161");
        UMLog.i("SDK::CommManager", "Device Manufacturer: " + this.getInfo_Manufacturer());
        UMLog.i("SDK::CommManager", "Device Model: " + this.getInfo_Model());
        UMLog.i("SDK::CommManager", "Android version: " + Build.VERSION.RELEASE);
    }

    public void config_setPath(String string) {
        this.i.setPathFileName(string);
    }

    public boolean config_load(boolean bl) {
        if (this.i.loadingXMLFile(bl)) {
            CommManagerAudio commManagerAudio = this;
            bl = commManagerAudio.setCfg_config(commManagerAudio.i.getConfigParams());
            this.l = this.i.getLoadedXmlVersion();
            return bl;
        }
        return false;
    }

    @Override
    public void cxn_setConnected(ToneType object) {
        object = this.j;
        synchronized (object) {
            if (!this.c) {
                return;
            }
            this.b = true;
        }
        if (audioDevice != null && this.m.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ) {
            audioDevice.icc_passthroughOffICC();
            object = new ResDataStruct();
            int n = audioDevice.ctls_retrieveTerminalData((ResDataStruct)object);
            if (n == 0 && ((ResDataStruct)object).resData != null && ((ResDataStruct)object).resData.length > 0) {
                String string = Common.base16Encode(((ResDataStruct)object).resData);
                IDT_Device.isBurstModeOn = string.contains("FFF70101");
                IDT_Device.isAutoPollOn = string.contains("DF891B0100");
            } else {
                n = audioDevice.ctls_retrieveTerminalData((ResDataStruct)object);
                if (n == 0 && ((ResDataStruct)object).resData != null && ((ResDataStruct)object).resData.length > 0) {
                    String string = Common.base16Encode(((ResDataStruct)object).resData);
                    IDT_Device.isBurstModeOn = string.contains("FFF70101");
                    IDT_Device.isAutoPollOn = string.contains("DF891B0100");
                }
            }
            Object object2 = new SimpleDateFormat("yyyyMMddHHmmss", Locale.US);
            Date date = new Date();
            object2 = ((DateFormat)object2).format(date);
            audioDevice.device_sendDataCommand("2503", true, ((String)object2).substring(0, 8), (ResDataStruct)object);
            audioDevice.device_sendDataCommand("2501", true, ((String)object2).substring(8, 12), (ResDataStruct)object);
            IDT_Device.cardSeated = false;
            IDT_Device.isCommandRunning = false;
            UMLog.i("SDK::CommManager", "SDK starts listening card data from reader.");
            if (this.n == null) {
                this.n = new b(this, 0);
                this.n.a = true;
                this.n.start();
            }
        }
        object = new Handler(Looper.getMainLooper());
        object.post(new Runnable(this){
            private /* synthetic */ CommManagerAudio a;
            {
                this.a = commManagerAudio;
            }

            @Override
            public final void run() {
                IDT_Device.maxLoopNum = 2;
                this.a.e.deviceConnected();
            }
        });
        IDT_Device.audioUnplugged = false;
        if (IOManager.emvListener != null) {
            IDT_Device.maxLoopNum = 2;
            IOManager.emvListener.deviceConnected();
        }
    }

    @Override
    public void cxn_setDisconnected() {
        Object object = this.j;
        synchronized (object) {
            if (this.n != null) {
                this.n.a = false;
            }
            this.b = false;
            this.h.getTonePlayer().setPlayingTone(null);
            this.h.stopRecordThread();
            this.m.stopTasks();
        }
        if (this.m.getReaderType() != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_USB && this.m.getReaderType() != ReaderInfo.DEVICE_TYPE.DEVICE_MINISMART_II) {
            IDT_Device.audioUnplugged = true;
            this.e.deviceDisconnected();
        }
        if (IOManager.emvListener != null) {
            IOManager.emvListener.deviceDisconnected();
        }
        IDT_Device.readyForCardSwipe = true;
    }

    @Override
    public void readerType_set(ReaderInfo.DEVICE_TYPE dEVICE_TYPE) {
        this.d = dEVICE_TYPE;
    }

    @Override
    public IOManager.RPDResult connect(byte[] byArray, double d2, IOManager.ICancel iCancel, IOManager.ResponseProcessor responseProcessor) {
        if (this.m.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_UNIMAG && this.k != null && this.k.getReverseAudioEvents() == 1) {
            return this.recordPlayDecode(byArray, d2, true, true, true, iCancel, responseProcessor);
        }
        return this.recordPlayDecode(byArray, d2, false, true, true, iCancel, responseProcessor);
    }

    @Override
    public IOManager.RPDResult sendCommand(byte[] byArray, double d2, IOManager.ICancel iCancel, IOManager.ResponseProcessor responseProcessor) {
        if (this.m.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_UNIMAG && this.k != null && this.k.getReverseAudioEvents() == 1) {
            return this.recordPlayDecode(byArray, d2, true, false, true, iCancel, responseProcessor);
        }
        return this.recordPlayDecode(byArray, d2, false, false, true, iCancel, responseProcessor);
    }

    @Override
    public IOManager.RPDResult waitResponse(double d2, IOManager.ICancel iCancel, IOManager.ResponseProcessor responseProcessor) {
        if (this.m.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_UNIMAG && this.k != null && this.k.getReverseAudioEvents() == 1) {
            return this.recordPlayDecode(null, d2, true, false, false, iCancel, responseProcessor);
        }
        return this.recordPlayDecode(null, d2, false, false, false, iCancel, responseProcessor);
    }

    protected IOManager.RPDResult recordPlayDecode(byte[] object, double d2, boolean bl, boolean bl2, boolean bl3, IOManager.ICancel iCancel, IOManager.ResponseProcessor responseProcessor) {
        IOManager.RPDResult rPDResult = this.h.recordPlayDecode((byte[])object, d2, iCancel, responseProcessor, bl, bl2, bl3);
        object = rPDResult;
        return rPDResult;
    }

    private final class a
    extends BroadcastReceiver {
        private /* synthetic */ CommManagerAudio a;

        private a(CommManagerAudio commManagerAudio) {
            this.a = commManagerAudio;
            commManagerAudio.f.getSystemService("audio");
        }

        public final void onReceive(Context object, Intent intent) {
            object = intent.getAction();
            if (((String)object).equals("android.intent.action.MEDIA_BUTTON")) {
                this.abortBroadcast();
            }
            if (((String)object).equals("android.intent.action.HEADSET_PLUG")) {
                int n = intent.getIntExtra("state", -999);
                int n2 = intent.getIntExtra("false_event", -999);
                if (n2 == -999) {
                    if (n == -999) {
                        UMLog.w("SDK::CommManager", "headset plug broadcast: failed to determine plug state");
                        this.a(false);
                    } else if (n == 0) {
                        this.a(false);
                    } else {
                        this.a(true);
                    }
                }
            }
            if (((String)object).equals("android.media.AUDIO_BECOMING_NOISY")) {
                this.a(false);
            }
        }

        private void a(boolean bl) {
            if (this.a.c == bl) {
                return;
            }
            UMLog.i("SDK::CommManager", "headset " + (bl ? "attached" : "detached"));
            if (bl) {
                this.a.c = true;
                this.a.h.setAttached(true);
                this.a.m.startConnectTask();
                return;
            }
            this.a.h.setAttached(false);
            Object object = this.a.j;
            synchronized (object) {
                this.a.c = false;
                this.a.cxn_setDisconnected();
            }
            this.a.readerType_set(null);
        }

        /* synthetic */ a(CommManagerAudio commManagerAudio, byte by) {
            this(commManagerAudio);
        }
    }

    private final class b
    extends Thread {
        public boolean a = true;
        private /* synthetic */ CommManagerAudio b;

        private b(CommManagerAudio commManagerAudio) {
            this.b = commManagerAudio;
        }

        @Override
        public final void run() {
            while (this.a) {
                Object object;
                if (!IDT_Device.isBurstModeOn || !IDT_Device.isAutoPollOn || IDT_Device.isCommandRunning) {
                    int n;
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        object = interruptedException;
                        interruptedException.printStackTrace();
                    }
                    if (IDT_Device.isBurstModeOn || !IDT_Device.isAutoPollOn || Common.getDeviceType() != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ && Common.getDeviceType() != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V) continue;
                    try {
                        Thread.sleep(900L);
                    }
                    catch (InterruptedException interruptedException) {
                        object = interruptedException;
                        interruptedException.printStackTrace();
                    }
                    if (IDT_Device.isCommandRunning) continue;
                    if (Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ && IDT_Device.isMonitorCtlsData && (n = audioDevice.device_getTransactionResults((IDTMSRData)(object = new IDTMSRData()))) == 0 && ((IDTMSRData)object).cardData != null && ((IDTMSRData)object).cardData.length > 7) {
                        this.b.e.swipeMSRData((IDTMSRData)object);
                    }
                    IDT_Device.readyForCardSwipe = true;
                    object = new ICCReaderStatusStruct();
                    n = audioDevice.icc_getICCReaderStatus((ICCReaderStatusStruct)object);
                    if (n != 0) continue;
                    if (((ICCReaderStatusStruct)object).cardSeated) {
                        if (!IDT_Device.cardSeated) {
                            IDT_Device.cardSeated = true;
                            if (IDT_Device.autoEMV) {
                                audioDevice.emv_startTransaction(IDT_Device.emv_amount, 0.0, IDT_Device.emv_type, IDT_Device.emv_timeout, IDT_Device.emv_tags, false);
                            }
                        }
                        IDT_Device.cardSeated = true;
                        continue;
                    }
                    IDT_Device.cardSeated = false;
                    continue;
                }
                IDT_Device.isCheckingNotification = true;
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    object = interruptedException;
                    interruptedException.printStackTrace();
                }
                object = new ResDataStruct();
                IDT_Device.isThreadReading = true;
                Object object2 = audioDevice.sendAudioCommand_helper(null, 1, (ResDataStruct)object);
                IDT_Device.isThreadReading = false;
                if (object2 == TaskManager.TaskStartRet.SUCCESS && ((ResDataStruct)object).resData != null && ((ResDataStruct)object).resData.length > 2 && (((ResDataStruct)object).resData.length <= 3 || ((ResDataStruct)object).resData[0] != 2 || ((ResDataStruct)object).resData[1] != 1 || ((ResDataStruct)object).resData[2] != 107 || ((ResDataStruct)object).resData[3] != 76)) {
                    if (((ResDataStruct)object).resData[0] == 3 && ((ResDataStruct)object).resData[1] == -93) {
                        IDT_Device.readyForCardSwipe = true;
                        IDT_Device.isCheckingNotification = false;
                        audioDevice.emv_startTransaction(IDT_Device.emv_amount, 0.0, IDT_Device.emv_type, IDT_Device.emv_timeout, IDT_Device.emv_tags, false);
                    } else {
                        if (Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ) {
                            if (((ResDataStruct)object).resData.length > 12 && ((ResDataStruct)object).resData[10] == 2 && ((ResDataStruct)object).resData[11] == -96) {
                                this.b.e.timeout(61088);
                                try {
                                    Thread.sleep(100L);
                                }
                                catch (InterruptedException interruptedException) {
                                    object2 = interruptedException;
                                    interruptedException.printStackTrace();
                                }
                                continue;
                            }
                            if (((ResDataStruct)object).resData.length > 12 && ((ResDataStruct)object).resData[10] == -18 && ((ResDataStruct)object).resData[11] == -16) {
                                this.b.e.timeout(61168);
                                try {
                                    Thread.sleep(100L);
                                }
                                catch (InterruptedException interruptedException) {
                                    object2 = interruptedException;
                                    interruptedException.printStackTrace();
                                }
                                continue;
                            }
                        }
                        object2 = new byte[((ResDataStruct)object).resData.length];
                        System.arraycopy(((ResDataStruct)object).resData, 0, object2, 0, ((ResDataStruct)object).resData.length);
                        object = new IDTMSRData();
                        Common.processCTLSData((byte[])object2, (IDTMSRData)object);
                        UMLog.i("listenForDataOnThread", "got: " + Common.getByteArrDesc((byte[])object2));
                        this.b.e.swipeMSRData((IDTMSRData)object);
                    }
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    object2 = interruptedException;
                    interruptedException.printStackTrace();
                }
                IDT_Device.isCheckingNotification = false;
                IDT_Device.readyForCardSwipe = true;
            }
            this.b.n = null;
        }

        /* synthetic */ b(CommManagerAudio commManagerAudio, byte by) {
            this(commManagerAudio);
        }
    }
}

