/*
 * Decompiled with CFR 0.152.
 */
package com.idtechproducts.device.audiojack;

import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.database.Cursor;
import android.media.AudioManager;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import com.idtechproducts.device.Common;
import com.idtechproducts.device.ICCReaderStatusStruct;
import com.idtechproducts.device.IDTMSRData;
import com.idtechproducts.device.IDT_Device;
import com.idtechproducts.device.OnReceiverListener;
import com.idtechproducts.device.ReaderInfo;
import com.idtechproducts.device.ResDataStruct;
import com.idtechproducts.device.StructConfigParameters;
import com.idtechproducts.device.audiojack.ReaderCommunication;
import com.idtechproducts.device.audiojack.UMLog;
import com.idtechproducts.device.audiojack.config.UniMagConfigHelper;
import com.idtechproducts.device.audiojack.io.IOManager;
import com.idtechproducts.device.audiojack.io.ToneType;
import com.idtechproducts.device.audiojack.tasks.TaskManager;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Locale;

public class CommManagerAudio
implements ReaderCommunication {
    private static final String TAG = "SDK::CommManager";
    private static final int SDK_VER_MAJOR = 4;
    private static final int SDK_VER_MINOR = 0;
    private volatile boolean _state_isListenerRegistered;
    private volatile boolean _state_isConnected;
    private volatile boolean _state_isAttached;
    private volatile ReaderInfo.DEVICE_TYPE _state_readerType;
    private final OnReceiverListener _umrMsg;
    private final Context _context;
    private final BroadcastReceiver _listener;
    private final IOManager _ioManager;
    private final UniMagConfigHelper _configHelper;
    private final Object _actLock;
    private StructConfigParameters _cfg_config;
    private String _cfg_loadedXmlVersion;
    private Cursor cursor = null;
    private static final String DB_NAME = "IDT_Device";
    private static final String DB_TABLE = "idt_device_table";
    private static final String DB_COLUMN = "device_type";
    private IDT_Device.TaskExport _taskExport;
    public static IDT_Device audioDevice = null;
    private listenForDataOnThread listenThread = null;

    public CommManagerAudio(OnReceiverListener umrMsg, Context context, IDT_Device.TaskExport taskExport) {
        if (umrMsg == null || context == null) {
            throw new NullPointerException();
        }
        this._taskExport = taskExport;
        this._state_isListenerRegistered = false;
        this._state_isAttached = false;
        this._state_isConnected = false;
        this._state_readerType = null;
        this._umrMsg = umrMsg;
        this._context = context;
        Common.context = context;
        this._listener = new UMListener();
        this._ioManager = new IOManager(this._umrMsg, context, this._taskExport);
        this._configHelper = new UniMagConfigHelper(this._umrMsg, this._context, 4, 0);
        this._actLock = new Object();
        this._cfg_config = null;
        this._cfg_loadedXmlVersion = null;
        UMLog.i(TAG, "initialized");
        this.log_printAbout();
    }

    public void release() {
        UMLog.i(TAG, "un-initializing");
        this._ioManager.stopRecordThread();
        if (this._ioManager != null) {
            this._ioManager.release();
        }
        this.listener_unregister();
        UMLog.close();
        this._state_isListenerRegistered = false;
        this._state_isAttached = false;
        this._state_isConnected = false;
        this._state_readerType = null;
        this._cfg_config = null;
        this._cfg_loadedXmlVersion = null;
    }

    public void listener_register() {
        if (this._state_isListenerRegistered) {
            return;
        }
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.intent.action.HEADSET_PLUG");
        filter.addAction("android.intent.action.MEDIA_BUTTON");
        filter.addAction("android.media.AUDIO_BECOMING_NOISY");
        this._context.registerReceiver(this._listener, filter);
        this.listener_mediaButtonReceiver(true);
        this._state_isListenerRegistered = true;
        UMLog.i(TAG, "registered broadcast listener");
    }

    public void listener_unregister() {
        if (!this._state_isListenerRegistered) {
            return;
        }
        this._context.unregisterReceiver(this._listener);
        this.listener_mediaButtonReceiver(false);
        this._state_isListenerRegistered = false;
        UMLog.i(TAG, "un-registered broadcast listener");
    }

    private void listener_mediaButtonReceiver(boolean isRegistering) {
        if (Build.VERSION.SDK_INT >= 8) {
            AudioManager am = (AudioManager)this._context.getSystemService("audio");
            Exception ex = null;
            try {
                Method regReceiver = AudioManager.class.getMethod(isRegistering ? "registerMediaButtonEventReceiver" : "unregisterMediaButtonEventReceiver", ComponentName.class);
                regReceiver.invoke((Object)am, new ComponentName(this._context, this._listener.getClass()));
            }
            catch (SecurityException e) {
                ex = e;
            }
            catch (NoSuchMethodException e) {
                ex = e;
            }
            catch (IllegalArgumentException e) {
                ex = e;
            }
            catch (IllegalAccessException e) {
                ex = e;
            }
            catch (InvocationTargetException e) {
                ex = e;
            }
            if (ex != null) {
                UMLog.w(TAG, String.valueOf(isRegistering ? "register" : "unregister") + " media button receiver failed: " + ex);
            }
        }
    }

    public boolean getState_isAttached() {
        return this._state_isAttached;
    }

    public boolean getState_isConnected() {
        return this._state_isConnected;
    }

    public ReaderInfo.DEVICE_TYPE getState_readerType() {
        return this._state_readerType;
    }

    public String getInfo_SDKVersionString() {
        return "IDTech Universal SDK Ver 1.00.126";
    }

    public String getInfo_Manufacturer() {
        return this._configHelper.getManufacture();
    }

    public String getInfo_Model() {
        return this._configHelper.getModel();
    }

    public ReaderInfo.SupportStatus getInfo_supportStatus(ReaderInfo.DEVICE_TYPE readerType) {
        if (readerType == null) {
            return null;
        }
        if (this._cfg_config == null) {
            UMLog.w(TAG, "get mobile device support status: no config loaded");
            return ReaderInfo.SupportStatus.UNSUPPORTED;
        }
        return this._cfg_config.querySupportStatus(readerType);
    }

    public String getInfo_loadedXmlVersion() {
        return this._cfg_loadedXmlVersion;
    }

    public OnReceiverListener getIntern_uniMagReaderMsg() {
        return this._umrMsg;
    }

    public IOManager getIntern_IOManager() {
        return this._ioManager;
    }

    public StructConfigParameters getIntern_StructConfigParameters() {
        return this._cfg_config;
    }

    public boolean setCfg_config(StructConfigParameters config) {
        UMLog.w("SDK", "setting config: config not set, SDK busy running task");
        if (config == null) {
            return false;
        }
        this._cfg_config = config.clone();
        this._ioManager.setConfig(this._cfg_config);
        this._cfg_loadedXmlVersion = null;
        return true;
    }

    public StructConfigParameters getCfg_config() {
        return this._cfg_config;
    }

    public void log_setEnableVerbose(boolean enable) {
        UMLog.setEnableVerbose(enable);
    }

    public void log_setEnableSave(boolean enable) {
        if (enable) {
            File dir = Common.getDir_externalOrSandbox(this._context);
            UMLog.open(dir, this.log_getPrefix());
            this.log_printAbout();
        } else {
            UMLog.close();
        }
        this._ioManager.setSaveLog(enable);
    }

    public int log_delete() {
        int ta = UMLog.deleteLogs(this._context.getFilesDir(), this.log_getPrefix());
        int ts = 0;
        if (Common.isStorageExist()) {
            ts = UMLog.deleteLogs(new File(Common.getSDRootFilePath()), this.log_getPrefix());
        }
        int w = this._ioManager.deleteLogs();
        return ta + ts + w;
    }

    private String log_getPrefix() {
        return "IDT_Log_Txt_";
    }

    private void log_printAbout() {
        UMLog.i(TAG, "IDTech Universal SDK Ver 1.00.126");
        UMLog.i(TAG, "Device Manufacturer: " + this.getInfo_Manufacturer());
        UMLog.i(TAG, "Device Model: " + this.getInfo_Model());
        UMLog.i(TAG, "Android version: " + Build.VERSION.RELEASE);
    }

    public void config_setPath(String path) {
        this._configHelper.setPathFileName(path);
    }

    public boolean config_load(boolean searchOtherPlaces) {
        if (this._configHelper.loadingXMLFile(searchOtherPlaces)) {
            boolean ret = this.setCfg_config(this._configHelper.getConfigParams());
            this._cfg_loadedXmlVersion = this._configHelper.getLoadedXmlVersion();
            return ret;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cxn_setConnected(ToneType newTone) {
        Object object = this._actLock;
        synchronized (object) {
            if (!this._state_isAttached) {
                return;
            }
            this._state_isConnected = true;
        }
        if (audioDevice != null && this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ) {
            audioDevice.icc_passthroughOffICC();
            ResDataStruct respData = new ResDataStruct();
            int r = audioDevice.ctls_retrieveTerminalData(respData);
            if (r == 0 && respData.resData != null && respData.resData.length > 0) {
                String str = Common.base16Encode(respData.resData);
                IDT_Device.isBurstModeOn = str.contains("FFF70101");
                IDT_Device.isAutoPollOn = str.contains("DF891B0100");
            } else {
                audioDevice.device_sendDataCommand("0409", true, "", respData);
                r = audioDevice.ctls_retrieveTerminalData(respData);
                if (r == 0 && respData.resData != null && respData.resData.length > 0) {
                    String str = Common.base16Encode(respData.resData);
                    IDT_Device.isBurstModeOn = str.contains("FFF70101");
                    IDT_Device.isAutoPollOn = str.contains("DF891B0100");
                }
            }
            IDT_Device.cardSeated = false;
            IDT_Device.isCommandRunning = false;
            UMLog.i(TAG, "SDK starts listening card data from reader.");
            if (this.listenThread == null) {
                this.listenThread = new listenForDataOnThread();
                this.listenThread.isRunning = true;
                this.listenThread.start();
            }
        }
        Handler h = new Handler(Looper.getMainLooper());
        h.post(new Runnable(){

            public void run() {
                IDT_Device.maxLoopNum = 2;
                CommManagerAudio.this._umrMsg.deviceConnected();
            }
        });
        IDT_Device.audioUnplugged = false;
        if (IOManager.emvListener != null) {
            IDT_Device.maxLoopNum = 2;
            IOManager.emvListener.deviceConnected();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cxn_setDisconnected() {
        Object object = this._actLock;
        synchronized (object) {
            if (this.listenThread != null) {
                this.listenThread.isRunning = false;
            }
            this._state_isConnected = false;
            this._ioManager.getTonePlayer().setPlayingTone(null);
            this._ioManager.stopRecordThread();
            this._taskExport.stopTasks();
        }
        if (this._taskExport.getReaderType() != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_USB && this._taskExport.getReaderType() != ReaderInfo.DEVICE_TYPE.DEVICE_MINISMART_II) {
            IDT_Device.audioUnplugged = true;
            this._umrMsg.deviceDisconnected();
        }
        if (IOManager.emvListener != null) {
            IOManager.emvListener.deviceDisconnected();
        }
        IDT_Device.readyForCardSwipe = true;
    }

    public void readerType_set(ReaderInfo.DEVICE_TYPE newType) {
        this._state_readerType = newType;
    }

    public IOManager.RPDResult connect(byte[] cmdString, double waitLen, IOManager.ICancel cancelHandle, IOManager.ResponseProcessor respProc) {
        if (this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_UNIMAG && this._cfg_config != null && this._cfg_config.getReverseAudioEvents() == 1) {
            return this.recordPlayDecode(cmdString, waitLen, true, true, true, cancelHandle, respProc);
        }
        return this.recordPlayDecode(cmdString, waitLen, false, true, true, cancelHandle, respProc);
    }

    public IOManager.RPDResult sendCommand(byte[] cmdString, double waitLen, IOManager.ICancel cancelHandle, IOManager.ResponseProcessor respProc) {
        if (this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_UNIMAG && this._cfg_config != null && this._cfg_config.getReverseAudioEvents() == 1) {
            return this.recordPlayDecode(cmdString, waitLen, true, false, true, cancelHandle, respProc);
        }
        return this.recordPlayDecode(cmdString, waitLen, false, false, true, cancelHandle, respProc);
    }

    public IOManager.RPDResult waitResponse(double waitLen, IOManager.ICancel cancelHandle, IOManager.ResponseProcessor respProc) {
        if (this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_UNIMAG && this._cfg_config != null && this._cfg_config.getReverseAudioEvents() == 1) {
            return this.recordPlayDecode(null, waitLen, true, false, false, cancelHandle, respProc);
        }
        return this.recordPlayDecode(null, waitLen, false, false, false, cancelHandle, respProc);
    }

    protected IOManager.RPDResult recordPlayDecode(byte[] cmdString, double waitLen, boolean recordAfterPlay, boolean maximizeVolumeAfterPlay, boolean withPlay, IOManager.ICancel cancelHandle, IOManager.ResponseProcessor respProc) {
        long tStart = System.currentTimeMillis();
        IOManager.RPDResult r = this._ioManager.recordPlayDecode(cmdString, waitLen, cancelHandle, respProc, recordAfterPlay, maximizeVolumeAfterPlay, withPlay);
        long tEnd = System.currentTimeMillis();
        String respDesc = "";
        if (r.data != null) {
            respDesc = "Read " + Common.getByteArrDesc(r.data.get(0));
            if (r.data.size() > 1 && !Arrays.equals(r.data.get(0), r.data.get(1))) {
                respDesc = String.valueOf(respDesc) + " " + Common.getByteArrDesc(r.data.get(0));
            }
        }
        UMLog.i("RPD", String.format(Locale.US, "%s after %.3fs. %s", r.status.name(), (double)(tEnd - tStart) / 1000.0, respDesc));
        return r;
    }

    private class UMListener
    extends BroadcastReceiver {
        AudioManager am;

        private UMListener() {
            this.am = (AudioManager)CommManagerAudio.this._context.getSystemService("audio");
        }

        public void onReceive(Context context, Intent intent) {
            String act = intent.getAction();
            if (act.equals("android.intent.action.MEDIA_BUTTON")) {
                this.abortBroadcast();
            }
            if (act.equals("android.intent.action.HEADSET_PLUG")) {
                int invalidValue = -999;
                int iPlugState = intent.getIntExtra("state", -999);
                int iFalseEvent = intent.getIntExtra("false_event", -999);
                if (iFalseEvent == -999) {
                    if (iPlugState == -999) {
                        UMLog.w(CommManagerAudio.TAG, "headset plug broadcast: failed to determine plug state");
                        this.processAttachmentStateChange(false);
                    } else if (iPlugState == 0) {
                        this.processAttachmentStateChange(false);
                    } else {
                        this.processAttachmentStateChange(true);
                    }
                }
            }
            if (act.equals("android.media.AUDIO_BECOMING_NOISY")) {
                this.processAttachmentStateChange(false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processAttachmentStateChange(boolean newState) {
            if (CommManagerAudio.this._state_isAttached == newState) {
                return;
            }
            UMLog.i(CommManagerAudio.TAG, "headset " + (newState ? "attached" : "detached"));
            if (newState) {
                CommManagerAudio.this._state_isAttached = true;
                CommManagerAudio.this._ioManager.setAttached(true);
                CommManagerAudio.this._taskExport.startConnectTask();
            } else {
                CommManagerAudio.this._ioManager.setAttached(false);
                Object object = CommManagerAudio.this._actLock;
                synchronized (object) {
                    CommManagerAudio.this._state_isAttached = false;
                    CommManagerAudio.this.cxn_setDisconnected();
                }
                CommManagerAudio.this.readerType_set(null);
            }
        }
    }

    private class listenForDataOnThread
    extends Thread {
        public boolean isRunning = true;

        private listenForDataOnThread() {
        }

        public void run() {
            while (this.isRunning) {
                if (!IDT_Device.isBurstModeOn || !IDT_Device.isAutoPollOn || IDT_Device.isCommandRunning) {
                    IDTMSRData card;
                    int ret;
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    if (IDT_Device.isBurstModeOn || !IDT_Device.isAutoPollOn || Common.getDeviceType() != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ && Common.getDeviceType() != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V) continue;
                    try {
                        Thread.sleep(900L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    if (IDT_Device.isCommandRunning) continue;
                    if (Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ && IDT_Device.isMonitorCtlsData && (ret = audioDevice.device_getTransactionResults(card = new IDTMSRData())) == 0 && card.cardData != null && card.cardData.length > 7) {
                        CommManagerAudio.this._umrMsg.swipeMSRData(card);
                    }
                    IDT_Device.readyForCardSwipe = true;
                    ICCReaderStatusStruct iccStatus = new ICCReaderStatusStruct();
                    ret = audioDevice.icc_getICCReaderStatus(iccStatus);
                    if (ret != 0) continue;
                    if (iccStatus.cardSeated) {
                        if (!IDT_Device.cardSeated) {
                            IDT_Device.cardSeated = true;
                            if (IDT_Device.autoEMV) {
                                audioDevice.emv_startTransaction(IDT_Device.emv_amount, 0.0, IDT_Device.emv_type, IDT_Device.emv_timeout, IDT_Device.emv_tags, false);
                            }
                        }
                        IDT_Device.cardSeated = true;
                        continue;
                    }
                    IDT_Device.cardSeated = false;
                    continue;
                }
                IDT_Device.isCheckingNotification = true;
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                ResDataStruct resData = new ResDataStruct();
                TaskManager.TaskStartRet r = TaskManager.TaskStartRet.NO_RESPONSE;
                r = audioDevice.sendAudioCommand_helper(null, 1, resData);
                if (r == TaskManager.TaskStartRet.SUCCESS && resData != null && resData.resData != null && resData.resData.length > 2 && (resData.resData.length <= 3 || resData.resData[0] != 2 || resData.resData[1] != 1 || resData.resData[2] != 107 || resData.resData[3] != 76)) {
                    if (resData.resData[0] == 3 && resData.resData[1] == -93) {
                        IDT_Device.readyForCardSwipe = true;
                        IDT_Device.isCheckingNotification = false;
                        audioDevice.emv_startTransaction(IDT_Device.emv_amount, 0.0, IDT_Device.emv_type, IDT_Device.emv_timeout, IDT_Device.emv_tags, false);
                    } else {
                        if (Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ) {
                            if (resData.resData.length > 12 && resData.resData[10] == 2 && resData.resData[11] == -96) {
                                CommManagerAudio.this._umrMsg.timeout(61088);
                                try {
                                    Thread.sleep(100L);
                                }
                                catch (InterruptedException e) {
                                    e.printStackTrace();
                                }
                                continue;
                            }
                            if (resData.resData.length > 12 && resData.resData[10] == -18 && resData.resData[11] == -16) {
                                CommManagerAudio.this._umrMsg.timeout(61168);
                                try {
                                    Thread.sleep(100L);
                                }
                                catch (InterruptedException e) {
                                    e.printStackTrace();
                                }
                                continue;
                            }
                        }
                        byte[] data = new byte[resData.resData.length];
                        System.arraycopy(resData.resData, 0, data, 0, resData.resData.length);
                        IDTMSRData card = new IDTMSRData();
                        Common.processCTLSData(data, card);
                        UMLog.i("listenForDataOnThread", "got: " + Common.getByteArrDesc(data));
                        CommManagerAudio.this._umrMsg.swipeMSRData(card);
                    }
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                IDT_Device.isCheckingNotification = false;
                IDT_Device.readyForCardSwipe = true;
            }
            CommManagerAudio.this.listenThread = null;
        }
    }
}

