/*
 * Decompiled with CFR 0.152.
 */
package com.idtechproducts.device.audiojack.tasks;

import com.idtechproducts.device.Common;
import com.idtechproducts.device.ResDataStruct;
import com.idtechproducts.device.audiojack.ReaderCommunication;
import com.idtechproducts.device.audiojack.UMLog;
import com.idtechproducts.device.audiojack.io.IOManager;
import com.idtechproducts.device.audiojack.tasks.Task;
import com.idtechproducts.device.audiojack.tasks.TaskManager;

public class ReceiveSynchroTask
extends Task {
    private final double _timeoutIntervalSec;

    public ReceiveSynchroTask(TaskManager umMan, ReaderCommunication readerCommunication, double timeoutIntervalSec) {
        super(umMan, readerCommunication);
        this._timeoutIntervalSec = timeoutIntervalSec;
    }

    public TaskManager.TaskType getType() {
        return TaskManager.TaskType.Command;
    }

    public void processSound() {
        UMLog.i(this.TAG, "command detected");
    }

    public boolean getResponse(ResDataStruct respData) {
        this.taskSetup();
        respData.resData = this.getResponse();
        this.taskCleanup();
        this._taskManager.task_signalStoppedStatus();
        return true;
    }

    public byte[] getResponse() {
        IOManager.RPDResult r = this._readerCommunication.waitResponse(this._timeoutIntervalSec, this, this);
        if (r.isCanceledOrFailed()) {
            return null;
        }
        byte[] returnedData = r.isParsed() ? r.data.get(0) : new byte[1];
        UMLog.i("**getResponse**", Common.getHexStringFromBytes(returnedData));
        return returnedData;
    }

    protected Runnable taskMain() {
        return null;
    }
}

