/*
 * Decompiled with CFR 0.152.
 */
package com.idtechproducts.device.audiojack.tasks;

import com.idtechproducts.device.Common;
import com.idtechproducts.device.IDTHttpClient;
import com.idtechproducts.device.IDT_Device;
import com.idtechproducts.device.OnReceiverListener;
import com.idtechproducts.device.ReaderInfo;
import com.idtechproducts.device.ResDataStruct;
import com.idtechproducts.device.audiojack.ReaderCommunication;
import com.idtechproducts.device.audiojack.UMLog;
import com.idtechproducts.device.audiojack.tasks.Task;
import com.idtechproducts.device.audiojack.tasks.TaskManager;
import com.idtechproducts.device.bluetooth.IDTechBluetoothLE;
import com.idtechproducts.device.rs232.IDTechRS232;
import com.idtechproducts.device.usb.IDTechUsbHid;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.Locale;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.json.JSONException;
import org.json.JSONObject;

public class RemoteKeyInjectionTask
extends Task {
    public static String RKI_URL = "https://rki.idtechproducts.com:8443/RKS_WebService/rest/rki/";
    public static String SRKI_URL = "http://symtest.idtechweb.com/api/srki/process";
    public static String LSRKI_URL = "http://99.93.153.229:8732/api/lrki/process";
    private String fwVersion = null;
    private String deviceSn = null;
    private IDTechUsbHid _usb;
    private IDTechBluetoothLE _btle;
    private IDTechRS232 _com;
    private OnReceiverListener _callback;
    private IDT_Device.TaskExport _taskExport;

    protected RemoteKeyInjectionTask(TaskManager taskManager, ReaderCommunication umMan, OnReceiverListener callback, IDTechUsbHid usb, IDT_Device.TaskExport taskExport) {
        super(taskManager, umMan);
        this._callback = callback;
        this._usb = usb;
        this._taskExport = taskExport;
    }

    protected RemoteKeyInjectionTask(TaskManager taskManager, ReaderCommunication umMan, OnReceiverListener callback, IDTechRS232 com, IDT_Device.TaskExport taskExport) {
        super(taskManager, umMan);
        this._callback = callback;
        this._com = com;
        this._taskExport = taskExport;
    }

    protected RemoteKeyInjectionTask(TaskManager taskManager, ReaderCommunication umMan, OnReceiverListener callback, IDTechBluetoothLE btle, IDT_Device.TaskExport taskExport) {
        super(taskManager, umMan);
        this._callback = callback;
        this._btle = btle;
        this._taskExport = taskExport;
    }

    public TaskManager.TaskType getType() {
        return TaskManager.TaskType.RemoteKeyInjection;
    }

    protected Runnable taskMain() {
        byte[] sn;
        byte[] fw;
        byte[] sn2;
        if (this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY) {
            ResDataStruct fwResp = new ResDataStruct();
            ResDataStruct snResp = new ResDataStruct();
            TaskManager.TaskStartRet retFw = this._taskManager.task_start_command_for_fw(Common.makeCommand("7831", 200), fwResp);
            TaskManager.TaskStartRet retSn = this._taskManager.task_start_command_for_fw(Common.makeCommand("784602", 200), snResp);
            if (retFw != TaskManager.TaskStartRet.SUCCESS || retSn != TaskManager.TaskStartRet.SUCCESS || snResp.resData.length < 10) {
                return new Runnable(){

                    public void run() {
                        UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify failed to get FW version/Serial Number");
                        IDT_Device.isCommandRunning = false;
                        RemoteKeyInjectionTask.this._callback.timeout(258);
                    }
                };
            }
            if (fwResp.resData[3] != 6 || snResp.resData[3] != 6) {
                return new Runnable(){

                    public void run() {
                        UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify failed to get FW version/Serial Number: received NAK");
                        IDT_Device.isCommandRunning = false;
                        RemoteKeyInjectionTask.this._callback.timeout(258);
                    }
                };
            }
            UMLog.i(this.TAG, "Fw version, SN received successfully");
            this.fwVersion = Common.getHexStringFromBytes(fwResp.resData);
            this.deviceSn = Common.getHexStringFromBytes(snResp.resData);
        } else if (this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ || this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V) {
            ResDataStruct snResp = new ResDataStruct();
            byte[] data = new byte[]{};
            TaskManager.TaskStartRet retSn = this._taskManager.task_start_command_for_fw(Common.grsiP2Command((byte)18, (byte)1, new byte[0]), snResp);
            if (retSn != TaskManager.TaskStartRet.SUCCESS || snResp.resData.length < 10) {
                return new Runnable(){

                    public void run() {
                        UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify failed to get Serial Number");
                        IDT_Device.isCommandRunning = false;
                        RemoteKeyInjectionTask.this._callback.timeout(258);
                    }
                };
            }
            if (snResp.resData[11] != 0) {
                return new Runnable(){

                    public void run() {
                        UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify failed to get Serial Number: received NAK");
                        IDT_Device.isCommandRunning = false;
                        RemoteKeyInjectionTask.this._callback.timeout(258);
                    }
                };
            }
            UMLog.i(this.TAG, "SN received successfully: " + this.deviceSn);
            byte[] ser = new byte[10];
            System.arraycopy(snResp.resData, 14, ser, 0, 10);
            this.deviceSn = Common.getAsciiFromByte(ser);
        } else if (this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB || this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V_USB || this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB || this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB || this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT || this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_COM) {
            sn2 = this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT ? this._btle.sendCommand(Common.getHexStringFromBytes(Common.grsiP2Command((byte)18, (byte)1, new byte[0])), 2) : (this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_COM ? this._com.sendCommand(Common.getHexStringFromBytes(Common.grsiP2Command((byte)18, (byte)1, new byte[0])), 2) : this._usb.sendCommand(Common.getHexStringFromBytes(Common.grsiP2Command((byte)18, (byte)1, new byte[0])), 2));
            if (sn2 == null || sn2.length < 10) {
                return new Runnable(){

                    public void run() {
                        UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify failed to get FW version/Serial Number");
                        IDT_Device.isCommandRunning = false;
                        RemoteKeyInjectionTask.this._callback.timeout(258);
                    }
                };
            }
            if (sn2[11] != 0) {
                return new Runnable(){

                    public void run() {
                        UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify failed to get Serial Number: received NAK");
                        IDT_Device.isCommandRunning = false;
                        RemoteKeyInjectionTask.this._callback.timeout(258);
                    }
                };
            }
            byte[] ser = new byte[10];
            System.arraycopy(sn2, 14, ser, 0, 10);
            this.deviceSn = Common.getAsciiFromByte(ser);
            UMLog.i(this.TAG, "SN received successfully: " + this.deviceSn);
        } else if (this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_VENDI || this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP2000 || this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB || this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT || this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 || this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT) {
            byte[] fw2;
            if (this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT || this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT) {
                sn2 = this._btle.sendCommand(Common.getHexStringFromBytes(Common.grsiP2Command((byte)18, (byte)1, new byte[0])), 2);
                fw2 = this._btle.sendCommand(Common.getHexStringFromBytes(Common.grsiP2Command((byte)41, (byte)0, new byte[0])), 2);
            } else {
                sn2 = this._usb.sendCommand(Common.getHexStringFromBytes(Common.grsiP2Command((byte)18, (byte)1, new byte[0])), 2);
                fw2 = this._usb.sendCommand(Common.getHexStringFromBytes(Common.grsiP2Command((byte)41, (byte)0, new byte[0])), 2);
            }
            if (sn2 == null || fw2 == null || sn2.length < 10 || fw2.length < 10) {
                return new Runnable(){

                    public void run() {
                        UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify failed to get FW version/Serial Number");
                        IDT_Device.isCommandRunning = false;
                        RemoteKeyInjectionTask.this._callback.timeout(258);
                    }
                };
            }
            if (fw2[11] != 0 || sn2[11] != 0) {
                return new Runnable(){

                    public void run() {
                        UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify failed to get FW version/Serial Number: received NAK");
                        IDT_Device.isCommandRunning = false;
                        RemoteKeyInjectionTask.this._callback.timeout(258);
                    }
                };
            }
            if (fw2 != null && fw2.length > 19 && fw2[14] == 75 && fw2[15] == 105 && fw2[16] == 111 && fw2[17] == 115 && fw2[18] == 107) {
                fw2[14] = 78;
                fw2[15] = 69;
                fw2[16] = 79;
                fw2[17] = 32;
                fw2[18] = 32;
            }
            this.fwVersion = Common.getHexStringFromBytes(fw2);
            this.deviceSn = Common.getHexStringFromBytes(sn2).toLowerCase(Locale.US);
            if (this.deviceSn.startsWith("5669564f7465636832001200000f")) {
                this.deviceSn = "5669564f7465636832001200000a" + this.deviceSn.substring(28, 52);
            }
            UMLog.i(this.TAG, "Fw version, SN received successfully: " + this.fwVersion + " / " + this.deviceSn);
        } else if (this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_KIOSK_III) {
            byte[] res;
            byte[] response;
            byte[] slice;
            if (IDT_Device._isK4) {
                sn2 = this._usb.sendCommand(Common.getHexStringFromBytes(Common.grsiP2Command((byte)18, (byte)1, new byte[0])), 2);
                if (sn2 == null || sn2.length < 10) {
                    return new Runnable(){

                        public void run() {
                            UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify failed to get Serial Number");
                            IDT_Device.isCommandRunning = false;
                            RemoteKeyInjectionTask.this._callback.timeout(258);
                        }
                    };
                }
                if (sn2[11] != 0) {
                    return new Runnable(){

                        public void run() {
                            UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify failed to get Serial Number: received NAK");
                            IDT_Device.isCommandRunning = false;
                            RemoteKeyInjectionTask.this._callback.timeout(258);
                        }
                    };
                }
                slice = Arrays.copyOfRange(sn2, 14, 24);
                this.deviceSn = Common.byteToString(slice);
                response = this._usb.sendCommand(Common.getHexStringFromBytes(Common.grsiP2Command((byte)-112, (byte)34, new byte[0])), 8);
                if (response == null || response.length < 16) {
                    return new Runnable(){

                        public void run() {
                            UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify failed to get Certificates");
                            IDT_Device.isCommandRunning = false;
                            RemoteKeyInjectionTask.this._callback.timeout(258);
                        }
                    };
                }
                int resLen = (response[12] & 0xFF) * 256 + (response[13] & 0xFF);
                res = new byte[resLen];
                System.arraycopy(response, 14, res, 0, resLen);
                this.fwVersion = Common.getHexStringFromBytes(res);
            } else {
                sn2 = this._usb.sendCommand(Common.getHexStringFromBytes(Common.grsiP2Command((byte)18, (byte)1, new byte[0])), 2);
                if (sn2 == null || sn2.length < 10) {
                    return new Runnable(){

                        public void run() {
                            UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify failed to get Serial Number");
                            IDT_Device.isCommandRunning = false;
                            RemoteKeyInjectionTask.this._callback.timeout(258);
                        }
                    };
                }
                if (sn2[11] != 0) {
                    return new Runnable(){

                        public void run() {
                            UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify failed to get Serial Number: received NAK");
                            IDT_Device.isCommandRunning = false;
                            RemoteKeyInjectionTask.this._callback.timeout(258);
                        }
                    };
                }
                slice = Arrays.copyOfRange(sn2, 14, 24);
                this.deviceSn = Common.byteToString(slice);
                response = this._usb.sendCommand(Common.getHexStringFromBytes(Common.grsiP2Command((byte)-112, (byte)34, new byte[0])), 8);
                if (response == null || response.length < 16 || response[11] != 0) {
                    return new Runnable(){

                        public void run() {
                            UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify failed to get Certificates");
                            IDT_Device.isCommandRunning = false;
                            RemoteKeyInjectionTask.this._callback.timeout(258);
                        }
                    };
                }
                int resLen = (response[12] & 0xFF) * 256 + (response[13] & 0xFF);
                res = new byte[resLen];
                System.arraycopy(response, 14, res, 0, resLen);
                this.fwVersion = Common.getHexStringFromBytes(res);
            }
        } else if (this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_USB || this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_MINISMART_II || this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_AUGUSTA) {
            fw = this._usb.sendCommand("7831", 5);
            if (fw == null || fw.length <= 7) {
                return new Runnable(){

                    public void run() {
                        UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify failed to get FW version/Serial Number");
                        IDT_Device.isCommandRunning = false;
                        RemoteKeyInjectionTask.this._callback.timeout(258);
                    }
                };
            }
            if (fw[3] != 6) {
                return new Runnable(){

                    public void run() {
                        UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify failed to get FW version/Serial Number: received NAK");
                        IDT_Device.isCommandRunning = false;
                        RemoteKeyInjectionTask.this._callback.timeout(258);
                    }
                };
            }
            this.fwVersion = Common.getHexStringFromBytes(fw);
            UMLog.i(this.TAG, "FW version: " + this.fwVersion);
            sn = this._usb.sendCommand("784602", 5);
            if (sn == null || sn.length <= 7) {
                return new Runnable(){

                    public void run() {
                        UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify failed to get FW version/Serial Number");
                        IDT_Device.isCommandRunning = false;
                        RemoteKeyInjectionTask.this._callback.timeout(258);
                    }
                };
            }
            if (sn[3] != 6) {
                return new Runnable(){

                    public void run() {
                        UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify failed to get FW version/Serial Number: received NAK");
                        IDT_Device.isCommandRunning = false;
                        RemoteKeyInjectionTask.this._callback.timeout(258);
                    }
                };
            }
            this.deviceSn = Common.getHexStringFromBytes(sn);
            UMLog.i(this.TAG, "Device SN: " + this.deviceSn);
        } else if (this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_SECUREMAG || this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_SECUREMAG_KB) {
            fw = this._usb.sendCommand("0252220371", 3);
            if (fw == null || fw.length < 4) {
                return new Runnable(){

                    public void run() {
                        UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify failed to get FW version/Serial Number");
                        IDT_Device.isCommandRunning = false;
                        RemoteKeyInjectionTask.this._callback.timeout(258);
                    }
                };
            }
            if (fw[0] != 6) {
                return new Runnable(){

                    public void run() {
                        UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify failed to get FW version/Serial Number: received NAK");
                        IDT_Device.isCommandRunning = false;
                        RemoteKeyInjectionTask.this._callback.timeout(258);
                    }
                };
            }
            this.fwVersion = Common.getHexStringFromBytes(fw);
            UMLog.i(this.TAG, "FW version: " + this.fwVersion);
            sn = this._usb.sendCommand("02524E031D", 7);
            if (sn == null || sn.length < 7) {
                return new Runnable(){

                    public void run() {
                        UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify failed to get FW version/Serial Number");
                        IDT_Device.isCommandRunning = false;
                        RemoteKeyInjectionTask.this._callback.timeout(258);
                    }
                };
            }
            if (sn[0] != 6) {
                return new Runnable(){

                    public void run() {
                        UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify failed to get FW version/Serial Number: received NAK");
                        IDT_Device.isCommandRunning = false;
                        RemoteKeyInjectionTask.this._callback.timeout(258);
                    }
                };
            }
            this.deviceSn = Common.getHexStringFromBytes(sn);
            UMLog.i(this.TAG, "Device SN: " + this.deviceSn);
        } else {
            return new Runnable(){

                public void run() {
                    UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify RKI failed: unsupported device");
                    IDT_Device.isCommandRunning = false;
                    RemoteKeyInjectionTask.this._callback.timeout(258);
                }
            };
        }
        try {
            byte[] resp;
            byte[] resp2;
            JSONObject authObj = null;
            byte[] result = null;
            if (this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_KIOSK_III) {
                DataInputStream is;
                Header[] headers;
                HttpEntity r_entity;
                HttpResponse res;
                StringEntity entity;
                BasicHttpParams httpParameters = new BasicHttpParams();
                int timeoutConnection = 15000;
                HttpConnectionParams.setConnectionTimeout((HttpParams)httpParameters, (int)timeoutConnection);
                int timeoutSocket = 35000;
                HttpConnectionParams.setSoTimeout((HttpParams)httpParameters, (int)timeoutSocket);
                DefaultHttpClient httpclient = new DefaultHttpClient((HttpParams)httpParameters);
                String SOAP_ACTION = "IDTECH01" + this.deviceSn + this.fwVersion;
                HttpPost httppost = new HttpPost(SRKI_URL);
                httppost.setHeader("Content-Type", "application/json; charset=utf-8");
                System.out.println("executing request" + httppost.getRequestLine());
                StringBuffer soap = new StringBuffer();
                soap.append(SOAP_ACTION);
                soap.append("");
                try {
                    StringEntity entity2 = new StringEntity(soap.toString(), "UTF-8");
                    httppost.setEntity((HttpEntity)entity2);
                    HttpResponse res2 = httpclient.execute((HttpUriRequest)httppost);
                    HttpEntity r_entity2 = res2.getEntity();
                    Header[] headers2 = res2.getAllHeaders();
                    if (r_entity2 != null) {
                        result = new byte[(int)r_entity2.getContentLength()];
                        if (r_entity2.isStreaming()) {
                            DataInputStream is2 = new DataInputStream(r_entity2.getContent());
                            is2.readFully(result);
                        }
                    }
                }
                catch (Exception E) {
                    System.out.println("Exception While Connecting: " + E.getMessage());
                    E.printStackTrace();
                }
                String strData = Common.getAsciiFromByte(result);
                if (result == null || result.length <= 9 || result[9] != 89) {
                    httpclient.getConnectionManager().shutdown();
                    return new Runnable(){

                        public void run() {
                            UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify failed to parse data from server");
                            IDT_Device.isCommandRunning = false;
                            RemoteKeyInjectionTask.this._callback.timeout(258);
                        }
                    };
                }
                byte[] data = Common.base16Decode(strData.substring(10, 94));
                byte[] response = this._usb.sendCommand(Common.getHexStringFromBytes(Common.grsiP2Command((byte)-112, (byte)35, data)), 8);
                if (response == null || response.length < 16 || response[11] != 0) {
                    httpclient.getConnectionManager().shutdown();
                    return new Runnable(){

                        public void run() {
                            UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify failed to get Certificates");
                            IDT_Device.isCommandRunning = false;
                            RemoteKeyInjectionTask.this._callback.timeout(259);
                        }
                    };
                }
                int respLen = (response[12] & 0xFF) * 256 + (response[13] & 0xFF);
                byte[] resp3 = new byte[respLen];
                System.arraycopy(response, 14, resp3, 0, respLen);
                strData = Common.getHexStringFromBytes(resp3);
                SOAP_ACTION = "IDTECH02" + this.deviceSn + strData;
                soap.setLength(0);
                soap.append(SOAP_ACTION);
                soap.append("");
                result = null;
                try {
                    entity = new StringEntity(soap.toString(), "UTF-8");
                    httppost.setEntity((HttpEntity)entity);
                    res = httpclient.execute((HttpUriRequest)httppost);
                    r_entity = res.getEntity();
                    headers = res.getAllHeaders();
                    if (r_entity != null) {
                        result = new byte[(int)r_entity.getContentLength()];
                        if (r_entity.isStreaming()) {
                            is = new DataInputStream(r_entity.getContent());
                            is.readFully(result);
                        }
                    }
                }
                catch (Exception E) {
                    System.out.println("Exception While Connecting: " + E.getMessage());
                    E.printStackTrace();
                }
                if (result == null || result.length <= 9 || result[9] != 89) {
                    httpclient.getConnectionManager().shutdown();
                    return new Runnable(){

                        public void run() {
                            UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify failed to parse data from server");
                            IDT_Device.isCommandRunning = false;
                            RemoteKeyInjectionTask.this._callback.timeout(259);
                        }
                    };
                }
                strData = Common.getAsciiFromByte(result);
                data = Common.base16Decode(strData.substring(10, strData.length() - 1));
                response = this._usb.sendCommand(Common.getHexStringFromBytes(Common.grsiP2Command((byte)-112, (byte)36, data)), 8);
                if (response == null || response.length < 16 || response[11] != 0) {
                    httpclient.getConnectionManager().shutdown();
                    return new Runnable(){

                        public void run() {
                            UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify failed to get Certificates");
                            IDT_Device.isCommandRunning = false;
                            RemoteKeyInjectionTask.this._callback.timeout(260);
                        }
                    };
                }
                respLen = (response[12] & 0xFF) * 256 + (response[13] & 0xFF);
                resp3 = new byte[respLen];
                System.arraycopy(response, 14, resp3, 0, respLen);
                strData = Common.getHexStringFromBytes(resp3);
                SOAP_ACTION = "IDTECH03" + this.deviceSn + strData;
                soap.setLength(0);
                soap.append(SOAP_ACTION);
                soap.append("");
                result = null;
                try {
                    entity = new StringEntity(soap.toString(), "UTF-8");
                    httppost.setEntity((HttpEntity)entity);
                    res = httpclient.execute((HttpUriRequest)httppost);
                    r_entity = res.getEntity();
                    headers = res.getAllHeaders();
                    if (r_entity != null) {
                        result = new byte[(int)r_entity.getContentLength()];
                        if (r_entity.isStreaming()) {
                            is = new DataInputStream(r_entity.getContent());
                            is.readFully(result);
                        }
                    }
                }
                catch (Exception E) {
                    System.out.println("Exception While Connecting: " + E.getMessage());
                    E.printStackTrace();
                }
                httpclient.getConnectionManager().shutdown();
                if (result != null && result.length > 9 && result[9] == 89) {
                    return new Runnable(){

                        public void run() {
                            UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify RKI Success");
                            IDT_Device.isCommandRunning = false;
                            RemoteKeyInjectionTask.this._callback.msgRKICompleted("00");
                        }
                    };
                }
                return new Runnable(){

                    public void run() {
                        UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify RKI timeout");
                        IDT_Device.isCommandRunning = false;
                        RemoteKeyInjectionTask.this._callback.timeout(257);
                    }
                };
            }
            if (this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ || this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V || this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB || this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V_USB || this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB || this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB || this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT || this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_COM) {
                DataInputStream is;
                Header[] headers;
                HttpEntity r_entity;
                HttpResponse res;
                StringEntity entity;
                String respStr = this.sendCommand("55524B4930");
                if (respStr == null) {
                    return new Runnable(){

                        public void run() {
                            UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify failed on Initialize RKI command");
                            IDT_Device.isCommandRunning = false;
                            RemoteKeyInjectionTask.this._callback.timeout(257);
                        }
                    };
                }
                if (respStr.length() < 30) {
                    return new Runnable(){

                        public void run() {
                            UMLog.i(RemoteKeyInjectionTask.this.TAG, "Response length is too short");
                            IDT_Device.isCommandRunning = false;
                            RemoteKeyInjectionTask.this._callback.timeout(258);
                        }
                    };
                }
                UMLog.i(this.TAG, "Response String 1: " + respStr);
                int len = respStr.length();
                String strData = respStr.substring(6, len - 6).toUpperCase(Locale.US);
                BasicHttpParams httpParameters = new BasicHttpParams();
                int timeoutConnection = 15000;
                HttpConnectionParams.setConnectionTimeout((HttpParams)httpParameters, (int)timeoutConnection);
                int timeoutSocket = 35000;
                HttpConnectionParams.setSoTimeout((HttpParams)httpParameters, (int)timeoutSocket);
                IDTHttpClient httpclient = new IDTHttpClient(IDT_Device.context);
                String SOAP_ACTION = "IDTECH01" + this.deviceSn + strData;
                HttpPost httppost = new HttpPost(LSRKI_URL);
                httppost.setHeader("Content-Type", "application/json; charset=utf-8");
                System.out.println("executing request" + httppost.getRequestLine());
                StringBuffer soap = new StringBuffer();
                soap.append(SOAP_ACTION);
                soap.append("");
                try {
                    entity = new StringEntity(soap.toString(), "UTF-8");
                    httppost.setEntity((HttpEntity)entity);
                    res = httpclient.execute((HttpUriRequest)httppost);
                    r_entity = res.getEntity();
                    headers = res.getAllHeaders();
                    if (r_entity != null) {
                        result = new byte[(int)r_entity.getContentLength()];
                        if (r_entity.isStreaming()) {
                            is = new DataInputStream(r_entity.getContent());
                            is.readFully(result);
                        }
                    }
                }
                catch (Exception E) {
                    System.out.println("Exception While Connecting: " + E.getMessage());
                    E.printStackTrace();
                }
                if ((strData = Common.getAsciiFromByte(result)) != null) {
                    len = strData.length();
                    strData = strData.substring(1, len - 1);
                }
                if (strData == null || !strData.startsWith("IDTECH01Y")) {
                    return new Runnable(){

                        public void run() {
                            UMLog.i(RemoteKeyInjectionTask.this.TAG, "Error RKI identifying device.");
                            IDT_Device.isCommandRunning = false;
                            RemoteKeyInjectionTask.this._callback.timeout(258);
                        }
                    };
                }
                respStr = this.sendCommand("55524B4931" + (strData = strData.substring(9).toUpperCase(Locale.US)));
                if (respStr == null) {
                    return new Runnable(){

                        public void run() {
                            UMLog.i(RemoteKeyInjectionTask.this.TAG, "Failed on key request command.");
                            IDT_Device.isCommandRunning = false;
                            RemoteKeyInjectionTask.this._callback.timeout(258);
                        }
                    };
                }
                UMLog.i(this.TAG, "Response String 2: " + respStr);
                len = respStr.length();
                strData = respStr.substring(6, len - 6).toUpperCase(Locale.US);
                SOAP_ACTION = "IDTECH02" + this.deviceSn + strData;
                soap = new StringBuffer();
                soap.append(SOAP_ACTION);
                soap.append("");
                try {
                    entity = new StringEntity(soap.toString(), "UTF-8");
                    httppost.setEntity((HttpEntity)entity);
                    res = httpclient.execute((HttpUriRequest)httppost);
                    r_entity = res.getEntity();
                    headers = res.getAllHeaders();
                    if (r_entity != null) {
                        result = new byte[(int)r_entity.getContentLength()];
                        if (r_entity.isStreaming()) {
                            is = new DataInputStream(r_entity.getContent());
                            is.readFully(result);
                        }
                    }
                }
                catch (Exception E) {
                    System.out.println("Exception While Connecting: " + E.getMessage());
                    E.printStackTrace();
                }
                if ((strData = Common.getAsciiFromByte(result)) != null) {
                    len = strData.length();
                    strData = strData.substring(1, len - 1);
                }
                if (strData == null || !strData.startsWith("IDTECH02Y")) {
                    return new Runnable(){

                        public void run() {
                            UMLog.i(RemoteKeyInjectionTask.this.TAG, "Error receiving keys.");
                            IDT_Device.isCommandRunning = false;
                            RemoteKeyInjectionTask.this._callback.timeout(258);
                        }
                    };
                }
                respStr = this.sendCommand("55524B4932" + (strData = strData.substring(9).toUpperCase(Locale.US)));
                if (respStr == null || respStr.length() < 7 || respStr.charAt(6) != '0' || respStr.charAt(7) != '6') {
                    return new Runnable(){

                        public void run() {
                            UMLog.i(RemoteKeyInjectionTask.this.TAG, "Failed on key request command.");
                            IDT_Device.isCommandRunning = false;
                            RemoteKeyInjectionTask.this._callback.timeout(258);
                        }
                    };
                }
                UMLog.i(this.TAG, "Response String 3: " + respStr);
                len = respStr.length();
                strData = respStr.substring(6, len - 6).toUpperCase(Locale.US);
                SOAP_ACTION = "IDTECH03" + this.deviceSn + strData;
                soap = new StringBuffer();
                soap.append(SOAP_ACTION);
                soap.append("");
                try {
                    entity = new StringEntity(soap.toString(), "UTF-8");
                    httppost.setEntity((HttpEntity)entity);
                    res = httpclient.execute((HttpUriRequest)httppost);
                    r_entity = res.getEntity();
                    headers = res.getAllHeaders();
                    if (r_entity != null) {
                        result = new byte[(int)r_entity.getContentLength()];
                        if (r_entity.isStreaming()) {
                            is = new DataInputStream(r_entity.getContent());
                            is.readFully(result);
                        }
                    }
                }
                catch (Exception E) {
                    System.out.println("Exception While Connecting: " + E.getMessage());
                    E.printStackTrace();
                }
                httpclient.getConnectionManager().shutdown();
                return new Runnable(){

                    public void run() {
                        UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify RKI Success");
                        IDT_Device.isCommandRunning = false;
                        RemoteKeyInjectionTask.this._callback.msgRKICompleted("00");
                    }
                };
            }
            authObj = this.submitRequest(String.valueOf(RKI_URL) + "authorize/" + this.deviceSn + "/" + this.fwVersion, "Authorize");
            UMLog.i(this.TAG, "URL: " + RKI_URL + "authorize/" + this.deviceSn + "/" + this.fwVersion);
            if (authObj == null) {
                return new Runnable(){

                    public void run() {
                        UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify failed to parse data from server");
                        IDT_Device.isCommandRunning = false;
                        RemoteKeyInjectionTask.this._callback.timeout(258);
                    }
                };
            }
            String urlResult = authObj.getString("Result");
            String command1 = null;
            if (!urlResult.equalsIgnoreCase("Success")) {
                if (urlResult.equalsIgnoreCase("Fail")) {
                    final String errorCode = authObj.getString("Error Code: ");
                    return new Runnable(){

                        public void run() {
                            UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify failed to authorize RKI: error code: " + errorCode);
                            IDT_Device.isCommandRunning = false;
                            RemoteKeyInjectionTask.this._callback.timeout(258);
                        }
                    };
                }
                return new Runnable(){

                    public void run() {
                        UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify failed to authorize RKI: unknown error");
                        IDT_Device.isCommandRunning = false;
                        RemoteKeyInjectionTask.this._callback.timeout(258);
                    }
                };
            }
            command1 = authObj.getString("Command");
            UMLog.i(this.TAG, "Success, next command: " + command1);
            if (command1 != null && this._taskExport.getReaderType() != ReaderInfo.DEVICE_TYPE.DEVICE_SECUREMAG && this._taskExport.getReaderType() != ReaderInfo.DEVICE_TYPE.DEVICE_SECUREMAG_KB) {
                command1 = this.trimNGACommand(command1);
            }
            if (command1 == null) {
                return new Runnable(){

                    public void run() {
                        UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify failed to authorize RKI");
                        IDT_Device.isCommandRunning = false;
                        RemoteKeyInjectionTask.this._callback.timeout(258);
                    }
                };
            }
            Object authStr = null;
            authStr = this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_SECUREMAG || this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_SECUREMAG_KB ? ((resp2 = this._usb.sendCommand(command1, 18)) == null || resp2.length < 7 ? null : Common.getHexStringFromBytes(resp2)) : this.sendCommand(command1);
            if (authStr == null) {
                return new Runnable(){

                    public void run() {
                        UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify failed on Initialize RKI command");
                        IDT_Device.isCommandRunning = false;
                        RemoteKeyInjectionTask.this._callback.timeout(257);
                    }
                };
            }
            UMLog.i(this.TAG, "Authentication String 1: " + (String)authStr);
            authObj = this.submitRequest(String.valueOf(RKI_URL) + "step1/" + (String)authStr, "Step 1");
            if (authObj == null) {
                return new Runnable(){

                    public void run() {
                        UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify failed to parse data from server");
                        IDT_Device.isCommandRunning = false;
                        RemoteKeyInjectionTask.this._callback.timeout(259);
                    }
                };
            }
            urlResult = authObj.getString("Result");
            String command4 = null;
            if (!urlResult.equalsIgnoreCase("Success")) {
                if (urlResult.equalsIgnoreCase("Fail")) {
                    final String errorCode = authObj.getString("Error Code: ");
                    return new Runnable(){

                        public void run() {
                            UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify failed to authorize RKI: error code: " + errorCode);
                            IDT_Device.isCommandRunning = false;
                            RemoteKeyInjectionTask.this._callback.timeout(259);
                        }
                    };
                }
                return new Runnable(){

                    public void run() {
                        UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify failed to authorize RKI: unknown error");
                        IDT_Device.isCommandRunning = false;
                        RemoteKeyInjectionTask.this._callback.timeout(259);
                    }
                };
            }
            command4 = authObj.getString("Command4");
            if (command4 == null) {
                return new Runnable(){

                    public void run() {
                        UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify failed to authorize RKI: unknown error");
                        IDT_Device.isCommandRunning = false;
                        RemoteKeyInjectionTask.this._callback.timeout(259);
                    }
                };
            }
            if (this._taskExport.getReaderType() != ReaderInfo.DEVICE_TYPE.DEVICE_SECUREMAG && this._taskExport.getReaderType() != ReaderInfo.DEVICE_TYPE.DEVICE_SECUREMAG_KB) {
                command4 = this.trimNGACommand(command4);
            }
            if (command4 == null) {
                return new Runnable(){

                    public void run() {
                        UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify failed to authorize RKI: wrong command protocol");
                        IDT_Device.isCommandRunning = false;
                        RemoteKeyInjectionTask.this._callback.timeout(259);
                    }
                };
            }
            authStr = this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_SECUREMAG || this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_SECUREMAG_KB ? ((resp = this._usb.sendCommand(command4, 18)) == null || resp.length < 7 ? null : Common.getHexStringFromBytes(resp)) : this.sendCommand(command4);
            if (authStr == null) {
                return new Runnable(){

                    public void run() {
                        UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify failed on RKI authentication");
                        IDT_Device.isCommandRunning = false;
                        RemoteKeyInjectionTask.this._callback.timeout(257);
                    }
                };
            }
            authObj = this.submitRequest(String.valueOf(RKI_URL) + "step2/" + this.deviceSn + "/" + (String)authStr, "Step 2");
            if (authObj == null) {
                return new Runnable(){

                    public void run() {
                        UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify failed to parse data from server");
                        IDT_Device.isCommandRunning = false;
                        RemoteKeyInjectionTask.this._callback.timeout(259);
                    }
                };
            }
            urlResult = authObj.getString("Result");
            String command5 = null;
            if (!urlResult.equalsIgnoreCase("Success")) {
                if (urlResult.equalsIgnoreCase("Fail")) {
                    final String errorCode = authObj.getString("Error Code: ");
                    return new Runnable(){

                        public void run() {
                            UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify failed to authorize RKI: error code: " + errorCode);
                            IDT_Device.isCommandRunning = false;
                            RemoteKeyInjectionTask.this._callback.timeout(259);
                        }
                    };
                }
                return new Runnable(){

                    public void run() {
                        UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify failed to authorize RKI: unknown error");
                        IDT_Device.isCommandRunning = false;
                        RemoteKeyInjectionTask.this._callback.timeout(259);
                    }
                };
            }
            command5 = authObj.getString("Command5");
            if (command5 == null) {
                return new Runnable(){

                    public void run() {
                        UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify failed to authorize RKI: unknown error");
                        IDT_Device.isCommandRunning = false;
                        RemoteKeyInjectionTask.this._callback.timeout(259);
                    }
                };
            }
            if (this._taskExport.getReaderType() != ReaderInfo.DEVICE_TYPE.DEVICE_SECUREMAG && this._taskExport.getReaderType() != ReaderInfo.DEVICE_TYPE.DEVICE_SECUREMAG_KB) {
                command5 = this.trimNGACommand(command5);
            }
            if (command5 == null) {
                return new Runnable(){

                    public void run() {
                        UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify failed to authorize RKI: wrong command protocol");
                        IDT_Device.isCommandRunning = false;
                        RemoteKeyInjectionTask.this._callback.timeout(257);
                    }
                };
            }
            if (this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_SECUREMAG || this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_SECUREMAG_KB) {
                byte[] resp4 = this._usb.sendCommand(command5, 18);
                if (resp4 != null && resp4.length >= 7) {
                    authStr = Common.getHexStringFromBytes(resp4);
                }
            } else {
                authStr = this.sendCommand(command5);
            }
            if (authStr == null) {
                return new Runnable(){

                    public void run() {
                        UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify failed on RKI authentication");
                        IDT_Device.isCommandRunning = false;
                        RemoteKeyInjectionTask.this._callback.timeout(257);
                    }
                };
            }
            authObj = this.submitRequest(String.valueOf(RKI_URL) + "step3/" + this.deviceSn + "/" + (String)authStr, "Step 3");
            if (authObj == null) {
                return new Runnable(){

                    public void run() {
                        UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify failed to parse data from server");
                        IDT_Device.isCommandRunning = false;
                        RemoteKeyInjectionTask.this._callback.timeout(260);
                    }
                };
            }
            urlResult = authObj.getString("Result");
            String mac = null;
            if (!urlResult.equalsIgnoreCase("Success")) {
                if (urlResult.equalsIgnoreCase("Fail")) {
                    final String errorCode = authObj.getString("Error Code: ");
                    return new Runnable(){

                        public void run() {
                            UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify failed to authorize RKI: error code: " + errorCode);
                            IDT_Device.isCommandRunning = false;
                            RemoteKeyInjectionTask.this._callback.timeout(260);
                        }
                    };
                }
                return new Runnable(){

                    public void run() {
                        UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify failed to authorize RKI: unknown error");
                        IDT_Device.isCommandRunning = false;
                        RemoteKeyInjectionTask.this._callback.timeout(257);
                    }
                };
            }
            mac = authObj.getString("Mac Result");
            if (mac != null) {
                final String macValue = mac;
                return new Runnable(){

                    public void run() {
                        UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify RKI Success");
                        IDT_Device.isCommandRunning = false;
                        RemoteKeyInjectionTask.this._callback.msgRKICompleted(macValue);
                    }
                };
            }
            return new Runnable(){

                public void run() {
                    UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify RKI timeout");
                    IDT_Device.isCommandRunning = false;
                    RemoteKeyInjectionTask.this._callback.timeout(257);
                }
            };
        }
        catch (JSONException e) {
            e.printStackTrace();
            return new Runnable(){

                public void run() {
                    UMLog.i(RemoteKeyInjectionTask.this.TAG, "notify failed to authorize RKI: unknown error");
                    IDT_Device.isCommandRunning = false;
                    RemoteKeyInjectionTask.this._callback.timeout(257);
                }
            };
        }
    }

    private String sendCommand(String cmd) {
        if (this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY) {
            ResDataStruct resp = new ResDataStruct();
            TaskManager.TaskStartRet ret = this._taskManager.task_start_command_for_fw(Common.makeCommand(cmd, 200), resp);
            if (ret != TaskManager.TaskStartRet.SUCCESS) {
                return null;
            }
            return Common.getHexStringFromBytes(resp.resData);
        }
        if (this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ || this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V) {
            ResDataStruct resp = new ResDataStruct();
            TaskManager.TaskStartRet ret = this._taskManager.task_start_command_for_fw(Common.makeCommand(cmd), resp);
            if (ret != TaskManager.TaskStartRet.SUCCESS) {
                return null;
            }
            return Common.getHexStringFromBytes(resp.resData);
        }
        if (this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_USB || this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_MINISMART_II || this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_KIOSK_III || this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB || this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V_USB || this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_VENDI || this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB || this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB || this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP2000 || this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB || this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800) {
            byte[] resp = this._usb.sendCommandForRKI(cmd, 5);
            if (resp == null || resp.length < 7) {
                return null;
            }
            return Common.getHexStringFromBytes(resp);
        }
        if (this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_COM) {
            byte[] resp = this._com.sendCommandForRKI(cmd, 5);
            if (resp == null || resp.length < 7) {
                return null;
            }
            return Common.getHexStringFromBytes(resp);
        }
        if (this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT || this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT || this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT) {
            byte[] resp = this._btle.sendCommandForRKI(cmd, 5);
            if (resp == null || resp.length < 7) {
                return null;
            }
            return Common.getHexStringFromBytes(resp);
        }
        return null;
    }

    private String trimNGACommand(String command) {
        if (command.startsWith("02") && command.endsWith("03") && command.length() > 14) {
            return command.substring(6, command.length() - 6);
        }
        return null;
    }

    private JSONObject submitRequest(String urlToRequest, String objName) {
        JSONObject jsonToReturn = null;
        try {
            urlToRequest = URLDecoder.decode(urlToRequest, "UTF-8");
            URL url = new URL(urlToRequest);
            BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream()));
            StringBuilder builder = new StringBuilder();
            String line = null;
            while ((line = in.readLine()) != null) {
                builder.append(line);
            }
            String response = builder.toString().replace("},}", "}}").replace("\",    }", "\"    }");
            JSONObject obj = new JSONObject(response);
            jsonToReturn = objName != null && objName.length() > 0 ? obj.getJSONObject(objName) : obj;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return jsonToReturn;
    }
}

