/*
 * Decompiled with CFR 0.152.
 */
package com.idtechproducts.device.audiojack.io;

import android.media.AudioTrack;
import com.idtechproducts.device.ReaderInfo;
import com.idtechproducts.device.StructConfigParameters;
import com.idtechproducts.device.audiojack.io.FreqCommPlayerAudioTrack;
import com.idtechproducts.device.audiojack.io.PlayerAudioTrack;
import com.idtechproducts.device.audiojack.io.UARTPlayerAudioTrack;
import com.idtechproducts.device.audiojack.io.UniJackCommandEncoder;
import com.idtechproducts.device.audiojack.io.UniPayIIICommandEncoder;

class Player {
    PlayerAudioTrack playerAudioTrack = null;
    static final int kAUDIO_CHANNEL = 12;
    static final int kAUDIO_ENCODING = 3;
    private static final int kFRAME_SIZE = 2;
    private AudioTrack command_At;

    public Player(ReaderInfo.DEVICE_TYPE readerType) {
        this.playerAudioTrack = readerType == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY ? new UARTPlayerAudioTrack() : (readerType == ReaderInfo.DEVICE_TYPE.DEVICE_UNIJACK ? new UniJackCommandEncoder() : (readerType == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ || readerType == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V ? new UniPayIIICommandEncoder() : new FreqCommPlayerAudioTrack()));
    }

    public void release() {
        this.stopCommand();
        if (this.command_At != null) {
            this.command_At.release();
            this.command_At = null;
        }
    }

    static byte[] synthesizeSquareWavePeriod(StructConfigParameters config, int squareWaveFrequency, int playbackFrequency) {
        if (squareWaveFrequency <= 0 || playbackFrequency <= 0) {
            throw new IllegalArgumentException();
        }
        int frameCount_total = (int)Math.round((double)playbackFrequency / (double)squareWaveFrequency);
        int frameCount_half = frameCount_total / 2;
        int frameCount_pos = frameCount_half - 1 + (frameCount_total & 1);
        int frameCount_neg = frameCount_half - 1;
        int H = -1;
        int M = -128;
        boolean L = true;
        byte[] midFrame = new byte[]{-128, -128};
        byte[] posFrame = new byte[]{-1, 1};
        byte[] negFrame = new byte[]{1, -1};
        if (config.getDirectionOutputWave() != 0) {
            byte[] t = posFrame;
            posFrame = negFrame;
            negFrame = t;
        }
        byte[] ret = new byte[frameCount_total * 2];
        int retI = 0;
        System.arraycopy(midFrame, 0, ret, retI, 2);
        retI += 2;
        int i = 0;
        while (i < frameCount_pos) {
            System.arraycopy(posFrame, 0, ret, retI, 2);
            retI += 2;
            ++i;
        }
        System.arraycopy(midFrame, 0, ret, retI, 2);
        retI += 2;
        i = 0;
        while (i < frameCount_neg) {
            System.arraycopy(negFrame, 0, ret, retI, 2);
            retI += 2;
            ++i;
        }
        return ret;
    }

    public void setConfig(StructConfigParameters newConfig) {
        if (this.command_At != null && this.command_At.getPlayState() == 3) {
            throw new IllegalStateException();
        }
        if (newConfig == null) {
            throw new NullPointerException();
        }
        this.release();
        this.playerAudioTrack.setConfig(newConfig);
    }

    public void startPlayingCommand(byte[] commandString) {
        if (commandString == null) {
            throw new NullPointerException();
        }
        this.checkInitializationState();
        this.stopCommand();
        this.command_At = this.playerAudioTrack.getCommandAudioTrack(commandString);
        this.command_At.play();
    }

    public void stopCommand() {
        try {
            if (this.command_At != null) {
                this.command_At.stop();
                this.command_At.release();
                this.command_At = null;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void checkInitializationState() {
        this.playerAudioTrack.checkInitializationState();
    }
}

