/*
 * Decompiled with CFR 0.152.
 */
package com.idtechproducts.device.usb;

import android.content.Context;
import com.idtechproducts.device.Common;
import com.idtechproducts.device.IDT_Device;
import com.idtechproducts.device.ReaderInfo;
import com.idtechproducts.device.ResDataStruct;
import com.idtechproducts.device.USBBypassListener;
import com.idtechproducts.device.audiojack.UMLog;
import com.idtechproducts.device.audiojack.tools.FirmwareUpdateTool;
import com.idtechproducts.device.audiojack.tools.FirmwareUpdateToolMsg;
import com.idtechproducts.device.usb.IDTechUsbHidMsg;
import com.idtechproducts.device.usb.UsbController;
import com.idtechproducts.device.usb.UsbControllerMsg;
import java.util.Arrays;

public class IDTechUsbHid {
    private static final String SDK_VER_STRING = "ID TECH USB-HID SDK Ver 1.0";
    private static final String TAG = "SDK::USB";
    private static final int VID = 2765;
    private static final int PID_UNIPAY = 12560;
    private static final int PID_MINISMART_II = 13328;
    private static final int PID_VP3300_AJ = 13600;
    private static final int PID_VP3300_BT = 13632;
    private static final int PID_BTPAY = 10512;
    private static final int PID_AUGUSTA = 14368;
    private static final int PID_UNIPAY_I_V = 12592;
    private static final int PID_UNIPAY_I_V_TTK = 12608;
    private static final int PID_AUGUSTA_S_TTK = 14384;
    private static final int PID_AUGUSTA_S = 14624;
    private static final int PID_AUGUSTA_S_THALES = 17424;
    private static final int PID_KIOSK_III = 14096;
    public static final int PID_KIOSK_IV = 17536;
    private static final int PID_VP2000 = 17460;
    private static final int PID_KIOSK_III_S = 10288;
    private static final int PID_VENDI = 13584;
    private static final int PID_VP3300_USB = 13616;
    public static final int PID_VP3600 = 17169;
    public static final int PID_VP5300 = 17488;
    private static final int PID_VP8800 = 16912;
    private static final int PID_SECUREMAG = 8208;
    private static final int PID_SECUREMAG_KB = 8240;
    private static final int PID_PIP_READER = 17984;
    private final IDTechUsbHidMsg _msg;
    private UsbController _usb = null;
    private Context _context;
    private volatile boolean _state_isConnected;
    private IDT_Device.TaskExport _taskExport;
    private USBBypassListener m_recListener;
    boolean isWakeupThreadRunning = false;
    PAT_Wakeup_Runnable wakeup_Runnable = null;
    private boolean isFirstTimeEraseSpace = true;

    public void externalConnect() {
        if (IDT_Device.getUSBBypass() && this._usb != null) {
            this._usb.externalConnect();
        }
    }

    public void externalDisconnect() {
        if (IDT_Device.getUSBBypass() && this._usb != null) {
            this._usb.externalDisconnect();
        }
    }

    public void externalDeviceNotFound() {
        if (IDT_Device.getUSBBypass() && this._usb != null) {
            this._usb.externalDeviceNotFound();
        }
    }

    public IDTechUsbHid(IDTechUsbHidMsg callback, Context context, IDT_Device.TaskExport taskExport, USBBypassListener listener, int PID) {
        this.m_recListener = listener;
        this._msg = callback;
        this._context = context;
        this._state_isConnected = false;
        this._taskExport = taskExport;
        switch (this._taskExport.getReaderType()) {
            case DEVICE_MINISMART_II: {
                this._usb = new UsbController(context, this._msg, new UsbControllerMsgImpl(), 2765, 13328, this.m_recListener);
                break;
            }
            case DEVICE_VP3300_AJ_USB: {
                this._usb = new UsbController(context, this._msg, new UsbControllerMsgImpl(), 2765, 13600, this.m_recListener);
                break;
            }
            case DEVICE_VP3300_BT_USB: {
                this._usb = new UsbController(context, this._msg, new UsbControllerMsgImpl(), 2765, 13632, this.m_recListener);
                break;
            }
            case DEVICE_UNIPAY_I_V_USB: {
                if (IDT_Device._isTTK) {
                    this._usb = new UsbController(context, this._msg, new UsbControllerMsgImpl(), 2765, 12608, this.m_recListener);
                    break;
                }
                this._usb = new UsbController(context, this._msg, new UsbControllerMsgImpl(), 2765, 12592, this.m_recListener);
                break;
            }
            case DEVICE_VENDI: {
                this._usb = new UsbController(context, this._msg, new UsbControllerMsgImpl(), 2765, 13584, this.m_recListener);
                break;
            }
            case DEVICE_BTPAY_USB: {
                this._usb = new UsbController(context, this._msg, new UsbControllerMsgImpl(), 2765, 10512, this.m_recListener);
                break;
            }
            case DEVICE_AUGUSTA: {
                if (IDT_Device._isSRED) {
                    this._usb = new UsbController(context, this._msg, new UsbControllerMsgImpl(), 2765, 14624, this.m_recListener);
                    break;
                }
                if (IDT_Device._isTTK) {
                    this._usb = new UsbController(context, this._msg, new UsbControllerMsgImpl(), 2765, 14384, this.m_recListener);
                    break;
                }
                if (IDT_Device._isThales) {
                    this._usb = new UsbController(context, this._msg, new UsbControllerMsgImpl(), 2765, 17424, this.m_recListener);
                    break;
                }
                this._usb = new UsbController(context, this._msg, new UsbControllerMsgImpl(), 2765, 14368, this.m_recListener);
                break;
            }
            case DEVICE_KIOSK_III: {
                if (IDT_Device._isSRED) {
                    this._usb = new UsbController(context, this._msg, new UsbControllerMsgImpl(), 2765, 10288, this.m_recListener);
                    break;
                }
                if (PID == 0) {
                    this._usb = new UsbController(context, this._msg, new UsbControllerMsgImpl(), 2765, 14096, this.m_recListener);
                    break;
                }
                this._usb = new UsbController(context, this._msg, new UsbControllerMsgImpl(), 2765, PID, this.m_recListener);
                break;
            }
            case DEVICE_PIP_READER: {
                this._usb = new UsbController(context, this._msg, new UsbControllerMsgImpl(), 2765, 17984, this.m_recListener);
                break;
            }
            case DEVICE_VP3300_USB: {
                this._usb = new UsbController(context, this._msg, new UsbControllerMsgImpl(), 2765, 13616, this.m_recListener);
                break;
            }
            case DEVICE_VP2000: {
                this._usb = new UsbController(context, this._msg, new UsbControllerMsgImpl(), 2765, 17460, this.m_recListener);
                break;
            }
            case DEVICE_NEO2_USB: {
                this._usb = new UsbController(context, this._msg, new UsbControllerMsgImpl(), 2765, PID, this.m_recListener);
                break;
            }
            case DEVICE_VP8800: {
                this._usb = new UsbController(context, this._msg, new UsbControllerMsgImpl(), 2765, 16912, this.m_recListener);
                break;
            }
            case DEVICE_SECUREMAG: {
                this._usb = new UsbController(context, this._msg, new UsbControllerMsgImpl(), 2765, 8208, this.m_recListener);
                break;
            }
            case DEVICE_SECUREMAG_KB: {
                this._usb = new UsbController(context, this._msg, new UsbControllerMsgImpl(), 2765, 8240, this.m_recListener);
                break;
            }
            default: {
                this._usb = new UsbController(context, this._msg, new UsbControllerMsgImpl(), 2765, 12560, this.m_recListener);
            }
        }
    }

    public static String getSDKVersionInfo() {
        return SDK_VER_STRING;
    }

    public void registerListen() {
        if (!this._usb.isRegistered()) {
            this._usb.registerReceiver();
        }
        if (this._usb.init()) {
            this._state_isConnected = true;
            if (Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB) {
                this._taskExport.setReaderType(ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB);
            } else if (Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_BTPAY_USB) {
                this._taskExport.setReaderType(ReaderInfo.DEVICE_TYPE.DEVICE_BTPAY_USB);
            } else if (Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_MINISMART_II) {
                this._taskExport.setReaderType(ReaderInfo.DEVICE_TYPE.DEVICE_MINISMART_II);
            } else if (Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_AUGUSTA) {
                this._taskExport.setReaderType(ReaderInfo.DEVICE_TYPE.DEVICE_AUGUSTA);
            } else if (Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V_USB) {
                this._taskExport.setReaderType(ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V_USB);
            } else if (Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VENDI) {
                this._taskExport.setReaderType(ReaderInfo.DEVICE_TYPE.DEVICE_VENDI);
            } else if (Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_KIOSK_III) {
                this._taskExport.setReaderType(ReaderInfo.DEVICE_TYPE.DEVICE_KIOSK_III);
            } else if (Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_PIP_READER) {
                this._taskExport.setReaderType(ReaderInfo.DEVICE_TYPE.DEVICE_PIP_READER);
            } else if (Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP2000) {
                this._taskExport.setReaderType(ReaderInfo.DEVICE_TYPE.DEVICE_VP2000);
            } else if (Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB) {
                this._taskExport.setReaderType(ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB);
            } else if (Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB) {
                this._taskExport.setReaderType(ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB);
            } else if (Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB) {
                this._taskExport.setReaderType(ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB);
            } else if (Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800) {
                this._taskExport.setReaderType(ReaderInfo.DEVICE_TYPE.DEVICE_VP8800);
            } else if (Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_SECUREMAG) {
                this._taskExport.setReaderType(ReaderInfo.DEVICE_TYPE.DEVICE_SECUREMAG);
            } else if (Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_SECUREMAG_KB) {
                this._taskExport.setReaderType(ReaderInfo.DEVICE_TYPE.DEVICE_SECUREMAG_KB);
            } else {
                this._taskExport.setReaderType(ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_USB);
            }
            this._msg.usb_onReceiveMsgConnected();
        }
    }

    public void unregisterListen() {
        if (this._usb.isRegistered()) {
            this._usb.unregisterReceiver();
        }
        this._state_isConnected = false;
    }

    public boolean isReaderConnected() {
        return this._state_isConnected;
    }

    public byte[] sendCommand(String cmd, int timeout) {
        if (!this._state_isConnected) {
            return null;
        }
        if (Common.isNeedWakeup()) {
            this.PAT_stopWakeupThread();
        }
        if (Common.getDeviceType() != ReaderInfo.DEVICE_TYPE.DEVICE_SECUREMAG && Common.getDeviceType() != ReaderInfo.DEVICE_TYPE.DEVICE_SECUREMAG_KB) {
            this._usb.disableSwipe();
        }
        byte[] command = Common.makeCommand(cmd);
        UMLog.i("**sendCommand**", String.valueOf(Common.base16Encode(command)) + " timeout: " + timeout);
        byte[] _return = this._usb.sendCommand(command, timeout);
        if (Common.isNeedWakeup()) {
            this.PAT_startWakeupThread();
        }
        return _return;
    }

    public byte[] sendCommandOnly(String cmd, int timeout) {
        if (!this._state_isConnected) {
            return null;
        }
        if (Common.isNeedWakeup()) {
            this.PAT_stopWakeupThread();
        }
        this._usb.disableSwipe();
        byte[] command = Common.makeCommand(cmd);
        UMLog.i("**sendCommand**", String.valueOf(Common.base16Encode(command)) + " timeout: " + timeout);
        byte[] _return = this._usb.sendCommandOnly(command, timeout);
        if (Common.isNeedWakeup()) {
            this.PAT_startWakeupThread();
        }
        return _return;
    }

    public byte[] PAT_sendCommand(String cmd, int timeout) {
        if (!this._state_isConnected) {
            return null;
        }
        this._usb.disableSwipe();
        byte[] command = Common.makeCommand(cmd);
        UMLog.i("**PAT_sendCommand**", String.valueOf(Common.base16Encode(command)) + " timeout: " + timeout);
        byte[] _return = this._usb.sendCommand(command, timeout);
        return _return;
    }

    public boolean isWakeup_Thread_Running() {
        return this.isWakeupThreadRunning;
    }

    public void PAT_Wakeup() {
        this._usb.disableSwipe();
        byte[] command = new byte[]{0};
        int ret = this._usb.writeNothing();
        UMLog.i("**writeNothing:", " ret = " + ret);
    }

    public void PAT_startWakeupThread() {
        if (this.isWakeupThreadRunning) {
            this.PAT_stopWakeupThread();
        }
        this.isWakeupThreadRunning = true;
        this.wakeup_Runnable = new PAT_Wakeup_Runnable();
        this.wakeup_Runnable.start();
    }

    public void PAT_stopWakeupThread() {
        if (!this.isWakeupThreadRunning) {
            return;
        }
        this.isWakeupThreadRunning = false;
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
        if (this.wakeup_Runnable != null) {
            while (this.wakeup_Runnable.isAlive()) {
                try {
                    this.wakeup_Runnable.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.wakeup_Runnable = null;
        }
    }

    public byte[] sendCommandForRKI(String cmd, int timeout) {
        if (!this._state_isConnected) {
            return null;
        }
        this._usb.disableSwipe();
        byte[] command = IDTechUsbHid.makeCommandForRKI(cmd);
        UMLog.i("**sendCommandForRKI**", String.valueOf(Common.base16Encode(command)) + " timeout: " + timeout);
        return this._usb.sendCommandForRKI(command, timeout);
    }

    public boolean readMessage(int timeout, long startTime, ResDataStruct respData, boolean ignoreLCDMsg) {
        return this._usb.readMessage(timeout, startTime, respData, ignoreLCDMsg);
    }

    private byte[] sendCommandFw(String cmd) {
        if (!this._state_isConnected) {
            return null;
        }
        byte[] command = Common.makeCommand(cmd);
        return this._usb.sendCommandFw(command);
    }

    public boolean startSwipeCard() {
        UMLog.i(TAG, "To enable Swipe...");
        if (!this._state_isConnected) {
            IDT_Device.isCommandRunning = false;
            return false;
        }
        return this._usb.enableSwipe();
    }

    public boolean startListenCard() {
        UMLog.i(TAG, "To enable Listen...");
        if (!this._state_isConnected) {
            return false;
        }
        return this._usb.enableListen();
    }

    public boolean stopListenCard() {
        UMLog.i(TAG, "To disable Listen...");
        return this._usb.disableListen();
    }

    public boolean startReadCard(int timeout, ResDataStruct respData) {
        UMLog.i(TAG, "To enable read...");
        if (!this._state_isConnected) {
            return false;
        }
        return this._usb.enableRead(timeout, respData);
    }

    public void stopSwipeCard() {
        UMLog.i(TAG, "To disable Swipe...");
        this._usb.disableSwipe();
    }

    public boolean setTimeoutOfSwipeCard(int timeoutValue) {
        this._usb.setTimeoutOfSwipeCard(timeoutValue);
        return true;
    }

    public void readBuffer(ResDataStruct respData) {
        this._usb.readBuffer(respData);
    }

    public boolean enterBootloader() {
        if (this._usb == null) {
            return false;
        }
        byte[] ret = this.sendCommand("78467A495246570000000000000000", 5);
        if (ret != null) {
            UMLog.w(TAG, "RET: " + Common.base16Encode(ret));
            return ret[3] == 6;
        }
        return false;
    }

    public boolean updateFirmware(FirmwareUpdateToolMsg _umtMsg, FirmwareUpdateTool.FMStruct fmFile) {
        if (this._usb == null) {
            return false;
        }
        FwUpdateThread fwThread = new FwUpdateThread(fmFile, _umtMsg);
        fwThread.start();
        return true;
    }

    private static byte[] makeCommandForRKI(String commandBodyData) {
        if (commandBodyData == null) {
            return null;
        }
        String sum = IDTechUsbHid.getSUM(commandBodyData);
        String lrc = IDTechUsbHid.getLRC(commandBodyData);
        short length = (short)(commandBodyData.length() / 2);
        byte[] lowHigh = new byte[2];
        byte[] cmdLen = new byte[1];
        lowHigh[0] = (byte)(length & 0xFF);
        lowHigh[1] = (byte)(length >> 8 & 0xFF);
        cmdLen[0] = lowHigh[0];
        String lengthCommand = Common.getHexStringFromBytes(lowHigh);
        String commandData = "02" + lengthCommand + commandBodyData + lrc + sum + "03";
        return Common.getByteArray(commandData);
    }

    private static String getSUM(String strData) {
        String strLRC = null;
        byte[] toCharArray = Common.getByteArray(strData);
        byte[] sum = new byte[]{toCharArray[0]};
        int i = 1;
        while (i < toCharArray.length) {
            sum[0] = (byte)(sum[0] + toCharArray[i]);
            ++i;
        }
        strLRC = Common.getHexStringFromBytes(sum);
        return strLRC;
    }

    public static String getLRC(String strData) {
        String strLRC = null;
        byte[] toCharArray = Common.getByteArray(strData);
        byte[] lrc = new byte[]{toCharArray[0]};
        int i = 1;
        while (i < toCharArray.length) {
            lrc[0] = (byte)(lrc[0] ^ toCharArray[i]);
            ++i;
        }
        strLRC = Common.getHexStringFromBytes(lrc);
        return strLRC;
    }

    private class FwUpdateThread
    extends Thread {
        FirmwareUpdateTool.FMStruct fmFile;
        FirmwareUpdateToolMsg _umtMsg;

        public FwUpdateThread(FirmwareUpdateTool.FMStruct fm, FirmwareUpdateToolMsg msg) {
            this.fmFile = fm;
            this._umtMsg = msg;
        }

        public void run() {
            block62: {
                block53: {
                    if (Common.getDeviceType() != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB && Common.getDeviceType() != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V_USB && Common.getDeviceType() != ReaderInfo.DEVICE_TYPE.DEVICE_KIOSK_III && Common.getDeviceType() != ReaderInfo.DEVICE_TYPE.DEVICE_PIP_READER && Common.getDeviceType() != ReaderInfo.DEVICE_TYPE.DEVICE_VENDI && Common.getDeviceType() != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB && Common.getDeviceType() != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB && Common.getDeviceType() != ReaderInfo.DEVICE_TYPE.DEVICE_VP2000 && Common.getDeviceType() != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB) break block53;
                    ResDataStruct respData = new ResDataStruct();
                    int timeout = 0;
                    int sleep = 0;
                    int cmdCount = 0;
                    int prevSend = -1;
                    int repeatCount = 0;
                    boolean jumpLine = false;
                    int i = 0;
                    while (i < this.fmFile.commands.length) {
                        block55: {
                            String[] strArray;
                            block57: {
                                byte[] ret;
                                String strCmd;
                                block61: {
                                    byte[] cmd;
                                    block59: {
                                        block60: {
                                            block58: {
                                                block56: {
                                                    block54: {
                                                        if (this.fmFile.commands[i].length() == 0) {
                                                            jumpLine = true;
                                                        }
                                                        if (!(strArray = this.fmFile.commands[i].split(":"))[0].equalsIgnoreCase("TIMEOUT")) break block54;
                                                        timeout = Integer.parseInt(strArray[1]);
                                                        if (timeout == 0) {
                                                            Common.commandTime = 5.0;
                                                            timeout = 5;
                                                        } else {
                                                            if (timeout < 2000) {
                                                                timeout = 2000;
                                                            }
                                                            Common.commandTime = timeout / 1000;
                                                        }
                                                        if (!IDTechUsbHid.this.isFirstTimeEraseSpace) {
                                                            this._umtMsg.onReceiveMsgUpdateFirmwareProgress(i / this.fmFile.commands.length + 1);
                                                        }
                                                        break block55;
                                                    }
                                                    if (!strArray[0].equalsIgnoreCase("SLEEP")) break block56;
                                                    sleep = Integer.parseInt(strArray[1]);
                                                    try {
                                                        Thread.sleep(sleep);
                                                    }
                                                    catch (InterruptedException ex) {
                                                        UMLog.i(IDTechUsbHid.TAG, "notify failed firmware update (Line#" + i + ") SLEEP");
                                                        this._umtMsg.onReceiveMsgUpdateFirmwareResult(303);
                                                        return;
                                                    }
                                                    if (!IDTechUsbHid.this.isFirstTimeEraseSpace) {
                                                        this._umtMsg.onReceiveMsgUpdateFirmwareProgress(i * 100 / this.fmFile.commands.length + 1);
                                                    }
                                                    break block55;
                                                }
                                                if (!strArray[0].equalsIgnoreCase("SEND")) break block57;
                                                cmd = Common.removeReportIds(strArray[1]);
                                                strCmd = Common.getHexStringFromBytes(cmd);
                                                ++cmdCount;
                                                if (cmd[10] == -57 && cmd[11] == 21) {
                                                    try {
                                                        Thread.sleep(10000L);
                                                    }
                                                    catch (InterruptedException ex) {
                                                        UMLog.i(IDTechUsbHid.TAG, "notify failed firmware update (Line#" + i + ") SEND");
                                                        this._umtMsg.onReceiveMsgUpdateFirmwareResult(303);
                                                        return;
                                                    }
                                                }
                                                if (cmd[10] != -57 || cmd[11] != 65) break block58;
                                                Common.setBootLoaderMode(true);
                                                if ((Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_KIOSK_III || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_PIP_READER) && !IDTechUsbHid.this.isFirstTimeEraseSpace) break block55;
                                            }
                                            repeatCount = prevSend == i ? ++repeatCount : 0;
                                            prevSend = i;
                                            ret = Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V_USB || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_KIOSK_III || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_PIP_READER || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VENDI || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB ? IDTechUsbHid.this._usb.sendCommandFw(cmd, timeout / 1000) : IDTechUsbHid.this._usb.sendCommand(cmd, timeout / 1000);
                                            if (Common.getDeviceType() != ReaderInfo.DEVICE_TYPE.DEVICE_KIOSK_III && Common.getDeviceType() != ReaderInfo.DEVICE_TYPE.DEVICE_PIP_READER) break block59;
                                            if (cmd[10] != -57 || cmd[11] != 65) break block60;
                                            if (IDTechUsbHid.this.isFirstTimeEraseSpace) {
                                                this._umtMsg.onReceiveMsgUpdateFirmwareResult(310);
                                                IDTechUsbHid.this.isFirstTimeEraseSpace = false;
                                                return;
                                            }
                                            break block61;
                                        }
                                        if (cmd[10] != -57 || cmd[11] != 22) break block61;
                                        respData.resData = new byte[16];
                                        System.arraycopy(Common.getByteArray("5669564F746563683200C7000000866E"), 0, respData.resData, 0, 16);
                                        break block55;
                                    }
                                    if (cmd[10] == -57 && cmd[11] == 18 && IDTechUsbHid.this.isFirstTimeEraseSpace) {
                                        this._umtMsg.onReceiveMsgUpdateFirmwareResult(310);
                                        IDTechUsbHid.this.isFirstTimeEraseSpace = false;
                                        return;
                                    }
                                }
                                if (ret == null) {
                                    UMLog.i(IDTechUsbHid.TAG, "notify failed firmware update (Line#" + i + ") SEND");
                                    this._umtMsg.onReceiveMsgUpdateFirmwareResult(303);
                                    return;
                                }
                                UMLog.i(IDTechUsbHid.TAG, "Line#" + i + " sent successfully.");
                                UMLog.i(IDTechUsbHid.TAG, strCmd);
                                if (strCmd.length() > 4053) {
                                    UMLog.i(IDTechUsbHid.TAG, strCmd.substring(4053));
                                }
                                respData.resData = new byte[ret.length];
                                System.arraycopy(ret, 0, respData.resData, 0, ret.length);
                                if (!IDTechUsbHid.this.isFirstTimeEraseSpace) {
                                    this._umtMsg.onReceiveMsgUpdateFirmwareProgress(i * 100 / this.fmFile.commands.length + 1);
                                }
                                break block55;
                            }
                            if (strArray[0].equalsIgnoreCase("WAIT")) {
                                byte[] resp = Common.removeReportIds(strArray[1]);
                                if (!Arrays.equals(resp, respData.resData)) {
                                    if (repeatCount < 3) {
                                        i = jumpLine ? (i -= 3) : (i -= 2);
                                    } else {
                                        UMLog.i(IDTechUsbHid.TAG, "notify failed firmware update (Line#" + i + ") WAIT");
                                        this._umtMsg.onReceiveMsgUpdateFirmwareResult(303);
                                        return;
                                    }
                                }
                                if (!IDTechUsbHid.this.isFirstTimeEraseSpace) {
                                    this._umtMsg.onReceiveMsgUpdateFirmwareProgress(i * 100 / this.fmFile.commands.length + 1);
                                }
                                try {
                                    Thread.sleep(500L);
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                            }
                        }
                        ++i;
                    }
                    this._umtMsg.onReceiveMsgUpdateFirmwareResult(301);
                    Common.setBootLoaderMode(false);
                    IDTechUsbHid.this.isFirstTimeEraseSpace = true;
                    break block62;
                }
                this._umtMsg.onReceiveMsgUpdateFirmwareProgress(0);
                this._umtMsg.onReceiveMsgUpdateFirmwareProgress(1);
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                byte[] ret = IDTechUsbHid.this.sendCommandFw("420000" + Common.base16Encode(this.fmFile.getBlock(0)));
                if (ret == null) {
                    UMLog.i(IDTechUsbHid.TAG, "notify failed firmware update (Block #0)");
                    this._umtMsg.onReceiveMsgUpdateFirmwareResult(303);
                    return;
                }
                if (ret[3] != 6) {
                    UMLog.i(IDTechUsbHid.TAG, "notify failed firmware update (Block #0)");
                    this._umtMsg.onReceiveMsgUpdateFirmwareResult(303);
                    return;
                }
                UMLog.i(IDTechUsbHid.TAG, "Block #0 sent successfully.");
                int curBlock = 0;
                while (curBlock < this.fmFile.N) {
                    int currentProgress = (curBlock + 2) * 100 / (this.fmFile.N + 3);
                    this._umtMsg.onReceiveMsgUpdateFirmwareProgress(currentProgress);
                    int blockNumber = curBlock + 1;
                    byte[] command = new byte[1027];
                    command[0] = 66;
                    command[1] = (byte)blockNumber;
                    command[2] = 0;
                    System.arraycopy(this.fmFile.getBlock(blockNumber), 0, command, 3, 1024);
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    ret = IDTechUsbHid.this.sendCommandFw(Common.getHexStringFromBytes(command));
                    if (ret == null) {
                        UMLog.i(IDTechUsbHid.TAG, "notify failed firmware update (Block #" + blockNumber + "-0)");
                        this._umtMsg.onReceiveMsgUpdateFirmwareResult(303);
                    } else if (ret[3] != 6) {
                        UMLog.i(IDTechUsbHid.TAG, "notify failed firmware update (Block #" + blockNumber + "-0)");
                        this._umtMsg.onReceiveMsgUpdateFirmwareResult(303);
                    } else {
                        UMLog.i(IDTechUsbHid.TAG, "Block #" + blockNumber + "-0 sent successfully.");
                    }
                    command = new byte[1027];
                    command[0] = 66;
                    command[1] = (byte)blockNumber;
                    command[2] = 1;
                    System.arraycopy(this.fmFile.getBlock(blockNumber), 1024, command, 3, 1024);
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    ret = IDTechUsbHid.this.sendCommandFw(Common.getHexStringFromBytes(command));
                    if (ret == null) {
                        UMLog.i(IDTechUsbHid.TAG, "notify failed firmware update (Block #" + blockNumber + "-1)");
                        this._umtMsg.onReceiveMsgUpdateFirmwareResult(303);
                    } else if (ret[3] != 6) {
                        UMLog.i(IDTechUsbHid.TAG, "notify failed firmware update (Block #" + blockNumber + "-1)");
                        this._umtMsg.onReceiveMsgUpdateFirmwareResult(303);
                    } else {
                        UMLog.i(IDTechUsbHid.TAG, "Block #" + blockNumber + "-1 sent successfully.");
                    }
                    command = new byte[259];
                    command[0] = 66;
                    command[1] = (byte)blockNumber;
                    command[2] = 2;
                    System.arraycopy(this.fmFile.getBlock(blockNumber), 2048, command, 3, 256);
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    ret = IDTechUsbHid.this.sendCommandFw(Common.getHexStringFromBytes(command));
                    if (ret == null) {
                        UMLog.i(IDTechUsbHid.TAG, "notify failed firmware update (Block #" + blockNumber + "-2)");
                        this._umtMsg.onReceiveMsgUpdateFirmwareResult(303);
                    } else if (ret[3] != 6) {
                        UMLog.i(IDTechUsbHid.TAG, "notify failed firmware update (Block #" + blockNumber + "-2)");
                        this._umtMsg.onReceiveMsgUpdateFirmwareResult(303);
                    } else {
                        UMLog.i(IDTechUsbHid.TAG, "Block #" + blockNumber + "-2 sent successfully.");
                    }
                    ++curBlock;
                }
                int currentProgress = (this.fmFile.N + 2) * 100 / (this.fmFile.N + 3);
                this._umtMsg.onReceiveMsgUpdateFirmwareProgress(currentProgress);
                byte[] checksumCommand = new byte[259];
                checksumCommand[0] = 66;
                checksumCommand[1] = -1;
                checksumCommand[2] = -1;
                System.arraycopy(this.fmFile.blockN, 0, checksumCommand, 3, 256);
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                ret = IDTechUsbHid.this.sendCommandFw(Common.base16Encode(checksumCommand));
                if (ret == null) {
                    UMLog.i(IDTechUsbHid.TAG, "notify failed firmware update (checksum block)");
                    this._umtMsg.onReceiveMsgUpdateFirmwareResult(304);
                } else if (ret[3] != 6) {
                    UMLog.i(IDTechUsbHid.TAG, "notify failed firmware update ((checksum block))");
                    this._umtMsg.onReceiveMsgUpdateFirmwareResult(304);
                } else {
                    UMLog.i(IDTechUsbHid.TAG, "Checksum block sent successfully.");
                    UMLog.i(IDTechUsbHid.TAG, "notify finished successfully");
                    this._umtMsg.onReceiveMsgUpdateFirmwareResult(301);
                }
            }
        }
    }

    class PAT_Wakeup_Runnable
    extends Thread {
        PAT_Wakeup_Runnable() {
        }

        public void run() {
            block16: {
                this.setName("Wakeup PAT-110 Thread Background");
                try {
                    try {
                        long timeBegin = System.currentTimeMillis();
                        long lastTime = 0L;
                        long wakeup_heartbeat = 4000L;
                        int ret = 0;
                        while (IDTechUsbHid.this.isWakeupThreadRunning) {
                            do {
                                if (!IDTechUsbHid.this.isWakeupThreadRunning) {
                                    break block16;
                                }
                                try {
                                    lastTime = System.currentTimeMillis() - timeBegin;
                                    if (lastTime > wakeup_heartbeat) {
                                        timeBegin = System.currentTimeMillis();
                                        IDTechUsbHid.this._usb.disableSwipe();
                                        int timeout = 5;
                                        int wakeup_option = 1;
                                        switch (wakeup_option) {
                                            case 0: {
                                                byte[] version = IDTechUsbHid.this.PAT_sendCommand("784601", timeout);
                                                UMLog.i("**Wakeup: Get Version **", "Ret:" + Common.getHexStringFromBytes(version));
                                                break;
                                            }
                                            case 1: {
                                                byte[] command = new byte[]{0};
                                                IDTechUsbHid.this._usb.PAT_wakeup_sendCommand(command, timeout);
                                                UMLog.i("**Wakeup: Zero Packet **" + lastTime, " Zero Packet  ");
                                                break;
                                            }
                                            case 2: {
                                                ret = IDTechUsbHid.this._usb.writeNothing();
                                                UMLog.i("**Wakeup: NULL Packet ** " + lastTime, " ret = " + ret);
                                            }
                                        }
                                        continue;
                                    }
                                    Thread.sleep(300L);
                                }
                                catch (InterruptedException e) {
                                    break block16;
                                }
                            } while (IDTechUsbHid.this.isWakeupThreadRunning);
                            if (IDTechUsbHid.this.isWakeupThreadRunning) continue;
                            break;
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        IDTechUsbHid.this.isWakeupThreadRunning = false;
                    }
                }
                finally {
                    IDTechUsbHid.this.isWakeupThreadRunning = false;
                }
            }
        }
    }

    private class UsbControllerMsgImpl
    implements UsbControllerMsg {
        private UsbControllerMsgImpl() {
        }

        public void onDeviceAttached() {
            if (IDTechUsbHid.this._usb.init()) {
                IDTechUsbHid.this._state_isConnected = true;
                if (IDTechUsbHid.this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY) {
                    IDTechUsbHid.this._taskExport.setReaderType(ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_USB);
                } else if (IDTechUsbHid.this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ) {
                    IDTechUsbHid.this._taskExport.setReaderType(ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB);
                } else if (IDTechUsbHid.this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V) {
                    IDTechUsbHid.this._taskExport.setReaderType(ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V_USB);
                } else if (IDTechUsbHid.this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_BTPAY) {
                    IDTechUsbHid.this._taskExport.setReaderType(ReaderInfo.DEVICE_TYPE.DEVICE_BTPAY_USB);
                } else if (IDTechUsbHid.this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_MINISMART_II) {
                    IDTechUsbHid.this._taskExport.setReaderType(ReaderInfo.DEVICE_TYPE.DEVICE_MINISMART_II);
                } else if (IDTechUsbHid.this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_AUGUSTA) {
                    IDTechUsbHid.this._taskExport.setReaderType(ReaderInfo.DEVICE_TYPE.DEVICE_AUGUSTA);
                } else if (IDTechUsbHid.this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_KIOSK_III) {
                    IDTechUsbHid.this._taskExport.setReaderType(ReaderInfo.DEVICE_TYPE.DEVICE_KIOSK_III);
                } else if (IDTechUsbHid.this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_PIP_READER) {
                    IDTechUsbHid.this._taskExport.setReaderType(ReaderInfo.DEVICE_TYPE.DEVICE_PIP_READER);
                } else if (IDTechUsbHid.this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP2000) {
                    IDTechUsbHid.this._taskExport.setReaderType(ReaderInfo.DEVICE_TYPE.DEVICE_VP2000);
                } else if (IDTechUsbHid.this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_VENDI) {
                    IDTechUsbHid.this._taskExport.setReaderType(ReaderInfo.DEVICE_TYPE.DEVICE_VENDI);
                } else if (IDTechUsbHid.this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB) {
                    IDTechUsbHid.this._taskExport.setReaderType(ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB);
                } else if (IDTechUsbHid.this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB) {
                    IDTechUsbHid.this._taskExport.setReaderType(ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB);
                } else if (IDTechUsbHid.this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB) {
                    IDTechUsbHid.this._taskExport.setReaderType(ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB);
                } else if (IDTechUsbHid.this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800) {
                    IDTechUsbHid.this._taskExport.setReaderType(ReaderInfo.DEVICE_TYPE.DEVICE_VP8800);
                } else if (IDTechUsbHid.this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_SECUREMAG) {
                    IDTechUsbHid.this._taskExport.setReaderType(ReaderInfo.DEVICE_TYPE.DEVICE_SECUREMAG);
                } else if (IDTechUsbHid.this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_SECUREMAG_KB) {
                    IDTechUsbHid.this._taskExport.setReaderType(ReaderInfo.DEVICE_TYPE.DEVICE_SECUREMAG_KB);
                }
                IDTechUsbHid.this._msg.usb_onReceiveMsgConnected();
            }
        }

        public void onDeviceDetached() {
            IDTechUsbHid.this._state_isConnected = false;
            IDTechUsbHid.this._msg.usb_onReceiveMsgDisconnected();
            if (IDTechUsbHid.this._usb != null) {
                IDTechUsbHid.this._usb.startCheckingConnection();
            }
        }

        public void onDeviceNotFound() {
            if (IDTechUsbHid.this._usb != null) {
                IDTechUsbHid.this._usb.startCheckingConnection();
            }
        }

        public void onDeviceMSRData(byte[] data) {
            UMLog.i(IDTechUsbHid.TAG, "Data: " + Common.getHexStringFromBytes(data));
            IDTechUsbHid.this._msg.usb_onReceiveMsgCardData(data);
        }
    }
}

