/*
 * Decompiled with CFR 0.152.
 */
package com.idtechproducts.device.audiojack.io;

import android.media.AudioTrack;
import com.idtechproducts.device.Common;
import com.idtechproducts.device.audiojack.io.PlayerAudioTrack;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Locale;

public class UARTPlayerAudioTrack
extends PlayerAudioTrack {
    static final int kAUDIO_CHANNEL = 4;
    static final int kAUDIO_ENCODING = 3;
    byte H = (byte)-1;
    byte M = (byte)-128;
    byte L = 1;
    byte[] midFrame = new byte[]{this.M};
    byte[] lineFrame = null;
    byte[] positiveFrame = null;
    byte[] negativeFrame = null;
    byte[] positiveFrameLine = null;
    byte[] peak2idleSmooth = new byte[20];

    public AudioTrack getCommandAudioTrack(byte[] commandString) {
        int[] ret_loopFrameIndex;
        boolean coverAllBaudRate;
        byte[] toneData;
        int outputFreq = this.config.getFrequenceOutput();
        AudioTrack ret = new AudioTrack(3, outputFreq, 4, 3, (toneData = this.synthesizeCommandString(commandString, coverAllBaudRate = Common.coverAllBaudRate, outputFreq, ret_loopFrameIndex = new int[2])).length, 0);
        if (ret.write(toneData, 0, toneData.length) != toneData.length) {
            ret.release();
            toneData = null;
            throw new RuntimeException();
        }
        if (ret.getState() != 1) {
            toneData = null;
            throw new RuntimeException();
        }
        toneData = null;
        return ret;
    }

    private void adjustFrame(int adjustBaudrate) {
        int i;
        int playbackFrequency = this.config.getFrequenceOutput();
        this.positiveFrame = null;
        this.negativeFrame = null;
        if (1 == this.config.getDirectionOutputWave()) {
            this.H = 1;
            this.L = (byte)-1;
            i = 0;
            while (i < 20) {
                this.peak2idleSmooth[i] = (byte)((i + 1) * 6);
                ++i;
            }
        } else {
            this.H = (byte)-1;
            this.L = 1;
            i = 0;
            while (i < 20) {
                this.peak2idleSmooth[i] = (byte)(255 - (i + 1) * 6);
                ++i;
            }
        }
        int sampleCount = (int)Math.round((double)playbackFrequency / (double)adjustBaudrate);
        switch (sampleCount) {
            case 3: {
                this.positiveFrame = new byte[sampleCount - 1];
                this.positiveFrameLine = new byte[sampleCount - 1];
                this.negativeFrame = new byte[sampleCount - 1];
                this.lineFrame = new byte[sampleCount - 1];
                int i2 = 0;
                while (i2 < sampleCount - 1) {
                    this.positiveFrame[i2] = this.H;
                    this.negativeFrame[i2] = this.L;
                    this.lineFrame[i2] = this.M;
                    ++i2;
                }
                break;
            }
            case 5: 
            case 10: 
            case 20: {
                this.positiveFrame = new byte[sampleCount];
                this.positiveFrameLine = new byte[sampleCount];
                this.negativeFrame = new byte[sampleCount];
                this.lineFrame = new byte[sampleCount];
                int i3 = 0;
                while (i3 < sampleCount) {
                    this.positiveFrame[i3] = this.H;
                    this.negativeFrame[i3] = this.L;
                    this.lineFrame[i3] = this.M;
                    ++i3;
                }
                break;
            }
        }
        System.arraycopy(this.positiveFrame, 0, this.positiveFrameLine, 0, this.positiveFrame.length);
    }

    private byte[] getWaveBufferData(byte[] charBuffer, int sampleCount) {
        ArrayList<byte[]> _listWaveData = new ArrayList<byte[]>();
        switch (sampleCount) {
            case 3: {
                byte[] tmpUARTByte;
                byte _data;
                if (charBuffer == null) break;
                int i = 0;
                while (i < charBuffer.length) {
                    _data = charBuffer[i];
                    tmpUARTByte = this.getWaveBufferDataByFlag3(_data);
                    _listWaveData.add(tmpUARTByte);
                    ++i;
                }
                break;
            }
            case 5: 
            case 10: 
            case 20: {
                byte[] tmpUARTByte;
                byte _data;
                if (charBuffer == null) break;
                int i = 0;
                while (i < charBuffer.length) {
                    _data = charBuffer[i];
                    tmpUARTByte = this.getWaveBufferDataByFlag5X(_data);
                    _listWaveData.add(tmpUARTByte);
                    ++i;
                }
                break;
            }
        }
        int totaoLenEx = 0;
        int totaoLen = 0;
        if (_listWaveData.size() <= 0) {
            return null;
        }
        int i = 0;
        while (i < _listWaveData.size()) {
            totaoLen += ((byte[])_listWaveData.get(i)).length;
            ++i;
        }
        byte[] realBuffer = new byte[totaoLen];
        int i2 = 0;
        while (i2 < _listWaveData.size()) {
            System.arraycopy(_listWaveData.get(i2), 0, realBuffer, totaoLenEx, ((byte[])_listWaveData.get(i2)).length);
            totaoLenEx += ((byte[])_listWaveData.get(i2)).length;
            ++i2;
        }
        _listWaveData.clear();
        _listWaveData = null;
        charBuffer = null;
        return realBuffer;
    }

    private byte[] getWaveBufferDataByFlag3(byte halfByte) {
        int writePos = 0;
        byte[] realBuffer = new byte[this.positiveFrame.length * 10 + 5];
        System.arraycopy(this.negativeFrame, 0, realBuffer, writePos, this.negativeFrame.length);
        writePos += this.negativeFrame.length;
        byte flag = (byte)(halfByte >> 4 & 0xF);
        switch (flag) {
            case 0: {
                byte oneBit = 0;
                byte fourBits = halfByte;
                int i = 0;
                while (i < 4) {
                    oneBit = (byte)(fourBits & 1);
                    if (oneBit == 0) {
                        System.arraycopy(this.positiveFrame, 0, realBuffer, writePos, this.positiveFrame.length);
                        System.arraycopy(this.midFrame, 0, realBuffer, writePos += this.positiveFrame.length, this.midFrame.length);
                        System.arraycopy(this.negativeFrame, 0, realBuffer, writePos += this.midFrame.length, this.negativeFrame.length);
                        writePos += this.negativeFrame.length;
                    } else {
                        System.arraycopy(this.negativeFrame, 0, realBuffer, writePos, this.negativeFrame.length);
                        System.arraycopy(this.midFrame, 0, realBuffer, writePos += this.negativeFrame.length, this.midFrame.length);
                        System.arraycopy(this.positiveFrame, 0, realBuffer, writePos += this.midFrame.length, this.positiveFrame.length);
                        writePos += this.positiveFrame.length;
                    }
                    fourBits = (byte)(halfByte >> 1 + i);
                    ++i;
                }
                System.arraycopy(this.positiveFrame, 0, realBuffer, writePos, this.positiveFrame.length);
                writePos += this.positiveFrame.length;
                break;
            }
            case 15: {
                writePos = 0;
                realBuffer = null;
                realBuffer = new byte[this.positiveFrameLine.length];
                int i = 0;
                while (i < 1) {
                    System.arraycopy(this.positiveFrameLine, 0, realBuffer, writePos, this.positiveFrameLine.length);
                    writePos += this.positiveFrameLine.length;
                    ++i;
                }
                break;
            }
            case 7: {
                realBuffer = null;
                realBuffer = new byte[this.lineFrame.length];
                writePos = 0;
                int i = 0;
                while (i < 1) {
                    System.arraycopy(this.lineFrame, 0, realBuffer, writePos, this.lineFrame.length);
                    writePos += this.lineFrame.length;
                    ++i;
                }
                break;
            }
            case 6: {
                realBuffer = null;
                realBuffer = new byte[this.peak2idleSmooth.length];
                writePos = 0;
                int i = 0;
                while (i < 1) {
                    System.arraycopy(this.peak2idleSmooth, 0, realBuffer, writePos, this.peak2idleSmooth.length);
                    writePos += this.peak2idleSmooth.length;
                    ++i;
                }
                break;
            }
        }
        return realBuffer;
    }

    private byte[] getWaveBufferDataByFlag5X(byte halfByte) {
        int writePos = 0;
        byte[] realBuffer = new byte[this.positiveFrame.length * 10];
        System.arraycopy(this.negativeFrame, 0, realBuffer, writePos, this.negativeFrame.length);
        writePos += this.negativeFrame.length;
        byte flag = (byte)(halfByte >> 4 & 0xF);
        switch (flag) {
            case 0: {
                byte oneBit = 0;
                byte fourBits = halfByte;
                int i = 0;
                while (i < 4) {
                    oneBit = (byte)(fourBits & 1);
                    if (oneBit == 0) {
                        System.arraycopy(this.positiveFrame, 0, realBuffer, writePos, this.positiveFrame.length);
                        System.arraycopy(this.negativeFrame, 0, realBuffer, writePos += this.positiveFrame.length, this.negativeFrame.length);
                        writePos += this.negativeFrame.length;
                    } else {
                        System.arraycopy(this.negativeFrame, 0, realBuffer, writePos, this.negativeFrame.length);
                        System.arraycopy(this.positiveFrame, 0, realBuffer, writePos += this.negativeFrame.length, this.positiveFrame.length);
                        writePos += this.positiveFrame.length;
                    }
                    fourBits = (byte)(halfByte >> 1 + i);
                    ++i;
                }
                System.arraycopy(this.positiveFrame, 0, realBuffer, writePos, this.positiveFrame.length);
                writePos += this.positiveFrame.length;
                break;
            }
            case 15: {
                writePos = 0;
                realBuffer = null;
                realBuffer = new byte[this.positiveFrameLine.length];
                int i = 0;
                while (i < 1) {
                    System.arraycopy(this.positiveFrameLine, 0, realBuffer, writePos, this.positiveFrameLine.length);
                    writePos += this.positiveFrameLine.length;
                    ++i;
                }
                break;
            }
            case 7: {
                realBuffer = null;
                realBuffer = new byte[this.lineFrame.length];
                writePos = 0;
                int i = 0;
                while (i < 1) {
                    System.arraycopy(this.lineFrame, 0, realBuffer, writePos, this.lineFrame.length);
                    writePos += this.lineFrame.length;
                    ++i;
                }
                break;
            }
            case 6: {
                realBuffer = null;
                realBuffer = new byte[this.peak2idleSmooth.length];
                writePos = 0;
                int i = 0;
                while (i < 1) {
                    System.arraycopy(this.peak2idleSmooth, 0, realBuffer, writePos, this.peak2idleSmooth.length);
                    writePos += this.peak2idleSmooth.length;
                    ++i;
                }
                break;
            }
        }
        return realBuffer;
    }

    public String writethedata(byte[] data, int length, boolean bSetBR) {
        Calendar c = Calendar.getInstance();
        int mHour = 0;
        int mMinute = 0;
        int mDay = 0;
        int second = 0;
        mDay = c.get(5);
        mHour = c.get(11);
        mMinute = c.get(12);
        second = c.get(13);
        int frequenceAudio = this.config.getFrequenceOutput();
        String strFileN = null;
        strFileN = String.format(Locale.US, "IDT_Log_Wave_%d_%d_%d_%d_%d.wav", mDay, mHour, mMinute, second, frequenceAudio);
        String _strSaveLogFilePath = Common.getMyStorageFilePath(Common.context);
        String strFileName = String.valueOf(_strSaveLogFilePath) + File.separator + strFileN;
        RandomAccessFile fisWriter = null;
        try {
            fisWriter = new RandomAccessFile(strFileName, "rw");
        }
        catch (FileNotFoundException e2) {
            e2.printStackTrace();
            return strFileN;
        }
        byte[] byArray = new byte[44];
        byArray[0] = 82;
        byArray[1] = 73;
        byArray[2] = 70;
        byArray[3] = 70;
        byArray[4] = 48;
        byArray[8] = 87;
        byArray[9] = 65;
        byArray[10] = 86;
        byArray[11] = 69;
        byArray[12] = 102;
        byArray[13] = 109;
        byArray[14] = 116;
        byArray[15] = 32;
        byArray[16] = 16;
        byArray[20] = 1;
        byArray[22] = 1;
        byArray[24] = -128;
        byArray[25] = -69;
        byArray[29] = 119;
        byArray[30] = 1;
        byArray[32] = 1;
        byArray[34] = 8;
        byArray[36] = 100;
        byArray[37] = 97;
        byArray[38] = 116;
        byArray[39] = 97;
        byte[] wav_template = byArray;
        try {
            fisWriter.write(wav_template);
        }
        catch (IOException e1) {
            e1.printStackTrace();
            return strFileN;
        }
        byte[] realBuffer = data;
        int dataBlock = length;
        try {
            fisWriter.write(realBuffer);
            realBuffer = null;
        }
        catch (IOException e) {
            e.printStackTrace();
            realBuffer = null;
            return strFileN;
        }
        try {
            Thread.sleep(10L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return strFileN;
        }
        try {
            fisWriter.seek(4L);
            long wavelength = wav_template.length + dataBlock - 8;
            byte[] byteWaveLength = new byte[]{(byte)(wavelength & 0xFFL), (byte)(wavelength >> 8 & 0xFFL), (byte)(wavelength >> 16 & 0xFFL), (byte)(wavelength >> 24 & 0xFFL)};
            fisWriter.write(byteWaveLength);
            fisWriter.seek(24L);
            byteWaveLength[0] = (byte)(frequenceAudio & 0xFF);
            byteWaveLength[1] = (byte)(frequenceAudio >> 8 & 0xFF);
            byteWaveLength[2] = (byte)(frequenceAudio >> 16 & 0xFF);
            byteWaveLength[3] = (byte)(frequenceAudio >> 24 & 0xFF);
            fisWriter.write(byteWaveLength);
            int frqA_2 = frequenceAudio * 2;
            fisWriter.seek(28L);
            byteWaveLength[0] = (byte)(frqA_2 & 0xFF);
            byteWaveLength[1] = (byte)(frqA_2 >> 8 & 0xFF);
            byteWaveLength[2] = (byte)(frqA_2 >> 16 & 0xFF);
            byteWaveLength[3] = (byte)(frqA_2 >> 24 & 0xFF);
            fisWriter.write(byteWaveLength);
            fisWriter.seek(40L);
            byteWaveLength[0] = (byte)(dataBlock & 0xFF);
            byteWaveLength[1] = (byte)(dataBlock >> 8 & 0xFF);
            byteWaveLength[2] = (byte)(dataBlock >> 16 & 0xFF);
            byteWaveLength[3] = (byte)(dataBlock >> 24 & 0xFF);
            fisWriter.write(byteWaveLength);
            fisWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            return strFileN;
        }
        return strFileN;
    }

    private byte[] synthesizeCommandString(byte[] command_string, boolean coverAllBaudRate, int playbackFrequency, int[] ret_loopFrameIndex) {
        int baudrate = this.config.getBaudRate();
        ArrayList<byte[]> _listWaveData = new ArrayList<byte[]>();
        int sampleCount = (int)Math.round((double)playbackFrequency / (double)baudrate);
        byte[] realBuffer = null;
        if (!coverAllBaudRate) {
            this.adjustFrame(this.config.getBaudRate());
            realBuffer = this.getWaveBufferData(command_string, sampleCount);
        } else {
            int[] baudList = new int[]{9600, 4800, 2400};
            int i = 0;
            while (i < 3) {
                baudrate = baudList[i];
                byte[] data = Common.makeSetBaudAndLevelCommand(this.config, baudrate);
                this.adjustFrame(baudrate);
                sampleCount = (int)Math.round((double)playbackFrequency / (double)baudrate);
                byte[] tmpUARTByte = this.getWaveBufferData(data, sampleCount);
                _listWaveData.add(tmpUARTByte);
                ++i;
            }
            int totaoLenEx = 0;
            int totaoLen = 0;
            if (_listWaveData.size() <= 0) {
                return null;
            }
            int i2 = 0;
            while (i2 < _listWaveData.size()) {
                totaoLen += ((byte[])_listWaveData.get(i2)).length;
                ++i2;
            }
            realBuffer = new byte[totaoLen];
            i2 = 0;
            while (i2 < _listWaveData.size()) {
                System.arraycopy(_listWaveData.get(i2), 0, realBuffer, totaoLenEx, ((byte[])_listWaveData.get(i2)).length);
                totaoLenEx += ((byte[])_listWaveData.get(i2)).length;
                ++i2;
            }
            _listWaveData.clear();
            _listWaveData = null;
        }
        return realBuffer;
    }
}

