/*
 * Decompiled with CFR 0.152.
 */
package com.idtechproducts.device;

import android.content.Context;
import com.idtechproducts.device.Common;
import java.io.InputStream;
import java.security.KeyStore;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.SingleClientConnManager;

public class IDTHttpClient
extends DefaultHttpClient {
    final Context context;

    public IDTHttpClient(Context context) {
        this.context = context;
    }

    protected ClientConnectionManager createClientConnectionManager() {
        SchemeRegistry registry = new SchemeRegistry();
        registry.register(new Scheme("http", (SocketFactory)PlainSocketFactory.getSocketFactory(), 80));
        registry.register(new Scheme("https", (SocketFactory)this.newSslSocketFactory(), 443));
        return new SingleClientConnManager(this.getParams(), registry);
    }

    private SSLSocketFactory newSslSocketFactory() {
        try {
            KeyStore trusted = KeyStore.getInstance("BKS");
            InputStream in = this.context.getResources().openRawResource(Common.mystore);
            try {
                trusted.load(in, "ez24get".toCharArray());
            }
            finally {
                in.close();
            }
            return new SSLSocketFactory(trusted);
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }
}

