/*
 * Decompiled with CFR 0.152.
 */
package com.idtechproducts.device;

import android.os.Build;
import com.idtechproducts.device.ReaderInfo;

public class StructConfigParameters
implements Cloneable {
    private int frequencyInput = 48000;
    private int iRecordReadBufferSize = 0;
    private int iRecordBufferSize = 0;
    private short useVOICE_RECOGNIZITION = 0;
    private int frequencyOutput = 48000;
    private short directionOutputWave = 0;
    private String versionToTestOtherDirection = null;
    private int baudRate = 9600;
    private byte shuttleChannel = (byte)48;
    private String strModel = "";
    private ReaderInfo.SupportStatus[] supportStatuses = new ReaderInfo.SupportStatus[ReaderInfo.DEVICE_TYPE.values().length];
    private short powerupWhenSwipe = 0;
    private short powerupLastBeforeCMD = (short)200;
    private short forceHeadsetPlug = 0;
    private short volumeLevelAdjust = 0;
    private short reverseAudioEvents = 0;

    public int getFrequenceInput() {
        return this.frequencyInput;
    }

    public int getRecordReadBufferSize() {
        return this.iRecordReadBufferSize;
    }

    public int getRecordBufferSize() {
        return this.iRecordBufferSize;
    }

    public short getUseVoiceRecognition() {
        return this.useVOICE_RECOGNIZITION;
    }

    public int getFrequenceOutput() {
        return this.frequencyOutput;
    }

    public short getDirectionOutputWave() {
        return this.directionOutputWave;
    }

    public String getVersionToTestOtherDirection() {
        return this.versionToTestOtherDirection;
    }

    public int getBaudRate() {
        return this.baudRate;
    }

    public byte getShuttleChannel() {
        return this.shuttleChannel;
    }

    public String getModelNumber() {
        return this.strModel;
    }

    public ReaderInfo.SupportStatus[] getSupportStatuses() {
        return (ReaderInfo.SupportStatus[])this.supportStatuses.clone();
    }

    public short getPowerupWhenSwipe() {
        return this.powerupWhenSwipe;
    }

    public short getPowerupLastBeforeCMD() {
        if (this.forceHeadsetPlug == 1) {
            return 600;
        }
        return this.powerupLastBeforeCMD;
    }

    public short getForceHeadsetPlug() {
        return this.forceHeadsetPlug;
    }

    public short getVolumeLevelAdjust() {
        return this.volumeLevelAdjust;
    }

    public short getReverseAudioEvents() {
        return this.reverseAudioEvents;
    }

    public void setFrequenceInput(int value) {
        this.frequencyInput = value;
    }

    public void setRecordReadBufferSize(int value) {
        this.iRecordReadBufferSize = value;
    }

    public void setRecordBufferSize(int value) {
        this.iRecordBufferSize = value;
    }

    public void setUseVoiceRecognition(short value) {
        this.useVOICE_RECOGNIZITION = value;
    }

    public void setFrequenceOutput(int value) {
        this.frequencyOutput = value;
    }

    public void setDirectionOutputWave(short value) {
        this.directionOutputWave = value;
    }

    public void setVersionToTestOtherDirection(String value) {
        this.versionToTestOtherDirection = value;
    }

    public void setBaudRate(int value) {
        this.baudRate = value;
    }

    public void setShuttleChannel(byte value) {
        this.shuttleChannel = value;
    }

    public void setModelNumber(String value) {
        this.strModel = value;
    }

    public void setSupportStatuses(ReaderInfo.SupportStatus[] value) {
        this.supportStatuses = (ReaderInfo.SupportStatus[])value.clone();
    }

    public void setPowerupWhenSwipe(short value) {
        this.powerupWhenSwipe = value;
    }

    public void setPowerupLastBeforeCMD(short value) {
        this.powerupLastBeforeCMD = value;
    }

    public void setForceHeadsetPlug(short value) {
        this.forceHeadsetPlug = value;
    }

    public void setVolumeLevelAdjust(short value) {
        this.volumeLevelAdjust = value;
    }

    public void setReverseAudioEvents(short value) {
        this.reverseAudioEvents = value;
    }

    public StructConfigParameters clone() {
        StructConfigParameters ret = new StructConfigParameters();
        ret.setFrequenceInput(this.getFrequenceInput());
        ret.setRecordReadBufferSize(this.getRecordReadBufferSize());
        ret.setRecordBufferSize(this.getRecordBufferSize());
        ret.setUseVoiceRecognition(this.getUseVoiceRecognition());
        ret.setFrequenceOutput(this.getFrequenceOutput());
        ret.setDirectionOutputWave(this.getDirectionOutputWave());
        ret.setVersionToTestOtherDirection(this.getVersionToTestOtherDirection());
        ret.setBaudRate(this.getBaudRate());
        ret.setShuttleChannel(this.getShuttleChannel());
        ret.setModelNumber(this.getModelNumber());
        ret.setSupportStatuses(this.getSupportStatuses());
        ret.setPowerupWhenSwipe(this.getPowerupWhenSwipe());
        ret.setPowerupLastBeforeCMD(this.getPowerupLastBeforeCMD());
        ret.setForceHeadsetPlug(this.getForceHeadsetPlug());
        ret.setVolumeLevelAdjust(this.getVolumeLevelAdjust());
        ret.setReverseAudioEvents(this.getReverseAudioEvents());
        return ret;
    }

    public ReaderInfo.SupportStatus querySupportStatus(ReaderInfo.DEVICE_TYPE readerType) {
        if (readerType == null) {
            return null;
        }
        if (readerType == ReaderInfo.DEVICE_TYPE.DEVICE_UNKNOWN) {
            return null;
        }
        ReaderInfo.SupportStatus ret = this.supportStatuses[readerType.ordinal()];
        return ret == null ? ReaderInfo.SupportStatus.UNSUPPORTED : ret;
    }

    public String toXMLString() {
        String endOfLine = "\n";
        StringBuffer sb = new StringBuffer();
        sb.append("<autoConfigResult manufacturer='" + Build.MANUFACTURER.toUpperCase() + "' model='" + Build.MODEL.replace(" ", "") + "'>" + endOfLine);
        sb.append("<directionOutputWave>" + this.directionOutputWave + "</directionOutputWave>" + endOfLine);
        sb.append("<InputFreq>" + this.frequencyInput + "</InputFreq>" + endOfLine);
        sb.append("<OutputFreq>" + this.frequencyOutput + "</OutputFreq>" + endOfLine);
        sb.append("<baudRate>" + this.baudRate + "</baudRate>" + endOfLine);
        sb.append("<shuttle_channel>" + this.shuttleChannel + "</shuttle_channel>" + endOfLine);
        sb.append("<useVoiceRecognition>" + this.useVOICE_RECOGNIZITION + "</useVoiceRecognition>" + endOfLine);
        if (this.forceHeadsetPlug == 1) {
            sb.append("<force_headset_plug>" + this.forceHeadsetPlug + "</force_headset_plug>" + endOfLine);
        }
        if (this.volumeLevelAdjust > 1) {
            sb.append("<volumeLevelAdjust>" + this.volumeLevelAdjust + "</volumeLevelAdjust>" + endOfLine);
        }
        sb.append("</autoConfigResult>" + endOfLine);
        return sb.toString();
    }
}

