/*
 * Decompiled with CFR 0.152.
 */
package com.idtechproducts.device;

import java.math.BigInteger;

public class CardData {
    private String stringData;
    private byte[] byteData;

    public CardData(String data) {
        if (data.length() % 2 == 0) {
            this.stringData = data;
            this.byteData = new byte[this.stringData.length() / 2];
            this.convertStringToByte();
        }
    }

    public CardData(byte[] data) {
        this.stringData = "";
        this.byteData = data;
        this.convertByteToString();
    }

    public String getSTX() {
        return this.stringData.substring(0, 2);
    }

    public int getDataLength() {
        if (!this.isDataEncrypted()) {
            return this.byteData.length;
        }
        return 0xFFFF & (this.byteData[2] << 8) + 255 & this.byteData[1];
    }

    public String getCardEncodeType() {
        if (!this.isDataEncrypted()) {
            return null;
        }
        return this.stringData.substring(6, 8);
    }

    public String getTrackStatus() {
        if (!this.isDataEncrypted()) {
            return null;
        }
        return this.stringData.substring(8, 10);
    }

    public int getTrack1Length() {
        if (!this.isDataEncrypted()) {
            return this.getT1Data().length() / 2;
        }
        return this.byteData[5];
    }

    public int getTrack2Length() {
        if (!this.isDataEncrypted()) {
            return this.getT2Data().length() / 2;
        }
        return this.byteData[6];
    }

    public int getTrack3Length() {
        if (!this.isDataEncrypted()) {
            return 0;
        }
        return this.byteData[7];
    }

    public String getFieldByte1() {
        if (!this.isDataEncrypted()) {
            return null;
        }
        return this.stringData.substring(16, 18);
    }

    public String getFieldByte2() {
        if (!this.isDataEncrypted()) {
            return null;
        }
        return this.stringData.substring(18, 20);
    }

    public String getT1Data() {
        if (!this.isDataEncrypted()) {
            int endIndex = this.stringData.indexOf("3f");
            return this.stringData.substring(0, endIndex + 2);
        }
        if (!this.isT1DataPresent()) {
            return null;
        }
        return this.stringData.substring(20, (this.getTrack1Length() + 10) * 2);
    }

    public String getT1DataAscii() {
        StringBuffer sf = new StringBuffer();
        if (!this.isDataEncrypted()) {
            int i = 0;
            while (i < this.getT1Data().length() / 2) {
                sf.append((char)this.byteData[i]);
                ++i;
            }
            return sf.toString();
        }
        if (!this.isT1DataPresent()) {
            return null;
        }
        int i = 10;
        while (i < this.getTrack1Length() + 10) {
            sf.append((char)this.byteData[i]);
            ++i;
        }
        return sf.toString();
    }

    public String getT2Data() {
        if (!this.isDataEncrypted()) {
            int startIndex = this.stringData.indexOf("3b");
            int endIndex1 = this.stringData.indexOf("3f");
            int endIndex2 = this.stringData.lastIndexOf("3f");
            if (endIndex2 > endIndex1 && startIndex > 0) {
                return this.stringData.substring(startIndex, endIndex2 + 2);
            }
            return null;
        }
        if (!this.isT1DataPresent()) {
            return null;
        }
        return this.stringData.substring((this.getTrack1Length() + 10) * 2, (this.getTrack1Length() + 10) * 2 + this.getTrack2Length() * 2);
    }

    public String getT2DataAscii() {
        String strData;
        StringBuffer sf = new StringBuffer();
        if (!this.isDataEncrypted() && (strData = this.getT2Data()) != null) {
            if (strData.length() > 0) {
                int startIndex = this.stringData.indexOf("3b");
                int endIndex = this.stringData.lastIndexOf("3f") + 2;
                int i = startIndex / 2;
                while (i < endIndex / 2) {
                    sf.append((char)this.byteData[i]);
                    ++i;
                }
                return sf.toString();
            }
            return null;
        }
        if (!this.isT1DataPresent()) {
            return null;
        }
        int i = this.getTrack1Length() + 10;
        while (i < this.getTrack1Length() + 10 + this.getTrack2Length()) {
            sf.append((char)this.byteData[i]);
            ++i;
        }
        return sf.toString();
    }

    public String getEncryptedSection() {
        if (!this.isDataEncrypted()) {
            return null;
        }
        int startIndex = 20;
        if (this.isT1DataPresent()) {
            startIndex += this.getTrack1Length() * 2;
        }
        if (this.isT2DataPresent()) {
            startIndex += this.getTrack2Length() * 2;
        }
        return this.stringData.substring(startIndex, startIndex + this.lengthOfEncryptedSection() * 2);
    }

    public int lengthOfEncryptedSection() {
        if (!this.isDataEncrypted()) {
            return 0;
        }
        int result = 0;
        if (this.isEncryptedWithTDES()) {
            result = this.getTrack1Length() % 8 == 0 ? (result += this.getTrack1Length()) : (result += this.getTrack1Length() / 8 * 8 + 8);
            result = this.getTrack2Length() % 8 == 0 ? (result += this.getTrack2Length()) : (result += this.getTrack2Length() / 8 * 8 + 8);
        } else if (this.isEncryptedWithAES()) {
            result = this.getTrack1Length() % 16 == 0 ? (result += this.getTrack1Length()) : (result += this.getTrack1Length() / 16 * 16 + 16);
            result = this.getTrack2Length() % 16 == 0 ? (result += this.getTrack2Length()) : (result += this.getTrack2Length() / 16 * 16 + 16);
        } else {
            return 0;
        }
        return result;
    }

    public String getSerialNumber() {
        if (!this.isDataEncrypted()) {
            return null;
        }
        if (!this.isSNPresent()) {
            return null;
        }
        if (this.isKSNPresent()) {
            return this.stringData.substring(this.stringData.length() - 46, this.stringData.length() - 26);
        }
        return this.stringData.substring(this.stringData.length() - 26, this.stringData.length() - 6);
    }

    public String getKSN() {
        if (!this.isDataEncrypted()) {
            return null;
        }
        if (!this.isKSNPresent()) {
            return null;
        }
        return this.stringData.substring(this.stringData.length() - 26, this.stringData.length() - 6);
    }

    public String getLRC() {
        if (!this.isDataEncrypted()) {
            return null;
        }
        return this.stringData.substring(this.stringData.length() - 6, this.stringData.length() - 4);
    }

    public String getCheckSum() {
        if (!this.isDataEncrypted()) {
            return null;
        }
        return this.stringData.substring(this.stringData.length() - 4, this.stringData.length() - 2);
    }

    public String getETX() {
        return this.stringData.substring(this.stringData.length() - 2);
    }

    public byte calculateCheckSum() {
        if (!this.isDataEncrypted()) {
            return 0;
        }
        byte result = 0;
        int i = 3;
        while (i < this.byteData.length - 3) {
            result = (byte)(result + this.byteData[i]);
            ++i;
        }
        return result;
    }

    public byte calculateLRC() {
        if (!this.isDataEncrypted()) {
            return 0;
        }
        byte result = 0;
        int i = 3;
        while (i < this.byteData.length - 3) {
            result = (byte)(result ^ this.byteData[i]);
            ++i;
        }
        return result;
    }

    public boolean isStartingWithSTX() {
        return this.getSTX().equals("02") || this.getSTX().equals("25");
    }

    public boolean isEndingWithETX() {
        return this.getETX().equalsIgnoreCase("03") || this.getETX().equals("0d");
    }

    public boolean isLRCCorrect() {
        if (!this.isDataEncrypted()) {
            return false;
        }
        String lrc = Integer.toHexString(0xFF & this.calculateLRC());
        if (lrc.length() == 1) {
            lrc = "0" + lrc;
        }
        return lrc.equalsIgnoreCase(this.getLRC());
    }

    public boolean isCheckSumCorrect() {
        if (!this.isDataEncrypted()) {
            return false;
        }
        String checkSum = Integer.toHexString(0xFF & this.calculateCheckSum());
        if (checkSum.length() == 1) {
            checkSum = "0" + checkSum;
        }
        return checkSum.equalsIgnoreCase(this.getCheckSum());
    }

    public boolean isSNPresent() {
        if (!this.isDataEncrypted()) {
            return false;
        }
        String binaryString = this.getFieldByte1Binary();
        if (binaryString.length() != 8) {
            return false;
        }
        return binaryString.charAt(0) == '1';
    }

    public boolean isKSNPresent() {
        if (!this.isDataEncrypted()) {
            return false;
        }
        String binaryString = this.getFieldByte2Binary();
        if (binaryString.length() != 8) {
            return false;
        }
        return binaryString.charAt(0) == '1';
    }

    public boolean isT1DataPresent() {
        if (!this.isDataEncrypted()) {
            return false;
        }
        String binaryString = this.getFieldByte1Binary();
        if (binaryString.length() != 8) {
            return false;
        }
        return binaryString.charAt(7) == '1';
    }

    public boolean isT2DataPresent() {
        if (!this.isDataEncrypted()) {
            return false;
        }
        String binaryString = this.getFieldByte1Binary();
        if (binaryString.length() != 8) {
            return false;
        }
        return binaryString.charAt(6) == '1';
    }

    public boolean isEncryptedWithTDES() {
        if (!this.isDataEncrypted()) {
            return false;
        }
        String binaryString = this.getFieldByte1Binary();
        while (binaryString.length() < 8) {
            binaryString = "00" + binaryString;
        }
        return binaryString.substring(2, 4).equals("00");
    }

    public boolean isEncryptedWithAES() {
        if (!this.isDataEncrypted()) {
            return false;
        }
        String binaryString = this.getFieldByte1Binary();
        if (binaryString.length() != 8) {
            return false;
        }
        return binaryString.substring(2, 4).equals("01");
    }

    public boolean isDataEncrypted() {
        if (this.byteData[0] == 37 && this.byteData[this.byteData.length - 1] == 13) {
            return false;
        }
        return this.byteData[0] == 2 && this.byteData[this.byteData.length - 1] == 3;
    }

    public String getFieldByte1Binary() {
        String binaryString = this.hexToBin(this.getFieldByte1());
        while (binaryString.length() < 8) {
            binaryString = "00" + binaryString;
        }
        return binaryString;
    }

    public String getFieldByte2Binary() {
        String binaryString = this.hexToBin(this.getFieldByte2());
        while (binaryString.length() < 8) {
            binaryString = "00" + binaryString;
        }
        return binaryString;
    }

    private void convertByteToString() {
        String str = null;
        StringBuffer hexString = new StringBuffer();
        int i = 0;
        while (i < this.byteData.length) {
            str = Integer.toHexString(0xFF & this.byteData[i]);
            if (str.length() == 1) {
                str = "0" + str;
            }
            hexString.append(str);
            ++i;
        }
        this.stringData = hexString.toString();
    }

    public String byteToString(byte[] value) {
        String str = null;
        StringBuffer hexString = new StringBuffer();
        int i = 0;
        while (i < value.length) {
            str = Integer.toHexString(0xFF & value[i]);
            if (str.length() == 1) {
                str = "0" + str;
            }
            hexString.append(str);
            ++i;
        }
        return hexString.toString();
    }

    public String byteToString(byte value) {
        return Integer.toHexString(0xFF & value);
    }

    private void convertStringToByte() {
        int i = 0;
        while (i < this.stringData.length() / 2) {
            this.byteData[i] = (byte)((Character.digit(this.stringData.charAt(i * 2), 16) << 4) + Character.digit(this.stringData.charAt(i * 2 + 1), 16));
            ++i;
        }
    }

    public String getStringData() {
        return this.stringData;
    }

    public byte[] getByteData() {
        return this.byteData;
    }

    public String toString() {
        String encryptionType = "No Encryption";
        if (this.isEncryptedWithTDES()) {
            encryptionType = "TDES";
        }
        if (this.isEncryptedWithAES()) {
            encryptionType = "AES";
        }
        if (this.isDataEncrypted()) {
            return "Encryption Type: " + encryptionType + "\n" + "STX: " + this.getSTX() + "\n" + "Data Length: " + this.getDataLength() + "\n" + "Card Encode Type: " + this.getCardEncodeType() + "\n" + "Track 1-3 Status: " + this.getTrackStatus() + "\n" + "Track 1 Data Length: " + this.getTrack1Length() + "\n" + "Track 2 Data Length: " + this.getTrack2Length() + "\n" + "Track 3 Data Length: " + this.getTrack3Length() + "\n" + "Field Byte 1: " + this.getFieldByte1() + "\n" + "Field Byte 2: " + this.getFieldByte2() + "\n\n" + "Track 1 Data: " + this.getT1Data() + "\n\n" + "Track 1 Data (Ascii): " + this.getT1DataAscii() + "\n\n" + "Track 2 Data: " + this.getT2Data() + "\n\n" + "Track 2 Data (Ascii): " + this.getT2DataAscii() + "\n\n" + "Encrypted Section: " + this.getEncryptedSection() + "\n\n" + "Serial Number: " + this.getSerialNumber() + "\n" + "KSN: " + this.getKSN() + "\n" + "LRC: " + this.getLRC() + "\n" + "Check Sum: " + this.getCheckSum() + "\n" + "ETX: " + this.getETX() + "\n\n" + "Strting with STX: " + this.isStartingWithSTX() + "\n" + "Ending with ETX: " + this.isEndingWithETX() + "\n" + "Checking LRC: " + this.isLRCCorrect() + "\n" + "Checking Check Sum: " + this.isCheckSumCorrect() + "\n";
        }
        return "Encryption Type: " + encryptionType + "\n" + "Track 1 Data: " + this.getT1Data() + "\n\n" + "Track 1 Data (Ascii): " + this.getT1DataAscii() + "\n\n" + "Track 2 Data: " + this.getT2Data() + "\n\n" + "Track 2 Data (Ascii): " + this.getT2DataAscii() + "\n\n";
    }

    public String hexToBin(String hex) {
        return new BigInteger(hex, 16).toString(2);
    }
}

