//  CreditCardTransaction.java
//  Sample App for PaymentSDK
//
//  Created by Samstaurej Siddiquie on 01/10/2019.
//  Copyright © 2019 Zeamster. All rights reserved.

package com.zeamster.sampleapp;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;

import androidx.annotation.NonNull;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentTransaction;

import com.zeamster.paymentsdk.transaction.TransactionAction;

public class CreditCardTransaction extends Fragment implements View.OnClickListener {

    public View onCreateView(@NonNull LayoutInflater inflater,
                             ViewGroup container, Bundle savedInstanceState) {

        MainActivity.transactionCategory = "CC";

        View root = inflater.inflate(R.layout.fragment_credit_card_transaction, container, false);

        Button btnAction = root.findViewById(R.id.btnSale);
        btnAction.setOnClickListener(this);

        btnAction = root.findViewById(R.id.btnRefund);
        btnAction.setOnClickListener(this);

        btnAction = root.findViewById(R.id.btnAuthOnly);
        btnAction.setOnClickListener(this);

        btnAction = root.findViewById(R.id.btnAuthIncrement);
        btnAction.setOnClickListener(this);

        btnAction = root.findViewById(R.id.btnAuthComplete);
        btnAction.setOnClickListener(this);

        btnAction = root.findViewById(R.id.btnForce);
        btnAction.setOnClickListener(this);

        btnAction = root.findViewById(R.id.btnAvsOnly);
        btnAction.setOnClickListener(this);

        return root;
    }

    @Override
    public void onClick(View view) {

        Button btnAction = view.getRootView().findViewById(view.getId());
        String action = MainActivity.actionsMapping.get(btnAction.getText());
        MainActivity.transactionAction = TransactionAction.valueOf(action);

        FragmentTransaction fr = getFragmentManager().beginTransaction();
        fr.replace(R.id.nav_host_fragment, new HeaderInformationFragment());
        fr.addToBackStack(null);
        fr.commit();
    }
}