//  ACHTransaction.java
//  Sample App for PaymentSDK
//
//  Created by Samstaurej Siddiquie on 01/10/2019.
//  Copyright © 2019 Zeamster. All rights reserved.

package com.zeamster.sampleapp;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;

import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentTransaction;

import com.zeamster.paymentsdk.transaction.TransactionAction;

public class ACHTransaction extends Fragment implements View.OnClickListener {

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container,
                             Bundle savedInstanceState) {

        MainActivity.transactionCategory = "ACH";

        View view = inflater.inflate(R.layout.fragment_ach, container, false);

        Button btnAction = view.findViewById(R.id.btnCredit);
        btnAction.setOnClickListener(this);

        btnAction = view.findViewById(R.id.btnDebit);
        btnAction.setOnClickListener(this);

        btnAction = view.findViewById(R.id.btnRefund);
        btnAction.setOnClickListener(this);

        btnAction = view.findViewById(R.id.btnAvsOnly);
        btnAction.setOnClickListener(this);

        return view;
    }

    @Override
    public void onClick(View view) {

        Button btnAction = view.getRootView().findViewById(view.getId());
        String action = MainActivity.actionsMapping.get(btnAction.getText());
        MainActivity.transactionAction = TransactionAction.valueOf(action);

        FragmentTransaction fr = getFragmentManager().beginTransaction();
        fr.replace(R.id.nav_host_fragment, new HeaderInformationFragment());
        fr.addToBackStack(null);
        fr.commit();

    }
}
