/*
 * Decompiled with CFR 0.152.
 */
package com.zeamster.paymentsdk.transaction;

import android.app.Activity;
import com.idtechproducts.device.IDT_VP3300;
import com.idtechproducts.device.ReaderInfo;
import com.zeamster.paymentsdk.resthandler.HttpMethod;
import com.zeamster.paymentsdk.resthandler.ICallback;
import com.zeamster.paymentsdk.resthandler.RestServiceClient;
import com.zeamster.paymentsdk.service.IDTECHBLEService;
import com.zeamster.paymentsdk.service.PaymentMethod;
import com.zeamster.paymentsdk.transaction.EncryptionFormat;
import com.zeamster.paymentsdk.transaction.EntryModeId;
import com.zeamster.paymentsdk.transaction.ICallbackEMV;
import com.zeamster.paymentsdk.transaction.ICallbackTransaction;
import com.zeamster.paymentsdk.transaction.Transaction;
import com.zeamster.paymentsdk.transaction.TransactionAction;
import java.util.HashMap;
import org.json.JSONObject;

public class EMVTransaction
extends Transaction
implements ICallback,
ICallbackTransaction {
    private static final String PAYMENT_METHOD = "payment_method";
    private static final String ACTION = "action";
    private static final String E_FORMAT = "e_format";
    private static final String ENTRY_MODE_ID = "entry_mode_id";
    private static final String E_TRACK_DATA = "e_track_data";
    private static final String EMV_REQUEST = "emv_request";
    private static final String E_SERIAL_NUMBER = "e_serial_number";
    private static final String DEVICE_MANUFACTURER = "DF7906313230303338";
    private ICallback initCallback;
    private IDTECHBLEService idTechBLEService;
    private TransactionAction transactionAction;
    private HashMap<String, Object> payload;

    public boolean isPluginRequest() {
        return this.idTechBLEService.isPluginRequest();
    }

    public void isPluginRequest(boolean pluginRequest) {
        this.idTechBLEService.isPluginRequest(pluginRequest);
    }

    public IDTECHBLEService getIdTechBLEService() {
        return this.idTechBLEService;
    }

    public ReaderInfo.DEVICE_TYPE getDeviceType() {
        return this.idTechBLEService.getDeviceType();
    }

    public void setDeviceType(ReaderInfo.DEVICE_TYPE deviceType) {
        this.idTechBLEService.setDeviceType(deviceType);
    }

    public IDT_VP3300 getIdt_vp3300() {
        return this.idTechBLEService.getIdt_vp3300();
    }

    public EMVTransaction(RestServiceClient restServiceClient, ICallbackEMV callbackEMV, Activity context, ReaderInfo.DEVICE_TYPE deviceType) {
        super(restServiceClient);
        this.idTechBLEService = new IDTECHBLEService(callbackEMV, context, deviceType);
    }

    public void scanForDevices() {
        this.scanForDevices(0L);
    }

    public void scanForDevices(long timeout) {
        this.scanForDevices("*", timeout);
    }

    public void scanForDevices(String searchString, long timeout) {
        this.idTechBLEService.scanForDevices(searchString, timeout);
    }

    public void stopScanForDevices() {
        this.idTechBLEService.stopScanForDevices();
    }

    public boolean connectDeviceByName(String deviceName) {
        return this.idTechBLEService.connectDeviceByName(deviceName);
    }

    public boolean connectDeviceByAddress(String address) {
        return this.idTechBLEService.connectDeviceByAddress(address);
    }

    public void performEMVSale(TransactionAction transactionAction, HashMap<String, Object> payload) {
        this.idTechBLEService.setCallbackTransaction(this);
        this.transactionAction = transactionAction;
        this.payload = payload;
        this.idTechBLEService.startEMVTransaction();
    }

    public void cancelEMVSale() {
        this.idTechBLEService.cancelEMVTransaction();
    }

    public void performRefund(HashMap<String, Object> payload) {
        this.restServiceClient.setRequestBody(this.convertToTransactionPayload(payload));
        this.perform(HttpMethod.POST);
    }

    public void performAuthOnly(HashMap<String, Object> payload) {
        this.restServiceClient.setRequestBody(this.convertToTransactionPayload(payload));
        this.perform(HttpMethod.POST);
    }

    public void performAVSOnly(HashMap<String, Object> payload) {
        this.restServiceClient.setRequestBody(this.convertToTransactionPayload(payload));
        this.perform(HttpMethod.POST);
    }

    @Override
    public void call(Object type, Object data, Object ksn, Object serial, Object isFallback) {
        if (type != null && type.toString().equalsIgnoreCase("MSR")) {
            this.payload.remove(EMV_REQUEST);
            this.payload.put(E_FORMAT, EncryptionFormat.IDTECH.toString().toLowerCase());
            this.payload.put(ENTRY_MODE_ID, EntryModeId.Swiped.getName());
            this.payload.put(E_TRACK_DATA, data.toString());
        } else if (type != null && type.toString().equalsIgnoreCase("EMV")) {
            this.payload.remove(E_TRACK_DATA);
            this.payload.put(E_FORMAT, EncryptionFormat.IDTECH_EMV.toString().toLowerCase());
            this.payload.put(ENTRY_MODE_ID, EntryModeId.ChipCardRead.getName());
            this.payload.put(EMV_REQUEST, data.toString() + DEVICE_MANUFACTURER);
        }
        this.payload.put(PAYMENT_METHOD, PaymentMethod.CC.name().toLowerCase());
        this.payload.put(ACTION, this.transactionAction.name().toLowerCase());
        this.payload.put(E_SERIAL_NUMBER, ksn.toString());
        this.restServiceClient.setRequestBody(this.convertToTransactionPayload(this.payload));
        this.perform(HttpMethod.POST);
    }

    public void runInitialDeviceSetup() {
        this.initCallback = this.restServiceClient.getCallback();
        this.restServiceClient.setCallback(this);
        HashMap<String, Object> deviceSettings = this.idTechBLEService.getDeviceSettings();
        this.restServiceClient.setRequestBody(deviceSettings);
        this.perform(HttpMethod.POST);
    }

    public void clearLog() {
        this.idTechBLEService.clearLog();
    }

    @Override
    public void onSuccess(String result) {
        block5: {
            if (result.contains("general_configuration")) {
                try {
                    JSONObject jsonObject = new JSONObject(result);
                    if (jsonObject.has("general_configuration") && jsonObject.getJSONObject("general_configuration").has("terminal_ics_type")) {
                        this.idTechBLEService.runInitialSetup(jsonObject);
                        this.initCallback.onSuccess("Device Initialized");
                        break block5;
                    }
                    this.initCallback.onSuccess(result);
                }
                catch (Exception ex) {
                    this.initCallback.onSuccess(result);
                }
            } else {
                this.initCallback.onSuccess(result);
            }
        }
    }

    @Override
    public void onFailure(String result) {
        this.initCallback.onFailure(result);
    }
}

