/*
 * Decompiled with CFR 0.152.
 */
package com.zeamster.paymentsdk.service;

import android.app.Activity;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.le.BluetoothLeScanner;
import android.bluetooth.le.ScanCallback;
import android.bluetooth.le.ScanResult;
import android.content.Context;
import android.os.Handler;
import android.util.Log;
import androidx.core.app.ActivityCompat;
import com.idtechproducts.device.Common;
import com.idtechproducts.device.IDTEMVData;
import com.idtechproducts.device.IDTMSRData;
import com.idtechproducts.device.IDT_VP3300;
import com.idtechproducts.device.OnReceiverListener;
import com.idtechproducts.device.ReaderInfo;
import com.idtechproducts.device.ResDataStruct;
import com.idtechproducts.device.StructConfigParameters;
import com.idtechproducts.device.bluetooth.BluetoothLEController;
import com.zeamster.paymentsdk.R;
import com.zeamster.paymentsdk.transaction.CardType;
import com.zeamster.paymentsdk.transaction.ICallbackEMV;
import com.zeamster.paymentsdk.transaction.ICallbackTransaction;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class IDTECHBLEService
implements OnReceiverListener {
    private static final int MY_PERMISSIONS_REQUEST_READ_CONTACTS = 3300;
    private static final int DEFAULT_TIMEOUT = 10000;
    private final int EMV_TIMEOUT = 90;
    private String btleDeviceAddress = "";
    private String btleDeviceName = "";
    private String message = "";
    private String log = "";
    private boolean btleDeviceRegistered;
    private boolean isReaderConnected = false;
    private IDT_VP3300 idt_vp3300;
    private ScanCallback scanCallback;
    private BluetoothAdapter mBtAdapter;
    private BluetoothLeScanner bluetoothLeScanner;
    private ArrayList<String> deviceNames = new ArrayList();
    private ArrayList<BluetoothDevice> discoveredDevices = new ArrayList();
    private ArrayList<Integer> scanErrorCodes = new ArrayList();
    private Handler handler = new Handler();
    private ReaderInfo.DEVICE_TYPE deviceType;
    private ICallbackEMV callback;
    private Activity context;
    private boolean isPluginRequest;
    private ICallbackTransaction callbackTransaction;
    private Map<String, byte[]> finalTransactionTags;
    public boolean isRefund;
    public String logsDATA = "";
    private String deviceSerialNumber = "";
    private String deviceEMVKernelVersion = "";
    public boolean isNonTechnicalFallback = false;
    private static ArrayList<CardType> cardDetails = new ArrayList();

    public IDTECHBLEService(ICallbackEMV callbackEMV, Activity context, ReaderInfo.DEVICE_TYPE deviceType) {
        this.callback = callbackEMV;
        this.context = context;
        this.deviceType = deviceType;
        this.createDeviceInstance();
        this.setCardDetails();
    }

    public ICallbackTransaction getCallbackTransaction() {
        return this.callbackTransaction;
    }

    public void setCallbackTransaction(ICallbackTransaction callbackTransaction) {
        this.callbackTransaction = callbackTransaction;
    }

    public boolean isPluginRequest() {
        return this.isPluginRequest;
    }

    public void isPluginRequest(boolean pluginRequest) {
        this.isPluginRequest = pluginRequest;
    }

    public ReaderInfo.DEVICE_TYPE getDeviceType() {
        return this.deviceType;
    }

    public void setDeviceType(ReaderInfo.DEVICE_TYPE deviceType) {
        this.deviceType = deviceType;
    }

    public int setTimeouts(String timeoutLength) {
        ResDataStruct resDataStruct = new ResDataStruct();
        int responseCode = this.idt_vp3300.device_sendDataCommand("F000", false, timeoutLength, resDataStruct);
        return responseCode;
    }

    public IDT_VP3300 getIdt_vp3300() {
        return this.idt_vp3300;
    }

    public ArrayList<Integer> getScanErrorCodes() {
        return this.scanErrorCodes;
    }

    private void createDeviceInstance() {
        switch (this.deviceType) {
            case DEVICE_VP3300_BT: {
                if (this.idt_vp3300 != null) {
                    this.idt_vp3300.unregisterListen();
                    this.idt_vp3300.release();
                    this.idt_vp3300 = null;
                    this.btleDeviceRegistered = false;
                }
                this.idt_vp3300 = new IDT_VP3300((OnReceiverListener)this, (Context)this.context);
                this.idt_vp3300.device_setDeviceType(this.deviceType);
                this.idt_vp3300.registerListen();
            }
        }
        this.loadXMLfile();
    }

    private void loadXMLfile() {
        String fileNameWithPath = this.getConfigurationFileFromRaw();
        if (!this.isFileExist(fileNameWithPath)) {
            fileNameWithPath = null;
        }
        this.idt_vp3300.config_setXMLFileNameWithPath(fileNameWithPath);
        Log.d((String)"Demo Info >>>>>", (String)"loadingConfigurationXMLFile begin.");
        this.idt_vp3300.config_loadingConfigurationXMLFile(true);
    }

    private String getConfigurationFileFromRaw() {
        return this.getXMLFileFromRaw("idt_unimagcfg_default.xml", R.raw.idt_unimagcfg_default);
    }

    private String getXMLFileFromRaw(String fileName, int res) {
        String fileNameWithPath = null;
        fileNameWithPath = fileName;
        try {
            InputStream in = this.context.getResources().openRawResource(res);
            int length = in.available();
            byte[] buffer = new byte[length];
            in.read(buffer);
            in.close();
            this.context.deleteFile(fileNameWithPath);
            FileOutputStream fout = this.context.openFileOutput(fileNameWithPath, 0);
            fout.write(buffer);
            fout.close();
            File fileDir = this.context.getFilesDir();
            fileNameWithPath = fileDir.getParent() + File.separator + fileDir.getName();
            fileNameWithPath = fileNameWithPath + File.separator + fileName;
        }
        catch (Exception e) {
            e.printStackTrace();
            fileNameWithPath = null;
        }
        return fileNameWithPath;
    }

    private boolean isFileExist(String path) {
        if (path == null) {
            return false;
        }
        File file = new File(path);
        return file.exists();
    }

    public ArrayList<String> scanForDevices(final String searchString, long timeout) {
        this.scanCallback = new ScanCallback(){

            public void onScanResult(int callbackType, ScanResult result) {
                if (searchString.equalsIgnoreCase("*") || result.getDevice().getName() != null && result.getDevice().getName().startsWith(searchString) || result.getDevice().getAddress() != null && result.getDevice().getAddress().startsWith(searchString)) {
                    for (BluetoothDevice bluetoothDevice : IDTECHBLEService.this.discoveredDevices) {
                        if (!bluetoothDevice.getAddress().contentEquals(result.getDevice().getAddress())) continue;
                        return;
                    }
                    IDTECHBLEService.this.discoveredDevices.add(result.getDevice());
                    if (result.getDevice().getName() != null && !result.getDevice().getName().isEmpty()) {
                        IDTECHBLEService.this.deviceNames.add(result.getDevice().getName());
                    } else {
                        IDTECHBLEService.this.deviceNames.add(result.getDevice().getAddress());
                    }
                    Log.d((String)"PaymentSDK", (String)("IDTECHBLEService.onScanResult: Found Device: " + result.getDevice().getName()));
                    IDTECHBLEService.this.callback.deviceScanResponse(result.getDevice().getAddress(), result.getDevice().getName());
                }
            }

            public void onBatchScanResults(List<ScanResult> results) {
                Log.d((String)"PaymentSDK", (String)"IDTECHBLEService.onBatchScanResults");
                for (ScanResult scanResult : results) {
                    this.onScanResult(1, scanResult);
                }
            }

            public void onScanFailed(int errorCode) {
                Log.d((String)"PaymentSDK", (String)("IDTECHBLEService.onScanFailed: " + String.valueOf(errorCode)));
                IDTECHBLEService.this.scanErrorCodes.add(errorCode);
            }
        };
        if (timeout < 10000L) {
            timeout = 10000L;
        }
        this.discoveredDevices.clear();
        this.scanLeDevice(timeout);
        return this.deviceNames;
    }

    private void scanLeDevice(long timeout) {
        if (this.mBtAdapter == null) {
            this.mBtAdapter = BluetoothAdapter.getDefaultAdapter();
        }
        if (this.mBtAdapter != null) {
            this.bluetoothLeScanner = this.mBtAdapter.getBluetoothLeScanner();
            if (this.bluetoothLeScanner != null) {
                if (!this.isPluginRequest()) {
                    Log.d((String)"PaymentSDK", (String)"IDTECHBLEService.scanLeDevice: Request Permissions");
                    ActivityCompat.requestPermissions((Activity)this.context, (String[])new String[]{"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION"}, (int)3300);
                }
                this.handler.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        Log.d((String)"PaymentSDK", (String)"IDTECHBLEService.scanLeDevice: Stopping Scan");
                        IDTECHBLEService.this.bluetoothLeScanner.stopScan(IDTECHBLEService.this.scanCallback);
                        IDTECHBLEService.this.callback.deviceScanCompleted();
                    }
                }, timeout);
                Log.d((String)"PaymentSDK", (String)"IDTECHBLEService.scanLeDevice: startScan");
                this.bluetoothLeScanner.startScan(this.scanCallback);
            } else {
                Log.d((String)"PaymentSDK", (String)"IDTECHBLEService.scanLeDevice: bluetoothLeScanner is null");
                this.callback.deviceScanCompleted();
            }
        } else {
            Log.d((String)"PaymentSDK", (String)"IDTECHBLEService.scanLeDevice: mBtAdapter is null");
            this.callback.deviceScanCompleted();
        }
    }

    public void stopScanForDevices() {
        if (this.bluetoothLeScanner != null) {
            Log.d((String)"PaymentSDK", (String)"IDTECHBLEService.stopScanForDevices");
            this.bluetoothLeScanner.stopScan(this.scanCallback);
        } else {
            Log.d((String)"PaymentSDK", (String)"IDTECHBLEService.stopScanForDevices: blueToothLeScanner null");
        }
    }

    public boolean connectDeviceByAddress(String deviceAddress) {
        BluetoothDevice bluetoothDevice;
        if (this.idt_vp3300 != null && this.btleDeviceRegistered) {
            this.idt_vp3300.unregisterListen();
            this.btleDeviceRegistered = false;
        }
        if (deviceAddress != null && !deviceAddress.isEmpty() && deviceAddress.length() == 17 && deviceAddress.charAt(2) == ':' && deviceAddress.charAt(5) == ':' && deviceAddress.charAt(8) == ':' && deviceAddress.charAt(11) == ':' && deviceAddress.charAt(14) == ':' && (bluetoothDevice = this.getDeviceByAddress(deviceAddress)) != null) {
            BluetoothLEController.setBluetoothDevice((BluetoothDevice)bluetoothDevice);
            this.btleDeviceAddress = deviceAddress;
            String string = this.btleDeviceName = bluetoothDevice.getName() != null ? bluetoothDevice.getName() : "";
            if (!this.btleDeviceRegistered) {
                this.idt_vp3300.registerListen();
                this.btleDeviceRegistered = true;
            }
            return true;
        }
        Log.d((String)"PaymentSDK", (String)"IDTECHBLEService.connectDeviceByAddress Failed");
        return false;
    }

    public boolean connectDeviceByName(String deviceName) {
        BluetoothDevice bluetoothDevice;
        if (this.idt_vp3300 != null && this.btleDeviceRegistered) {
            this.idt_vp3300.unregisterListen();
            this.btleDeviceRegistered = false;
        }
        if (deviceName != null && !deviceName.isEmpty() && (bluetoothDevice = this.getDeviceByName(deviceName)) != null) {
            BluetoothLEController.setBluetoothDevice((BluetoothDevice)bluetoothDevice);
            this.btleDeviceName = deviceName;
            String string = this.btleDeviceAddress = bluetoothDevice.getAddress() != null ? bluetoothDevice.getAddress() : "";
            if (!this.btleDeviceRegistered) {
                this.idt_vp3300.registerListen();
                this.btleDeviceRegistered = true;
            }
            return true;
        }
        Log.d((String)"PaymentSDK", (String)"IDTECHBLEService.connectDeviceByName Failed");
        return false;
    }

    public boolean disconnectDevice() {
        if (this.idt_vp3300 != null && this.btleDeviceRegistered) {
            Log.d((String)"PaymentSDK", (String)"IDTECHBLEService.disconnectDevice");
            this.idt_vp3300.unregisterListen();
            this.btleDeviceRegistered = false;
            this.idt_vp3300.device_disconnectBLE();
            this.deviceDisconnected();
        } else {
            Log.d((String)"PaymentSDK", (String)"IDTECHBLEService.disconnectDevice Failed");
        }
        return true;
    }

    private BluetoothDevice getDeviceByName(String name) {
        for (BluetoothDevice bluetoothDevice : this.discoveredDevices) {
            if (bluetoothDevice.getName() == null || !bluetoothDevice.getName().equalsIgnoreCase(name)) continue;
            return bluetoothDevice;
        }
        return null;
    }

    private BluetoothDevice getDeviceByAddress(String address) {
        for (BluetoothDevice bluetoothDevice : this.discoveredDevices) {
            if (bluetoothDevice.getAddress() == null || !bluetoothDevice.getAddress().equalsIgnoreCase(address)) continue;
            return bluetoothDevice;
        }
        return null;
    }

    public String getConnectedDeviceAndStatus() {
        String device = "UNKNOWN";
        if (this.btleDeviceName != null && !this.btleDeviceName.isEmpty()) {
            device = this.btleDeviceName;
        } else if (this.btleDeviceAddress != null && !this.btleDeviceAddress.isEmpty()) {
            device = this.btleDeviceAddress;
        }
        String status = "DISCONNECTED";
        if (this.isReaderConnected) {
            status = "CONNECTED";
        }
        return status + " - " + device;
    }

    public void clearLog() {
        this.log = "";
    }

    public void runInitialSetup(JSONObject jsonObject) {
        this.message = "Running initial device setup..";
        this.log = "";
        this.sendResponse();
        try {
            if (jsonObject.has("general_configuration")) {
                JSONObject generalConf = jsonObject.getJSONObject("general_configuration");
                if (generalConf.has("terminal_ics_type")) {
                    this.setTerminalMajorConfiguration(generalConf.getString("terminal_ics_type"));
                }
                if (generalConf.has("terminal_data")) {
                    this.setTerminalData(generalConf.getString("terminal_data"));
                }
                if (generalConf.has("crl")) {
                    this.setCRLData(generalConf.getString("crl"));
                }
                if (generalConf.has("contact")) {
                    this.setContactSettings(generalConf.getJSONObject("contact"));
                }
                if (generalConf.has("contactless")) {
                    this.setContactlessSettings(generalConf.getJSONObject("contactless"));
                }
            }
        }
        catch (JSONException ex) {
            this.log = ex.getMessage();
        }
        this.message = "Initial device setup completed.";
        this.sendResponse();
    }

    private void setContactlessSettings(JSONObject contactless) throws JSONException {
        if (contactless.has("capk")) {
            this.setCTLSCAPKData(contactless.getJSONArray("capk"));
        }
        if (contactless.has("aids")) {
            this.setCTLSAIDData(contactless.getJSONArray("aids"));
        }
        if (contactless.has("configuration_groups")) {
            this.setCTLSGroupData(contactless.getJSONArray("configuration_groups"));
        }
    }

    private void setCTLSGroupData(JSONArray configuration_groups) throws JSONException {
        this.message = "Setting Configuration Group Data";
        this.sendResponse();
        for (int i = 0; i < configuration_groups.length(); ++i) {
            JSONObject group = configuration_groups.getJSONObject(i);
            ResDataStruct resDataStruct = new ResDataStruct();
            int groupID = group.getInt("group");
            byte[] key = Common.getBytesFromHexString((String)("FFE4010" + String.valueOf(groupID) + group.getString("data")));
            int n = this.idt_vp3300.ctls_setConfigurationGroup(key, resDataStruct);
        }
    }

    private void setCTLSAIDData(JSONArray aidData) throws JSONException {
        this.message = "Setting Contactless AID Data";
        this.sendResponse();
        for (int i = 0; i < aidData.length(); ++i) {
            JSONObject aid = aidData.getJSONObject(i);
            String aidHexString = aid.getString("name");
            String tlvHexString = aid.getString("value");
            byte[] TLV = Common.getBytesFromHexString((String)tlvHexString);
            ResDataStruct resDataStruct = new ResDataStruct();
            int n = this.idt_vp3300.ctls_setApplicationData(TLV, resDataStruct);
        }
    }

    private void setCTLSCAPKData(JSONArray capkData) throws JSONException {
        this.message = "Setting Contactless CAPK Data";
        this.sendResponse();
        for (int i = 0; i < capkData.length(); ++i) {
            ResDataStruct resDataStruct = new ResDataStruct();
            JSONObject capk = capkData.getJSONObject(i);
            String capkFile = capk.getString("name") + capk.getString("hash_algorithm") + capk.getString("encryption_algorithm") + capk.getString("hash_value") + capk.getString("exponent") + capk.getString("modulus_length") + capk.getString("modulus");
            byte[] key = Common.getBytesFromHexString((String)capkFile);
            int n = this.idt_vp3300.ctls_setCAPK(key, resDataStruct);
        }
    }

    private void setContactSettings(JSONObject contact) throws JSONException {
        if (contact.has("capk")) {
            this.setCAPKData(contact.getJSONArray("capk"));
        }
        if (contact.has("aid")) {
            this.setAIDData(contact.getJSONArray("aid"));
        }
    }

    private void setTerminalMajorConfiguration(String terminalKernelConfig) {
        this.message = "Setting Terminal Major Configuration";
        this.sendResponse();
        if (terminalKernelConfig == null || terminalKernelConfig.isEmpty()) {
            this.log = "Invalid Terminal Major Configuration Data!";
            this.sendResponse();
        } else {
            int n = this.idt_vp3300.emv_setTerminalMajorConfiguration(Integer.parseInt(terminalKernelConfig.substring(0, 1)));
        }
    }

    private void setTerminalData(String terminalData) {
        this.message = "Setting Terminal Data";
        this.sendResponse();
        if (terminalData == null || terminalData.isEmpty()) {
            this.log = "Invalid Terminal data.";
            this.sendResponse();
        } else {
            ResDataStruct resDataStruct = new ResDataStruct();
            byte[] TLV = Common.getBytesFromHexString((String)terminalData);
            int n = this.idt_vp3300.emv_setTerminalData(TLV, resDataStruct);
        }
    }

    private void setAIDData(JSONArray aidData) throws JSONException {
        this.message = "Setting Contact AID Data";
        this.sendResponse();
        for (int i = 0; i < aidData.length(); ++i) {
            JSONObject aid = aidData.getJSONObject(i);
            String aidHexString = aid.getString("name");
            String tlvHexString = aid.getString("value");
            byte[] TLV = Common.getBytesFromHexString((String)tlvHexString);
            ResDataStruct resDataStruct = new ResDataStruct();
            int n = this.idt_vp3300.emv_setApplicationData(aidHexString, TLV, resDataStruct);
        }
    }

    private void setCAPKData(JSONArray capkData) throws JSONException {
        this.message = "Setting Contact CAPK Data";
        this.sendResponse();
        for (int i = 0; i < capkData.length(); ++i) {
            ResDataStruct resDataStruct = new ResDataStruct();
            JSONObject capk = capkData.getJSONObject(i);
            String capkFile = capk.getString("name") + capk.getString("hash_algorithm") + capk.getString("encryption_algorithm") + capk.getString("hash_value") + capk.getString("exponent") + capk.getString("modulus_length") + capk.getString("modulus");
            byte[] key = Common.getBytesFromHexString((String)capkFile);
            int n = this.idt_vp3300.emv_setCAPK(key, resDataStruct);
        }
    }

    private void setCRLData(String crlData) {
        this.message = "Setting CRL Data";
        this.sendResponse();
        if (crlData == null || crlData.isEmpty()) {
            this.log = "Invalid CRL data.";
        } else {
            ResDataStruct resDataStruct = new ResDataStruct();
            crlData = crlData.replaceAll(",", "");
            byte[] crlList = Common.getBytesFromHexString((String)crlData);
            int n = this.idt_vp3300.emv_setCRL(crlList, resDataStruct);
        }
    }

    private void sendResponse() {
        Thread thread = new Thread(){

            @Override
            public void run() {
                IDTECHBLEService.this.callback.deviceMessage(IDTECHBLEService.this.message);
                IDTECHBLEService.this.callback.outputLogs(IDTECHBLEService.this.log);
            }
        };
        thread.start();
    }

    public HashMap<String, Object> getDeviceSettings() {
        HashMap<String, Object> deviceSettings = new HashMap<String, Object>();
        HashMap<String, Object> generalConfig = new HashMap<String, Object>();
        deviceSettings.put("serial_number", this.getSerialNumber());
        deviceSettings.put("firmware_version", this.getFirmwareDetail());
        generalConfig.put("terminal_ics_type", "");
        generalConfig.put("terminal_data", this.getTerminalData());
        generalConfig.put("crl", this.getCRLData());
        generalConfig.put("contact", this.getContactSettings());
        generalConfig.put("contactless", this.getContactlessSettings());
        deviceSettings.put("general_configuration", generalConfig);
        return deviceSettings;
    }

    private Object getContactlessSettings() {
        HashMap contactlessSettings = new HashMap();
        contactlessSettings.put("configuration_groups", this.getContactlessGroups());
        contactlessSettings.put("capk", this.getContactlessCAPKSettings());
        contactlessSettings.put("aid", new ArrayList());
        return contactlessSettings;
    }

    private Object getContactSettings() {
        HashMap<String, ArrayList> contactSettings = new HashMap<String, ArrayList>();
        contactSettings.put("aid", this.getContactAIDSettings());
        contactSettings.put("capk", this.getContactCAPKSettings());
        return contactSettings;
    }

    private Object getCRLData() {
        this.message = "Getting CRL Data";
        this.sendResponse();
        ResDataStruct resData = new ResDataStruct();
        int ret = this.idt_vp3300.emv_retrieveCRL(resData);
        if (ret == 0 && resData.resData != null) {
            return Common.getHexStringFromBytes((byte[])resData.resData);
        }
        return "";
    }

    private String getFirmwareDetail() {
        this.message = "Getting Firmware";
        this.sendResponse();
        StringBuilder sb = new StringBuilder();
        int ret = this.idt_vp3300.device_getFirmwareVersion(sb);
        if (ret == 0 && sb != null) {
            return sb.toString();
        }
        return "";
    }

    private String getSerialNumber() {
        StringBuilder sb = new StringBuilder();
        String serialNumber = "";
        int ret = this.idt_vp3300.config_getSerialNumber(sb);
        if (ret == 0 && sb != null) {
            serialNumber = sb.toString();
            if (serialNumber.length() > 8) {
                serialNumber = serialNumber.substring(serialNumber.length() - 8);
            }
            Log.d((String)"PaymentSDK", (String)("IDTECHBLEService.getSerialNumber: " + serialNumber));
            return serialNumber;
        }
        Log.d((String)"PaymentSDK", (String)"IDTECHBLEService.getSerialNumber: Failed");
        return "";
    }

    private ArrayList getContactAIDSettings() {
        this.message = "Getting Contact AID Settings";
        this.sendResponse();
        ArrayList aidList = new ArrayList();
        ResDataStruct resData = new ResDataStruct();
        int ret = this.idt_vp3300.emv_retrieveAidList(resData);
        if (ret == 0 && resData.stringArray != null) {
            for (String aidName : resData.stringArray) {
                ResDataStruct aidData = new ResDataStruct();
                int retVal = this.idt_vp3300.emv_retrieveApplicationData(aidName, aidData);
                if (retVal != 0 || aidData.resData == null) continue;
                HashMap<String, String> aidMap = new HashMap<String, String>();
                aidMap.put("name", aidName);
                aidMap.put("value", Common.getHexStringFromBytes((byte[])aidData.resData));
                aidList.add(aidMap);
            }
        }
        return aidList;
    }

    private ArrayList getContactlessAIDSettings() {
        this.message = "Getting Contactless AID Settings";
        this.sendResponse();
        ArrayList aidList = new ArrayList();
        ResDataStruct resData = new ResDataStruct();
        int ret = this.idt_vp3300.ctls_retrieveAidList(resData);
        if (ret == 0 && resData.stringArray != null) {
            for (String aidName : resData.stringArray) {
                ResDataStruct aidData = new ResDataStruct();
                int retVal = this.idt_vp3300.ctls_retrieveApplicationData(aidName, aidData);
                if (retVal != 0 || aidData.resData == null) continue;
                HashMap<String, String> aidMap = new HashMap<String, String>();
                aidMap.put("name", aidName);
                aidMap.put("value", Common.getHexStringFromBytes((byte[])aidData.resData));
                aidList.add(aidMap);
            }
        }
        return aidList;
    }

    private ArrayList getContactCAPKSettings() {
        this.message = "Getting Contact CAPK Settings";
        this.sendResponse();
        ArrayList capkList = new ArrayList();
        ResDataStruct resData = new ResDataStruct();
        int ret = this.idt_vp3300.emv_retrieveCAPKList(resData);
        if (ret == 0 && resData.resData != null) {
            String capkDataStr = Common.getHexStringFromBytes((byte[])resData.resData);
            for (int start = 0; start < capkDataStr.length(); start += 12) {
                String capkName = capkDataStr.substring(start, Math.min(capkDataStr.length(), start + 12));
                ResDataStruct capkData = new ResDataStruct();
                int retVal = this.idt_vp3300.emv_retrieveCAPK(Common.getBytesFromHexString((String)capkName), capkData);
                if (retVal != 0 || capkData.resData == null) continue;
                String capkFile = Common.getHexStringFromBytes((byte[])capkData.resData);
                HashMap<String, String> capkMap = new HashMap<String, String>();
                capkMap.put("name", capkFile.substring(0, 12));
                capkMap.put("hash_algorithm", capkFile.substring(12, 14));
                capkMap.put("encryption_algorithm", capkFile.substring(14, 16));
                capkMap.put("hash_value", capkFile.substring(16, 56));
                capkMap.put("exponent", capkFile.substring(56, 64));
                capkMap.put("modulus_length", capkFile.substring(64, 68));
                capkMap.put("modulus", capkFile.substring(68));
                capkList.add(capkMap);
            }
        }
        return capkList;
    }

    private ArrayList getContactlessCAPKSettings() {
        this.message = "Getting Contactless CAPK Settings";
        this.sendResponse();
        ArrayList capkList = new ArrayList();
        ResDataStruct resData = new ResDataStruct();
        int ret = this.idt_vp3300.ctls_retrieveCAPKList(resData);
        this.log = "Getting CAPK List: " + this.idt_vp3300.device_getResponseCodeString(ret) + "\n";
        this.sendResponse();
        if (ret == 0 && resData.resData != null) {
            String capkDataStr = Common.getHexStringFromBytes((byte[])resData.resData);
            for (int start = 0; start < capkDataStr.length(); start += 12) {
                String capkName = capkDataStr.substring(start, Math.min(capkDataStr.length(), start + 12));
                ResDataStruct capkData = new ResDataStruct();
                int retVal = this.idt_vp3300.ctls_retrieveCAPK(Common.getBytesFromHexString((String)capkName), capkData);
                if (retVal != 0 || capkData.resData == null) continue;
                String capkFile = Common.getHexStringFromBytes((byte[])capkData.resData);
                HashMap<String, String> capkMap = new HashMap<String, String>();
                capkMap.put("name", capkName);
                capkMap.put("hash_algorithm", capkFile.substring(0, 2));
                capkMap.put("encryption_algorithm", capkFile.substring(2, 4));
                capkMap.put("hash_value", capkFile.substring(4, 44));
                capkMap.put("exponent", capkFile.substring(44, 52));
                capkMap.put("modulus_length", capkFile.substring(52, 56));
                capkMap.put("modulus", capkFile.substring(56));
                capkList.add(capkMap);
            }
        }
        return capkList;
    }

    private ArrayList getContactlessGroups() {
        this.message = "Getting Configuration Groups";
        this.sendResponse();
        ArrayList groupList = new ArrayList();
        for (int groupID = 0; groupID < 4; ++groupID) {
            ResDataStruct groupData = new ResDataStruct();
            int retVal = this.idt_vp3300.ctls_getConfigurationGroup(groupID, groupData);
            if (retVal != 0 || groupData.resData == null) continue;
            HashMap<String, Object> groupMap = new HashMap<String, Object>();
            groupMap.put("group", groupID);
            groupMap.put("data", Common.getHexStringFromBytes((byte[])groupData.resData));
            groupList.add(groupMap);
        }
        return groupList;
    }

    private String getTerminalData() {
        this.message = "Getting Terminal data";
        this.sendResponse();
        ResDataStruct resData = new ResDataStruct();
        int ret = this.idt_vp3300.emv_retrieveTerminalData(resData);
        if (ret == 0) {
            return Common.getHexStringFromBytes((byte[])resData.resData);
        }
        return "";
    }

    public void startEMVTransaction(double amount) {
        this.message = "EMV Tramsaction Starting\n";
        this.sendResponse();
        this.deviceSerialNumber = this.getSerialNumber();
        this.finalTransactionTags = null;
        this.isNonTechnicalFallback = false;
        int type = 0;
        IDT_VP3300.emv_setAutoAuthenticateTransaction((boolean)false);
        IDT_VP3300.emv_setAutoCompleteTransaction((boolean)false);
        IDT_VP3300.emv_allowFallback((boolean)true);
        if (this.isRefund) {
            type = 32;
        }
        byte[] inputTags = Common.hexStringToByteArray((String)"DFEF7E085004500550325033");
        Log.d((String)"PaymentSDK", (String)"IDTECHBLEService.startEMVTransaction: device_startTransaction");
        int responseCode = this.idt_vp3300.device_startTransaction(amount, 0.0, type, 90, inputTags, false);
        this.message = responseCode == 61027 ? "SDK is doing EMV task.\n" : "EMV Transaction started\n";
        this.sendResponse();
    }

    public void completeEMVTransaction() {
        Map retrievedTags = null;
        Log.d((String)"PaymentSDK", (String)"IDTECHBLEService.completeEMVTransaction: retrieve and complete");
        this.idt_vp3300.emv_retrieveTransactionResult(new byte[5], retrievedTags);
        this.idt_vp3300.emv_completeTransaction(false, new byte[5], new byte[5], new byte[5], new byte[5]);
        this.message = "EMV Transaction Completed.\n";
        this.sendResponse();
    }

    public void cancelEMVTransaction() {
        this.sendResponse();
        Log.d((String)"PaymentSDK", (String)"IDTECHBLEService.cancelEMVTransaction");
        int responseCode = this.idt_vp3300.device_cancelTransaction();
        if (responseCode == 0) {
            this.message = "EMV Transaction Cancelled\n";
        } else {
            Log.d((String)"PaymentSDK", (String)"IDTECHBLEService.cancelEMVTransaction: Failed");
        }
        this.sendResponse();
    }

    public void swipeMSRData(IDTMSRData idtmsrData) {
        Log.d((String)"PaymentSDK", (String)"IDTECHBLEService.swipeMSRData");
        if (idtmsrData != null && idtmsrData.unencryptedTags != null && idtmsrData.unencryptedTags.containsKey("9F39") && Common.getHexStringFromBytes((byte[])((byte[])idtmsrData.unencryptedTags.get("9F39"))).equalsIgnoreCase("07") && this.isRefund) {
            byte[] data;
            Log.d((String)"PaymentSDK", (String)"IDTECHBLEService.swipeMSRData: Tap");
            this.message = "Tap Read Successfully";
            this.log = this.log + "\nUnencrypted Tags/API Input Transaction Tags:\r\n";
            Set keys = idtmsrData.unencryptedTags.keySet();
            StringBuilder sb = new StringBuilder();
            StringBuilder unencryptedTags = new StringBuilder();
            for (String key : keys) {
                sb.append(key).append(": ");
                data = (byte[])idtmsrData.unencryptedTags.get(key);
                String value = Common.getHexStringFromBytes((byte[])data);
                sb.append(value).append("\r\n");
                String length = String.format("%02x", value.length() / 2);
                unencryptedTags.append(key).append(length).append(value);
            }
            this.log = this.log + sb.toString() + "\r\n";
            this.sendResponse();
            String KSN = "";
            data = null;
            if (idtmsrData.unencryptedTags.containsKey("FFEE12")) {
                data = (byte[])idtmsrData.unencryptedTags.get("FFEE12");
            } else if (idtmsrData.unencryptedTags.containsKey("DFEE12 ")) {
                data = (byte[])idtmsrData.unencryptedTags.get("DFEE12");
            }
            if (data != null) {
                KSN = Common.getHexStringFromBytes((byte[])data);
            }
            this.deviceEMVKernelVersion = this.getTransactionKernelVersion("EMVTap");
            Log.d((String)"PaymentSDK", (String)"IDTECHBLEService.swipeMSRData: Tap Returning Status");
            this.callbackTransaction.call("EMVTap", unencryptedTags.toString(), KSN, this.deviceSerialNumber, this.deviceEMVKernelVersion, false);
        } else if (idtmsrData != null && idtmsrData.unencryptedTags != null && idtmsrData.unencryptedTags.containsKey("9F39") && !Common.getHexStringFromBytes((byte[])((byte[])idtmsrData.unencryptedTags.get("9F39"))).equalsIgnoreCase("07")) {
            Log.d((String)"PaymentSDK", (String)"IDTECHBLEService.swipeMSRData: Swipe");
            this.message = idtmsrData.cardData[0] != 1 && idtmsrData.track1Length == 0 && idtmsrData.track2Length == 0 && idtmsrData.track3Length == 0 ? "Swipe data didn't read correctly" : "Swipe Read Successfully";
            this.log = Common.parse_MSRData((ReaderInfo.DEVICE_TYPE)this.idt_vp3300.device_getDeviceType(), (IDTMSRData)idtmsrData);
            this.sendResponse();
            String DFEE23 = "";
            Boolean isFallback = false;
            Boolean isTapCardData = false;
            if (idtmsrData != null && idtmsrData.unencryptedTags != null) {
                byte[] data = (byte[])idtmsrData.unencryptedTags.get("DFEE23");
                DFEE23 = Common.getHexStringFromBytes((byte[])data);
                byte[] fallback = (byte[])idtmsrData.unencryptedTags.get("9F39");
                String fallbackStr = Common.getHexStringFromBytes((byte[])fallback);
                if (fallbackStr.equalsIgnoreCase("80")) {
                    byte[] tagValue;
                    String nonTechFallbackTagValue;
                    isFallback = true;
                    if (idtmsrData.unencryptedTags.containsKey("DFEE25") && (nonTechFallbackTagValue = Common.getHexStringFromBytes((byte[])(tagValue = (byte[])idtmsrData.unencryptedTags.get("DFEE25")))).equalsIgnoreCase("0011")) {
                        this.isNonTechnicalFallback = true;
                    }
                }
            }
            StringBuilder KSN = new StringBuilder();
            if (idtmsrData != null && idtmsrData.KSN != null && idtmsrData.KSN.length > 0) {
                for (int i = 0; i < idtmsrData.KSN.length; ++i) {
                    KSN.append(String.format(Locale.US, "%02x", idtmsrData.KSN[i]));
                }
            }
            this.deviceEMVKernelVersion = this.getTransactionKernelVersion("MSR");
            Log.d((String)"PaymentSDK", (String)"IDTECHBLEService.swipeMSRData: Swipe Returning Status");
            this.callbackTransaction.call("MSR", DFEE23, KSN.toString(), this.deviceSerialNumber, this.deviceEMVKernelVersion, isFallback);
        }
    }

    public void lcdDisplay(int mode, String[] lines, int timeout) {
        if (mode == 1) {
            this.idt_vp3300.emv_lcdControlResponse((byte)mode, (byte)1);
        } else if (mode == 8) {
            this.idt_vp3300.emv_lcdControlResponse((byte)mode, (byte)1);
        } else {
            this.message = lines[0];
            Log.d((String)"PaymentSDK", (String)("IDTECHBLEService.lcdDisplay: " + this.message));
            if (!this.message.contains("DECLINED")) {
                this.callback.deviceMessage(this.message);
            }
        }
    }

    public void lcdDisplay(int i, String[] strings, int i1, byte[] bytes, byte b) {
    }

    public void ctlsEvent(byte b, byte b1, byte b2) {
    }

    public void emvTransactionData(IDTEMVData idtEMVData) {
        Set<Object> keys;
        Log.d((String)"PaymentSDK", (String)"IDTECHBLEService.emvTransactionData");
        this.log = this.log + "\r\nEMV Transaction Data Response:\r\n";
        this.log = this.log + "\r\n" + this.emvErrorCodes(idtEMVData.result) + "\r\n\n";
        if (idtEMVData.result == 16) {
            this.log = this.log + "\nStart Transaction Response:\r\n";
        } else if (idtEMVData.result == 4) {
            this.log = this.log + "\r\nAuthentication Response:\r\n";
        } else if (idtEMVData.result == 2 || idtEMVData.result == 3) {
            this.log = this.log + "\r\nComplete Transaction Response:\r\n\n";
            this.message = "COMPLETED";
        } else if (idtEMVData.result == 9) {
            this.log = this.log + "\r\nCaptured Contactless Transaction Response:\r\n";
            this.message = "COMPLETED";
        } else {
            this.log = this.log + "\r\n" + this.idt_vp3300.device_getResponseCodeString(idtEMVData.result) + "\r\n";
            this.log = this.log + "\r\nUnhandled Transaction Response.\r\n";
        }
        if (idtEMVData.unencryptedTags != null && !idtEMVData.unencryptedTags.isEmpty()) {
            this.log = this.log + "\nUnencrypted Tags:\r\n";
            Set keys2 = idtEMVData.unencryptedTags.keySet();
            StringBuilder sb = new StringBuilder();
            StringBuilder stringBuilder = new StringBuilder();
            for (Object key : keys2) {
                sb.append((String)key).append(": ");
                byte[] byArray = (byte[])idtEMVData.unencryptedTags.get(key);
                String value = Common.getHexStringFromBytes((byte[])byArray);
                sb.append(value).append("\r\n");
            }
            this.log = this.log + sb.toString() + "\r\n";
        }
        this.sendResponse();
        if (idtEMVData.result == 16) {
            this.finalTransactionTags = idtEMVData.unencryptedTags;
            Log.d((String)"PaymentSDK", (String)"IDTECHBLEService.emvTransactionData: Authenticate Transaction");
            int keys2 = this.idt_vp3300.emv_authenticateTransaction(null);
        } else if (idtEMVData.result == 4) {
            keys = idtEMVData.unencryptedTags.keySet();
            for (String string : keys) {
                this.finalTransactionTags.put(string, (byte[])idtEMVData.unencryptedTags.get(string));
            }
            byte[] response = new byte[]{48, 48};
            Log.d((String)"PaymentSDK", (String)"IDTECHBLEService.emvTransactionData: Complete Transaction 1");
            int n = this.idt_vp3300.emv_completeTransaction(false, response, null, null, null);
        } else if (idtEMVData.result == 2 || idtEMVData.result == 3 || idtEMVData.result == 9) {
            byte[] data;
            String string;
            if (this.finalTransactionTags == null) {
                this.finalTransactionTags = new HashMap<String, byte[]>();
            }
            keys = idtEMVData.unencryptedTags.keySet();
            boolean isCorrect9F27Found = false;
            if (this.finalTransactionTags.containsKey("9F27") && (string = Common.getHexStringFromBytes((byte[])this.finalTransactionTags.get("9F27"))).equals("80")) {
                isCorrect9F27Found = true;
            }
            for (String string2 : keys) {
                if (isCorrect9F27Found && (string2.equals("9F27") || string2.equals("9F36"))) continue;
                this.finalTransactionTags.put(string2, (byte[])idtEMVData.unencryptedTags.get(string2));
            }
            this.log = this.log + "\nAPI Input Transaction Tags:\r\n";
            keys = this.finalTransactionTags.keySet();
            StringBuilder stringBuilder = new StringBuilder();
            StringBuilder stringBuilder2 = new StringBuilder();
            for (String string3 : keys) {
                stringBuilder.append(string3).append(": ");
                data = this.finalTransactionTags.get(string3);
                String value = Common.getHexStringFromBytes((byte[])data);
                stringBuilder.append(value).append("\r\n");
                String length = String.format("%02x", value.length() / 2);
                stringBuilder2.append(string3).append(length).append(value);
            }
            this.log = this.log + stringBuilder.toString();
            this.sendResponse();
            String KSN = "";
            data = null;
            if (this.finalTransactionTags.containsKey("FFEE12")) {
                data = this.finalTransactionTags.get("FFEE12");
            } else if (this.finalTransactionTags.containsKey("DFEE12 ")) {
                data = this.finalTransactionTags.get("DFEE12");
            }
            if (data != null) {
                KSN = Common.getHexStringFromBytes((byte[])data);
            }
            if (idtEMVData.result == 9) {
                this.deviceEMVKernelVersion = this.getTransactionKernelVersion("EMVTap");
                Log.d((String)"PaymentSDK", (String)"IDTECHBLEService.emvTransactionData: Tap");
                this.callbackTransaction.call("EMVTap", stringBuilder2.toString(), KSN, this.deviceSerialNumber, this.deviceEMVKernelVersion, false);
            } else {
                this.deviceEMVKernelVersion = this.getTransactionKernelVersion("EMVChip");
                Log.d((String)"PaymentSDK", (String)"IDTECHBLEService.emvTransactionData: Chip");
                this.callbackTransaction.call("EMVChip", stringBuilder2.toString(), KSN, this.deviceSerialNumber, this.deviceEMVKernelVersion, false);
            }
        } else if (idtEMVData.result == 1) {
            this.message = "DECLINED  Please try another card.\r\n";
            Log.d((String)"PaymentSDK", (String)"IDTECHBLEService.emvTransactionData Declined");
            this.sendResponse();
        } else {
            this.sendResponse();
            Log.d((String)"PaymentSDK", (String)"IDTECHBLEService.emvTransactionData Cancelling Transaction");
            this.cancelEMVTransaction();
        }
        Log.d((String)"PaymentSDK", (String)"IDTECHBLEService.emvTransactionData Complete 2");
    }

    public void deviceConnected() {
        this.isReaderConnected = true;
        Log.d((String)"PaymentSDK", (String)"IDTECHBLEService.deviceConnected");
        this.callback.deviceConnected(this.getConnectedDeviceAndStatus());
    }

    public void deviceDisconnected() {
        this.isReaderConnected = false;
        Log.d((String)"PaymentSDK", (String)"IDTECHBLEService.deviceDisconnected");
        this.callback.deviceDisconnected(this.getConnectedDeviceAndStatus());
    }

    public void timeout(int i) {
    }

    public void autoConfigCompleted(StructConfigParameters structConfigParameters) {
    }

    public void autoConfigProgress(int i) {
    }

    public void msgRKICompleted(String s) {
    }

    public void ICCNotifyInfo(byte[] bytes, String s) {
    }

    public void msgBatteryLow() {
    }

    public void LoadXMLConfigFailureInfo(int i, String s) {
    }

    public void msgToConnectDevice() {
    }

    public void msgAudioVolumeAjustFailed() {
    }

    public void dataInOutMonitor(byte[] bytes, boolean b) {
        this.logsDATA = b ? this.logsDATA + "IN: " + Common.getHexStringFromBytes((byte[])bytes) + " @@ " : this.logsDATA + "OUT: " + Common.getHexStringFromBytes((byte[])bytes) + " @@ ";
    }

    private void setCardDetails() {
        CardType americanExpress = new CardType();
        americanExpress.CardName = "AmericanExpress";
        americanExpress.AIDs.add("A00000002501");
        americanExpress.CardHexValue = "76312e3030";
        cardDetails.add(americanExpress);
        CardType masterCard = new CardType();
        masterCard.CardName = "MasterCard";
        masterCard.AIDs.add("A0000000041010");
        masterCard.AIDs.add("A0000000043060");
        masterCard.AIDs.add("A0000000042203");
        masterCard.CardHexValue = "76312e3034";
        cardDetails.add(masterCard);
        CardType visa = new CardType();
        visa.CardName = "Visa";
        visa.AIDs.add("A0000000031010");
        visa.AIDs.add("A0000000032010");
        visa.AIDs.add("A0000000033010");
        visa.AIDs.add("A0000000038010");
        visa.CardHexValue = "76312e30";
        cardDetails.add(visa);
        CardType discover = new CardType();
        discover.CardName = "Discover";
        discover.AIDs.add("A0000003241010");
        discover.AIDs.add("A0000001523010");
        discover.AIDs.add("A0000000659001");
        discover.AIDs.add("A0000000651010");
        discover.CardHexValue = "76312e3030";
        cardDetails.add(discover);
        CardType interac = new CardType();
        interac.CardName = "Interac";
        interac.AIDs.add("A0000002771010");
        interac.CardHexValue = "76312e3030";
        cardDetails.add(interac);
        CardType googlePaySmartTap = new CardType();
        googlePaySmartTap.CardName = "GooglePaySmartTap";
        googlePaySmartTap.AIDs.add("A000000476D0000111");
        googlePaySmartTap.CardHexValue = "76322e31";
        cardDetails.add(googlePaySmartTap);
    }

    private String getTransactionKernelVersion(String transactionType) {
        String kernelVersion = "";
        if (transactionType == "EMVChip" || transactionType == "MSR") {
            kernelVersion = "56312e31302e303337";
        } else if (transactionType == "EMVTap") {
            byte[] data = null;
            String aid = "";
            if (this.finalTransactionTags.containsKey("84")) {
                aid = Common.getHexStringFromBytes((byte[])this.finalTransactionTags.get("84"));
            } else {
                Map dataDict;
                Map dataDictTags;
                if (this.finalTransactionTags.containsKey("FF8105")) {
                    data = this.finalTransactionTags.get("FF8105");
                }
                if (data != null && (dataDictTags = (Map)(dataDict = Common.processTLV(data)).get("tags")).containsKey("84")) {
                    aid = Common.getHexStringFromBytes((byte[])((byte[])dataDictTags.get("84")));
                }
            }
            for (CardType card : cardDetails) {
                if (!card.AIDs.contains(aid.toUpperCase())) continue;
                kernelVersion = card.CardHexValue;
                break;
            }
        }
        if (kernelVersion == "") {
            kernelVersion = "756e6b6e6f776e";
        }
        return kernelVersion;
    }

    private String emvErrorCodes(int val) {
        if (val == 0) {
            return "APPROVED_OFFLINE";
        }
        if (val == 1) {
            return "DECLINED_OFFLINE";
        }
        if (val == 2) {
            return "APPROVED";
        }
        if (val == 3) {
            return "DECLINED";
        }
        if (val == 4) {
            return "GO_ONLINE";
        }
        if (val == 5) {
            return "CALL_YOUR_BANK";
        }
        if (val == 6) {
            return "NOT_ACCEPTED";
        }
        if (val == 7) {
            return "USE_MAGSTRIPE";
        }
        if (val == 8) {
            return "TIME_OUT";
        }
        if (val == 9) {
            return "GO_ONLINE_CTLS";
        }
        if (val == 16) {
            return "START_TRANS_SUCCESS";
        }
        if (val == 17) {
            return "MSR_SUCCESS";
        }
        if (val == 18) {
            return "TRANSACTION_CANCELED";
        }
        if (val == 122) {
            return "CTLS_TWO_CARDS";
        }
        if (val == 126) {
            return "CTLS_TERMINATE";
        }
        if (val == 125) {
            return "CTLS_TERMINATE_TRY_ANOTHER";
        }
        if (val == 128) {
            return "MSR_SWIPE_CAPTURED";
        }
        if (val == 129) {
            return "REQUEST_ONLINE_PIN";
        }
        if (val == 130) {
            return "REQUEST_SIGNATURE";
        }
        if (val == 131) {
            return "FALLBACK_TO_CONTACT";
        }
        if (val == 132) {
            return "FALLBACK_TO_OTHER";
        }
        if (val == 133) {
            return "REVERSAL_REQUIRED";
        }
        if (val == 134) {
            return "ADVISE_REQUIRED";
        }
        if (val == 136) {
            return "NO_ADVISE_REVERSAL_REQUIRED";
        }
        if (val == 255) {
            return "UNABLE_TO_REACH_HOST";
        }
        if (val == 4097) {
            return "FILE_ARG_INVALID";
        }
        if (val == 4098) {
            return "FILE_OPEN_FAILED";
        }
        if (val == 4099) {
            return "FILE_OPERATION_FAILED";
        }
        if (val == 8193) {
            return "MEMORY_NOT_ENOUGH";
        }
        if (val == 12289) {
            return "SMARTCARD_OK";
        }
        if (val == 12290) {
            return "SMARTCARD_FAIL";
        }
        if (val == 12291) {
            return "SMARTCARD_INIT_FAILED";
        }
        if (val == 12292) {
            return "FALLBACK_SITUATION";
        }
        if (val == 12293) {
            return "SMARTCARD_ABSENT";
        }
        if (val == 12294) {
            return "SMARTCARD_TIMEOUT";
        }
        if (val == 12295) {
            return "MSR_CARD_ERROR";
        }
        if (val == 12306) {
            return "MSR_CARD_ERROR_FALLBACK";
        }
        if (val == 12307) {
            return "TIMEOUT_FOR_WAITING_ICC_INSERT_OR_MSR_SWIPE_FALLBACK";
        }
        if (val == 20481) {
            return "PARSING_TAGS_FAILED";
        }
        if (val == 20482) {
            return "CARD_DATA_ELEMENT_DUPLICATE";
        }
        if (val == 20483) {
            return "DATA_FORMAT_INCORRECT";
        }
        if (val == 20484) {
            return "APP_NO_TERM";
        }
        if (val == 20485) {
            return "APP_NO_MATCHING";
        }
        if (val == 20486) {
            return "AMANDATORY_OBJECT_MISSING";
        }
        if (val == 20487) {
            return "APP_SELECTION_RETRY";
        }
        if (val == 20488) {
            return "AMOUNT_ERROR_GET";
        }
        if (val == 20489) {
            return "CARD_REJECTED";
        }
        if (val == 20496) {
            return "AIP_NOT_RECEIVED";
        }
        if (val == 20497) {
            return "AFL_NOT_RECEIVEDE";
        }
        if (val == 20498) {
            return "AFL_LEN_OUT_OF_RANGE";
        }
        if (val == 20499) {
            return "SFI_OUT_OF_RANGE";
        }
        if (val == 20500) {
            return "AFL_INCORRECT";
        }
        if (val == 20501) {
            return "EXP_DATE_INCORRECT";
        }
        if (val == 20502) {
            return "EFF_DATE_INCORRECT";
        }
        if (val == 20503) {
            return "ISS_COD_TBL_OUT_OF_RANGE";
        }
        if (val == 20504) {
            return "CRYPTOGRAM_TYPE_INCORRECT";
        }
        if (val == 20505) {
            return "PSE_BY_CARD_NOT_SUPPORTED";
        }
        if (val == 20512) {
            return "USER_LANGUAGE_SELECTED";
        }
        if (val == 20513) {
            return "SERVICE_NOT_ALLOWED";
        }
        if (val == 20514) {
            return "NO_TAG_FOUND";
        }
        if (val == 20515) {
            return "CARD_BLOCKED";
        }
        if (val == 20516) {
            return "LEN_INCORRECT";
        }
        if (val == 20517) {
            return "CARD_COM_ERROR";
        }
        if (val == 20518) {
            return "TSC_NOT_INCREASED";
        }
        if (val == 20519) {
            return "HASH_INCORRECT";
        }
        if (val == 20520) {
            return "ARC_NOT_PRESENCED";
        }
        if (val == 20521) {
            return "ARC_INVALID";
        }
        if (val == 20528) {
            return "COMM_NO_ONLINE";
        }
        if (val == 20529) {
            return "TRAN_TYPE_INCORRECT";
        }
        if (val == 20530) {
            return "APP_NO_SUPPORT";
        }
        if (val == 20531) {
            return "APP_NOT_SELECT";
        }
        if (val == 20532) {
            return "LANG_NOT_SELECT";
        }
        if (val == 20533) {
            return "TERM_DATA_NOT_PRESENCED";
        }
        if (val == 24577) {
            return "CVM_TYPE_UNKNOWN";
        }
        if (val == 24578) {
            return "CVM_AIP_NOT_SUPPORTED";
        }
        if (val == 24579) {
            return "CVM_TAG_8E_MISSING";
        }
        if (val == 24580) {
            return "CVM_TAG_8E_FORMAT_ERROR";
        }
        if (val == 24581) {
            return "CVM_CODE_IS_NOT_SUPPORTED";
        }
        if (val == 24582) {
            return "CVM_COND_CODE_IS_NOT_SUPPORTED";
        }
        if (val == 24583) {
            return "CVM_NO_MORE";
        }
        if (val == 24584) {
            return "PIN_BYPASSED_BEFORE";
        }
        if (val == 65535) {
            return "UNKONWN";
        }
        return "";
    }
}

