/*
 * Decompiled with CFR 0.152.
 */
package com.idtechproducts.device.audiojack.tasks;

import com.idtechproducts.device.Common;
import com.idtechproducts.device.audiojack.ReaderCommunication;
import com.idtechproducts.device.audiojack.UMLog;
import com.idtechproducts.device.audiojack.io.IOManager;
import com.idtechproducts.device.audiojack.io.ToneType;
import com.idtechproducts.device.audiojack.tasks.Task;
import com.idtechproducts.device.audiojack.tasks.TaskManager;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwipeUMTask
extends Task {
    public final double d;
    public byte[] e = null;

    public SwipeUMTask(TaskManager umMan, ReaderCommunication readerCommunication, double timeoutIntervalSec) {
        super(umMan, readerCommunication);
        this.d = timeoutIntervalSec;
    }

    @Override
    public TaskManager.TaskType getType() {
        return TaskManager.TaskType.Swipe;
    }

    @Override
    public void taskCleanup() {
        IOManager this_ = ((Task)((Object)this_))._ioManager;
        if (this_ != null) {
            this_.notifyTaskFinished();
        }
    }

    @Override
    public Runnable taskMain() {
        SwipeUMTask swipeUMTask = this;
        swipeUMTask._ioManager.getTonePlayer().setPlayingTone(ToneType.T_2000Hz);
        double d2 = this.d;
        SwipeUMTask swipeUMTask2 = this;
        IOManager.RPDResult rPDResult = swipeUMTask._ioManager.recordPlayDecode(null, d2, swipeUMTask2, swipeUMTask2, false, false, false);
        if (rPDResult.isCanceledOrFailed()) {
            this._ioManager.getTonePlayer().setPlayingTone(null);
            return null;
        }
        if (rPDResult.isTimedOut()) {
            return new Runnable(){

                public void run() {
                    a a2 = this;
                    a2.SwipeUMTask.this._umrMsg.timeout(24);
                    a2.SwipeUMTask.this._ioManager.getTonePlayer().setPlayingTone(null);
                }
            };
        }
        return new Runnable(){

            public void run() {
                SwipeUMTask swipeUMTask = runnable.SwipeUMTask.this;
                if (swipeUMTask.e != null) {
                    b b2 = runnable;
                    UMLog.i(swipeUMTask.TAG, "Response MSR Data - Runnable");
                    Runnable runnable = b2.SwipeUMTask.this;
                    Common.Response.responesMSRData(((Task)runnable)._umrMsg, ((SwipeUMTask)runnable).e);
                    b2.SwipeUMTask.this._ioManager.getTonePlayer().setPlayingTone(null);
                }
            }
        };
    }

    @Override
    public boolean processResponse(List<byte[]> response) {
        Iterator<byte[]> iterator = response.iterator();
        while (true) {
            block8: {
                boolean bl;
                block6: {
                    byte[] byArray;
                    block7: {
                        block5: {
                            if (iterator.hasNext()) break block5;
                            bl = false;
                            break block6;
                        }
                        byArray = iterator.next();
                        SwipeUMTask swipeUMTask = this;
                        UMLog.i(swipeUMTask.TAG, "got: " + Common.getByteArrDesc(byArray));
                        UMLog.i(swipeUMTask.TAG, "got: " + Common.getHexStringFromBytes(byArray));
                        if (byArray.length < 2) continue;
                        if (Common.PUSType.parse(byArray) != Common.PUSType.INVALID) {
                            UMLog.i(this.TAG, "ignored PUS");
                            continue;
                        }
                        if (13 != byArray[byArray.length - 1] || byArray.length == 13) break block7;
                        this.e = byArray;
                        bl = true;
                        break block6;
                    }
                    if (2 != byArray[1] && 2 != byArray[0] || 3 != byArray[byArray.length - 1]) break block8;
                    this.e = byArray;
                    bl = true;
                }
                return bl;
            }
            UMLog.i(this.TAG, "ignored ill-formed swipe data");
        }
    }

    @Override
    public void processSound() {
        SwipeUMTask swipeUMTask = this;
        UMLog.i(swipeUMTask.TAG, "swipe detected");
        swipeUMTask.post(new Runnable(this){

            public void run() {
            }
        });
    }
}

