/*
 * Decompiled with CFR 0.152.
 */
package com.idtechproducts.device.rs232;

import android.content.Context;
import com.idtechproducts.device.Common;
import com.idtechproducts.device.IDT_Device;
import com.idtechproducts.device.ReaderInfo;
import com.idtechproducts.device.ResDataStruct;
import com.idtechproducts.device.audiojack.UMLog;
import com.idtechproducts.device.audiojack.tools.FirmwareUpdateTool;
import com.idtechproducts.device.audiojack.tools.FirmwareUpdateToolMsg;
import com.idtechproducts.device.rs232.IDTechRS232Msg;
import com.idtechproducts.device.rs232.RS232Controller;
import com.idtechproducts.device.rs232.RS232ControllerMsg;

public class IDTechRS232 {
    private static final String SDK_VER_STRING = "ID TECH RS232 SDK Ver 1.0";
    private static final String TAG = "SDK::RS232";
    private final IDTechRS232Msg _msg;
    private RS232Controller _com = null;
    private Context _context;
    private volatile boolean _state_isConnected;
    private IDT_Device.TaskExport _taskExport;
    boolean isWakeupThreadRunning = false;
    PAT_Wakeup_Runnable wakeup_Runnable = null;
    private boolean isFirstTimeEraseSpace = true;

    public void externalConnect() {
        if (IDT_Device.getUSBBypass() && this._com != null) {
            this._com.externalConnect();
        }
    }

    public void externalDisconnect() {
        if (IDT_Device.getUSBBypass() && this._com != null) {
            this._com.externalDisconnect();
        }
    }

    public void externalDeviceNotFound() {
        if (IDT_Device.getUSBBypass() && this._com != null) {
            this._com.externalDeviceNotFound();
        }
    }

    public IDTechRS232(IDTechRS232Msg callback, Context context, IDT_Device.TaskExport taskExport, String path, String baudrate, int flags) {
        this._msg = callback;
        this._context = context;
        this._state_isConnected = false;
        this._taskExport = taskExport;
        switch (this._taskExport.getReaderType()) {
            case DEVICE_VP3300_COM: {
                this._com = new RS232Controller(context, this._msg, new RS232ControllerMsgImpl(), path, baudrate, flags);
                break;
            }
            default: {
                this._com = new RS232Controller(context, this._msg, new RS232ControllerMsgImpl(), path, baudrate, flags);
            }
        }
    }

    public static String getSDKVersionInfo() {
        return SDK_VER_STRING;
    }

    public void registerListen() {
        if (!this._com.isRegistered()) {
            this._com.registerReceiver();
        }
        if (this._com.init()) {
            this._state_isConnected = true;
            if (Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_COM) {
                this._taskExport.setReaderType(ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_COM);
            } else {
                this._taskExport.setReaderType(ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_COM);
            }
            this._msg.com_onReceiveMsgConnected();
        }
    }

    public void unregisterListen() {
        if (this._com.isRegistered()) {
            this._com.unregisterReceiver();
        }
        this._state_isConnected = false;
    }

    public boolean isReaderConnected() {
        return this._state_isConnected;
    }

    public byte[] sendCommand(String cmd, int timeout) {
        if (!this._state_isConnected) {
            return null;
        }
        if (Common.isNeedWakeup()) {
            this.PAT_stopWakeupThread();
        }
        this._com.disableSwipe();
        byte[] command = Common.makeCommand(cmd);
        UMLog.i("**sendCommand**", String.valueOf(Common.base16Encode(command)) + " timeout: " + timeout);
        byte[] _return = this._com.sendCommand(command, timeout);
        if (Common.isNeedWakeup()) {
            this.PAT_startWakeupThread();
        }
        return _return;
    }

    public byte[] sendCommandOnly(String cmd, int timeout) {
        if (!this._state_isConnected) {
            return null;
        }
        if (Common.isNeedWakeup()) {
            this.PAT_stopWakeupThread();
        }
        this._com.disableSwipe();
        byte[] command = Common.makeCommand(cmd);
        UMLog.i("**sendCommand**", String.valueOf(Common.base16Encode(command)) + " timeout: " + timeout);
        byte[] _return = this._com.sendCommandOnly(command, timeout);
        if (Common.isNeedWakeup()) {
            this.PAT_startWakeupThread();
        }
        return _return;
    }

    public byte[] PAT_sendCommand(String cmd, int timeout) {
        if (!this._state_isConnected) {
            return null;
        }
        this._com.disableSwipe();
        byte[] command = Common.makeCommand(cmd);
        UMLog.i("**PAT_sendCommand**", String.valueOf(Common.base16Encode(command)) + " timeout: " + timeout);
        byte[] _return = this._com.sendCommand(command, timeout);
        return _return;
    }

    public boolean isWakeup_Thread_Running() {
        return this.isWakeupThreadRunning;
    }

    public void PAT_Wakeup() {
        this._com.disableSwipe();
        byte[] command = new byte[]{0};
        int ret = this._com.writeNothing();
        UMLog.i("**writeNothing:", " ret = " + ret);
    }

    public void PAT_startWakeupThread() {
        if (this.isWakeupThreadRunning) {
            this.PAT_stopWakeupThread();
        }
        this.isWakeupThreadRunning = true;
        this.wakeup_Runnable = new PAT_Wakeup_Runnable();
        this.wakeup_Runnable.start();
    }

    public void PAT_stopWakeupThread() {
        if (!this.isWakeupThreadRunning) {
            return;
        }
        this.isWakeupThreadRunning = false;
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
        if (this.wakeup_Runnable != null) {
            while (this.wakeup_Runnable.isAlive()) {
                try {
                    this.wakeup_Runnable.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.wakeup_Runnable = null;
        }
    }

    public byte[] sendCommandForRKI(String cmd, int timeout) {
        if (!this._state_isConnected) {
            return null;
        }
        this._com.disableSwipe();
        byte[] command = IDTechRS232.makeCommandForRKI(cmd);
        String cmdStr = Common.base16Encode(command);
        command = Common.makeCommand(cmdStr);
        UMLog.i("**sendCommandForRKI**", String.valueOf(Common.base16Encode(command)) + " timeout: " + timeout);
        return this._com.sendCommandForRKI(command, timeout);
    }

    public boolean readMessage(int timeout, long startTime, ResDataStruct respData, boolean ignoreLCDMsg) {
        return this._com.readMessage(timeout, startTime, respData, ignoreLCDMsg);
    }

    private byte[] sendCommandFw(String cmd) {
        if (!this._state_isConnected) {
            return null;
        }
        byte[] command = Common.makeCommand(cmd);
        return this._com.sendCommandFw(command);
    }

    public boolean startSwipeCard() {
        UMLog.i(TAG, "To enable Swipe...");
        if (!this._state_isConnected) {
            IDT_Device.isCommandRunning = false;
            return false;
        }
        return this._com.enableSwipe();
    }

    public boolean startListenCard() {
        UMLog.i(TAG, "To enable Listen...");
        if (!this._state_isConnected) {
            return false;
        }
        return this._com.enableListen();
    }

    public boolean stopListenCard() {
        UMLog.i(TAG, "To disable Listen...");
        return this._com.disableListen();
    }

    public boolean startReadCard(int timeout, ResDataStruct respData) {
        UMLog.i(TAG, "To enable read...");
        if (!this._state_isConnected) {
            return false;
        }
        return this._com.enableRead(timeout, respData);
    }

    public void stopSwipeCard() {
        UMLog.i(TAG, "To disable Swipe...");
        this._com.disableSwipe();
    }

    public boolean setTimeoutOfSwipeCard(int timeoutValue) {
        this._com.setTimeoutOfSwipeCard(timeoutValue);
        return true;
    }

    public void readBuffer(ResDataStruct respData) {
        this._com.readBuffer(respData);
    }

    public boolean enterBootloader() {
        if (this._com == null) {
            return false;
        }
        byte[] ret = this.sendCommand("78467A495246570000000000000000", 5);
        if (ret != null) {
            UMLog.w(TAG, "RET: " + Common.base16Encode(ret));
            return ret[3] == 6;
        }
        return false;
    }

    public boolean updateFirmware(FirmwareUpdateToolMsg _umtMsg, FirmwareUpdateTool.FMStruct fmFile) {
        if (this._com == null) {
            return false;
        }
        FwUpdateThread fwThread = new FwUpdateThread(fmFile, _umtMsg);
        fwThread.start();
        return true;
    }

    private static byte[] makeCommandForRKI(String commandBodyData) {
        if (commandBodyData == null) {
            return null;
        }
        String sum = IDTechRS232.getSUM(commandBodyData);
        String lrc = IDTechRS232.getLRC(commandBodyData);
        short length = (short)(commandBodyData.length() / 2);
        byte[] lowHigh = new byte[2];
        byte[] cmdLen = new byte[1];
        lowHigh[0] = (byte)(length & 0xFF);
        lowHigh[1] = (byte)(length >> 8 & 0xFF);
        cmdLen[0] = lowHigh[0];
        String lengthCommand = Common.getHexStringFromBytes(lowHigh);
        String commandData = "02" + lengthCommand + commandBodyData + lrc + sum + "03";
        return Common.getByteArray(commandData);
    }

    private static String getSUM(String strData) {
        String strLRC = null;
        byte[] toCharArray = Common.getByteArray(strData);
        byte[] sum = new byte[]{toCharArray[0]};
        int i = 1;
        while (i < toCharArray.length) {
            sum[0] = (byte)(sum[0] + toCharArray[i]);
            ++i;
        }
        strLRC = Common.getHexStringFromBytes(sum);
        return strLRC;
    }

    public static String getLRC(String strData) {
        String strLRC = null;
        byte[] toCharArray = Common.getByteArray(strData);
        byte[] lrc = new byte[]{toCharArray[0]};
        int i = 1;
        while (i < toCharArray.length) {
            lrc[0] = (byte)(lrc[0] ^ toCharArray[i]);
            ++i;
        }
        strLRC = Common.getHexStringFromBytes(lrc);
        return strLRC;
    }

    private class FwUpdateThread
    extends Thread {
        FirmwareUpdateTool.FMStruct fmFile;
        FirmwareUpdateToolMsg _umtMsg;

        public FwUpdateThread(FirmwareUpdateTool.FMStruct fm, FirmwareUpdateToolMsg msg) {
            this.fmFile = fm;
            this._umtMsg = msg;
        }

        public void run() {
            if (Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_COM) {
                ResDataStruct respData = new ResDataStruct();
                int timeout = 0;
                int sleep = 0;
                int cmdCount = 0;
                int prevSend = -1;
                int repeatCount = 0;
                boolean jumpLine = false;
                int i = 0;
                while (i < this.fmFile.commands.length) {
                    String[] strArray;
                    if (this.fmFile.commands[i].length() == 0) {
                        jumpLine = true;
                    }
                    if ((strArray = this.fmFile.commands[i].split(":"))[0].equalsIgnoreCase("TIMEOUT")) {
                        timeout = Integer.parseInt(strArray[1]);
                        if (timeout == 0) {
                            Common.commandTime = 5.0;
                            timeout = 5;
                        } else {
                            if (timeout < 2000) {
                                timeout = 2000;
                            }
                            Common.commandTime = timeout / 1000;
                        }
                        if (!IDTechRS232.this.isFirstTimeEraseSpace) {
                            this._umtMsg.onReceiveMsgUpdateFirmwareProgress(i / this.fmFile.commands.length + 1);
                        }
                    } else if (strArray[0].equalsIgnoreCase("SLEEP")) {
                        sleep = Integer.parseInt(strArray[1]);
                        try {
                            Thread.sleep(sleep);
                        }
                        catch (InterruptedException ex) {
                            UMLog.i(IDTechRS232.TAG, "notify failed firmware update (Line#" + i + ") SLEEP");
                            this._umtMsg.onReceiveMsgUpdateFirmwareResult(303);
                            return;
                        }
                        if (!IDTechRS232.this.isFirstTimeEraseSpace) {
                            this._umtMsg.onReceiveMsgUpdateFirmwareProgress(i * 100 / this.fmFile.commands.length + 1);
                        }
                    } else if (strArray[0].equalsIgnoreCase("SEND")) {
                        byte[] cmd = Common.removeReportIdsAddLength(strArray[1]);
                        String strCmd = Common.getHexStringFromBytes(cmd);
                        ++cmdCount;
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException ex) {
                            UMLog.i(IDTechRS232.TAG, "notify failed firmware update (Line#" + i + ") SEND");
                            this._umtMsg.onReceiveMsgUpdateFirmwareResult(303);
                            return;
                        }
                        if (cmd[11] == -57 && cmd[12] == 21) {
                            try {
                                Thread.sleep(10000L);
                            }
                            catch (InterruptedException ex) {
                                UMLog.i(IDTechRS232.TAG, "notify failed firmware update (Line#" + i + ") SEND");
                                this._umtMsg.onReceiveMsgUpdateFirmwareResult(303);
                                return;
                            }
                        } else if (cmd[11] == -57 && cmd[12] == 65) {
                            Common.setBootLoaderMode(true);
                        }
                        repeatCount = prevSend == i ? ++repeatCount : 0;
                        prevSend = i;
                        byte[] ret = IDTechRS232.this._com.sendCommand(cmd, timeout / 1000);
                        if (cmd[11] == -57 && cmd[12] == 18 && IDTechRS232.this.isFirstTimeEraseSpace) {
                            this._umtMsg.onReceiveMsgUpdateFirmwareResult(310);
                            IDTechRS232.this.isFirstTimeEraseSpace = false;
                            return;
                        }
                        if (ret == null) {
                            UMLog.i(IDTechRS232.TAG, "notify failed firmware update (Line#" + i + ") SEND");
                            this._umtMsg.onReceiveMsgUpdateFirmwareResult(303);
                            return;
                        }
                        UMLog.i(IDTechRS232.TAG, "Line#" + i + " sent successfully.");
                        UMLog.i(IDTechRS232.TAG, strCmd);
                        if (strCmd.length() > 4053) {
                            UMLog.i(IDTechRS232.TAG, strCmd.substring(4053));
                        }
                        respData.resData = new byte[ret.length];
                        System.arraycopy(ret, 0, respData.resData, 0, ret.length);
                        if (!IDTechRS232.this.isFirstTimeEraseSpace) {
                            this._umtMsg.onReceiveMsgUpdateFirmwareProgress(i * 100 / this.fmFile.commands.length + 1);
                        }
                    } else if (strArray[0].equalsIgnoreCase("WAIT")) {
                        byte[] resp = Common.removeReportIds(strArray[1]);
                        if (!IDTechRS232.this.isFirstTimeEraseSpace) {
                            this._umtMsg.onReceiveMsgUpdateFirmwareProgress(i * 100 / this.fmFile.commands.length + 1);
                        }
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    ++i;
                }
                this._umtMsg.onReceiveMsgUpdateFirmwareResult(301);
                Common.setBootLoaderMode(false);
                IDTechRS232.this.isFirstTimeEraseSpace = true;
            }
        }
    }

    class PAT_Wakeup_Runnable
    extends Thread {
        PAT_Wakeup_Runnable() {
        }

        public void run() {
            block16: {
                this.setName("Wakeup PAT-110 Thread Background");
                try {
                    try {
                        long timeBegin = System.currentTimeMillis();
                        long lastTime = 0L;
                        long wakeup_heartbeat = 4000L;
                        int ret = 0;
                        while (IDTechRS232.this.isWakeupThreadRunning) {
                            do {
                                if (!IDTechRS232.this.isWakeupThreadRunning) {
                                    break block16;
                                }
                                try {
                                    lastTime = System.currentTimeMillis() - timeBegin;
                                    if (lastTime > wakeup_heartbeat) {
                                        timeBegin = System.currentTimeMillis();
                                        IDTechRS232.this._com.disableSwipe();
                                        int timeout = 5;
                                        int wakeup_option = 1;
                                        switch (wakeup_option) {
                                            case 0: {
                                                byte[] version = IDTechRS232.this.PAT_sendCommand("784601", timeout);
                                                UMLog.i("**Wakeup: Get Version **", "Ret:" + Common.getHexStringFromBytes(version));
                                                break;
                                            }
                                            case 1: {
                                                byte[] command = new byte[]{0};
                                                IDTechRS232.this._com.PAT_wakeup_sendCommand(command, timeout);
                                                UMLog.i("**Wakeup: Zero Packet **" + lastTime, " Zero Packet  ");
                                                break;
                                            }
                                            case 2: {
                                                ret = IDTechRS232.this._com.writeNothing();
                                                UMLog.i("**Wakeup: NULL Packet ** " + lastTime, " ret = " + ret);
                                            }
                                        }
                                        continue;
                                    }
                                    Thread.sleep(300L);
                                }
                                catch (InterruptedException e) {
                                    break block16;
                                }
                            } while (IDTechRS232.this.isWakeupThreadRunning);
                            if (IDTechRS232.this.isWakeupThreadRunning) continue;
                            break;
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        IDTechRS232.this.isWakeupThreadRunning = false;
                    }
                }
                finally {
                    IDTechRS232.this.isWakeupThreadRunning = false;
                }
            }
        }
    }

    private class RS232ControllerMsgImpl
    implements RS232ControllerMsg {
        private RS232ControllerMsgImpl() {
        }

        public void onDeviceAttached() {
            if (IDTechRS232.this._com.init()) {
                IDTechRS232.this._state_isConnected = true;
                if (IDTechRS232.this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_COM) {
                    IDTechRS232.this._taskExport.setReaderType(ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_COM);
                }
                IDTechRS232.this._msg.com_onReceiveMsgConnected();
            }
        }

        public void onDeviceDetached() {
            IDTechRS232.this._state_isConnected = false;
            IDTechRS232.this._msg.com_onReceiveMsgDisconnected();
            if (IDTechRS232.this._com != null) {
                IDTechRS232.this._com.startCheckingConnection();
            }
        }

        public void onDeviceNotFound() {
            if (IDTechRS232.this._com != null) {
                IDTechRS232.this._com.startCheckingConnection();
            }
        }
    }
}

