/*
 * Decompiled with CFR 0.152.
 */
package com.idtechproducts.device;

import android.content.Context;
import android.media.AudioRecord;
import android.media.AudioTrack;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.os.Environment;
import com.idtechproducts.device.IDTMSRData;
import com.idtechproducts.device.IDT_Device;
import com.idtechproducts.device.OnReceiverListener;
import com.idtechproducts.device.PostCardDataParse;
import com.idtechproducts.device.ReaderInfo;
import com.idtechproducts.device.ResDataStruct;
import com.idtechproducts.device.StructConfigParameters;
import com.idtechproducts.device.audiojack.SdkCustomization;
import com.idtechproducts.device.audiojack.UMLog;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Common {
    static final int[] CrcTable;
    static final String[] languageEN;
    static final String[] languageFR;
    static final String[] languageSP;
    static final String[] languageZH;
    static boolean isNeedWakeupPAT_110;
    static String BTLE_Name;
    public static int mystore;
    static HashMap<String, String> h;
    private static final short[] crc_tabccitt;
    public static OnReceiverListener emvListener;
    public static String voice_recognition_prefix;
    private static boolean P2;
    public static boolean coverAllBaudRate;
    public static Context context;
    public static double commandTime;
    public static long beginTimeEachCmd;
    public static long nTimeCost;
    public static boolean fastSearch;
    private static ReaderInfo.DEVICE_TYPE deviceType;
    private static boolean fw_bootloader_mode;
    private static boolean calculateLRC;
    private static final char[] hexArray;
    public static boolean isGen2;

    static {
        int[] nArray = new int[256];
        nArray[1] = 4129;
        nArray[2] = 8258;
        nArray[3] = 12387;
        nArray[4] = 16516;
        nArray[5] = 20645;
        nArray[6] = 24774;
        nArray[7] = 28903;
        nArray[8] = 33032;
        nArray[9] = 37161;
        nArray[10] = 41290;
        nArray[11] = 45419;
        nArray[12] = 49548;
        nArray[13] = 53677;
        nArray[14] = 57806;
        nArray[15] = 61935;
        nArray[16] = 4657;
        nArray[17] = 528;
        nArray[18] = 12915;
        nArray[19] = 8786;
        nArray[20] = 21173;
        nArray[21] = 17044;
        nArray[22] = 29431;
        nArray[23] = 25302;
        nArray[24] = 37689;
        nArray[25] = 33560;
        nArray[26] = 45947;
        nArray[27] = 41818;
        nArray[28] = 54205;
        nArray[29] = 50076;
        nArray[30] = 62463;
        nArray[31] = 58334;
        nArray[32] = 9314;
        nArray[33] = 13379;
        nArray[34] = 1056;
        nArray[35] = 5121;
        nArray[36] = 25830;
        nArray[37] = 29895;
        nArray[38] = 17572;
        nArray[39] = 21637;
        nArray[40] = 42346;
        nArray[41] = 46411;
        nArray[42] = 34088;
        nArray[43] = 38153;
        nArray[44] = 58862;
        nArray[45] = 62927;
        nArray[46] = 50604;
        nArray[47] = 54669;
        nArray[48] = 13907;
        nArray[49] = 9842;
        nArray[50] = 5649;
        nArray[51] = 1584;
        nArray[52] = 30423;
        nArray[53] = 26358;
        nArray[54] = 22165;
        nArray[55] = 18100;
        nArray[56] = 46939;
        nArray[57] = 42874;
        nArray[58] = 38681;
        nArray[59] = 34616;
        nArray[60] = 63455;
        nArray[61] = 59390;
        nArray[62] = 55197;
        nArray[63] = 51132;
        nArray[64] = 18628;
        nArray[65] = 22757;
        nArray[66] = 26758;
        nArray[67] = 30887;
        nArray[68] = 2112;
        nArray[69] = 6241;
        nArray[70] = 10242;
        nArray[71] = 14371;
        nArray[72] = 51660;
        nArray[73] = 55789;
        nArray[74] = 59790;
        nArray[75] = 63919;
        nArray[76] = 35144;
        nArray[77] = 39273;
        nArray[78] = 43274;
        nArray[79] = 47403;
        nArray[80] = 23285;
        nArray[81] = 19156;
        nArray[82] = 31415;
        nArray[83] = 27286;
        nArray[84] = 6769;
        nArray[85] = 2640;
        nArray[86] = 14899;
        nArray[87] = 10770;
        nArray[88] = 56317;
        nArray[89] = 52188;
        nArray[90] = 64447;
        nArray[91] = 60318;
        nArray[92] = 39801;
        nArray[93] = 35672;
        nArray[94] = 47931;
        nArray[95] = 43802;
        nArray[96] = 27814;
        nArray[97] = 31879;
        nArray[98] = 19684;
        nArray[99] = 23749;
        nArray[100] = 11298;
        nArray[101] = 15363;
        nArray[102] = 3168;
        nArray[103] = 7233;
        nArray[104] = 60846;
        nArray[105] = 64911;
        nArray[106] = 52716;
        nArray[107] = 56781;
        nArray[108] = 44330;
        nArray[109] = 48395;
        nArray[110] = 36200;
        nArray[111] = 40265;
        nArray[112] = 32407;
        nArray[113] = 28342;
        nArray[114] = 24277;
        nArray[115] = 20212;
        nArray[116] = 15891;
        nArray[117] = 11826;
        nArray[118] = 7761;
        nArray[119] = 3696;
        nArray[120] = 65439;
        nArray[121] = 61374;
        nArray[122] = 57309;
        nArray[123] = 53244;
        nArray[124] = 48923;
        nArray[125] = 44858;
        nArray[126] = 40793;
        nArray[127] = 36728;
        nArray[128] = 37256;
        nArray[129] = 33193;
        nArray[130] = 45514;
        nArray[131] = 41451;
        nArray[132] = 53516;
        nArray[133] = 49453;
        nArray[134] = 61774;
        nArray[135] = 57711;
        nArray[136] = 4224;
        nArray[137] = 161;
        nArray[138] = 12482;
        nArray[139] = 8419;
        nArray[140] = 20484;
        nArray[141] = 16421;
        nArray[142] = 28742;
        nArray[143] = 24679;
        nArray[144] = 33721;
        nArray[145] = 37784;
        nArray[146] = 41979;
        nArray[147] = 46042;
        nArray[148] = 49981;
        nArray[149] = 54044;
        nArray[150] = 58239;
        nArray[151] = 62302;
        nArray[152] = 689;
        nArray[153] = 4752;
        nArray[154] = 8947;
        nArray[155] = 13010;
        nArray[156] = 16949;
        nArray[157] = 21012;
        nArray[158] = 25207;
        nArray[159] = 29270;
        nArray[160] = 46570;
        nArray[161] = 42443;
        nArray[162] = 38312;
        nArray[163] = 34185;
        nArray[164] = 62830;
        nArray[165] = 58703;
        nArray[166] = 54572;
        nArray[167] = 50445;
        nArray[168] = 13538;
        nArray[169] = 9411;
        nArray[170] = 5280;
        nArray[171] = 1153;
        nArray[172] = 29798;
        nArray[173] = 25671;
        nArray[174] = 21540;
        nArray[175] = 17413;
        nArray[176] = 42971;
        nArray[177] = 47098;
        nArray[178] = 34713;
        nArray[179] = 38840;
        nArray[180] = 59231;
        nArray[181] = 63358;
        nArray[182] = 50973;
        nArray[183] = 55100;
        nArray[184] = 9939;
        nArray[185] = 14066;
        nArray[186] = 1681;
        nArray[187] = 5808;
        nArray[188] = 26199;
        nArray[189] = 30326;
        nArray[190] = 17941;
        nArray[191] = 22068;
        nArray[192] = 55628;
        nArray[193] = 51565;
        nArray[194] = 63758;
        nArray[195] = 59695;
        nArray[196] = 39368;
        nArray[197] = 35305;
        nArray[198] = 47498;
        nArray[199] = 43435;
        nArray[200] = 22596;
        nArray[201] = 18533;
        nArray[202] = 30726;
        nArray[203] = 26663;
        nArray[204] = 6336;
        nArray[205] = 2273;
        nArray[206] = 14466;
        nArray[207] = 10403;
        nArray[208] = 52093;
        nArray[209] = 56156;
        nArray[210] = 60223;
        nArray[211] = 64286;
        nArray[212] = 35833;
        nArray[213] = 39896;
        nArray[214] = 43963;
        nArray[215] = 48026;
        nArray[216] = 19061;
        nArray[217] = 23124;
        nArray[218] = 27191;
        nArray[219] = 31254;
        nArray[220] = 2801;
        nArray[221] = 6864;
        nArray[222] = 10931;
        nArray[223] = 14994;
        nArray[224] = 64814;
        nArray[225] = 60687;
        nArray[226] = 56684;
        nArray[227] = 52557;
        nArray[228] = 48554;
        nArray[229] = 44427;
        nArray[230] = 40424;
        nArray[231] = 36297;
        nArray[232] = 31782;
        nArray[233] = 27655;
        nArray[234] = 23652;
        nArray[235] = 19525;
        nArray[236] = 15522;
        nArray[237] = 11395;
        nArray[238] = 7392;
        nArray[239] = 3265;
        nArray[240] = 61215;
        nArray[241] = 65342;
        nArray[242] = 53085;
        nArray[243] = 57212;
        nArray[244] = 44955;
        nArray[245] = 49082;
        nArray[246] = 36825;
        nArray[247] = 40952;
        nArray[248] = 28183;
        nArray[249] = 32310;
        nArray[250] = 20053;
        nArray[251] = 24180;
        nArray[252] = 11923;
        nArray[253] = 16050;
        nArray[254] = 3793;
        nArray[255] = 7920;
        CrcTable = nArray;
        languageEN = new String[]{"", "AMOUNT", "AMOUNT OK ? ", "APPROVED", "CALL YOUR BANK", "CANCEL OR ENTER", "CARD ERROR", "DECLINED", "ENTER AMOUNT", "ENTER PIN:", "INCORRECT PIN", "SWIPE OR INSERT", "CARD", "INSERT CARD", "USE CHIP READER", "NOT ACCEPTED", "GET PIN OK", "PLEASE WAIT...", "PROCESSING ERROR", "USE MAGSTRIPE", "TRY AGAIN", "GO ONLINE", "TRANSACTION ERR", "TERMINATE", "ADVICE", "TIME OUT", "PROCESSING...", "PIN TRY LIMIT EX", "ISSUER AUTH FAIL", "CONTINUE PROCESS", "GET PIN ERROR", "GET PIN FAIL", "NO KEY GET PIN", "CANCELLED", "LAST PIN TRY", "WELCOME", "AMOUNT OTHER", "ENTER AMOUNT OTHER", "CAPK HASH VALUE FAIL", "REMOVE CARD", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "TRY MSR AGAIN", "LAST MSR TRY", "TRY ICC AGAIN", "REMOVE CARD", "THANK YOU", "NOT AUTHORIZED", "TRANSACTION COMPLETED", "FAIL", "ERROR", "STOP", "SEE MOBILE PHONE", "PLEASE SIGN RECEIPT", "SIGNATURE REQUIRED", "NOT CONNECTED", "TOO MANY TAPS", "FORM ERROR", "OFFLINE AMOUNT", "BALANCE:", "REFUND", "SWIPE CARD", "PRESENT CARD", "PLEASE TAP OR SWIPE CARD", "INSERT/PRESENT CARD", "INSERT/PRESENT/SWIPE CARD", "USE CHIP & PIN", "TRY OTHER INTERFACE", "USE OTHER CARD", "PLEASE USE OTHER VISA CARD", "USE ALTERNATIVE PAYMENT METHOD", "NO CARD", "PRESENT ONE CARD ONLY", "INTERNATIONAL CARD ONLY", "SWIPE CARD AGAIN", "LAST SWIPE CARD", "INSERT CARD AGAIN", "CARD BLOCKED", "CORRECT PIN", "ENTER PIN AGAIN", "UNABLE TO ENTER PIN", "SELECT NEXT CANDIDATE", "CARD READ OK - REMOVE CARD", "AVAILABLE:", "PLEASE WAIT", "INITIALIZING - PLEASE WAIT...", "APPROVED, BAL:", "DECLINED, BAL:", "PIN REQUIRED", "PAYMENT TYPE NOT ACCEPTED"};
        languageFR = new String[]{"", "MONTANT", "MONTANT OK?", "APPROUVE", "APPE VOTRE BANQE", "ANNULE OU ENTRER", "ERREUR CARTE", "REFUSE", "ENTREZ MONTANT", "ENTREZ PIN:", "NIP INCORRECT", "PASSER OU INSERT", "CARTE", "INSERT CARTE", "UTI LECTEUR CHIP", "PAS ACCEPTE", "CODE OK", "ATTENDRE...", "ERREUR DE TRAITE", "USE MAGSTRIPE", "REESSAYER", "GO LIGNE", "ERREUR DE TRANS", "RESILIER", "CONSEILS", "TIMEOUT", "PROCESSUS...", "PIN TRY DEPASSE", "EMETTEUR FAIL", "CONTINUER LA", "GET PIN ERROR", "GET PIN FAIL", "NO KEY GET PIN", "ANNULE", "LAST PIN TRY", "BIENVENUE", "MONTANT AUTRES", "ENTRER MONTANT AUTRES", "CAPK HASH VALEUR FAIL", "RETIRER LA CARTE", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "TRY MSR AGAIN", "LAST MSR TRY", "INSERER VOTRE CARTE", "RETIRER VOTRE CARTE", "MERCI", "PAS AUTORIS\u00c9", "TRANSACTION TERMIN\u00c9E", "ECHEC", "ERREUR", "ARR\u00caTEZ", "VOYEZ VOTRE MOBILE", "SIGNEZ LE RE\u00c7U", "SIGNATURE REQUISE", "PAS CONNECT\u00c9", "TROP D'ESSAIS", "ERREUR DE FORME", "MONTANT HORS LIGNE", "SOLDE:", "REMBOURSEMENT", "PASSEZ VOTRE CARTE", "PR\u00c9SENTEZ VOTRE CARTE", "PRESENTEZ/PASSEZ VOTRE CARTE", "INS\u00c9REZ OU PRES. VOTRE CARTE", "INS\u00c9REZ OU PRES. /PASSEZ CARTE", "INS\u00c9REZ VOTRE CARTE", "ESSAYER UNE AUTRE INTERFACE", "UTILISEZ UNE AUTRE CARTE", "UTILISEZ UNE AUTRE CARTE VISA", "UTILISEZ AUTRE MODE DE PAIEMENT", "PAS DE CARTE", "PRESENTEZ UNE SEULE CARTE", "CARTE INTERNATI- ONALE SEULEMENT", "PASSEZ LA CARTE A NOUVEAU", "PASSEZ VOTRE DERNIERE CARTE", "INS\u00c9REZ VOTRE CARTE A NOUVEAU", "CARTE BLOQU\u00c9E", "CORRIGER CODE", "RE-ENTREZ VOTRE CODE", "IMPOSSIBLE D'ENTRER CODE", "CHOISIR LE CANDIDAT SUIVANT", "LECTURE CARTE OK RETIREZ CARTE", "DISPONIBLE:", "ATTENDEZ SVP", "INITIALISATION ATTENDEZ SVP", "APPROUV\u00c9, SOLDE:", "REFUSE, SOLDE:", "CODE REQUIS", "TYPE DE PAIEMENT PAS ACCEPT\u00c9"};
        languageSP = new String[]{"", "CANTIDAD", "MONTO ES CORRECTO?", "APROVADO", "LLAME A SU BANCO", "CANCELAR O ENTRAR", "ERROR DE TARJETA", "DECLINADO", "INGRESE MONTO", "ENTRAR NPI:", "NPI INCORRECTO", "MOVER O INSERT", "TARJETA", "INSERTAR TARJETA", "USO CHIP  LECTOR", "NO ACEPTADO", "PIN ACEPTADO", "POR FAVOR ESPERE", "ERROR PROCESANDO", "USO DE MAGSTRIPE", "VUELV INTENTARLO", "GO LINEA", "ERROR DE TRANSAC", "TERMINAR", "CONSEJOS", "TIEMPO DE ESPERA", "PROCESANDO...", "TRY PIN SUPERADA", "EMISOR FALLA", "CONTINUAR PROCES", "OBTENER PIN ERR", "OBTENER PIN FALL", "NO CLAVE GET PIN", "CANCELADO", "LAST PIN TRY", "BIENVENIDOS", "IMPORTE OTRAS", "ENTRAR IMPORTE OTRAS", "CAPK HASH VALOR FAIL", "RETIRE LA TARJETA", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "TRY MSR AGAIN", "LAST MSR TRY", "RETIRER VOTRE CARTE", "QUITE TARJETA", "GRACIAS", "NO AUTORIZADO", "TRANSACCI\u00d3N CONCLUIDA", "FALLA", "ERROR", "PARE", "VER TEL\u00c9FONO", "POR FAVOR FIRMAR RECIBO", "FIRMA REQUERIDA", "NO CONECTADO", "TENTATIVAS EXCEDIDO", "ERROR DE FORMA", "VALOR OFFLINE", "BALANCE:", "REEMBOLSO", "PASE LA TARJETA", "PRESENTE TARJETA", "PRESENTE/PASE LA TARJETA", "INSIRA/PRESENTE LA TARJETA", "INSIRA/PRESENTE/ PASE TARJETA", "USAR CHIP & PIN", "TENTE OTRA FORMA DE PAGO", "USE OTRA TARJETA", "FAVOR USE OTRA TARJETA VISA", "USE OTRA FORMA DE PAGO", "SIN TARJETA", "PRESENTE SOLO UNA TARJETA", "SOLO TARJETAS INTERNACIONALES", "PASE LA TARJETA DE NOVO", "\u00daLTIMO PASE DE LA TARJETA", "INSIRA TARJETA DE NOVO", "TARJETA BLOQUEADA", "CORREGIR PIN", "ENTRAR PIN DE NOVO", "NO SE PUEDE ENTRAR PIN", "ELIGE PR\u00d3XIMO CANDIDATO", "TARJETA OK RETIRE TARJETA", "DISPONIBLE:", "POR FAVOR ESPERE", "INICIALIZANDO POR FAVOR ESPERE", "APROBADO, BAL:", "RECHAZADO, BAL:", "PIN REQUERIDO", "TIPO DE PAGO NO ACEPTADO"};
        languageZH = new String[]{"", "\u91d1\u989d", "\u786e\u5b9a\u91d1\u989d?", "\u901a\u8fc7", "\u8bf7\u8054\u7cfb\u60a8\u7684\u94f6\u884c", "\u53d6\u6d88\u6216\u786e\u5b9a", "\u8bfb\u5361\u9519\u8bef", "\u5361\u88ab\u62d2", "\u8f93\u5165\u91d1\u989d", "\u8bf7\u8f93\u5165\u5bc6\u7801:", "\u5bc6\u7801\u9519\u8bef", "\u8bf7\u5237\u5361\u6216\u63d2\u5361", "\u5361", "\u8bf7\u63d2\u5361", "\u4f7f\u7528\u82af\u7247\u5361", "\u65e0\u6cd5\u63a5\u53d7", "\u83b7\u53d6\u5bc6\u7801\u6b63\u786e", "\u7b49\u5019\u4e2d", "\u5904\u7406\u9519\u8bef", "\u4f7f\u7528\u78c1\u6761\u5361", "\u8bf7\u91cd\u8bd5", "\u5728\u7ebf", "\u4ea4\u6613\u9519\u8bef", "\u7ec8\u6b62", "\u5efa\u8bae", "\u8d85\u65f6", "\u5904\u7406\u4e2d...", "\u5bc6\u7801\u5c1d\u8bd5\u6b21\u6570\u8fc7\u591a", "\u4e0e\u53d1\u5361\u673a\u6784\u8ba4\u8bc1", "\u7ee7\u7eed\u5904\u7406", "\u5bc6\u7801\u9519\u8bef", "\u83b7\u53d6\u5bc6\u7801\u9519\u8bef", "\u65e0\u6cd5\u8f93\u5165\u5bc6\u7801", "\u53d6\u6d88", "\u6700\u540e\u4e00\u6b21\u8f93\u5165\u5bc6\u7801", "\u6b22\u8fce\u4f7f\u7528", "\u8fd4\u73b0", "\u8f93\u5165\u8fd4\u73b0", "\u516c\u94a5\u54c8\u5e0c\u503c\u9519\u8bef", "\u8bf7\u53d6\u5361", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "\u518d\u6b21\u4f7f\u7528\u78c1\u6761\u5361", "\u6700\u540e\u4e00\u6b21\u4f7f\u7528\u78c1\u6761\u5361", "\u516c\u94a5\u54c8\u5e0c\u503c\u9519\u8bef", "\u8bf7\u53d6\u5361", "\u8c22\u8c22\u60a8", "\u672a\u6388\u6743", "\u4ea4\u6613\u5b8c\u6210", "\u5931\u8d25", "\u9519\u8bef", "\u505c\u6b62", "\u8bf7\u67e5\u770b\u624b\u673a", "\u8bf7\u7b7e\u6536\u636e", "\u9700\u8981\u7b7e\u540d", "\u672a\u8fde\u63a5", "\u8fc7\u591a\u5c1d\u8bd5", "\u683c\u5f0f\u9519\u8bef", "\u7ebf\u4e0b\u91d1\u989d", "\u4f59\u989d\uff1a", "\u9000\u6b3e", "\u8bf7\u5237\u5361", "\u8bf7\u62cd\u5361", "\u8bf7\u62cd\u5361\u6216\u5237\u5361", "\u8bf7\u63d2\u5361\u6216\u62cd\u5361", "\u8bf7\u63d2\u5361\u6216\u62cd\u5361\u6216\u5237\u5361", "\u4f7f\u7528\u82af\u7247\u53ca\u5bc6\u7801", "\u8bf7\u5c1d\u8bd5\u5176\u4ed6\u754c\u9762", "\u8bf7\u7528\u5176\u4ed6\u5361", "\u8bf7\u7528\u5176\u4ed6VISA\u5361", "\u8bf7\u7528\u53e6\u5916\u4e00\u79cd\u652f\u4ed8\u65b9\u5f0f", "\u65e0\u5361", "\u8bf7\u62cd\u4e00\u5f20\u5361", "\u8bf7\u7528\u56fd\u9645\u5361", "\u8bf7\u518d\u6b21\u5237\u5361", "\u6700\u540e\u4e00\u6b21\u5237\u5361", "\u8bf7\u518d\u6b21\u63d2\u5361", "\u5361\u88ab\u9501", "\u8bf7\u66f4\u6b63\u5bc6\u7801", "\u8bf7\u518d\u6b21\u8f93\u5165\u5bc6\u7801", "\u65e0\u6cd5\u8f93\u5165\u5bc6\u7801", "\u8bf7\u9009\u62e9\u4e0b\u4e00\u4e2a\u5019\u9009", "\u8bfb\u5361\u6210\u529f \u8bf7\u79fb\u5361", "\u53ef\u7528\uff1a", "\u8bf7\u7b49\u5f85", "\u521d\u59cb\u5316\u4e2d \u8bf7\u7b49\u5f85", "\u901a\u8fc7\uff0c\u4f59\u989d\uff1a", "\u62d2\u7edd\uff0c\u4f59\u989d\uff1a", "\u9700\u8981\u5bc6\u7801", "\u4e0d\u63a5\u53d7\u6b64\u652f\u4ed8\u65b9\u5f0f"};
        isNeedWakeupPAT_110 = false;
        BTLE_Name = "";
        mystore = 0;
        h = null;
        crc_tabccitt = new short[256];
        int P_CCITT = 4129;
        int i = 0;
        while (i < 256) {
            int crc = 0;
            int c = 0xFFFF & (0xFFFFFF00 & i << 8);
            int j = 0;
            while (j < 8) {
                crc = ((crc ^ c) & 0x8000) != 0 ? 0xFFFFFFFE & crc << 1 ^ 0x1021 : 0xFFFF & (0xFFFFFFFE & crc << 1);
                c = (short)(0xFFFF & (0xFFFFFFFE & c << 1));
                ++j;
            }
            Common.crc_tabccitt[i] = (short)crc;
            ++i;
        }
        emvListener = null;
        voice_recognition_prefix = "prefix_vr_";
        P2 = false;
        coverAllBaudRate = false;
        commandTime = 5.0;
        beginTimeEachCmd = 0L;
        nTimeCost = 0L;
        fastSearch = false;
        fw_bootloader_mode = false;
        calculateLRC = true;
        hexArray = "0123456789ABCDEF".toCharArray();
        isGen2 = false;
    }

    public static boolean isStorageExist() {
        boolean sdCardExist = Environment.getExternalStorageState().equals("mounted");
        return sdCardExist;
    }

    public static boolean isNeedWakeup() {
        return isNeedWakeupPAT_110;
    }

    public static void CheckIfNeedWakeup() {
        String manufacture = Build.MANUFACTURER;
        String model = Build.MODEL;
        String releaseVersion = Build.VERSION.RELEASE;
        if (manufacture.equalsIgnoreCase("Partner") && model.equalsIgnoreCase("PAT-110") && releaseVersion.equalsIgnoreCase("4.4.4")) {
            isNeedWakeupPAT_110 = true;
        }
        isNeedWakeupPAT_110 = false;
    }

    public static String getBLEDeviceName() {
        if (deviceType == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT || deviceType == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT || deviceType == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT) {
            return BTLE_Name;
        }
        return "";
    }

    public static void setBLEDeviceName(String btle_name) {
        BTLE_Name = btle_name != null && btle_name.length() > 0 ? btle_name : "";
    }

    public static String getSDRootFilePath() {
        String path = null;
        boolean sdCardExist = Environment.getExternalStorageState().equals("mounted");
        if (sdCardExist) {
            path = Environment.getExternalStorageDirectory().toString();
        }
        return path;
    }

    public static String getApplicationPath(Context ctx) {
        String path = null;
        File fileDir = ctx.getFilesDir();
        path = String.valueOf(fileDir.getParent()) + File.separator + fileDir.getName();
        return path;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean copyFile(String sourceFileName, String destFileName) {
        File f1 = new File(sourceFileName);
        File f2 = new File(destFileName);
        int length = 0x200000;
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            in = new FileInputStream(f1);
            out = new FileOutputStream(f2);
            FileChannel inC = in.getChannel();
            FileChannel outC = out.getChannel();
            ByteBuffer b = null;
            while (true) {
                if (inC.position() == inC.size()) {
                    inC.close();
                    outC.close();
                    return true;
                }
                length = inC.size() - inC.position() < (long)length ? (int)(inC.size() - inC.position()) : 0x200000;
                b = ByteBuffer.allocateDirect(length);
                inC.read(b);
                b.flip();
                outC.write(b);
                outC.force(false);
                continue;
                break;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            return false;
        }
        catch (IOException iOException) {
            return false;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static File getDir_externalOrSandbox(Context context) {
        if (Common.isStorageExist()) {
            return Environment.getExternalStorageDirectory();
        }
        return context.getFilesDir();
    }

    public static Map<String, byte[]> updateTags_Old_To_New(Map<String, byte[]> dict) {
        if (dict == null) {
            return null;
        }
        if (h == null) {
            h = new HashMap();
            h.put("DF01", "DFED26");
            h.put("DF02", "DFEE02");
            h.put("DF10", "DFEE10");
            h.put("DF11", "DFEE11");
            h.put("DF13", "DFEE13");
            h.put("DF14", "DFEE14");
            h.put("DF15", "DFEE04");
            h.put("DF17", "DFEE05");
            h.put("DF18", "DFEE06");
            h.put("DF19", "DFEE07");
            h.put("DF1F", "DFEE09");
            h.put("DF21", "DFEE0B");
            h.put("DF22", "DFEE0D");
            h.put("DF25", "DFEE0E");
            h.put("DF26", "DFEE0F");
            h.put("DF27", "DFEE3E");
            h.put("DF28", "DFEE28");
            h.put("DF29", "DFEE29");
            h.put("DF2A", "DFEE2A");
            h.put("DF2B", "DFEE2B");
            h.put("DF2C", "DFEE2C");
            h.put("DF30", "DFEE30");
            h.put("DF31", "DFEE31");
            h.put("DF32", "DFEE32");
            h.put("DF33", "DFEE33");
            h.put("DF40", "DFEE40");
            h.put("DF41", "DFEE41");
            h.put("DF42", "DFEE42");
            h.put("DF43", "DFEE43");
            h.put("DF45", "DFEE45");
            h.put("DF46", "DFEE46");
            h.put("DF47", "DFEE47");
            h.put("DF48", "DFEE48");
            h.put("DF49", "DFEE49");
            h.put("DF4E", "DFEE4E");
            h.put("DF50", "DFEE50");
            h.put("DF52", "DFEE52");
            h.put("DF55", "DFEE55");
            h.put("DF56", "DFEE56");
            h.put("DF57", "DFEE57");
            h.put("DF58", "DFEE58");
            h.put("DF5A", "DFEE5A");
            h.put("DF5B", "DFEE5B");
            h.put("DF5C", "DFEE5C");
            h.put("DF5D", "DFEE5D");
            h.put("DF5E", "DFEE5E");
            h.put("DF5F", "DFEE5F");
            h.put("DF60", "DFEE60");
            h.put("DF61", "DFEE61");
            h.put("DF62", "DFEE62");
            h.put("DF63", "DFEE63");
            h.put("DF64", "DFEE64");
            h.put("DF65", "DFEE65");
            h.put("DF66", "DFEE66");
            h.put("DF68", "DFEE68");
            h.put("DF69", "DFEE69");
            h.put("DF6A", "DFEE6A");
            h.put("DF6C", "DFEE6C");
            h.put("DF6D", "DFEE6D");
            h.put("DF6E", "FFEE09");
            h.put("DF6F", "DFEE6F");
            h.put("DF70", "DFEE70");
            h.put("DF71", "DFEE71");
            h.put("DF72", "DFEE72");
            h.put("DF73", "DFEE73");
            h.put("DF74", "DFEE74");
            h.put("DF75", "DFEE75");
            h.put("DF76", "DFEE76");
            h.put("DF77", "DFEE77");
            h.put("DF78", "DFEE78");
            h.put("DF79", "DFEE79");
            h.put("DF7A", "DFEE7A");
            h.put("DF7B", "DFEE7B");
            h.put("DF7C", "DFEE7C");
            h.put("DF7D", "DFEE7D");
            h.put("DF7F", "DFEE7F");
            h.put("FF69", "FFEE69");
            h.put("FF70", "DFEF09");
            h.put("FF71", "DFEF14");
            h.put("FF74", "DFEF0F");
            h.put("FF75", "DFEF10");
            h.put("FF76", "DFEF11");
            h.put("FF77", "DFEF15");
            h.put("FF78", "DFEF1B");
            h.put("FF79", "DFEF03");
            h.put("FF7A", "DFEF1D");
            h.put("FF7B", "DFEE03");
            h.put("FF7C", "DFEF12");
            h.put("FF7D", "DFEF13");
            h.put("FFE0", "DFEE4A");
            h.put("FFE1", "DFEE4B");
            h.put("FFE2", "DFEE4C");
            h.put("FFE3", "DFEE4D");
            h.put("FFE4", "DFEE2D");
            h.put("FFE5", "DFEE2E");
            h.put("FFE6", "DFEE2F");
            h.put("FFE7", "DFEE4F");
            h.put("FFE8", "DFEE53");
            h.put("FFE9", "DFEE54");
            h.put("FFEA", "DFEE59");
            h.put("FFEE12", "DFEE12");
            h.put("FFEE13", "DFEF17");
            h.put("FFEE14", "DFEF18");
            h.put("FFEE1C", "DFEF19");
            h.put("FFEE1D", "DFEE1D");
            h.put("FFEE1E", "DFEE0A");
            h.put("FFEE1F", "DFEE02");
            h.put("FFEE20", "DFEE5C");
            h.put("FFF0", "DFEE67");
            h.put("FFF1", "DFEE34");
            h.put("FFF2", "DFEE6B");
            h.put("FFF3", "DFEE44");
            h.put("FFF4", "DFEE35");
            h.put("FFF6", "DFEE6E");
            h.put("FFF7", "DFEE7E");
            h.put("FFF8", "DFEE37");
            h.put("FFF9", "DFEE1C");
            h.put("FFFA", "DFEF29");
            h.put("FFFB", "DFEE38");
            h.put("FFFC", "DFEE39");
        }
        HashMap<String, byte[]> retVal = new HashMap<String, byte[]>();
        Set<String> keys = dict.keySet();
        Iterator<String> iterator = keys.iterator();
        while (iterator.hasNext()) {
            String key;
            String newKey = key = iterator.next();
            if (h.containsKey(key)) {
                newKey = h.get(key);
            }
            retVal.put(newKey, dict.get(key));
        }
        return retVal;
    }

    public static String msrToKB(byte[] data) {
        boolean hasOptional;
        if (data == null || data.length == 0) {
            return "";
        }
        if (data[0] != 2) {
            data = Common.makeCommand(Common.getHexStringFromBytes(data));
        }
        if (data.length < 20) {
            return Common.getHexStringFromBytes(data);
        }
        int len = 0;
        if (data[3] == 192) {
            len = data[6] + data[7];
        } else {
            if ((data[8] & 1) == 1) {
                len += data[5];
            }
            if ((data[8] & 2) == 2) {
                len += data[6];
            }
            if ((data[8] & 4) == 4) {
                len += data[7];
            }
        }
        int offset = 10;
        boolean bl = hasOptional = (data[4] & 0x40) == 64;
        if (hasOptional) {
            offset = offset + 1 + data[10];
        }
        byte[] part1 = new byte[offset];
        byte[] part2 = new byte[len];
        byte[] part3 = new byte[data.length - len - offset];
        System.arraycopy(data, 0, part1, 0, offset);
        System.arraycopy(data, offset, part2, 0, len);
        System.arraycopy(data, offset + len, part3, 0, part3.length);
        String total = String.valueOf(Common.getHexStringFromBytes(part1)) + new String(part2) + Common.getHexStringFromBytes(part3);
        return total;
    }

    public static boolean isFileExist(String path) {
        if (path == null) {
            return false;
        }
        File file = new File(path);
        if (!file.exists()) {
            file = null;
            return false;
        }
        file = null;
        return true;
    }

    public static String base16Encode(byte[] data) {
        if (data == null) {
            return "";
        }
        char[] ENC = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        char[] ret = new char[data.length * 2];
        int i = 0;
        while (i < data.length) {
            ret[i * 2] = ENC[data[i] >> 4 & 0xF];
            ret[i * 2 + 1] = ENC[data[i] & 0xF];
            ++i;
        }
        return String.copyValueOf(ret);
    }

    public static String getHexStringFromBytes(byte[] data) {
        return Common.base16Encode(data);
    }

    public static String getAsciiFromByte(byte[] data) {
        if (data == null) {
            return null;
        }
        if (data.length > 0) {
            StringBuffer sf = new StringBuffer();
            int i = 0;
            while (i < data.length) {
                sf.append((char)data[i]);
                ++i;
            }
            return sf.toString();
        }
        return null;
    }

    public static byte[] base16Decode(String encodedString) {
        if (encodedString == null || encodedString.length() % 2 != 0) {
            return null;
        }
        char[] str = encodedString.toCharArray();
        byte[] ret = new byte[encodedString.length() / 2];
        int i = 0;
        while (i < ret.length) {
            byte n;
            char c = str[i * 2];
            if ('0' <= c && c <= '9') {
                n = (byte)(c - 48);
            } else if ('A' <= c && c <= 'F') {
                n = (byte)(c - 65 + 10);
            } else if ('a' <= c && c <= 'f') {
                n = (byte)(c - 97 + 10);
            } else {
                return null;
            }
            byte b = (byte)(n << 4);
            c = str[i * 2 + 1];
            if ('0' <= c && c <= '9') {
                n = (byte)(c - 48);
            } else if ('A' <= c && c <= 'F') {
                n = (byte)(c - 65 + 10);
            } else if ('a' <= c && c <= 'f') {
                n = (byte)(c - 97 + 10);
            } else {
                return null;
            }
            ret[i] = b = (byte)(b + n);
            ++i;
        }
        return ret;
    }

    public static String getTimeInfoMs(long timeBase) {
        float time = (float)(Common.getCurrentTime() - timeBase) / 1000.0f;
        String strtime = String.format(Locale.US, "%03f", Float.valueOf(time));
        return strtime;
    }

    public static long getCurrentTime() {
        return System.currentTimeMillis();
    }

    public static String getDoubleValue(double dbValue) {
        String strtime = String.format(Locale.US, "%08f", dbValue);
        return strtime;
    }

    public static boolean checkFrequencySupported(int inputFreq, int outputFreq) {
        if (-2 == AudioRecord.getMinBufferSize((int)inputFreq, (int)16, (int)2)) {
            return false;
        }
        return -2 != AudioTrack.getMinBufferSize((int)outputFreq, (int)12, (int)3);
    }

    public static boolean checkInputFrequencySupported(int inputFreq) {
        if (-2 == AudioRecord.getMinBufferSize((int)inputFreq, (int)2, (int)2)) {
            return false;
        }
        return -2 != AudioTrack.getMinBufferSize((int)inputFreq, (int)12, (int)3);
    }

    public static short crc_Update(int crc, byte c) {
        int short_c = 0xFF & c;
        int tmp = 0xFFFF & (0xFF & crc >> 8 ^ short_c);
        crc = 0xFFFF & (0xFFFFFF00 & crc << 8 ^ crc_tabccitt[tmp]);
        return (short)crc;
    }

    public static byte[] makeSetBaudCommand(StructConfigParameters config) {
        int baudByte;
        int baud = config.getBaudRate();
        int levelByte = config.getShuttleChannel();
        switch (baud) {
            case 2400: {
                baudByte = 3;
                break;
            }
            case 4800: {
                baudByte = 4;
                break;
            }
            default: {
                baudByte = 5;
            }
        }
        switch (levelByte) {
            case 0: 
            case 8: 
            case 32: 
            case 48: {
                break;
            }
            default: {
                levelByte = 48;
            }
        }
        byte channel = (byte)(baudByte + levelByte);
        byte[] byArray = new byte[7];
        byArray[0] = 2;
        byArray[1] = 83;
        byArray[2] = 65;
        byArray[3] = 1;
        byArray[4] = channel;
        byArray[5] = 3;
        byte[] ret = byArray;
        byte lrc = 0;
        byte[] byArray2 = ret;
        int n = ret.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray2[n2];
            lrc = (byte)(lrc ^ b);
            ++n2;
        }
        ret[ret.length - 1] = lrc;
        return ret;
    }

    public static byte[] makeSetBaudCommandForUniJack(StructConfigParameters config) {
        int baudByte;
        int baud = config.getBaudRate();
        int levelByte = config.getShuttleChannel();
        switch (baud) {
            case 2400: {
                baudByte = 3;
                break;
            }
            case 4800: {
                baudByte = 4;
                break;
            }
            default: {
                baudByte = 5;
            }
        }
        switch (levelByte) {
            case 0: {
                levelByte = 64;
                break;
            }
            case 32: {
                levelByte = 48;
                break;
            }
            case 48: {
                levelByte = 16;
                break;
            }
            case 8: {
                levelByte = 0;
                break;
            }
            default: {
                levelByte = 16;
            }
        }
        byte channel = (byte)(baudByte + levelByte);
        byte[] byArray = new byte[7];
        byArray[0] = 2;
        byArray[1] = 83;
        byArray[2] = 65;
        byArray[3] = 1;
        byArray[4] = channel;
        byArray[5] = 3;
        byte[] ret = byArray;
        byte lrc = 0;
        byte[] byArray2 = ret;
        int n = ret.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray2[n2];
            lrc = (byte)(lrc ^ b);
            ++n2;
        }
        ret[ret.length - 1] = lrc;
        return ret;
    }

    public static String packageCommand(int powerupBeforeCmd, String strCmd) {
        String strWakeup = "";
        String strIdle1 = "";
        String strIdle2 = "";
        String strIdle3 = "";
        strCmd = String.valueOf(strCmd) + "5555555555";
        int strIdle1Length = 10;
        int wakeupLen = 200;
        int strIdle2Length = 52;
        int internal = 400;
        if (powerupBeforeCmd > 200) {
            wakeupLen = powerupBeforeCmd + 100;
        }
        int i = 0;
        while (i < strIdle1Length) {
            strIdle1 = String.valueOf(strIdle1) + "p";
            ++i;
        }
        i = 0;
        while (i < wakeupLen) {
            strWakeup = String.valueOf(strWakeup) + "0";
            ++i;
        }
        i = 0;
        while (i < strIdle2Length) {
            strIdle2 = String.valueOf(strIdle2) + "p";
            ++i;
        }
        i = 0;
        while (i < internal) {
            strIdle3 = String.valueOf(strIdle3) + "pp";
            ++i;
        }
        String strWaveHexString = String.valueOf(strIdle1) + strWakeup + "s" + strIdle2 + strCmd + "s" + strIdle3;
        return strWaveHexString;
    }

    public static String packageCommand(String strCmd, int baudrate) {
        String strBeforeCmd = "";
        String strIdle1 = "";
        String strIdle2 = "";
        String strIdle3 = "";
        int begin = 20;
        int wakeup = 360;
        int beforeCommand = 52;
        int internal = 400;
        strCmd = String.valueOf(strCmd) + "5555555555";
        if (coverAllBaudRate) {
            begin = 20 * baudrate / 9600;
            wakeup = 360 * baudrate / 9600;
            beforeCommand = 52 * baudrate / 9600;
            internal = 400 * baudrate / 9600;
        }
        int i = 0;
        while (i < begin) {
            strIdle1 = String.valueOf(strIdle1) + "pp";
            ++i;
        }
        i = 0;
        while (i < wakeup) {
            strBeforeCmd = String.valueOf(strBeforeCmd) + "0";
            ++i;
        }
        i = 0;
        while (i < beforeCommand) {
            strIdle2 = String.valueOf(strIdle2) + "p";
            ++i;
        }
        i = 0;
        while (i < internal) {
            strIdle3 = String.valueOf(strIdle3) + "pp";
            ++i;
        }
        String strWaveHexString = String.valueOf(strIdle1) + strBeforeCmd + "s" + strIdle2 + strCmd + "s" + strIdle3;
        return strWaveHexString;
    }

    public static byte[] makeCommand(String commandBodyData, int powerupBeforeCmd) {
        String sum = null;
        String lrc = null;
        List<String> list = Common.getSUM_And_LRC(commandBodyData);
        sum = list.get(0);
        lrc = list.get(1);
        list = null;
        short length = (short)(commandBodyData.length() / 2);
        byte[] lowHigh = new byte[]{(byte)(length & 0xFF), (byte)(length >> 8 & 0xFF)};
        String lengthCommand = Common.getHexStringFromBytes(lowHigh);
        String commandData = Common.packageCommand(powerupBeforeCmd, "02" + lengthCommand + commandBodyData + lrc + sum + "03");
        UMLog.i("~~~COMMAND~~~", "COMMAND=02" + lengthCommand + commandBodyData + lrc + sum + "03");
        lowHigh = null;
        return Common.toHalfByteArray(commandData);
    }

    public static byte[] makeCommand(String commandBodyData) {
        String commandData;
        if (commandBodyData == null) {
            return null;
        }
        String sum = Common.getSUM(commandBodyData);
        String lrc = Common.getLRC(commandBodyData);
        short length = (short)(commandBodyData.length() / 2);
        byte[] lowHigh = new byte[2];
        byte[] cmdLen = new byte[1];
        lowHigh[0] = (byte)(length & 0xFF);
        lowHigh[1] = (byte)(length >> 8 & 0xFF);
        cmdLen[0] = lowHigh[0];
        if (Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V_USB || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_KIOSK_III || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_PIP_READER || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VENDI || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP2000 || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_COM) {
            String lengthCommand = Common.getHexStringFromBytes(cmdLen);
            commandData = String.valueOf(lengthCommand) + commandBodyData;
        } else if (Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_BTMAG || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_SECUREMAG || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_SECUREMAG_KB) {
            commandData = commandBodyData;
        } else {
            String lengthCommand = Common.getHexStringFromBytes(lowHigh);
            commandData = "02" + lengthCommand + commandBodyData + lrc + sum + "03";
        }
        return Common.getByteArray(commandData);
    }

    public static String packageCommandForVendi(String strCmd) {
        String preamble = "5555555555555555555555555555555555555555";
        return String.valueOf(preamble) + strCmd;
    }

    public static String byteToString(byte[] bytes) {
        String result = "";
        if (bytes == null || bytes.length == 0) {
            return result;
        }
        int i = 0;
        while (i < bytes.length) {
            if ((bytes[i] & 0x80) == 0) {
                result = String.valueOf(result) + String.format(Locale.US, "%c", bytes[i]);
            }
            ++i;
        }
        return result;
    }

    public static byte[] makeSetBaudAndLevelCommand(StructConfigParameters config, int outputBaudrate) {
        if (deviceType == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ || deviceType == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V) {
            int baudByte;
            int levelByte = config.getShuttleChannel();
            switch (outputBaudrate) {
                case 2400: {
                    baudByte = 3;
                    break;
                }
                case 4800: {
                    baudByte = 4;
                    break;
                }
                default: {
                    baudByte = 5;
                }
            }
            switch (levelByte) {
                case 0: 
                case 8: 
                case 32: 
                case 48: {
                    break;
                }
                default: {
                    levelByte = 48;
                }
            }
            byte channel = (byte)(baudByte + levelByte);
            String _strCommandData = Common.getHexStringFromBytes(Common.grsiP2Command((byte)48, (byte)3, new byte[]{channel}));
            UMLog.e("Universal SDK", "UniPayIII command: " + _strCommandData);
            _strCommandData = Common.packageCommandForVendi(_strCommandData);
            return Common.getBytesFromHexString(_strCommandData);
        }
        int baud = config.getBaudRate();
        byte levelByte = config.getShuttleChannel();
        int level = 1;
        switch (levelByte) {
            case 0: {
                level = 1;
                break;
            }
            case 32: {
                level = 2;
                break;
            }
            case 48: {
                level = 3;
                break;
            }
            case 8: {
                level = 4;
                break;
            }
            default: {
                level = 3;
            }
        }
        int value = (int)Math.pow(2.0, --level);
        String commandData = "7D53014102" + Common.getUniPayBaudRateHex(Integer.toString(baud)) + "0" + value;
        String sum = Common.getSUM(commandData);
        String lrc = Common.getLRC(commandData);
        String _strCommandData = Common.packageCommand("020700" + commandData + lrc + sum + "03", outputBaudrate);
        return Common.toHalfByteArray(_strCommandData);
    }

    public static byte[] toHalfByteArray(String hexString) {
        if (hexString == null) {
            throw new IllegalArgumentException("this hexString must not be empty");
        }
        hexString = hexString.toLowerCase(Locale.US);
        byte[] byteArray = new byte[hexString.length()];
        int k = 0;
        int i = 0;
        while (i < byteArray.length) {
            byte data;
            byteArray[i] = data = (byte)(Character.digit(hexString.charAt(k), 16) & 0xF);
            if (!(hexString.charAt(k) >= '0' && hexString.charAt(k) <= '9' || hexString.charAt(k) >= 'a' && hexString.charAt(k) <= 'f')) {
                if (hexString.charAt(k) == 'p') {
                    int n = i;
                    byteArray[n] = (byte)(byteArray[n] | 0x70);
                } else if (hexString.charAt(k) == 's') {
                    int n = i;
                    byteArray[n] = (byte)(byteArray[n] | 0x60);
                } else {
                    int n = i;
                    byteArray[n] = (byte)(byteArray[n] | 0xF0);
                }
            }
            ++k;
            ++i;
        }
        return byteArray;
    }

    private static String getUniPayBaudRateHex(String strBaudRate) {
        int baudBits = 0;
        if (strBaudRate.compareTo("38400") == 0) {
            baudBits = 7;
        }
        baudBits = strBaudRate.compareTo("19200") == 0 ? 6 : (strBaudRate.compareTo("9600") == 0 ? 52 : (strBaudRate.compareTo("4800") == 0 ? 51 : (strBaudRate.compareTo("2400") == 0 ? 50 : 52)));
        int baudCommandByte = baudBits;
        return String.format(Locale.US, "%02x", (byte)baudCommandByte);
    }

    public static List<String> getSUM_And_LRC(String strData) {
        byte[] toCharArray = Common.getByteArray(strData);
        byte[] sum = new byte[]{toCharArray[0]};
        byte[] lrc = new byte[]{toCharArray[0]};
        int i = 1;
        while (i < toCharArray.length) {
            lrc[0] = (byte)(lrc[0] ^ toCharArray[i]);
            sum[0] = (byte)(sum[0] + toCharArray[i]);
            ++i;
        }
        String strLRC = Common.getHexStringFromBytes(lrc);
        String strSUM = Common.getHexStringFromBytes(sum);
        ArrayList<String> list = new ArrayList<String>();
        list.add(strSUM);
        list.add(strLRC);
        return list;
    }

    public static String getSUM(String strData) {
        String strLRC = null;
        byte[] toCharArray = Common.getByteArray(strData);
        byte[] sum = new byte[]{toCharArray[0]};
        int i = 1;
        while (i < toCharArray.length) {
            sum[0] = (byte)(sum[0] + toCharArray[i]);
            ++i;
        }
        strLRC = Common.getHexStringFromBytes(sum);
        return strLRC;
    }

    public static String getLRC(String strData) {
        String strLRC = null;
        byte[] toCharArray = Common.getByteArray(strData);
        byte[] lrc = new byte[]{toCharArray[0]};
        int i = 1;
        while (i < toCharArray.length) {
            lrc[0] = (byte)(lrc[0] ^ toCharArray[i]);
            ++i;
        }
        strLRC = Common.getHexStringFromBytes(lrc);
        return strLRC;
    }

    public static byte getLRC(byte[] byteArray) {
        if (byteArray == null) {
            return 0;
        }
        byte lrc = byteArray[0];
        int i = 1;
        while (i < byteArray.length) {
            lrc = (byte)(lrc ^ byteArray[i]);
            ++i;
        }
        return lrc;
    }

    public static byte[] getByteArray(String hexString) {
        if (hexString == null) {
            throw new IllegalArgumentException("this hexString must not be empty");
        }
        hexString = hexString.toLowerCase(Locale.US);
        byte[] byteArray = new byte[hexString.length() / 2];
        int i = 0;
        while (i < byteArray.length) {
            byte dataH = (byte)(Character.digit(hexString.charAt(2 * i), 16) & 0xF);
            byte dataL = (byte)(Character.digit(hexString.charAt(2 * i + 1), 16) & 0xF);
            byteArray[i] = (byte)(dataH << 4 & 0xF0 | dataL & 0xF);
            ++i;
        }
        return byteArray;
    }

    public static String getByteArrDesc(byte[] d) {
        if (d == null) {
            return "(null)";
        }
        int dl = d.length;
        return String.format(Locale.US, "%d bytes: [%s%s%s%s]", dl, dl >= 1 ? String.format(Locale.US, "%02X", d[0]) : "", dl >= 2 ? String.format(Locale.US, "%02X", d[1]) : "", dl >= 4 ? "..." : "", dl >= 3 ? String.format(Locale.US, "%02X", d[dl - 1]) : "");
    }

    public static boolean containsStr(byte[] buff, String str) {
        char[] ca = str.toCharArray();
        byte[] bseq = new byte[ca.length];
        int i = 0;
        while (i < ca.length) {
            bseq[i] = (byte)(ca[i] & 0xFF);
            ++i;
        }
        i = 0;
        while (i < buff.length - bseq.length + 1) {
            block4: {
                int o = 0;
                while (o < bseq.length) {
                    if (buff[i + o] == bseq[o]) {
                        ++o;
                        continue;
                    }
                    break block4;
                }
                return true;
            }
            ++i;
        }
        return false;
    }

    public static void setEMVListener(OnReceiverListener callback) {
        emvListener = callback;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean bytesMatch(byte[] ba, String pattern) throws IllegalArgumentException {
        try {
            String[] exps;
            String[] stringArray = exps = pattern.split(",");
            int n = exps.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return true;
                }
                String exp = stringArray[n2];
                IllegalArgumentException invalidExp = new IllegalArgumentException("invalid exp <" + exp + ">");
                String[] LR = exp.split("=");
                if (LR.length != 2) {
                    throw invalidExp;
                }
                if (LR[0].equals("len")) {
                    int val = Integer.parseInt(LR[1], 10);
                    if (ba.length != val) {
                        return false;
                    }
                } else {
                    byte val;
                    if (!LR[0].startsWith("[")) throw invalidExp;
                    if (!LR[0].endsWith("]")) throw invalidExp;
                    if (!LR[1].startsWith("x")) throw invalidExp;
                    int idx = Integer.parseInt(LR[0].substring(1, LR[0].length() - 1), 10);
                    if (idx < 0) {
                        idx = ba.length + idx;
                    }
                    if (ba[idx] != (val = (byte)(0xFF & Integer.parseInt(LR[1].substring(1), 16)))) {
                        return false;
                    }
                }
                ++n2;
            }
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException("invalid pattern string <" + pattern + ">", e);
        }
    }

    public static byte[] getBytesFromHexString(String strHexData) {
        if (1 == strHexData.length() % 2) {
            return null;
        }
        byte[] bytes = new byte[strHexData.length() / 2];
        int i = 0;
        while (i < strHexData.length() / 2) {
            try {
                bytes[i] = (byte)Integer.parseInt(strHexData.substring(i * 2, (i + 1) * 2), 16);
            }
            catch (Exception e) {
                return null;
            }
            ++i;
        }
        return bytes;
    }

    public static byte[] synthesizeStereoSquareWavePeriod(int squareWaveFrequency, int playbackFrequency, int outputWaveDirection) {
        if (squareWaveFrequency <= 0 || playbackFrequency <= 0) {
            throw new IllegalArgumentException();
        }
        int frameCount_total = (int)Math.round((double)playbackFrequency / (double)squareWaveFrequency);
        int frameCount_half = frameCount_total / 2;
        int frameCount_pos = frameCount_half - 1 + (frameCount_total & 1);
        int frameCount_neg = frameCount_half - 1;
        int H = -1;
        int M = -128;
        boolean L = true;
        int stereoFrameSize = 2;
        byte[] midFrame = new byte[]{-128, -128};
        byte[] posFrame = new byte[]{-1, 1};
        byte[] negFrame = new byte[]{1, -1};
        if (outputWaveDirection != 0) {
            byte[] t = posFrame;
            posFrame = negFrame;
            negFrame = t;
        }
        byte[] ret = new byte[frameCount_total * 2];
        int retI = 0;
        System.arraycopy(midFrame, 0, ret, retI, 2);
        retI += 2;
        int i = 0;
        while (i < frameCount_pos) {
            System.arraycopy(posFrame, 0, ret, retI, 2);
            retI += 2;
            ++i;
        }
        System.arraycopy(midFrame, 0, ret, retI, 2);
        retI += 2;
        i = 0;
        while (i < frameCount_neg) {
            System.arraycopy(negFrame, 0, ret, retI, 2);
            retI += 2;
            ++i;
        }
        return ret;
    }

    public static boolean isOnline(Context ctx) {
        ConnectivityManager cm;
        block5: {
            block4: {
                try {
                    cm = (ConnectivityManager)ctx.getSystemService("connectivity");
                    NetworkInfo wifiNetwork = cm.getNetworkInfo(1);
                    if (wifiNetwork == null || !wifiNetwork.isConnected()) break block4;
                    return true;
                }
                catch (Exception e) {
                    return false;
                }
            }
            NetworkInfo mobileNetwork = cm.getNetworkInfo(0);
            if (mobileNetwork == null || !mobileNetwork.isConnected()) break block5;
            return true;
        }
        NetworkInfo activeNetwork = cm.getActiveNetworkInfo();
        return activeNetwork != null && activeNetwork.isConnected();
    }

    public static byte[] grsiP2Command(byte command, byte status, byte[] data) {
        P2 = true;
        byte[] byArray = new byte[14];
        byArray[0] = 86;
        byArray[1] = 105;
        byArray[2] = 86;
        byArray[3] = 79;
        byArray[4] = 116;
        byArray[5] = 101;
        byArray[6] = 99;
        byArray[7] = 104;
        byArray[8] = 50;
        byArray[10] = command;
        byArray[11] = status;
        byArray[12] = (byte)((data.length & 0xFF00) >> 8);
        byArray[13] = (byte)(data.length & 0xFF);
        byte[] cmd = byArray;
        byte[] md = new byte[cmd.length + data.length];
        System.arraycopy(cmd, 0, md, 0, cmd.length);
        if (data.length > 0) {
            System.arraycopy(data, 0, md, cmd.length, data.length);
        }
        char crc = Common.CalculateCRC(md, md.length);
        char[] theCRC = new char[]{(char)(crc & 0xFF), (char)((crc & 0xFF00) >> 8)};
        byte[] b = new byte[md.length + 2];
        System.arraycopy(md, 0, b, 0, md.length);
        b[md.length] = (byte)theCRC[0];
        b[md.length + 1] = (byte)theCRC[1];
        return b;
    }

    public static char CalculateCRC(byte[] Buffer2, int Len) {
        char Crc = '\uffff';
        int i = 0;
        while (Len > 0) {
            Crc = (char)((char)CrcTable[(char)(Crc >> 8) ^ (char)Buffer2[i] & 0xFF] ^ (char)(Crc << 8));
            ++i;
            --Len;
        }
        return Crc;
    }

    public static byte[] grsiP1Command(byte command, byte sub, byte d1, byte d2) {
        P2 = false;
        byte[] byArray = new byte[16];
        byArray[0] = 86;
        byArray[1] = 105;
        byArray[2] = 86;
        byArray[3] = 79;
        byArray[4] = 116;
        byArray[5] = 101;
        byArray[6] = 99;
        byArray[7] = 104;
        byArray[9] = 67;
        byArray[10] = command;
        byArray[11] = sub;
        byArray[12] = d1;
        byArray[13] = d2;
        byte[] cmd = byArray;
        char crc = Common.CalculateCRC(cmd, cmd.length - 2);
        cmd[14] = (byte)(crc & 0xFF);
        cmd[15] = (byte)((crc & 0xFF00) >> 8);
        return cmd;
    }

    public static boolean isP2() {
        return P2;
    }

    public static String getMyStorageFilePath(Context ctx) {
        String path = null;
        path = Common.isStorageExist() ? Environment.getExternalStorageDirectory().toString() : Common.getApplicationPath(ctx);
        return path;
    }

    public static void setDeviceType(ReaderInfo.DEVICE_TYPE dt) {
        deviceType = dt;
    }

    public static ReaderInfo.DEVICE_TYPE getDeviceType() {
        return deviceType;
    }

    public static void setBootLoaderMode(boolean fwi) {
        fw_bootloader_mode = fwi;
    }

    public static boolean getBootLoaderMode() {
        return fw_bootloader_mode;
    }

    public static void setCalculateLRC(boolean on) {
        calculateLRC = on;
    }

    public static boolean getCalculateLRC() {
        return calculateLRC;
    }

    public static byte[] encodeTags(Map<String, String> emvTags, int timeout) {
        if (timeout == 0) {
            timeout = 5;
        }
        ArrayList<Byte> byteArray = new ArrayList<Byte>();
        byteArray.add((byte)timeout);
        if (emvTags.size() == 0) {
            return null;
        }
        for (String key : emvTags.keySet()) {
            if (key.equalsIgnoreCase("ERROR")) continue;
            byte[] bytes = Common.hexStringToByteArray(key);
            int i = 0;
            while (i < bytes.length) {
                byteArray.add(bytes[i]);
                ++i;
            }
            byte[] currentData = Common.hexStringToByteArray(emvTags.get(key));
            int currentLength = currentData.length;
            if (currentLength > 255) {
                byteArray.add((byte)-126);
                byteArray.add((byte)(currentLength >> 8));
                byteArray.add((byte)(currentLength & 0xFF));
            } else if (currentLength > 127) {
                byteArray.add((byte)-127);
                byteArray.add((byte)currentLength);
            } else {
                byteArray.add((byte)currentLength);
            }
            i = 0;
            while (i < currentData.length) {
                byteArray.add(currentData[i]);
                ++i;
            }
        }
        byte[] combined = new byte[byteArray.size()];
        int i = 0;
        while (i < byteArray.size()) {
            combined[i] = (Byte)byteArray.get(i);
            ++i;
        }
        return combined;
    }

    public static byte[] getHash(String password) {
        MessageDigest digest = null;
        try {
            digest = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e1) {
            e1.printStackTrace();
        }
        digest.reset();
        return digest.digest(password.getBytes());
    }

    public static String bin2hex(byte[] data) {
        return String.format(Locale.US, "%0" + data.length * 2 + "X", new BigInteger(1, data));
    }

    public static byte[] encodeTags(Map<String, String> emvTags, byte fallback, int timeout1, int timeout2) {
        if (timeout1 == 0) {
            timeout1 = 5;
        }
        if (timeout2 == 0) {
            timeout2 = 5;
        }
        ArrayList<Byte> byteArray = new ArrayList<Byte>();
        byteArray.add(fallback);
        byteArray.add((byte)(timeout1 >> 8));
        byteArray.add((byte)(timeout1 & 0xFF));
        byteArray.add((byte)(timeout2 >> 8));
        byteArray.add((byte)(timeout2 & 0xFF));
        if (emvTags.size() == 0) {
            return null;
        }
        for (String key : emvTags.keySet()) {
            byte[] bytes = Common.hexStringToByteArray(key);
            int i = 0;
            while (i < bytes.length) {
                byteArray.add(bytes[i]);
                ++i;
            }
            byte[] currentData = Common.hexStringToByteArray(emvTags.get(key));
            int currentLength = currentData.length;
            if (currentLength > 255) {
                byteArray.add((byte)-126);
                byteArray.add((byte)(currentLength >> 8));
                byteArray.add((byte)(currentLength & 0xFF));
            } else if (currentLength > 127) {
                byteArray.add((byte)-127);
                byteArray.add((byte)currentLength);
            } else {
                byteArray.add((byte)currentLength);
            }
            i = 0;
            while (i < currentData.length) {
                byteArray.add(currentData[i]);
                ++i;
            }
        }
        byte[] combined = new byte[byteArray.size()];
        int i = 0;
        while (i < byteArray.size()) {
            combined[i] = (Byte)byteArray.get(i);
            ++i;
        }
        return combined;
    }

    public static byte[] hexStringToByteArray(String s) {
        int len = s.length();
        byte[] data = new byte[len / 2];
        int i = 0;
        while (i < len) {
            data[i / 2] = (byte)((Character.digit(s.charAt(i), 16) << 4) + Character.digit(s.charAt(i + 1), 16));
            i += 2;
        }
        return data;
    }

    public static String asciiToHex(String asciiValue) {
        char[] chars = asciiValue.toCharArray();
        StringBuffer hex = new StringBuffer();
        int i = 0;
        while (i < chars.length) {
            hex.append(Integer.toHexString(chars[i]));
            ++i;
        }
        return hex.toString();
    }

    public static String bytesToHex(byte[] bytes) {
        if (bytes == null) {
            return "";
        }
        char[] hexChars = new char[bytes.length * 2];
        int j = 0;
        while (j < bytes.length) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
            ++j;
        }
        return new String(hexChars);
    }

    public static ReaderInfo.CAPTURE_ENCODE_TYPE getCardType(byte type) {
        switch (type) {
            case -128: {
                return ReaderInfo.CAPTURE_ENCODE_TYPE.CAPTURE_ENCODE_TYPE_ISOABA;
            }
            case -127: {
                return ReaderInfo.CAPTURE_ENCODE_TYPE.CAPTURE_ENCODE_TYPE_AAMVA;
            }
            case -125: {
                return ReaderInfo.CAPTURE_ENCODE_TYPE.CAPTURE_ENCODE_TYPE_Other;
            }
            case -124: {
                return ReaderInfo.CAPTURE_ENCODE_TYPE.CAPTURE_ENCODE_TYPE_Raw;
            }
            case -123: {
                return ReaderInfo.CAPTURE_ENCODE_TYPE.CAPTURE_ENCODE_TYPE_Jis_II;
            }
            case -122: {
                return ReaderInfo.CAPTURE_ENCODE_TYPE.CAPTURE_ENCODE_TYPE_Jis_I;
            }
            case -121: {
                return ReaderInfo.CAPTURE_ENCODE_TYPE.CAPTURE_ENCODE_TYPE_Jis_II_Security;
            }
            case -111: {
                return ReaderInfo.CAPTURE_ENCODE_TYPE.CAPTURE_ENCODE_TYPE_Contactless_Visa_Kernel1;
            }
            case -110: {
                return ReaderInfo.CAPTURE_ENCODE_TYPE.CAPTURE_ENCODE_TYPE_Contactless_MasterCard;
            }
            case -109: {
                return ReaderInfo.CAPTURE_ENCODE_TYPE.CAPTURE_ENCODE_TYPE_Contactless_Visa_Kernel3;
            }
            case -108: {
                return ReaderInfo.CAPTURE_ENCODE_TYPE.CAPTURE_ENCODE_TYPE_Contactless_AmericanExpress;
            }
            case -107: {
                return ReaderInfo.CAPTURE_ENCODE_TYPE.CAPTURE_ENCODE_TYPE_Contactless_JCB;
            }
            case -106: {
                return ReaderInfo.CAPTURE_ENCODE_TYPE.CAPTURE_ENCODE_TYPE_Contactless_Discover;
            }
            case -105: {
                return ReaderInfo.CAPTURE_ENCODE_TYPE.CAPTURE_ENCODE_TYPE_Contactless_UnionPay;
            }
            case -112: {
                return ReaderInfo.CAPTURE_ENCODE_TYPE.CAPTURE_ENCODE_TYPE_Contactless_Others;
            }
            case -64: {
                return ReaderInfo.CAPTURE_ENCODE_TYPE.CAPTURE_ENCODE_TYPE_Manual_Entry_Enhanced_Mode;
            }
        }
        return ReaderInfo.CAPTURE_ENCODE_TYPE.CAPTURE_ENCODE_TYPE_UNKNOWN;
    }

    public static ReaderInfo.CTLS_APPLICATION getApplicationType(byte type) {
        switch (type) {
            case 0: {
                return ReaderInfo.CTLS_APPLICATION.CTLS_APPLICATION_NONE;
            }
            case 1: {
                return ReaderInfo.CTLS_APPLICATION.CTLS_APPLICATION_MASTERCARD;
            }
            case 2: {
                return ReaderInfo.CTLS_APPLICATION.CTLS_APPLICATION_VISA;
            }
            case 3: {
                return ReaderInfo.CTLS_APPLICATION.CTLS_APPLICATION_AMEX;
            }
            case 4: {
                return ReaderInfo.CTLS_APPLICATION.CTLS_APPLICATION_DISCOVER;
            }
            case 5: {
                return ReaderInfo.CTLS_APPLICATION.CTLS_APPLICATION_SPEEDPASS;
            }
            case 6: {
                return ReaderInfo.CTLS_APPLICATION.CTLS_APPLICATION_GIFT_CARD;
            }
            case 7: {
                return ReaderInfo.CTLS_APPLICATION.CTLS_APPLICATION_DINERS_CLUB;
            }
            case 8: {
                return ReaderInfo.CTLS_APPLICATION.CTLS_APPLICATION_EN_ROUTE;
            }
            case 9: {
                return ReaderInfo.CTLS_APPLICATION.CTLS_APPLICATION_JCB;
            }
            case 10: {
                return ReaderInfo.CTLS_APPLICATION.CTLS_APPLICATION_VIVO_DIAGNOSTIC;
            }
            case 11: {
                return ReaderInfo.CTLS_APPLICATION.CTLS_APPLICATION_HID;
            }
            case 12: {
                return ReaderInfo.CTLS_APPLICATION.CTLS_APPLICATION_MSR_SWIPE;
            }
            case 13: {
                return ReaderInfo.CTLS_APPLICATION.CTLS_APPLICATION_RESERVED;
            }
            case 14: {
                return ReaderInfo.CTLS_APPLICATION.CTLS_APPLICATION_DES_FIRE_TRACK_DATA;
            }
            case 15: {
                return ReaderInfo.CTLS_APPLICATION.CTLS_APPLICATION_DES_FIRE_RAW_DATA;
            }
            case 17: {
                return ReaderInfo.CTLS_APPLICATION.CTLS_APPLICATION_RBS;
            }
            case 20: {
                return ReaderInfo.CTLS_APPLICATION.CTLS_APPLICATION_VIVO_COMM;
            }
        }
        return ReaderInfo.CTLS_APPLICATION.CTLS_APPLICATION_NONE;
    }

    public static void parseCardData3in1(byte[] resData, IDTMSRData cardData) {
        if (resData == null || resData.length == 0) {
            return;
        }
        int len = resData.length;
        int dataIndex = 10;
        cardData.event = ReaderInfo.EVENT_MSR_Types.EVENT_MSR_CARD_DATA;
        boolean isTDES = true;
        if (len > 14) {
            if (deviceType == ReaderInfo.DEVICE_TYPE.DEVICE_AUGUSTA) {
                cardData.cardData = new byte[resData.length];
                try {
                    System.arraycopy(resData, 0, cardData.cardData, 0, resData.length);
                }
                catch (ArrayIndexOutOfBoundsException exception) {
                    return;
                }
            }
            int dataLen = (resData[12] & 0xFF) << 8 | resData[13] & 0xFF;
            if (dataLen == 0) {
                return;
            }
            cardData.cardData = new byte[dataLen];
            if (14 + dataLen <= resData.length) {
                try {
                    System.arraycopy(resData, 14, cardData.cardData, 0, dataLen);
                }
                catch (ArrayIndexOutOfBoundsException exception) {
                    return;
                }
            }
            byte[] data = cardData.cardData;
            if (deviceType == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ || deviceType == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB || deviceType == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V || deviceType == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V_USB || deviceType == ReaderInfo.DEVICE_TYPE.DEVICE_KIOSK_III || deviceType == ReaderInfo.DEVICE_TYPE.DEVICE_PIP_READER || deviceType == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB || deviceType == ReaderInfo.DEVICE_TYPE.DEVICE_VENDI || deviceType == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT || deviceType == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB || deviceType == ReaderInfo.DEVICE_TYPE.DEVICE_VP2000 || deviceType == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT || deviceType == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB || deviceType == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 || deviceType == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT || deviceType == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_COM) {
                boolean isEncrypted;
                boolean isContactless;
                cardData.isCTLS = isContactless = (data[0] & 1) == 1;
                isTDES = (data[0] & 6) == 0;
                boolean isMSR = (data[0] & 8) == 8;
                boolean bl = isEncrypted = (data[0] & 0xFFFFFF80) == -128;
                if (deviceType == ReaderInfo.DEVICE_TYPE.DEVICE_VP2000) {
                    isContactless = true;
                    cardData.isCTLS = true;
                }
                if (isContactless) {
                    byte[] tlvs;
                    if (deviceType == ReaderInfo.DEVICE_TYPE.DEVICE_VP2000) {
                        tlvs = new byte[data.length];
                        try {
                            System.arraycopy(data, 0, tlvs, 0, data.length);
                        }
                        catch (ArrayIndexOutOfBoundsException exception) {
                            return;
                        }
                    }
                    tlvs = new byte[data.length - 1];
                    try {
                        System.arraycopy(data, 1, tlvs, 0, data.length - 1);
                    }
                    catch (ArrayIndexOutOfBoundsException exception) {
                        return;
                    }
                    Map<String, Map<String, byte[]>> TLVDict = Common.processTLV(tlvs);
                    cardData.unencryptedTags = TLVDict.get("tags");
                    cardData.encryptedTags = TLVDict.get("encrypted");
                    cardData.maskedTags = TLVDict.get("masked");
                    byte[] temp = cardData.encryptedTags.get("FFEE13");
                    if (temp != null && temp.length > 0) {
                        cardData.encTrack1 = new byte[temp.length];
                        try {
                            System.arraycopy(temp, 0, cardData.encTrack1, 0, temp.length);
                        }
                        catch (ArrayIndexOutOfBoundsException exception) {
                            return;
                        }
                    }
                    if ((temp = cardData.encryptedTags.get("FFEE14")) != null && temp.length > 0) {
                        cardData.encTrack2 = new byte[temp.length];
                        try {
                            System.arraycopy(temp, 0, cardData.encTrack2, 0, temp.length);
                        }
                        catch (ArrayIndexOutOfBoundsException exception) {
                            return;
                        }
                    }
                    boolean hasFFEE13_FFEE14 = false;
                    temp = cardData.unencryptedTags.get("FFEE13");
                    if (temp != null && temp.length > 0) {
                        cardData.track1 = Common.getAsciiFromByte(temp);
                        cardData.track1Length = cardData.track1.length();
                        hasFFEE13_FFEE14 = true;
                    } else {
                        temp = cardData.maskedTags.get("FFEE13");
                        if (temp != null && temp.length > 0) {
                            cardData.track1 = Common.getAsciiFromByte(temp);
                            cardData.track1Length = cardData.track1.length();
                            hasFFEE13_FFEE14 = true;
                        }
                    }
                    temp = cardData.unencryptedTags.get("FFEE14");
                    if (temp != null && temp.length > 0) {
                        cardData.track2 = Common.getAsciiFromByte(temp);
                        cardData.track2Length = cardData.track2.length();
                        hasFFEE13_FFEE14 = true;
                    } else {
                        temp = cardData.maskedTags.get("FFEE14");
                        if (temp != null && temp.length > 0) {
                            cardData.track2 = Common.getAsciiFromByte(temp);
                            cardData.track2Length = cardData.track2.length();
                            hasFFEE13_FFEE14 = true;
                        }
                    }
                    if (hasFFEE13_FFEE14) {
                        temp = cardData.unencryptedTags.get("FFEE12");
                        if (temp != null && temp.length > 0) {
                            cardData.KSN = new byte[temp.length];
                            try {
                                System.arraycopy(temp, 0, cardData.KSN, 0, temp.length);
                            }
                            catch (ArrayIndexOutOfBoundsException exception) {
                                return;
                            }
                        }
                        if ((temp = cardData.unencryptedTags.get("DFEE12")) != null && temp.length > 0) {
                            cardData.KSN = new byte[temp.length];
                            try {
                                System.arraycopy(temp, 0, cardData.KSN, 0, temp.length);
                            }
                            catch (ArrayIndexOutOfBoundsException exception) {
                                return;
                            }
                        }
                    }
                } else {
                    byte[] value;
                    if (IDT_Device._isTTK) {
                        boolean isEMV = (cardData.result & Integer.MIN_VALUE) != 0;
                        cardData.result &= Integer.MAX_VALUE;
                        if (cardData.result == 7) {
                            byte[] tlvs = new byte[data.length - 1];
                            try {
                                System.arraycopy(data, 1, tlvs, 0, data.length - 1);
                            }
                            catch (ArrayIndexOutOfBoundsException exception) {
                                return;
                            }
                            Map<String, Map<String, byte[]>> TLVDict = Common.processTLV(tlvs);
                            Map<String, byte[]> unencryptedTags = TLVDict.get("tags");
                            cardData.encryptedTags = TLVDict.get("encrypted");
                            cardData.maskedTags = TLVDict.get("masked");
                            LinkedHashMap<String, byte[]> tags = new LinkedHashMap<String, byte[]>();
                            byte[] value2 = cardData.encryptedTags.get("57");
                            tags.put("57", value2);
                            value2 = unencryptedTags.get("DF4A");
                            tags.put("DF4A", value2);
                            value2 = unencryptedTags.get("DF4C");
                            if (value2 != null && value2.length > 0) {
                                String strValue = Common.base16Encode(value2);
                                if (strValue.contains("CCCC")) {
                                    String finalStr = "";
                                    int i = 0;
                                    while (i < strValue.length()) {
                                        char c = strValue.charAt(i);
                                        if (c == 'C') {
                                            finalStr = String.valueOf(finalStr) + "2A";
                                        } else {
                                            finalStr = String.valueOf(finalStr) + "3";
                                            finalStr = String.valueOf(finalStr) + c;
                                        }
                                        ++i;
                                    }
                                    value2 = Common.getBytesFromHexString(finalStr);
                                    tags.put("DF4C", value2);
                                } else {
                                    tags.put("DF4C", value2);
                                }
                            } else {
                                tags.put("DF4C", value2);
                            }
                            value2 = unencryptedTags.get("84");
                            tags.put("84", value2);
                            value2 = unencryptedTags.get("9F39");
                            if (value2 != null && value2.length > 0) {
                                if ((value2[0] & 0xFFFFFFF0) == 0) {
                                    tags.put("9F39", new byte[]{5, 16});
                                } else {
                                    tags.put("9F39", new byte[]{-112, 16});
                                }
                            } else {
                                tags.put("9F39", new byte[]{-112, 16});
                            }
                            value2 = unencryptedTags.get("5F34");
                            tags.put("5F34", value2);
                            value2 = unencryptedTags.get("9F27");
                            tags.put("9F27", value2);
                            value2 = unencryptedTags.get("9F02");
                            tags.put("9F02", value2);
                            value2 = unencryptedTags.get("9F03");
                            tags.put("9F03", value2);
                            value2 = unencryptedTags.get("9F34");
                            tags.put("9F34", value2);
                            value2 = unencryptedTags.get("9F35");
                            tags.put("9F35", value2);
                            value2 = unencryptedTags.get("9F1E");
                            tags.put("9F1E", value2);
                            tags.put("9F53", new byte[]{82});
                            value2 = unencryptedTags.get("9F09");
                            tags.put("9F09", value2);
                            value2 = unencryptedTags.get("9F41");
                            tags.put("9F41", value2);
                            byte[] byArray = new byte[5];
                            byArray[0] = 5;
                            byArray[3] = 80;
                            tags.put("DF4D", byArray);
                            value2 = unencryptedTags.get("9F26");
                            tags.put("9F26", value2);
                            value2 = unencryptedTags.get("9F10");
                            tags.put("9F10", value2);
                            value2 = unencryptedTags.get("82");
                            tags.put("82", value2);
                            value2 = unencryptedTags.get("9F36");
                            tags.put("9F36", value2);
                            value2 = unencryptedTags.get("9F37");
                            tags.put("9F37", value2);
                            value2 = unencryptedTags.get("9F37");
                            tags.put("9F37", value2);
                            value2 = unencryptedTags.get("95");
                            tags.put("95", value2);
                            value2 = unencryptedTags.get("9A");
                            tags.put("9A", value2);
                            value2 = unencryptedTags.get("9C");
                            tags.put("9C", value2);
                            value2 = unencryptedTags.get("9F33");
                            tags.put("9F33", value2);
                            tags.put("9F15", new byte[2]);
                            value2 = unencryptedTags.get("DF21");
                            tags.put("DF21", value2);
                            if (isEMV) {
                                tags.put("DF4F", new byte[1]);
                            } else {
                                tags.put("DF4F", new byte[]{3});
                            }
                            value2 = unencryptedTags.get("9F07");
                            tags.put("9F07", value2);
                            value2 = unencryptedTags.get("5F25");
                            tags.put("5F25", value2);
                            value2 = unencryptedTags.get("5F24");
                            tags.put("5F24", value2);
                            value2 = unencryptedTags.get("5F28");
                            tags.put("5F28", value2);
                            value2 = unencryptedTags.get("5F28");
                            tags.put("5F28", value2);
                            if (!isEMV) {
                                value2 = unencryptedTags.get("DF4B");
                                tags.put("DF4B", value2);
                            }
                            if ((value2 = unencryptedTags.get("DF34")) == null || value2.length < 3) {
                                if (IDT_Device.firmware_version_ttk != null && IDT_Device.firmware_version_ttk.length > 0) {
                                    tags.put("DF34", IDT_Device.firmware_version_ttk);
                                }
                            } else {
                                tags.put("DF34", value2);
                            }
                            cardData.unencryptedTags = tags;
                            LinkedHashMap<String, String> strTags = new LinkedHashMap<String, String>();
                            Set<String> keys = cardData.unencryptedTags.keySet();
                            for (String key : keys) {
                                value2 = cardData.unencryptedTags.get(key);
                                if (value2 == null || value2.length == 0) {
                                    strTags.put(key, "");
                                    continue;
                                }
                                strTags.put(key, Common.getHexStringFromBytes(value2));
                            }
                            value2 = Common.encodeTags(strTags, 30);
                            cardData.TLVData = new byte[value2.length - 1];
                            try {
                                System.arraycopy(value2, 1, cardData.TLVData, 0, value2.length - 1);
                            }
                            catch (ArrayIndexOutOfBoundsException exception) {
                                return;
                            }
                            cardData.TLVLen = cardData.TLVData.length;
                            cardData.iccPresent = true;
                            cardData.captureEncryptType = ReaderInfo.CAPTURE_ENCRYPT_TYPE.CAPTURE_ENCRYPT_TYPE_AES;
                            cardData.result = 0;
                            return;
                        }
                        if (cardData.result == 17) {
                            byte[] tlvs = new byte[data.length - 1];
                            try {
                                System.arraycopy(data, 1, tlvs, 0, data.length - 1);
                            }
                            catch (ArrayIndexOutOfBoundsException exception) {
                                return;
                            }
                            Map<String, Map<String, byte[]>> TLVDict = Common.processTLV(tlvs);
                            Map<String, byte[]> unencryptedTags = TLVDict.get("tags");
                            cardData.encryptedTags = TLVDict.get("encrypted");
                            cardData.maskedTags = TLVDict.get("masked");
                            LinkedHashMap<String, byte[]> tags = new LinkedHashMap<String, byte[]>();
                            byte[] value3 = unencryptedTags.get("DF4A");
                            if (value3 != null && value3.length > 0) {
                                tags.put("DF4A", value3);
                            }
                            if ((value3 = unencryptedTags.get("DF4C")) != null && value3.length > 0) {
                                tags.put("DF4C", value3);
                            }
                            if ((value3 = unencryptedTags.get("DF4B")) != null) {
                                tags.put("DF4B", value3);
                            }
                            if ((value3 = unencryptedTags.get("DF34")) == null || value3.length < 3) {
                                if (IDT_Device.firmware_version_ttk != null && IDT_Device.firmware_version_ttk.length > 0) {
                                    tags.put("DF34", IDT_Device.firmware_version_ttk);
                                }
                            } else {
                                tags.put("DF34", value3);
                            }
                            cardData.unencryptedTags = tags;
                            LinkedHashMap<String, String> strTags = new LinkedHashMap<String, String>();
                            Set<String> keys = cardData.unencryptedTags.keySet();
                            for (String key : keys) {
                                value3 = cardData.unencryptedTags.get(key);
                                if (value3 == null || value3.length == 0) {
                                    strTags.put(key, "");
                                    continue;
                                }
                                strTags.put(key, Common.getHexStringFromBytes(value3));
                            }
                            value3 = Common.encodeTags(strTags, 30);
                            cardData.TLVData = new byte[value3.length - 1];
                            try {
                                System.arraycopy(value3, 1, cardData.TLVData, 0, value3.length - 1);
                            }
                            catch (ArrayIndexOutOfBoundsException exception) {
                                return;
                            }
                            cardData.TLVLen = cardData.TLVData.length;
                            cardData.iccPresent = true;
                            cardData.captureEncryptType = ReaderInfo.CAPTURE_ENCRYPT_TYPE.CAPTURE_ENCRYPT_TYPE_AES;
                            cardData.result = 0;
                            return;
                        }
                    }
                    byte[] tlvs = new byte[data.length - 1];
                    try {
                        System.arraycopy(data, 1, tlvs, 0, data.length - 1);
                    }
                    catch (ArrayIndexOutOfBoundsException exception) {
                        return;
                    }
                    Map<String, Map<String, byte[]>> TLVDict = Common.processTLV(tlvs);
                    cardData.unencryptedTags = TLVDict.get("tags");
                    byte[] temp = cardData.unencryptedTags.get("DFEE23");
                    if (temp == null) {
                        return;
                    }
                    cardData.encryptedTags = TLVDict.get("encrypted");
                    cardData.maskedTags = TLVDict.get("masked");
                    cardData.rawTrackData = new byte[temp.length];
                    try {
                        System.arraycopy(temp, 0, cardData.rawTrackData, 0, temp.length);
                    }
                    catch (ArrayIndexOutOfBoundsException exception) {
                        return;
                    }
                    Common.parseEMVFormat1(temp, cardData);
                    HashMap<String, String> tags = new HashMap<String, String>();
                    Set<String> keys = cardData.unencryptedTags.keySet();
                    for (String key : keys) {
                        if (key.equalsIgnoreCase("DFEE23")) continue;
                        value = cardData.unencryptedTags.get(key);
                        tags.put(key, Common.getHexStringFromBytes(value));
                    }
                    value = Common.encodeTags(tags, 30);
                    if (value == null) {
                        return;
                    }
                    cardData.TLVData = new byte[value.length - 1];
                    try {
                        System.arraycopy(value, 1, cardData.TLVData, 0, value.length - 1);
                    }
                    catch (ArrayIndexOutOfBoundsException exception) {
                        return;
                    }
                    cardData.TLVLen = cardData.TLVData.length;
                    if (cardData.result == 7 || cardData.result == 17) {
                        cardData.result = 0;
                    }
                }
            } else {
                if (deviceType == ReaderInfo.DEVICE_TYPE.DEVICE_AUGUSTA && IDT_Device._isTTK) {
                    boolean isEMV = (cardData.result & Integer.MIN_VALUE) != 0;
                    cardData.result &= Integer.MAX_VALUE;
                    if (cardData.result == 7) {
                        byte[] tlvs = new byte[data.length - 6];
                        try {
                            System.arraycopy(data, 6, tlvs, 0, data.length - 6);
                        }
                        catch (ArrayIndexOutOfBoundsException exception) {
                            return;
                        }
                        Map<String, Map<String, byte[]>> TLVDict = Common.processTLV(tlvs);
                        Map<String, byte[]> unencryptedTags = TLVDict.get("tags");
                        cardData.encryptedTags = TLVDict.get("encrypted");
                        cardData.maskedTags = TLVDict.get("masked");
                        LinkedHashMap<String, byte[]> tags = new LinkedHashMap<String, byte[]>();
                        byte[] value = unencryptedTags.get("57");
                        tags.put("57", value);
                        value = unencryptedTags.get("DF4A");
                        tags.put("DF4A", value);
                        value = unencryptedTags.get("DF4C");
                        if (value != null && value.length > 0) {
                            String strValue = Common.base16Encode(value);
                            if (strValue.contains("CCCC")) {
                                String finalStr = "";
                                int i = 0;
                                while (i < strValue.length()) {
                                    char c = strValue.charAt(i);
                                    if (c == 'C') {
                                        finalStr = String.valueOf(finalStr) + "2A";
                                    } else {
                                        finalStr = String.valueOf(finalStr) + "3";
                                        finalStr = String.valueOf(finalStr) + c;
                                    }
                                    ++i;
                                }
                                value = Common.getBytesFromHexString(finalStr);
                                tags.put("DF4C", value);
                            } else {
                                tags.put("DF4C", value);
                            }
                        } else {
                            tags.put("DF4C", value);
                        }
                        value = unencryptedTags.get("84");
                        tags.put("84", value);
                        value = unencryptedTags.get("9F39");
                        if (value != null && value.length > 0) {
                            if ((value[0] & 0xFFFFFFF0) == 0) {
                                tags.put("9F39", new byte[]{5, 16});
                            } else {
                                tags.put("9F39", new byte[]{-112, 16});
                            }
                        } else {
                            tags.put("9F39", new byte[]{-112, 16});
                        }
                        value = unencryptedTags.get("5F34");
                        tags.put("5F34", value);
                        value = unencryptedTags.get("9F27");
                        tags.put("9F27", value);
                        value = unencryptedTags.get("9F02");
                        tags.put("9F02", value);
                        value = unencryptedTags.get("9F03");
                        tags.put("9F03", value);
                        value = unencryptedTags.get("9F34");
                        tags.put("9F34", value);
                        value = unencryptedTags.get("9F35");
                        tags.put("9F35", value);
                        value = unencryptedTags.get("9F1E");
                        tags.put("9F1E", value);
                        tags.put("9F53", new byte[]{82});
                        value = unencryptedTags.get("9F09");
                        tags.put("9F09", value);
                        value = unencryptedTags.get("9F41");
                        tags.put("9F41", value);
                        byte[] byArray = new byte[5];
                        byArray[0] = 5;
                        byArray[3] = 80;
                        tags.put("DF4D", byArray);
                        value = unencryptedTags.get("9F26");
                        tags.put("9F26", value);
                        value = unencryptedTags.get("9F10");
                        tags.put("9F10", value);
                        value = unencryptedTags.get("82");
                        tags.put("82", value);
                        value = unencryptedTags.get("9F36");
                        tags.put("9F36", value);
                        value = unencryptedTags.get("9F37");
                        tags.put("9F37", value);
                        value = unencryptedTags.get("9F37");
                        tags.put("9F37", value);
                        value = unencryptedTags.get("95");
                        tags.put("95", value);
                        value = unencryptedTags.get("9A");
                        tags.put("9A", value);
                        value = unencryptedTags.get("9C");
                        tags.put("9C", value);
                        value = unencryptedTags.get("9F33");
                        tags.put("9F33", value);
                        tags.put("9F15", new byte[2]);
                        value = unencryptedTags.get("DF21");
                        tags.put("DF21", value);
                        if (isEMV) {
                            tags.put("DF4F", new byte[1]);
                        } else {
                            tags.put("DF4F", new byte[]{3});
                        }
                        value = unencryptedTags.get("9F07");
                        tags.put("9F07", value);
                        value = unencryptedTags.get("5F25");
                        tags.put("5F25", value);
                        value = unencryptedTags.get("5F24");
                        tags.put("5F24", value);
                        value = unencryptedTags.get("5F28");
                        tags.put("5F28", value);
                        value = unencryptedTags.get("5F28");
                        tags.put("5F28", value);
                        if (!isEMV) {
                            value = unencryptedTags.get("DF4B");
                            tags.put("DF4B", value);
                        }
                        if ((value = unencryptedTags.get("DF34")) == null || value.length < 3) {
                            if (IDT_Device.firmware_version_ttk != null && IDT_Device.firmware_version_ttk.length > 0) {
                                tags.put("DF34", IDT_Device.firmware_version_ttk);
                            }
                        } else {
                            tags.put("DF34", value);
                        }
                        cardData.unencryptedTags = tags;
                        LinkedHashMap<String, String> strTags = new LinkedHashMap<String, String>();
                        Set<String> keys = cardData.unencryptedTags.keySet();
                        for (String key : keys) {
                            value = cardData.unencryptedTags.get(key);
                            if (value == null || value.length == 0) {
                                strTags.put(key, "");
                                continue;
                            }
                            strTags.put(key, Common.getHexStringFromBytes(value));
                        }
                        value = Common.encodeTags(strTags, 30);
                        cardData.TLVData = new byte[value.length - 1];
                        try {
                            System.arraycopy(value, 1, cardData.TLVData, 0, value.length - 1);
                        }
                        catch (ArrayIndexOutOfBoundsException exception) {
                            return;
                        }
                        cardData.TLVLen = cardData.TLVData.length;
                        cardData.iccPresent = false;
                        cardData.captureEncryptType = ReaderInfo.CAPTURE_ENCRYPT_TYPE.CAPTURE_ENCRYPT_TYPE_AES;
                        cardData.result = 0;
                        return;
                    }
                    if (cardData.result == 17) {
                        byte[] tlvs = new byte[data.length - 6];
                        try {
                            System.arraycopy(data, 6, tlvs, 0, data.length - 6);
                        }
                        catch (ArrayIndexOutOfBoundsException exception) {
                            return;
                        }
                        Map<String, Map<String, byte[]>> TLVDict = Common.processTLV(tlvs);
                        Map<String, byte[]> unencryptedTags = TLVDict.get("tags");
                        cardData.encryptedTags = TLVDict.get("encrypted");
                        cardData.maskedTags = TLVDict.get("masked");
                        LinkedHashMap<String, byte[]> tags = new LinkedHashMap<String, byte[]>();
                        byte[] value = unencryptedTags.get("DF4A");
                        if (value != null && value.length > 0) {
                            tags.put("DF4A", value);
                        }
                        if ((value = unencryptedTags.get("DF4C")) != null && value.length > 0) {
                            tags.put("DF4C", value);
                        }
                        if ((value = unencryptedTags.get("DF4B")) != null) {
                            tags.put("DF4B", value);
                        }
                        if ((value = unencryptedTags.get("DF34")) == null || value.length < 3) {
                            if (IDT_Device.firmware_version_ttk != null && IDT_Device.firmware_version_ttk.length > 0) {
                                tags.put("DF34", IDT_Device.firmware_version_ttk);
                            }
                        } else {
                            tags.put("DF34", value);
                        }
                        cardData.unencryptedTags = tags;
                        LinkedHashMap<String, String> strTags = new LinkedHashMap<String, String>();
                        Set<String> keys = cardData.unencryptedTags.keySet();
                        for (String key : keys) {
                            value = cardData.unencryptedTags.get(key);
                            if (value == null || value.length == 0) {
                                strTags.put(key, "");
                                continue;
                            }
                            strTags.put(key, Common.getHexStringFromBytes(value));
                        }
                        value = Common.encodeTags(strTags, 30);
                        cardData.TLVData = new byte[value.length - 1];
                        try {
                            System.arraycopy(value, 1, cardData.TLVData, 0, value.length - 1);
                        }
                        catch (ArrayIndexOutOfBoundsException exception) {
                            return;
                        }
                        cardData.TLVLen = cardData.TLVData.length;
                        cardData.iccPresent = false;
                        cardData.captureEncryptType = ReaderInfo.CAPTURE_ENCRYPT_TYPE.CAPTURE_ENCRYPT_TYPE_AES;
                        cardData.result = 0;
                        return;
                    }
                }
                if (data[0] == 0) {
                    byte[] value;
                    if (data[5] != 0 || data[6] != 17) {
                        return;
                    }
                    byte[] tlvs = new byte[data.length - 1];
                    try {
                        System.arraycopy(data, 1, tlvs, 0, data.length - 1);
                    }
                    catch (ArrayIndexOutOfBoundsException exception) {
                        return;
                    }
                    Map<String, Map<String, byte[]>> TLVDict = Common.processTLV(tlvs);
                    cardData.unencryptedTags = TLVDict.get("tags");
                    byte[] temp = cardData.unencryptedTags.get("DFEE23");
                    if (temp == null) {
                        return;
                    }
                    cardData.encryptedTags = TLVDict.get("encrypted");
                    cardData.maskedTags = TLVDict.get("masked");
                    cardData.rawTrackData = new byte[temp.length];
                    try {
                        System.arraycopy(temp, 0, cardData.rawTrackData, 0, temp.length);
                    }
                    catch (ArrayIndexOutOfBoundsException exception) {
                        return;
                    }
                    Common.parseEMVFormat1(temp, cardData);
                    HashMap<String, String> tags = new HashMap<String, String>();
                    Set<String> keys = cardData.unencryptedTags.keySet();
                    for (String key : keys) {
                        if (key.equalsIgnoreCase("DFEE23")) continue;
                        value = cardData.unencryptedTags.get(key);
                        tags.put(key, Common.getHexStringFromBytes(value));
                    }
                    value = Common.encodeTags(tags, 30);
                    cardData.TLVData = new byte[value.length - 1];
                    try {
                        System.arraycopy(value, 1, cardData.TLVData, 0, value.length - 1);
                    }
                    catch (ArrayIndexOutOfBoundsException exception) {
                        return;
                    }
                    cardData.TLVLen = cardData.TLVData.length;
                } else if (data[0] == 1) {
                    byte[] tlvs = new byte[data.length - 1];
                    try {
                        System.arraycopy(data, 1, tlvs, 0, data.length - 1);
                    }
                    catch (ArrayIndexOutOfBoundsException exception) {
                        return;
                    }
                    Map<String, Map<String, byte[]>> TLVDict = Common.processTLV(tlvs);
                    cardData.unencryptedTags = TLVDict.get("tags");
                    cardData.encryptedTags = TLVDict.get("encrypted");
                    cardData.maskedTags = TLVDict.get("masked");
                } else if (data[0] == 2) {
                    Common.parseEMVFormat1(data, cardData);
                } else if (data[0] == 96) {
                    byte[] slice;
                    cardData.cardType = Common.getCardType(data[3]);
                    cardData.track1Length = data[5] & 0xFF;
                    cardData.track2Length = data[6] & 0xFF;
                    cardData.track3Length = data[7] & 0xFF;
                    byte cmDataStatus = data[8];
                    byte encryptDataStatus = data[9];
                    if ((cmDataStatus & 1) == 1) {
                        byte[] slice2 = Arrays.copyOfRange(data, 10, cardData.track1Length + 10);
                        cardData.track1 = Common.byteToString(slice2);
                        dataIndex = cardData.track1Length + 10;
                    }
                    int tmp = ++dataIndex;
                    if ((cmDataStatus & 2) == 2) {
                        byte[] temp = new byte[cardData.track2Length];
                        try {
                            System.arraycopy(data, dataIndex, temp, 0, cardData.track2Length);
                        }
                        catch (ArrayIndexOutOfBoundsException exception) {
                            return;
                        }
                        slice = Arrays.copyOfRange(data, tmp, cardData.track2Length + tmp);
                        cardData.track2 = Common.byteToString(slice);
                        dataIndex = cardData.track2Length + tmp;
                    }
                    tmp = dataIndex;
                    if ((cmDataStatus & 4) == 4) {
                        byte[] slice3 = Arrays.copyOfRange(data, tmp, cardData.track3Length + tmp);
                        cardData.track3 = Common.byteToString(slice3);
                        dataIndex = cardData.track3Length + tmp;
                    }
                    if ((cmDataStatus & 0x10) == 16) {
                        isTDES = false;
                        cardData.captureEncryptType = ReaderInfo.CAPTURE_ENCRYPT_TYPE.CAPTURE_ENCRYPT_TYPE_AES;
                    } else {
                        cardData.captureEncryptType = ReaderInfo.CAPTURE_ENCRYPT_TYPE.CAPTURE_ENCRYPT_TYPE_TDES;
                    }
                    if ((encryptDataStatus & 1) == 1) {
                        int encTrack1Len = Common.getEncryptedTrackDataLength(isTDES, cardData.track1Length);
                        cardData.encTrack1 = new byte[encTrack1Len];
                        try {
                            System.arraycopy(data, dataIndex, cardData.encTrack1, 0, encTrack1Len);
                        }
                        catch (ArrayIndexOutOfBoundsException exception) {
                            return;
                        }
                        dataIndex += encTrack1Len;
                    }
                    if ((encryptDataStatus & 2) == 2) {
                        int encTrack2Len = Common.getEncryptedTrackDataLength(isTDES, cardData.track2Length);
                        cardData.encTrack2 = new byte[encTrack2Len];
                        try {
                            System.arraycopy(data, dataIndex, cardData.encTrack2, 0, encTrack2Len);
                        }
                        catch (ArrayIndexOutOfBoundsException exception) {
                            return;
                        }
                        dataIndex += encTrack2Len;
                    }
                    if ((encryptDataStatus & 4) == 4) {
                        int encTrack3Len = Common.getEncryptedTrackDataLength(isTDES, cardData.track3Length);
                        cardData.encTrack3 = new byte[encTrack3Len];
                        try {
                            System.arraycopy(data, dataIndex, cardData.encTrack3, 0, encTrack3Len);
                        }
                        catch (ArrayIndexOutOfBoundsException exception) {
                            return;
                        }
                        dataIndex += encTrack3Len;
                    }
                    if ((encryptDataStatus & 0x40) == 64) {
                        dataIndex += 8;
                    }
                    if ((encryptDataStatus & 8) == 8) {
                        dataIndex += 20;
                    }
                    if ((encryptDataStatus & 0x10) == 16) {
                        dataIndex += 20;
                    }
                    if ((encryptDataStatus & 0x20) == 32) {
                        dataIndex += 20;
                    }
                    tmp = dataIndex;
                    cardData.serialNumber = new byte[0];
                    if ((cmDataStatus & 0x80) == 128) {
                        byte[] serial = new byte[10];
                        try {
                            System.arraycopy(data, dataIndex, serial, 0, 10);
                        }
                        catch (ArrayIndexOutOfBoundsException exception) {
                            return;
                        }
                        if (Arrays.equals(serial, new byte[10])) {
                            cardData.serialNumber = serial;
                            dataIndex += 10;
                        } else {
                            slice = Arrays.copyOfRange(data, tmp, 10 + tmp);
                            cardData.serialNumber = slice;
                            dataIndex = 10 + tmp;
                        }
                    }
                    if ((encryptDataStatus & 0x80) == 128) {
                        cardData.KSN = new byte[10];
                        try {
                            System.arraycopy(data, dataIndex, cardData.KSN, 0, 10);
                        }
                        catch (ArrayIndexOutOfBoundsException exception) {
                            return;
                        }
                        dataIndex += 10;
                    }
                } else {
                    return;
                }
            }
        }
    }

    public static void parseEMVFormat1(byte[] data, IDTMSRData cardData) {
        byte[] temp;
        byte[] slice;
        byte encryptDataStatus;
        byte cmDataStatus;
        int dataIndex = 10;
        boolean isTDES = true;
        int hashSize = 20;
        int optionalBytesLen = 0;
        if (deviceType == ReaderInfo.DEVICE_TYPE.DEVICE_AUGUSTA) {
            int tmp;
            cardData.cardType = Common.getCardType(data[3]);
            byte trackStatus = data[4];
            cardData.track1Length = data[5] & 0xFF;
            cardData.track2Length = data[6] & 0xFF;
            cardData.track3Length = data[7] & 0xFF;
            cmDataStatus = data[8];
            encryptDataStatus = data[9];
            int offset = 0;
            if ((trackStatus & 0x40) == 64) {
                optionalBytesLen = data[dataIndex] & 0xFF;
                cardData.optionalBytes = new byte[optionalBytesLen];
                ++dataIndex;
                try {
                    System.arraycopy(data, dataIndex, cardData.optionalBytes, 0, optionalBytesLen);
                }
                catch (ArrayIndexOutOfBoundsException exception) {
                    return;
                }
                dataIndex += optionalBytesLen;
                if ((cardData.optionalBytes[0] & 1) == 1) {
                    hashSize = 32;
                }
            }
            if ((cmDataStatus & 1) == 1) {
                slice = Arrays.copyOfRange(data, dataIndex + offset, cardData.track1Length + dataIndex + offset);
                cardData.track1 = Common.byteToString(slice);
                dataIndex = cardData.track1Length + dataIndex + offset;
                tmp = data[3] == -128 ? dataIndex : dataIndex + 1;
            } else {
                tmp = dataIndex + offset;
            }
            if ((cmDataStatus & 2) == 2) {
                temp = new byte[cardData.track2Length];
                try {
                    System.arraycopy(data, dataIndex, temp, 0, cardData.track2Length);
                }
                catch (ArrayIndexOutOfBoundsException exception) {
                    return;
                }
                cardData.track2 = Common.byteToString(temp);
                dataIndex = cardData.track2Length + tmp;
            }
            tmp = (cmDataStatus & 1) == 0 && (cmDataStatus & 2) == 0 ? 10 + offset : (data[3] == -128 ? dataIndex : dataIndex + 1);
            if ((cmDataStatus & 4) == 4) {
                slice = Arrays.copyOfRange(data, tmp, cardData.track3Length + tmp);
                cardData.track3 = Common.byteToString(slice);
                dataIndex = cardData.track3Length + tmp;
            }
        } else {
            cardData.cardType = Common.getCardType(data[3]);
            byte trackStatus = data[4];
            cardData.track1Length = data[5] & 0xFF;
            cardData.track2Length = data[6] & 0xFF;
            cardData.track3Length = data[7] & 0xFF;
            cmDataStatus = data[8];
            encryptDataStatus = data[9];
            if ((trackStatus & 0x40) == 64) {
                optionalBytesLen = data[dataIndex] & 0xFF;
                cardData.optionalBytes = new byte[optionalBytesLen];
                ++dataIndex;
                try {
                    System.arraycopy(data, dataIndex, cardData.optionalBytes, 0, optionalBytesLen);
                }
                catch (ArrayIndexOutOfBoundsException exception) {
                    return;
                }
                dataIndex += optionalBytesLen;
                if ((cardData.optionalBytes[0] & 1) == 1) {
                    hashSize = 32;
                }
            }
            if ((cmDataStatus & 1) == 1) {
                slice = Arrays.copyOfRange(data, dataIndex, cardData.track1Length + dataIndex);
                cardData.track1 = Common.byteToString(slice);
                dataIndex = cardData.track1Length + dataIndex;
            }
            int tmp = dataIndex;
            if ((cmDataStatus & 2) == 2) {
                temp = new byte[cardData.track2Length];
                try {
                    System.arraycopy(data, dataIndex, temp, 0, cardData.track2Length);
                }
                catch (ArrayIndexOutOfBoundsException exception) {
                    return;
                }
                cardData.track2 = Common.byteToString(temp);
                dataIndex = cardData.track2Length + tmp;
            }
            tmp = dataIndex;
            if ((cmDataStatus & 4) == 4) {
                slice = Arrays.copyOfRange(data, tmp, cardData.track3Length + tmp);
                cardData.track3 = Common.byteToString(slice);
                dataIndex = cardData.track3Length + tmp;
            }
        }
        if (optionalBytesLen > 0) {
            if ((cardData.optionalBytes[0] & 2) == 2) {
                int encryptType = cardData.optionalBytes[0] & 0x1C;
                if ((encryptType >>= 2) == 0) {
                    cardData.captureEncryptType = ReaderInfo.CAPTURE_ENCRYPT_TYPE.CAPTURE_ENCRYPT_TRANS_ARMOR;
                } else if (encryptType == 1) {
                    cardData.captureEncryptType = ReaderInfo.CAPTURE_ENCRYPT_TYPE.CAPTURE_ENCRYPT_TYPE_VOLTAGE;
                } else if (encryptType == 2) {
                    cardData.captureEncryptType = ReaderInfo.CAPTURE_ENCRYPT_TYPE.CAPTURE_ENCRYPT_TYPE_VISA_FPE;
                } else if (encryptType == 3) {
                    cardData.captureEncryptType = ReaderInfo.CAPTURE_ENCRYPT_TYPE.CAPTURE_ENCRYPT_TYPE_VERIFONE_FPE;
                }
            } else if ((cmDataStatus & 0x10) == 16) {
                isTDES = false;
                cardData.captureEncryptType = ReaderInfo.CAPTURE_ENCRYPT_TYPE.CAPTURE_ENCRYPT_TYPE_AES;
            } else {
                cardData.captureEncryptType = ReaderInfo.CAPTURE_ENCRYPT_TYPE.CAPTURE_ENCRYPT_TYPE_TDES;
            }
        } else if ((cmDataStatus & 0x10) == 16) {
            isTDES = false;
            cardData.captureEncryptType = ReaderInfo.CAPTURE_ENCRYPT_TYPE.CAPTURE_ENCRYPT_TYPE_AES;
        } else {
            cardData.captureEncryptType = ReaderInfo.CAPTURE_ENCRYPT_TYPE.CAPTURE_ENCRYPT_TYPE_TDES;
        }
        boolean bl = cardData.iccPresent = (cmDataStatus & 0x20) == 32;
        if ((encryptDataStatus & 1) == 1) {
            int encTrack1Len = 0;
            if (optionalBytesLen > 0 && (cardData.optionalBytes[0] & 0x40) == 64) {
                encTrack1Len = Common.getEncryptedTrackDataLength(isTDES, cardData.track1Length + 2);
            }
            if ((encTrack1Len = cardData.captureEncryptType == ReaderInfo.CAPTURE_ENCRYPT_TYPE.CAPTURE_ENCRYPT_TRANS_ARMOR ? 344 : Common.getEncryptedTrackDataLength(isTDES, cardData.track1Length)) > 0) {
                cardData.encTrack1 = new byte[encTrack1Len];
                try {
                    System.arraycopy(data, dataIndex, cardData.encTrack1, 0, encTrack1Len);
                }
                catch (ArrayIndexOutOfBoundsException exception) {
                    return;
                }
                dataIndex += encTrack1Len;
            }
        }
        if ((encryptDataStatus & 2) == 2) {
            int encTrack2Len = 0;
            if (optionalBytesLen > 0 && (cardData.optionalBytes[0] & 0x40) == 64) {
                encTrack2Len = Common.getEncryptedTrackDataLength(isTDES, cardData.track2Length + 2);
            }
            if ((encTrack2Len = cardData.captureEncryptType == ReaderInfo.CAPTURE_ENCRYPT_TYPE.CAPTURE_ENCRYPT_TRANS_ARMOR ? 344 : Common.getEncryptedTrackDataLength(isTDES, cardData.track2Length)) > 0) {
                cardData.encTrack2 = new byte[encTrack2Len];
                try {
                    System.arraycopy(data, dataIndex, cardData.encTrack2, 0, encTrack2Len);
                }
                catch (ArrayIndexOutOfBoundsException exception) {
                    return;
                }
                dataIndex += encTrack2Len;
            }
        }
        if ((encryptDataStatus & 4) == 4) {
            int encTrack3Len = 0;
            if (optionalBytesLen > 0 && (cardData.optionalBytes[0] & 0x40) == 64) {
                encTrack3Len = Common.getEncryptedTrackDataLength(isTDES, cardData.track3Length + 2);
            }
            if ((encTrack3Len = cardData.captureEncryptType == ReaderInfo.CAPTURE_ENCRYPT_TYPE.CAPTURE_ENCRYPT_TRANS_ARMOR ? 344 : Common.getEncryptedTrackDataLength(isTDES, cardData.track3Length)) > 0) {
                cardData.encTrack3 = new byte[encTrack3Len];
                try {
                    System.arraycopy(data, dataIndex, cardData.encTrack3, 0, encTrack3Len);
                }
                catch (ArrayIndexOutOfBoundsException exception) {
                    return;
                }
                dataIndex += encTrack3Len;
            }
        }
        if (cardData.captureEncryptType == ReaderInfo.CAPTURE_ENCRYPT_TYPE.CAPTURE_ENCRYPT_TRANS_ARMOR || (encryptDataStatus & 0x40) == 64) {
            dataIndex += 8;
        }
        if ((encryptDataStatus & 8) == 8) {
            dataIndex += hashSize;
        }
        if ((encryptDataStatus & 0x10) == 16) {
            dataIndex += hashSize;
        }
        if ((encryptDataStatus & 0x20) == 32) {
            dataIndex += hashSize;
        }
        if ((cmDataStatus & 0x80) == 128) {
            cardData.serialNumber = new byte[10];
            try {
                System.arraycopy(data, dataIndex, cardData.serialNumber, 0, 10);
            }
            catch (ArrayIndexOutOfBoundsException exception) {
                return;
            }
            dataIndex += 10;
        }
        if ((encryptDataStatus & 0x80) == 128) {
            int KSNLen = 10;
            if (cardData.captureEncryptType == ReaderInfo.CAPTURE_ENCRYPT_TYPE.CAPTURE_ENCRYPT_TRANS_ARMOR) {
                KSNLen = 11;
            } else if (optionalBytesLen > 0 && (cardData.optionalBytes[0] & 0x40) == 64) {
                KSNLen = 8;
            }
            cardData.KSN = new byte[KSNLen];
            try {
                System.arraycopy(data, dataIndex, cardData.KSN, 0, KSNLen);
            }
            catch (ArrayIndexOutOfBoundsException exception) {
                return;
            }
            dataIndex += KSNLen;
        }
    }

    public static void parseUnencryptedData(byte[] resData, IDTMSRData cardData) {
        int dataIndex = 0;
        cardData.track1Length = resData[0] & 0xFF;
        if (cardData.track1Length > 0) {
            cardData.encTrack1 = new byte[cardData.track1Length];
            System.arraycopy(resData, dataIndex, cardData.encTrack1, 0, cardData.track1Length);
            cardData.track1 = Common.byteToString(cardData.encTrack1);
            dataIndex += cardData.track1Length;
        }
        cardData.track2Length = resData[dataIndex] & 0xFF;
        if (cardData.track2Length == 255) {
            cardData.track2Length = 0;
        }
        ++dataIndex;
        if (cardData.track2Length > 0) {
            cardData.encTrack2 = new byte[cardData.track2Length];
            System.arraycopy(resData, dataIndex, cardData.encTrack2, 0, cardData.track2Length);
            cardData.track2 = Common.byteToString(cardData.encTrack2);
            dataIndex += cardData.track2Length;
        }
        cardData.track3Length = 0;
        cardData.track3 = "";
        cardData.hasDE055 = resData[dataIndex];
        ++dataIndex;
        if (cardData.hasDE055 == 1) {
            cardData.DE055Len = resData[++dataIndex] & 0xFF;
            System.arraycopy(resData, ++dataIndex, cardData.DE055Data, 0, cardData.DE055Len);
            dataIndex += cardData.DE055Len;
        }
        cardData.TLVLen = resData.length - dataIndex;
        cardData.TLVData = new byte[cardData.TLVLen];
        System.arraycopy(resData, dataIndex, cardData.TLVData, 0, cardData.TLVLen);
    }

    public static void parseEncryptedData(byte[] resData, IDTMSRData cardData) {
        int dataIndex = 0;
        byte attribution = resData[dataIndex];
        if (resData[++dataIndex] == -1 && resData[dataIndex + 1] == -18 && resData[dataIndex + 2] == 18) {
            cardData.KSN = new byte[resData[dataIndex += 3] & 0xFF];
            System.arraycopy(resData, ++dataIndex, cardData.KSN, 0, 10);
            dataIndex += 10;
        }
        if (resData[dataIndex] == -1 && resData[dataIndex + 1] == -18 && resData[dataIndex + 2] == 19) {
            cardData.track1Length = resData[dataIndex += 3] & 0xFF;
            cardData.encTrack1 = new byte[cardData.track1Length];
            System.arraycopy(resData, ++dataIndex, cardData.encTrack1, 0, cardData.track1Length);
            cardData.track1 = Common.byteToString(cardData.encTrack1);
            dataIndex += cardData.track1Length;
        }
        if (resData[dataIndex] == -1 && resData[dataIndex + 1] == -18 && resData[dataIndex + 2] == 20) {
            cardData.track2Length = resData[dataIndex += 3] & 0xFF;
            cardData.encTrack2 = new byte[cardData.track2Length];
            System.arraycopy(resData, ++dataIndex, cardData.encTrack2, 0, cardData.track2Length);
            cardData.track2 = Common.byteToString(cardData.encTrack2);
            dataIndex += cardData.track2Length;
        }
        cardData.track3Length = 0;
        cardData.track3 = "";
        cardData.hasDE055 = resData[dataIndex];
        ++dataIndex;
        if (cardData.hasDE055 == 1) {
            cardData.DE055Len = resData[++dataIndex] & 0xFF;
            System.arraycopy(resData, ++dataIndex, cardData.DE055Data, 0, cardData.DE055Len);
            dataIndex += cardData.DE055Len;
        }
        cardData.TLVLen = resData.length - dataIndex;
        cardData.TLVData = new byte[cardData.TLVLen];
        System.arraycopy(resData, dataIndex, cardData.TLVData, 0, cardData.TLVLen);
    }

    public static int getEncryptedTrackDataLength(boolean isTDES, int unencryptLen) {
        if (isTDES) {
            if (unencryptLen % 8 == 0) {
                return unencryptLen;
            }
            return (unencryptLen / 8 + 1) * 8;
        }
        if (unencryptLen % 16 == 0) {
            return unencryptLen;
        }
        return (unencryptLen / 16 + 1) * 16;
    }

    public static void getTLVData(byte[] resData, IDTMSRData cardData) {
        int len = resData.length;
        cardData.cardData = new byte[resData.length];
        System.arraycopy(resData, 0, cardData.cardData, 0, resData.length);
        cardData.event = ReaderInfo.EVENT_MSR_Types.EVENT_MSR_CARD_DATA;
        if (len > 16) {
            int dataLen = (resData[12] & 0xFF) << 8;
            cardData.TLVLen = dataLen |= resData[13] & 0xFF;
            cardData.TLVData = new byte[cardData.TLVLen];
            System.arraycopy(resData, 14, cardData.TLVData, 0, cardData.TLVLen);
        }
    }

    public static byte[][] processTLVGroups(byte[] param) {
        String strParam = Common.getHexStringFromBytes(param);
        String[] strArray = strParam.split("FFE401");
        byte[][] temp = new byte[strArray.length - 1][];
        int i = 1;
        while (i < strArray.length) {
            byte[] data = Common.hexStringToByteArray(strArray[i]);
            temp[i - 1] = new byte[data.length];
            System.arraycopy(data, 0, temp[i - 1], 0, data.length);
            ++i;
        }
        int count = 0;
        byte[] bitmap = new byte[temp.length];
        int i2 = 0;
        while (i2 < temp.length) {
            if (temp[i2][0] == (byte)count) {
                ++count;
                bitmap[i2] = 0;
            } else {
                bitmap[i2] = 1;
            }
            ++i2;
        }
        int idx = 0;
        int i3 = 0;
        while (i3 < temp.length) {
            if (bitmap[i3] == 0) {
                idx = i3;
            } else {
                byte[] data = new byte[temp[idx].length + temp[i3].length + 3];
                System.arraycopy(temp[idx], 0, data, 0, temp[idx].length);
                data[temp[idx].length] = -1;
                data[temp[idx].length + 1] = -28;
                data[temp[idx].length + 2] = 1;
                System.arraycopy(temp[i3], 0, data, temp[idx].length + 3, temp[i3].length);
                temp[idx] = new byte[data.length];
                System.arraycopy(data, 0, temp[idx], 0, data.length);
            }
            ++i3;
        }
        byte[][] ret = new byte[count][];
        idx = 0;
        int i4 = 0;
        while (i4 < temp.length) {
            if (bitmap[i4] == 0) {
                ret[idx] = new byte[temp[i4].length - 1];
                System.arraycopy(temp[i4], 1, ret[idx], 0, temp[i4].length - 1);
                ++idx;
            }
            ++i4;
        }
        return ret;
    }

    public static String tagToString(String tag, byte[] val) {
        StringBuilder sb = new StringBuilder();
        if (tag != null && tag.length() > 0 && val != null) {
            sb.append(tag);
            if (val.length == 0) {
                sb.append("00");
            } else if (val.length < 128) {
                byte[] len = new byte[]{(byte)val.length};
                sb.append(Common.bytesToHex(len));
                sb.append(Common.bytesToHex(val));
            } else if (val.length < 256) {
                byte[] len = new byte[]{-127, (byte)val.length};
                sb.append(Common.bytesToHex(len));
                sb.append(Common.bytesToHex(val));
            } else {
                byte[] len = new byte[]{-126, (byte)(val.length >> 8 & 0xFF), (byte)(val.length & 0xFF)};
                sb.append(Common.bytesToHex(len));
                sb.append(Common.bytesToHex(val));
            }
        }
        return sb.toString();
    }

    public static Map<String, Map<String, byte[]>> processTLV(byte[] param) {
        if (param == null) {
            return null;
        }
        HashMap<String, byte[]> tags = new HashMap<String, byte[]>();
        HashMap<String, byte[]> maskedTags = new HashMap<String, byte[]>();
        HashMap<String, byte[]> encryptedTags = new HashMap<String, byte[]>();
        ArrayList<byte[]> C2Array = new ArrayList<byte[]>();
        HashMap<String, Map<String, byte[]>> retDictionary = new HashMap<String, Map<String, byte[]>>();
        byte[] bytes = param;
        int vlen = param.length;
        int position = 0;
        ArrayList<Byte> currentTag = new ArrayList<Byte>();
        ArrayList<Byte> combined = new ArrayList<Byte>();
        while (position < vlen) {
            boolean isEncrypted;
            int tagLength = 0;
            if ((bytes[position] & 0x1F) == 31) {
                currentTag.add(bytes[position++]);
                do {
                    currentTag.add(bytes[position++]);
                } while ((bytes[position - 2] != -1 || !Common.isAIDTag(bytes[position - 1])) && position < vlen && (bytes[position - 1] & 0x80) == 128);
            } else {
                if (bytes[position] == 0) {
                    while (bytes[position] == 0 && position < vlen) {
                        if (++position >= vlen) break;
                    }
                    if (position < vlen) continue;
                    break;
                }
                if (position >= vlen) break;
                currentTag.add(bytes[position++]);
            }
            if (position >= vlen) break;
            byte lenByte = bytes[position];
            boolean isMasked = (lenByte & 0xA0) == 160;
            boolean bl = isEncrypted = (lenByte & 0xC0) == 192;
            if ((bytes[position] & 0x80) != 128) {
                tagLength = bytes[position++];
            } else {
                switch (bytes[position] & 3) {
                    case 3: {
                        if (position + 3 < bytes.length) {
                            tagLength = (bytes[position + 1] & 0xFF) * 65536 + (bytes[position + 2] & 0xFF) * 256 + (bytes[position + 3] & 0xFF);
                        }
                        position += 4;
                        break;
                    }
                    case 2: {
                        if (position + 2 < bytes.length) {
                            tagLength = (bytes[position + 1] & 0xFF) * 256 + (bytes[position + 2] & 0xFF);
                        }
                        position += 3;
                        break;
                    }
                    case 1: {
                        if (position + 1 < bytes.length) {
                            tagLength = bytes[position + 1] & 0xFF;
                        }
                        position += 2;
                        break;
                    }
                    default: {
                        tagLength = bytes[position] & 0xFF;
                        ++position;
                    }
                }
            }
            if (position + tagLength > vlen) break;
            byte[] curTag = new byte[currentTag.size()];
            int i = 0;
            while (i < currentTag.size()) {
                curTag[i] = (Byte)currentTag.get(i);
                ++i;
            }
            String currentTagHex = Common.getHexStringFromBytes(curTag).toUpperCase(Locale.US);
            if (!currentTagHex.startsWith("E")) {
                int y = 0;
                while (y < tagLength) {
                    combined.add(bytes[position]);
                    ++position;
                    ++y;
                }
                byte[] com = new byte[combined.size()];
                int i2 = 0;
                while (i2 < combined.size()) {
                    com[i2] = (Byte)combined.get(i2);
                    ++i2;
                }
                if (currentTagHex.length() > 0) {
                    if (currentTagHex.equals("C2")) {
                        C2Array.add(com);
                    } else if (!currentTagHex.equals("00") && com.length > 0) {
                        if (isMasked) {
                            maskedTags.put(currentTagHex, com);
                        } else if (isEncrypted) {
                            encryptedTags.put(currentTagHex, com);
                        } else {
                            tags.put(currentTagHex, com);
                        }
                    }
                }
            }
            currentTag.clear();
            combined.clear();
        }
        retDictionary.put("tags", tags);
        retDictionary.put("masked", maskedTags);
        retDictionary.put("encrypted", encryptedTags);
        return retDictionary;
    }

    public static boolean processCTLSData(byte[] retData, IDTMSRData cardData) {
        if (retData == null || retData.length < 6) {
            return false;
        }
        cardData.cardData = new byte[retData.length];
        System.arraycopy(retData, 0, cardData.cardData, 0, retData.length);
        if (retData[0] == 1 && retData[1] == 0 && retData[4] == -1 && retData[5] == -18 && retData[6] == 18) {
            cardData.ctlsApplication = Common.getApplicationType(retData[2]);
            cardData.isCTLS = (retData[3] & 1) == 1;
            cardData.captureEncryptType = ReaderInfo.CAPTURE_ENCRYPT_TYPE.CAPTURE_ENCRYPT_TYPE_TDES;
            if ((retData[3] & 2) == 2) {
                cardData.captureEncryptType = ReaderInfo.CAPTURE_ENCRYPT_TYPE.CAPTURE_ENCRYPT_TYPE_AES;
            }
            byte[] theBytes = new byte[retData.length - 6];
            System.arraycopy(retData, 4, theBytes, 0, theBytes.length);
            Map<String, Map<String, byte[]>> TLVDict = Common.processTLV(theBytes);
            cardData.unencryptedTags = TLVDict.get("tags");
            cardData.encryptedTags = TLVDict.get("encrypted");
            cardData.maskedTags = TLVDict.get("masked");
            byte[] ffee = cardData.encryptedTags.get("FFEE13");
            if (ffee != null && ffee.length > 0) {
                cardData.encTrack1 = new byte[ffee.length];
                System.arraycopy(ffee, 0, cardData.encTrack1, 0, ffee.length);
            }
            if ((ffee = cardData.encryptedTags.get("FFEE14")) != null && ffee.length > 0) {
                cardData.encTrack2 = new byte[ffee.length];
                System.arraycopy(ffee, 0, cardData.encTrack2, 0, ffee.length);
            }
            cardData.event = ReaderInfo.EVENT_MSR_Types.EVENT_MSR_CARD_DATA;
            return true;
        }
        if (retData[0] == 1 && retData[1] == 0 && retData[3] > 31) {
            cardData.ctlsApplication = Common.getApplicationType(retData[2]);
            cardData.isCTLS = cardData.ctlsApplication != ReaderInfo.CTLS_APPLICATION.CTLS_APPLICATION_MSR_SWIPE;
            byte[] strBytes = new byte[retData.length - 5];
            System.arraycopy(retData, 3, strBytes, 0, strBytes.length);
            String cardDataStr = Common.getAsciiFromByte(strBytes);
            String[] arr = cardDataStr.split(";");
            if (arr.length > 0) {
                cardData.track1 = arr[0];
                cardData.track1Length = cardData.track1.length();
            }
            if (arr.length > 1) {
                String[] t2s;
                cardData.track2 = ";" + arr[1];
                cardData.track2Length = cardData.track2.length();
                if (cardData.track2Length > 0 && (t2s = cardData.track2.split("=")).length > 1) {
                    String tsr = t2s[1];
                    char cs = '\u0000';
                    if (tsr.length() > 4) {
                        cs = tsr.charAt(4);
                    }
                    boolean bl = cardData.iccPresent = cs == '2' || cs == '6';
                }
            }
            if (arr.length > 2) {
                cardData.track3 = ";" + arr[2];
                cardData.track3Length = cardData.track3.length();
            }
            cardData.event = ReaderInfo.EVENT_MSR_Types.EVENT_MSR_CARD_DATA;
            return true;
        }
        if (retData[0] == 3 && retData[1] == 0 && retData[5] > 31) {
            String[] t2s;
            byte[] strBytes;
            cardData.ctlsApplication = Common.getApplicationType(retData[2]);
            cardData.isCTLS = cardData.ctlsApplication != ReaderInfo.CTLS_APPLICATION.CTLS_APPLICATION_MSR_SWIPE;
            int idx = 5;
            cardData.track1Length = retData[idx++];
            if (cardData.track1Length > 0) {
                strBytes = new byte[cardData.track1Length];
                System.arraycopy(retData, idx, strBytes, 0, strBytes.length);
                cardData.track1 = Common.getAsciiFromByte(strBytes);
                idx += cardData.track1Length;
            }
            cardData.track2Length = retData[idx++];
            if (cardData.track2Length > 0) {
                strBytes = new byte[cardData.track2Length];
                System.arraycopy(retData, idx, strBytes, 0, strBytes.length);
                cardData.track2 = Common.getAsciiFromByte(strBytes);
                idx += cardData.track2Length;
            }
            if (cardData.track2Length > 0 && (t2s = cardData.track2.split("=")).length > 1) {
                String tsr = t2s[1];
                char cs = tsr.charAt(4);
                cardData.iccPresent = cs == '2' || cs == '6';
            }
            cardData.hasDE055 = retData[idx++];
            if (cardData.hasDE055 == 1) {
                int n = ++idx;
                ++idx;
                cardData.DE055Len = retData[n];
                if (cardData.DE055Len > 0) {
                    cardData.DE055Data = new byte[cardData.DE055Len];
                    System.arraycopy(retData, idx, cardData.DE055Data, 0, cardData.DE055Len);
                }
                idx += cardData.DE055Len;
            }
            cardData.TLVLen = retData.length - (idx + 2);
            if (cardData.TLVLen > 0) {
                cardData.TLVData = new byte[cardData.TLVLen];
                System.arraycopy(retData, idx, cardData.TLVData, 0, cardData.TLVLen);
            }
            return true;
        }
        return false;
    }

    public static boolean processData_Vendi(byte[] resData, IDTMSRData cData) {
        if (resData[15] == -1 && resData[16] == -18 && (resData[17] == 18 || resData[17] == 31)) {
            cData.isCTLS = (resData[14] & 1) == 1;
            cData.captureEncryptType = ReaderInfo.CAPTURE_ENCRYPT_TYPE.CAPTURE_ENCRYPT_TYPE_TDES;
            if ((resData[14] & 2) == 2) {
                cData.captureEncryptType = ReaderInfo.CAPTURE_ENCRYPT_TYPE.CAPTURE_ENCRYPT_TYPE_AES;
            }
            byte[] theBytes = new byte[resData.length - 16];
            System.arraycopy(resData, 15, theBytes, 0, theBytes.length);
            Map<String, Map<String, byte[]>> TLVDict = Common.processTLV(theBytes);
            cData.unencryptedTags = TLVDict.get("tags");
            cData.encryptedTags = TLVDict.get("encrypted");
            cData.maskedTags = TLVDict.get("masked");
        } else {
            byte clearingRecord;
            byte[] strBytes;
            cData.track1Length = resData[14];
            int index = 15;
            int dataLen = (resData[12] & 0xFF) << 8 | resData[13] & 0xFF;
            if (cData.track1Length > 0) {
                strBytes = new byte[cData.track1Length];
                System.arraycopy(resData, index, strBytes, 0, strBytes.length);
                cData.track1 = Common.byteToString(strBytes);
                index += cData.track1Length;
            }
            if (index < dataLen + 14) {
                cData.track2Length = resData[index++];
                if (cData.track2Length > 0) {
                    String tsr;
                    char cs;
                    strBytes = new byte[cData.track2Length];
                    System.arraycopy(resData, index, strBytes, 0, strBytes.length);
                    cData.track2 = Common.byteToString(strBytes);
                    String[] t2s = cData.track2.split("=");
                    if (t2s.length > 1 && ((cs = (tsr = t2s[1]).charAt(4)) == '2' || cs == '6')) {
                        cData.iccPresent = true;
                    }
                    index += cData.track2Length;
                }
            }
            if (index < dataLen + 14 && (clearingRecord = resData[index++]) == 1) {
                int n = ++index;
                ++index;
                int e1Len = resData[n];
                if (e1Len == 129) {
                    e1Len = resData[index++];
                }
                if (e1Len == 130) {
                    e1Len = (resData[index] & 0xFF) << 8 | resData[index + 1] & 0xFF;
                    index += 2;
                }
                byte[] theBytes = new byte[e1Len];
                System.arraycopy(resData, index, theBytes, 0, e1Len);
                Map<String, Map<String, byte[]>> TLVDict = Common.processTLV(theBytes);
                cData.unencryptedTags = TLVDict.get("tags");
                cData.encryptedTags = TLVDict.get("encrypted");
                cData.maskedTags = TLVDict.get("masked");
                index += e1Len;
            }
            if (index < dataLen + 14) {
                byte[] data1;
                Map<String, Map<String, byte[]>> temp;
                Map<String, byte[]> tags2;
                byte[] data;
                byte[] theBytes = new byte[resData.length - 2 - index];
                System.arraycopy(resData, index, theBytes, 0, resData.length - 2 - index);
                Map<String, Map<String, byte[]>> TLVDict = Common.processTLV(theBytes);
                cData.unencryptedTags = TLVDict.get("tags");
                cData.encryptedTags = TLVDict.get("encrypted");
                cData.maskedTags = TLVDict.get("masked");
                Map<String, byte[]> tags = TLVDict.get("tags");
                if (tags != null && (data = tags.get("FFEE01")) != null && (tags2 = (temp = Common.processTLV(data)).get("tags")) != null && (data1 = tags2.get("DF30")) != null) {
                    cData.isCTLS = data1[0] == 0;
                }
            }
        }
        return true;
    }

    public static int byteToUnsignedInt(byte b) {
        return b & 0xFF;
    }

    public static boolean isAIDTag(byte tag) {
        if (isGen2) {
            return false;
        }
        return tag == -32 || tag == -31 || tag == -30 || tag == -29 || tag == -28 || tag == -27 || tag == -26 || tag == -25 || tag == -24 || tag == -23 || tag == -22 || tag == -16 || tag == -15 || tag == -14 || tag == -13 || tag == -12 || tag == -11 || tag == -10 || tag == -9 || tag == -8 || tag == -7 || tag == -6 || tag == -5 || tag == -4 || tag == -3 || tag == -2 || tag == -1;
    }

    public static String getTagString(Map<String, byte[]> tagMap) {
        String tagsString = "";
        Set<String> keys = tagMap.keySet();
        for (String key : keys) {
            byte[] tagData = tagMap.get(key);
            byte[] len = new byte[]{(byte)tagData.length};
            tagsString = String.valueOf(tagsString) + key;
            tagsString = String.valueOf(tagsString) + Common.getHexStringFromBytes(len);
            tagsString = String.valueOf(tagsString) + Common.getHexStringFromBytes(tagData);
        }
        return tagsString;
    }

    public static void convertMapByteToMapString(Map<String, byte[]> srcMap, Map<String, String> dstMap) {
        Set<String> keys = srcMap.keySet();
        for (String key : keys) {
            byte[] tagData = srcMap.get(key);
            dstMap.put(key, Common.getHexStringFromBytes(tagData));
        }
    }

    public static String parse_MSRSetting(IDT_Device device, IDTMSRData cardData, int ret) {
        String info = "";
        if (ret == 0) {
            byte[] data;
            Set<String> keys;
            info = String.valueOf(info) + "\r\nTLV Data:\r\n";
            int i = 0;
            while (i < cardData.TLVLen) {
                info = String.valueOf(info) + String.format(Locale.US, "%02x ", cardData.TLVData[i]);
                ++i;
            }
            info = String.valueOf(info) + "\r\nTLV Parsed:\r\n";
            Map<String, Map<String, byte[]>> TLVDict = Common.processTLV(cardData.TLVData);
            Map<String, byte[]> tags = TLVDict.get("tags");
            Map<String, byte[]> maskedTags = TLVDict.get("masked");
            Map<String, byte[]> encryptedTags = TLVDict.get("encrypted");
            if (!tags.isEmpty()) {
                info = String.valueOf(info) + "tags:\r\n";
                keys = tags.keySet();
                for (String key : keys) {
                    info = String.valueOf(info) + key + ": ";
                    data = tags.get(key);
                    info = String.valueOf(info) + Common.getHexStringFromBytes(data) + "\r\n";
                }
            }
            if (!maskedTags.isEmpty()) {
                info = String.valueOf(info) + "maskedTags:\r\n";
                keys = maskedTags.keySet();
                for (String key : keys) {
                    info = String.valueOf(info) + key + ": ";
                    data = maskedTags.get(key);
                    info = String.valueOf(info) + Common.getHexStringFromBytes(data) + "\r\n";
                }
            }
            if (!encryptedTags.isEmpty()) {
                info = String.valueOf(info) + "encrypted:\r\n";
                keys = encryptedTags.keySet();
                for (String key : keys) {
                    info = String.valueOf(info) + key + ": ";
                    data = encryptedTags.get(key);
                    info = String.valueOf(info) + Common.getHexStringFromBytes(data) + "\r\n";
                }
            }
        } else {
            info = String.valueOf(info) + "[Status: " + device.device_getResponseCodeString(ret) + "]";
        }
        return info;
    }

    public static String parse_MSRData(ReaderInfo.DEVICE_TYPE deviceType, IDTMSRData card) {
        if (card.cardData == null || card.cardData.length == 0) {
            return "";
        }
        String str = new String();
        int len = card.cardData.length;
        int i = 0;
        if (IDT_Device._isTTK) {
            str = "";
        } else {
            str = "CardData:\r\n";
            i = 0;
            while (i < len) {
                str = String.valueOf(str) + String.format(Locale.US, "%02x ", card.cardData[i]);
                ++i;
            }
            str = String.valueOf(str) + String.format(Locale.US, "\r\n\r\n", new Object[0]);
        }
        str = card.iccPresent ? String.valueOf(str) + String.format(Locale.US, "ICC Present: TRUE\r\n", new Object[0]) : String.valueOf(str) + String.format(Locale.US, "ICC Present: FALSE\r\n", new Object[0]);
        str = card.isCTLS ? String.valueOf(str) + String.format(Locale.US, "CTLS Capture: TRUE\r\n", new Object[0]) : String.valueOf(str) + String.format(Locale.US, "CTLS Capture: FALSE\r\n", new Object[0]);
        if (card.captureEncryptType == ReaderInfo.CAPTURE_ENCRYPT_TYPE.CAPTURE_ENCRYPT_TYPE_TDES) {
            str = String.valueOf(str) + String.format(Locale.US, "Encryption Type: TDES", new Object[0]);
        } else if (card.captureEncryptType == ReaderInfo.CAPTURE_ENCRYPT_TYPE.CAPTURE_ENCRYPT_TYPE_AES) {
            str = String.valueOf(str) + String.format(Locale.US, "Encryption Type: AES", new Object[0]);
        } else if (card.captureEncryptType == ReaderInfo.CAPTURE_ENCRYPT_TYPE.CAPTURE_ENCRYPT_TRANS_ARMOR) {
            str = String.valueOf(str) + String.format(Locale.US, "Encryption Type: TRANS ARMOR", new Object[0]);
        } else if (card.captureEncryptType == ReaderInfo.CAPTURE_ENCRYPT_TYPE.CAPTURE_ENCRYPT_TYPE_VERIFONE_FPE) {
            str = String.valueOf(str) + String.format(Locale.US, "Encryption Type: VERIFONE FPE", new Object[0]);
        } else if (card.captureEncryptType == ReaderInfo.CAPTURE_ENCRYPT_TYPE.CAPTURE_ENCRYPT_TYPE_VISA_FPE) {
            str = String.valueOf(str) + String.format(Locale.US, "Encryption Type: VISA FPE", new Object[0]);
        } else if (card.captureEncryptType == ReaderInfo.CAPTURE_ENCRYPT_TYPE.CAPTURE_ENCRYPT_TYPE_VOLTAGE) {
            str = String.valueOf(str) + String.format(Locale.US, "Encryption Type: VOLTAGE", new Object[0]);
        }
        if (!IDT_Device._isTTK) {
            if (card.track1 != "") {
                str = String.valueOf(str) + "\r\n\r\nTrack1 data:\r\n";
                str = String.valueOf(str) + card.track1;
            }
            if (card.track2 != "") {
                str = String.valueOf(str) + "\r\n\r\nTrack2 data:\r\n";
                str = String.valueOf(str) + card.track2;
            }
            if (card.track3 != "") {
                str = String.valueOf(str) + "\r\n\r\nTrack3 data:\r\n";
                str = String.valueOf(str) + card.track3;
            }
        }
        len = 0;
        if (card.encTrack1 != null) {
            len = card.encTrack1.length;
        }
        if (len > 0) {
            str = String.valueOf(str) + "\r\n\r\nTrack1 encrypted data:\r\n";
            i = 0;
            while (i < len) {
                str = String.valueOf(str) + String.format(Locale.US, "%02X ", card.encTrack1[i]);
                ++i;
            }
        }
        len = 0;
        if (card.encTrack2 != null) {
            len = card.encTrack2.length;
        }
        if (len > 0) {
            str = String.valueOf(str) + "\r\n\r\nTrack2 encrypted data:\r\n";
            i = 0;
            while (i < len) {
                str = String.valueOf(str) + String.format(Locale.US, "%02X ", card.encTrack2[i]);
                ++i;
            }
        }
        len = 0;
        if (card.encTrack3 != null) {
            len = card.encTrack3.length;
        }
        if (len > 0) {
            str = String.valueOf(str) + "\r\n\r\nTrack3 encrypted data:\r\n";
            i = 0;
            while (i < len) {
                str = String.valueOf(str) + String.format(Locale.US, "%02X ", card.encTrack3[i]);
                ++i;
            }
        }
        if (card.serialNumber != null) {
            str = String.valueOf(str) + "\r\n\r\nReader Serial Number: ";
            str = String.valueOf(str) + Common.bytesToHex(card.serialNumber);
        }
        len = 0;
        if (card.KSN != null) {
            len = card.KSN.length;
        }
        if (len > 0) {
            str = card.captureEncryptType == ReaderInfo.CAPTURE_ENCRYPT_TYPE.CAPTURE_ENCRYPT_TRANS_ARMOR ? String.valueOf(str) + "\r\n\r\nKID: " : String.valueOf(str) + "\r\n\r\nKSN: ";
            i = 0;
            while (i < len) {
                str = String.valueOf(str) + String.format(Locale.US, "%02x ", card.KSN[i]);
                ++i;
            }
        }
        len = 0;
        if (card.DE055Data != null) {
            len = card.DE055Data.length;
        }
        if (len > 0) {
            str = String.valueOf(str) + "\r\n\r\nDE055:";
            i = 0;
            while (i < len) {
                str = String.valueOf(str) + String.format(Locale.US, "%02x ", card.DE055Data[i]);
                ++i;
            }
        }
        len = 0;
        if (card.TLVData != null) {
            len = card.TLVData.length;
        }
        if (len > 0) {
            str = String.valueOf(str) + "\r\n\r\nTLV Data:\r\n";
            i = 0;
            while (i < len) {
                str = String.valueOf(str) + String.format(Locale.US, "%02x ", card.TLVData[i]);
                ++i;
            }
            if (!IDT_Device._isTTK) {
                byte[] data;
                Set<String> keys;
                str = String.valueOf(str) + "\r\n\r\nTLV Parsed:\r\n";
                Map<String, Map<String, byte[]>> TLVDict = Common.processTLV(card.TLVData);
                Map<String, byte[]> tags = TLVDict.get("tags");
                Map<String, byte[]> maskedTags = TLVDict.get("masked");
                Map<String, byte[]> encryptedTags = TLVDict.get("encrypted");
                if (!tags.isEmpty()) {
                    str = String.valueOf(str) + "tags:\r\n";
                    keys = tags.keySet();
                    for (String key : keys) {
                        str = String.valueOf(str) + key + ": ";
                        data = tags.get(key);
                        str = String.valueOf(str) + Common.getHexStringFromBytes(data) + "\r\n";
                    }
                }
                if (!maskedTags.isEmpty()) {
                    str = String.valueOf(str) + "maskedTags:\r\n";
                    keys = maskedTags.keySet();
                    for (String key : keys) {
                        str = String.valueOf(str) + key + ": ";
                        data = maskedTags.get(key);
                        str = String.valueOf(str) + Common.getHexStringFromBytes(data) + "\r\n";
                    }
                }
                if (!encryptedTags.isEmpty()) {
                    str = String.valueOf(str) + "encrypted:\r\n";
                    keys = encryptedTags.keySet();
                    for (String key : keys) {
                        str = String.valueOf(str) + key + ": ";
                        data = encryptedTags.get(key);
                        str = String.valueOf(str) + Common.getHexStringFromBytes(data) + "\r\n";
                    }
                }
            }
        }
        if (card.unencryptedTags != null) {
            byte[] data;
            Set<String> keys;
            if (card.unencryptedTags != null && !card.unencryptedTags.isEmpty()) {
                str = String.valueOf(str) + "\r\n\r\nunencrypted tags:\r\n";
                keys = card.unencryptedTags.keySet();
                for (String key : keys) {
                    str = String.valueOf(str) + key + ": ";
                    data = card.unencryptedTags.get(key);
                    str = String.valueOf(str) + Common.getHexStringFromBytes(data) + "\r\n";
                }
            }
            if (!IDT_Device._isTTK && card.maskedTags != null && !card.maskedTags.isEmpty()) {
                str = String.valueOf(str) + "\r\n\r\nmaskedTags:\r\n";
                keys = card.maskedTags.keySet();
                for (String key : keys) {
                    str = String.valueOf(str) + key + ": ";
                    data = card.maskedTags.get(key);
                    str = String.valueOf(str) + Common.getHexStringFromBytes(data) + "\r\n";
                }
            }
            if (!IDT_Device._isTTK && card.encryptedTags != null && !card.encryptedTags.isEmpty()) {
                str = String.valueOf(str) + "\r\n\r\nencrypted:\r\n";
                keys = card.encryptedTags.keySet();
                for (String key : keys) {
                    str = String.valueOf(str) + key + ": ";
                    data = card.encryptedTags.get(key);
                    str = String.valueOf(str) + Common.getHexStringFromBytes(data) + "\r\n";
                }
            }
        }
        if (card.fastEMV != null && card.fastEMV.length() > 0) {
            str = String.valueOf(str) + "\r\n\r\nFastEMV: " + card.fastEMV + "\r\n\r\n";
        }
        if (deviceType != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ && deviceType != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB && deviceType != ReaderInfo.DEVICE_TYPE.DEVICE_AUGUSTA && deviceType != ReaderInfo.DEVICE_TYPE.DEVICE_BTPAY && deviceType != ReaderInfo.DEVICE_TYPE.DEVICE_BTPAY_USB && deviceType != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V && deviceType != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V_USB && deviceType != ReaderInfo.DEVICE_TYPE.DEVICE_KIOSK_III && deviceType != ReaderInfo.DEVICE_TYPE.DEVICE_PIP_READER && deviceType != ReaderInfo.DEVICE_TYPE.DEVICE_VENDI && deviceType != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB && deviceType != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT && deviceType != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB && deviceType != ReaderInfo.DEVICE_TYPE.DEVICE_VP2000 && deviceType != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB && deviceType != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT && deviceType != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 && deviceType != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT && deviceType != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_COM) {
            str = String.valueOf(str) + "\r\nCard Type:";
            str = card.cardType == ReaderInfo.CAPTURE_ENCODE_TYPE.CAPTURE_ENCODE_TYPE_ISOABA ? String.valueOf(str) + String.format(Locale.US, "ISO 7813/ISO 4909/ABA format.", new Object[0]) : (card.cardType == ReaderInfo.CAPTURE_ENCODE_TYPE.CAPTURE_ENCODE_TYPE_AAMVA ? String.valueOf(str) + String.format(Locale.US, "AAMVA format.", new Object[0]) : (card.cardType == ReaderInfo.CAPTURE_ENCODE_TYPE.CAPTURE_ENCODE_TYPE_Raw ? String.valueOf(str) + String.format(Locale.US, "Raw; un-decoded format.", new Object[0]) : (card.cardType == ReaderInfo.CAPTURE_ENCODE_TYPE.CAPTURE_ENCODE_TYPE_JisI_II ? String.valueOf(str) + String.format(Locale.US, "JIS I or JIS II.", new Object[0]) : String.valueOf(str) + String.format(Locale.US, "Other format.", new Object[0]))));
            str = String.valueOf(str) + "\r\nEncode Status:";
            str = String.valueOf(str) + String.format(Locale.US, "%02x ", card.captureEncodeStatus);
            str = String.valueOf(str) + "\r\nEncrypt Type:";
            if (card.captureEncryptType == ReaderInfo.CAPTURE_ENCRYPT_TYPE.CAPTURE_ENCRYPT_TYPE_TDES) {
                str = String.valueOf(str) + String.format(Locale.US, "TDES", new Object[0]);
            }
            if (card.captureEncryptType == ReaderInfo.CAPTURE_ENCRYPT_TYPE.CAPTURE_ENCRYPT_TYPE_AES) {
                str = String.valueOf(str) + String.format(Locale.US, "AES", new Object[0]);
            }
            if (card.serialNumber != null) {
                str = String.valueOf(str) + "\r\nReader Serial Number:";
                str = String.valueOf(str) + Common.bytesToHex(card.serialNumber);
            }
        }
        return str;
    }

    public static String getMSRTapTrack2(IDTMSRData card) {
        String result = "";
        if (card.unencryptedTags != null && !card.unencryptedTags.isEmpty()) {
            Set<String> keys = card.unencryptedTags.keySet();
            for (String key : keys) {
                if (!key.equalsIgnoreCase("FFEE14")) continue;
                byte[] data = card.unencryptedTags.get(key);
                result = Common.getAsciiFromByte(data);
            }
        }
        return result;
    }

    public static String processAIDs(byte[] param) {
        if (param == null) {
            return "";
        }
        byte[] bytes = param;
        int vlen = param.length;
        int position = 0;
        String str = "";
        while (position < vlen) {
            int curTag = (bytes[position] & 0xFF) * 256 + (bytes[position + 1] & 0xFF);
            switch (curTag) {
                case 40710: 
                case 57212: 
                case 65504: 
                case 65505: 
                case 65506: 
                case 65507: 
                case 65508: 
                case 65509: 
                case 65510: 
                case 65512: 
                case 65513: 
                case 65514: {
                    if (curTag != 65508) {
                        str = String.valueOf(str) + "\t";
                    }
                    str = String.valueOf(str) + Integer.toHexString(curTag).toUpperCase() + ": ";
                    position += 2;
                    byte len = bytes[position++];
                    byte[] value = new byte[len];
                    System.arraycopy(bytes, position, value, 0, len);
                    str = String.valueOf(str) + Common.getHexStringFromBytes(value).toUpperCase() + "\r\n";
                    position += len;
                    break;
                }
                default: {
                    str = String.valueOf(str) + "Unknown tag: " + Integer.toHexString(curTag).toUpperCase() + "\r\n";
                    position += 2;
                }
            }
        }
        return str;
    }

    public static byte[][] getAIDs(byte[] param) {
        if (param == null) {
            return null;
        }
        byte[] bytes = param;
        byte[][] aids = null;
        int vlen = param.length;
        int position = 0;
        int count = 0;
        while (position < vlen) {
            int curTag = (bytes[position] & 0xFF) * 256 + (bytes[position + 1] & 0xFF);
            switch (curTag) {
                case 40710: {
                    ++count;
                }
            }
            position += 2;
            byte len = bytes[position++];
            position += len;
        }
        if (count <= 0) {
            return aids;
        }
        aids = new byte[count][];
        position = 0;
        int index = 0;
        int ffe6_idx = 0;
        byte[] ffe6 = new byte[count];
        while (position < vlen) {
            int curTag = (bytes[position] & 0xFF) * 256 + (bytes[position + 1] & 0xFF);
            switch (curTag) {
                case 40710: {
                    position += 2;
                    byte len = bytes[position++];
                    aids[index] = new byte[len];
                    System.arraycopy(bytes, position, aids[index], 0, len);
                    position += len;
                    ffe6_idx = index++;
                    break;
                }
                case 65510: {
                    position += 2;
                    byte len = bytes[position++];
                    ffe6[ffe6_idx] = bytes[position];
                    position += len;
                    break;
                }
                case 14675503: {
                    position += 2;
                    byte len = bytes[position++];
                    ffe6[ffe6_idx] = bytes[position];
                    position += len;
                    break;
                }
                default: {
                    position += 2;
                    byte len = bytes[position++];
                    position += len;
                }
            }
        }
        int finalCnt = 0;
        int i = 0;
        while (i < count) {
            if (ffe6[i] != -128) {
                ++finalCnt;
            }
            ++i;
        }
        byte[][] finalAids = null;
        if (finalCnt <= 0) {
            return finalAids;
        }
        finalAids = new byte[finalCnt][];
        index = 0;
        int i2 = 0;
        while (i2 < count) {
            if (ffe6[i2] != -128) {
                finalAids[index] = new byte[aids[i2].length];
                System.arraycopy(aids[i2], 0, finalAids[index], 0, aids[i2].length);
                ++index;
            }
            ++i2;
        }
        return finalAids;
    }

    public static String retrieveAIDTags(byte[] param, String aid) {
        if (param == null) {
            return "";
        }
        byte[] bytes = new byte[param.length + 2];
        System.arraycopy(param, 0, bytes, 0, param.length);
        bytes[param.length] = bytes[0];
        bytes[param.length + 1] = bytes[1];
        int vlen = param.length + 2;
        int position = 0;
        String str = "";
        int firstTag = 0;
        int index = 0;
        int[] tags = new int[20];
        String[] values = new String[20];
        int count = 0;
        boolean found = false;
        boolean done = false;
        while (position < vlen && !done) {
            int curTag = (bytes[position] & 0xFF) * 256 + (bytes[position + 1] & 0xFF);
            switch (curTag) {
                case 40710: 
                case 57212: 
                case 65504: 
                case 65505: 
                case 65506: 
                case 65507: 
                case 65508: 
                case 65509: 
                case 65510: 
                case 65512: 
                case 65513: 
                case 65514: {
                    if (curTag == firstTag) {
                        count = index;
                        index = 0;
                        if (found) {
                            done = true;
                            break;
                        }
                    }
                    if (position == 0) {
                        firstTag = curTag;
                    }
                    tags[index] = curTag;
                    position += 2;
                    byte len = bytes[position++];
                    byte[] value = new byte[len];
                    System.arraycopy(bytes, position, value, 0, len);
                    values[index] = Common.getHexStringFromBytes(value).toUpperCase();
                    if (curTag == 40710 && values[index].equalsIgnoreCase(aid)) {
                        found = true;
                    }
                    position += len;
                    break;
                }
                default: {
                    if (curTag == firstTag) {
                        count = index;
                        index = 0;
                        if (found) {
                            done = true;
                        }
                    }
                    if (position == 0) {
                        firstTag = curTag;
                    }
                    tags[index] = curTag;
                    values[index] = "Unknown Tag value: ";
                    position += 2;
                    byte len = bytes[position++];
                    byte[] value = new byte[len];
                    System.arraycopy(bytes, position, value, 0, len);
                    values[index] = Common.getHexStringFromBytes(value).toUpperCase();
                    position += len;
                }
            }
            ++index;
        }
        int i = 0;
        while (i < count) {
            str = String.valueOf(str) + Integer.toHexString(tags[i]).toUpperCase() + ": ";
            str = String.valueOf(str) + values[i] + "\r\n";
            ++i;
        }
        return str;
    }

    public static byte[] getAIDTags(byte[] param, String aid) {
        byte[] tlv;
        if (param == null) {
            return null;
        }
        byte[] bytes = param;
        int vlen = param.length;
        int position = 0;
        String str = "";
        int firstTag = 0;
        int index = 0;
        int[] tags = new int[20];
        String[] values = new String[20];
        int count = 0;
        boolean found = false;
        boolean done = false;
        while (position < vlen && !done) {
            int curTag = (bytes[position] & 0xFF) * 256 + (bytes[position + 1] & 0xFF);
            switch (curTag) {
                case 40710: 
                case 57212: 
                case 65504: 
                case 65505: 
                case 65506: 
                case 65507: 
                case 65508: 
                case 65509: 
                case 65510: 
                case 65512: 
                case 65513: 
                case 65514: {
                    if (curTag == firstTag) {
                        count = index;
                        index = 0;
                        if (found) {
                            done = true;
                            break;
                        }
                    }
                    if (position == 0) {
                        firstTag = curTag;
                    }
                    tags[index] = curTag;
                    position += 2;
                    byte len = bytes[position++];
                    byte[] value = new byte[len];
                    System.arraycopy(bytes, position, value, 0, len);
                    values[index] = Common.getHexStringFromBytes(value).toUpperCase();
                    if (curTag == 40710 && values[index].equalsIgnoreCase(aid)) {
                        found = true;
                    }
                    position += len;
                    break;
                }
                default: {
                    if (curTag == firstTag) {
                        count = index;
                        index = 0;
                        if (found) {
                            done = true;
                        }
                    }
                    if (position == 0) {
                        firstTag = curTag;
                    }
                    tags[index] = curTag;
                    values[index] = "Unknown Tag value: ";
                    position += 2;
                    byte len = bytes[position++];
                    byte[] value = new byte[len];
                    System.arraycopy(bytes, position, value, 0, len);
                    values[index] = Common.getHexStringFromBytes(value).toUpperCase();
                    position += len;
                }
            }
            ++index;
        }
        if (!done && position >= vlen) {
            count = index;
        }
        if (found) {
            int i = 0;
            while (i < count) {
                str = String.valueOf(str) + Integer.toHexString(tags[i]).toUpperCase();
                int vl = values[i].length() / 2;
                str = String.valueOf(str) + (vl < 16 ? "0" + Integer.toHexString(vl).toUpperCase() : Integer.toHexString(vl).toUpperCase());
                str = String.valueOf(str) + values[i];
                ++i;
            }
            tlv = Common.getBytesFromHexString(str);
        } else {
            tlv = null;
        }
        return tlv;
    }

    public static byte[] getAIDTags_DFEE2D(byte[] param, String aid) {
        byte[] tlv;
        if (param == null) {
            return null;
        }
        byte[] bytes = param;
        int vlen = param.length;
        int position = 0;
        String str = "";
        int firstTag = 0;
        int index = 0;
        int[] tags = new int[20];
        String[] values = new String[20];
        int count = 0;
        boolean found = false;
        boolean done = false;
        while (position < vlen && !done) {
            int curTag = bytes[position] == -97 ? (bytes[position] & 0xFF) * 256 + (bytes[position + 1] & 0xFF) : (bytes[position] & 0xFF) * 65536 + (bytes[position + 1] & 0xFF) * 256 + (bytes[position + 2] & 0xFF);
            switch (curTag) {
                case 40710: {
                    if (curTag == firstTag) {
                        count = index;
                        index = 0;
                        if (found) {
                            done = true;
                            break;
                        }
                    }
                    if (position == 0) {
                        firstTag = curTag;
                    }
                    tags[index] = curTag;
                    position += 2;
                    byte len = bytes[position++];
                    byte[] value = new byte[len];
                    System.arraycopy(bytes, position, value, 0, len);
                    values[index] = Common.getHexStringFromBytes(value).toUpperCase();
                    if (curTag == 40710 && values[index].equalsIgnoreCase(aid)) {
                        found = true;
                    }
                    position += len;
                    break;
                }
                case 14675501: 
                case 14675502: 
                case 14675503: 
                case 14675531: 
                case 14675532: 
                case 14675533: {
                    if (curTag == firstTag) {
                        count = index;
                        index = 0;
                        if (found) {
                            done = true;
                            break;
                        }
                    }
                    if (position == 0) {
                        firstTag = curTag;
                    }
                    tags[index] = curTag;
                    position += 3;
                    byte len = bytes[position++];
                    byte[] value = new byte[len];
                    System.arraycopy(bytes, position, value, 0, len);
                    values[index] = Common.getHexStringFromBytes(value).toUpperCase();
                    if (curTag == 40710 && values[index].equalsIgnoreCase(aid)) {
                        found = true;
                    }
                    position += len;
                    break;
                }
                default: {
                    if (curTag == firstTag) {
                        count = index;
                        index = 0;
                        if (found) {
                            done = true;
                        }
                    }
                    if (position == 0) {
                        firstTag = curTag;
                    }
                    tags[index] = curTag;
                    values[index] = "Unknown Tag value: ";
                    position += 3;
                    byte len = bytes[position++];
                    byte[] value = new byte[len];
                    System.arraycopy(bytes, position, value, 0, len);
                    values[index] = Common.getHexStringFromBytes(value).toUpperCase();
                    position += len;
                }
            }
            ++index;
        }
        if (!done && position >= vlen) {
            count = index;
        }
        if (found) {
            int i = 0;
            while (i < count) {
                str = String.valueOf(str) + Integer.toHexString(tags[i]).toUpperCase();
                int vl = values[i].length() / 2;
                str = String.valueOf(str) + (vl < 16 ? "0" + Integer.toHexString(vl).toUpperCase() : Integer.toHexString(vl).toUpperCase());
                str = String.valueOf(str) + values[i];
                ++i;
            }
            tlv = Common.getBytesFromHexString(str);
        } else {
            tlv = null;
        }
        return tlv;
    }

    public static byte[][] getAIDList(byte[] aidListData, boolean isContactless) {
        Object aidList;
        if (aidListData == null || aidListData.length < 5) {
            return null;
        }
        if (deviceType == ReaderInfo.DEVICE_TYPE.DEVICE_MINISMART_II || deviceType == ReaderInfo.DEVICE_TYPE.DEVICE_AUGUSTA) {
            if (aidListData[3] == 21) {
                aidList = null;
            } else {
                int listCount = aidListData[4] & 0xFF | (aidListData[5] & 0xFF) << 8;
                int idx = 6;
                aidList = new byte[listCount][];
                int i = 0;
                while (i < listCount) {
                    int aidLen = aidListData[idx] & 0xFF | (aidListData[idx + 1] & 0xFF) << 8;
                    aidList[i] = new byte[aidLen];
                    System.arraycopy(aidListData, idx += 2, aidList[i], 0, aidLen);
                    idx += aidLen;
                    ++i;
                }
            }
        } else if (deviceType == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ || deviceType == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB || deviceType == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V || deviceType == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V_USB || deviceType == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB || deviceType == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT || deviceType == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB || deviceType == ReaderInfo.DEVICE_TYPE.DEVICE_VP2000 || deviceType == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_COM) {
            if (aidListData[11] != 0) {
                aidList = null;
            } else if (aidListData[14] == -1 && aidListData[15] == -28) {
                int listCount = aidListData[13] & 0xFF | (aidListData[12] & 0xFF) << 8;
                byte[] tlv = new byte[listCount];
                System.arraycopy(aidListData, 14, tlv, 0, listCount);
                aidList = Common.getAIDs(tlv);
            } else {
                int listCount = aidListData[14] & 0xFF | (aidListData[15] & 0xFF) << 8;
                int idx = 16;
                aidList = new byte[listCount][];
                int i = 0;
                while (i < listCount) {
                    int aidLen = aidListData[idx] & 0xFF | (aidListData[idx + 1] & 0xFF) << 8;
                    aidList[i] = new byte[aidLen];
                    System.arraycopy(aidListData, idx += 2, aidList[i], 0, aidLen);
                    idx += aidLen;
                    ++i;
                }
            }
        } else if (deviceType == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB || deviceType == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT) {
            if (isContactless) {
                if (aidListData[11] != 0) {
                    aidList = null;
                } else {
                    int listCount = aidListData[13] & 0xFF | (aidListData[12] & 0xFF) << 8;
                    byte[] tlv = new byte[listCount];
                    System.arraycopy(aidListData, 14, tlv, 0, listCount);
                    String strTagData = Common.base16Encode(tlv).toUpperCase(Locale.US);
                    String[] tag9F06 = strTagData.split("9F06");
                    if (tag9F06 != null && tag9F06.length > 0) {
                        String[] tmp = new String[tag9F06.length];
                        listCount = 0;
                        int i = 1;
                        while (i < tag9F06.length) {
                            byte[] aidData = Common.getBytesFromHexString(tag9F06[i]);
                            byte aidLen = aidData[0];
                            byte[] aid = new byte[aidLen];
                            System.arraycopy(aidData, 1, aid, 0, aidLen);
                            tmp[listCount] = Common.base16Encode(aid).toUpperCase(Locale.US);
                            ++listCount;
                            ++i;
                        }
                        if (listCount > 0) {
                            aidList = new byte[listCount][];
                            i = 0;
                            while (i < listCount) {
                                aidList[i] = Common.getBytesFromHexString(tmp[i]);
                                ++i;
                            }
                        } else {
                            aidList = null;
                        }
                    } else {
                        aidList = null;
                    }
                }
            } else if (aidListData[11] != 0) {
                aidList = null;
            } else if (aidListData[14] == -1 && aidListData[15] == -28) {
                int listCount = aidListData[13] & 0xFF | (aidListData[12] & 0xFF) << 8;
                byte[] tlv = new byte[listCount];
                System.arraycopy(aidListData, 14, tlv, 0, listCount);
                aidList = Common.getAIDs(tlv);
            } else {
                int listCount = aidListData[14] & 0xFF | (aidListData[15] & 0xFF) << 8;
                int idx = 16;
                aidList = new byte[listCount][];
                int i = 0;
                while (i < listCount) {
                    int aidLen = aidListData[idx] & 0xFF | (aidListData[idx + 1] & 0xFF) << 8;
                    aidList[i] = new byte[aidLen];
                    System.arraycopy(aidListData, idx += 2, aidList[i], 0, aidLen);
                    idx += aidLen;
                    ++i;
                }
            }
        } else if (deviceType == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 || deviceType == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT) {
            if (aidListData[11] != 0) {
                aidList = null;
            } else {
                int listCount = aidListData[13] & 0xFF | (aidListData[12] & 0xFF) << 8;
                byte[] tlv = new byte[listCount];
                System.arraycopy(aidListData, 14, tlv, 0, listCount);
                String strTagData = Common.base16Encode(tlv).toUpperCase(Locale.US);
                String[] tag9F06 = strTagData.split("9F06");
                if (tag9F06 != null && tag9F06.length > 0) {
                    String[] tmp = new String[tag9F06.length];
                    listCount = 0;
                    int i = 1;
                    while (i < tag9F06.length) {
                        if (deviceType != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 && deviceType != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT || tag9F06[i].contains("DFEE4F0102")) {
                            byte[] aidData = Common.getBytesFromHexString(tag9F06[i]);
                            byte aidLen = aidData[0];
                            byte[] aid = new byte[aidLen];
                            System.arraycopy(aidData, 1, aid, 0, aidLen);
                            tmp[listCount] = Common.base16Encode(aid).toUpperCase(Locale.US);
                            ++listCount;
                        }
                        ++i;
                    }
                    if (listCount > 0) {
                        aidList = new byte[listCount][];
                        i = 0;
                        while (i < listCount) {
                            aidList[i] = Common.getBytesFromHexString(tmp[i]);
                            ++i;
                        }
                    } else {
                        aidList = null;
                    }
                } else {
                    aidList = null;
                }
            }
        } else if (deviceType == ReaderInfo.DEVICE_TYPE.DEVICE_KIOSK_III || deviceType == ReaderInfo.DEVICE_TYPE.DEVICE_PIP_READER || deviceType == ReaderInfo.DEVICE_TYPE.DEVICE_VENDI) {
            if (aidListData[11] != 0) {
                aidList = null;
            } else {
                int listCount = aidListData[13] & 0xFF | (aidListData[12] & 0xFF) << 8;
                byte[] tlv = new byte[listCount];
                System.arraycopy(aidListData, 14, tlv, 0, listCount);
                aidList = Common.getAIDs(tlv);
            }
        } else if (aidListData[3] == 21) {
            aidList = null;
        } else {
            int listCount = aidListData[4] & 0xFF;
            int idx = 5;
            aidList = new byte[listCount][];
            int i = 0;
            while (i < listCount) {
                int aidLen = aidListData[idx] & 0xFF;
                aidList[i] = new byte[aidLen];
                System.arraycopy(aidListData, ++idx, aidList[i], 0, aidLen);
                idx += aidLen;
                ++i;
            }
        }
        return aidList;
    }

    public static byte[][] getRIDList(byte[] ridListData, boolean withIndex) {
        int idx;
        int listCount;
        int length;
        if (ridListData == null || ridListData.length < 5) {
            return null;
        }
        int n = length = withIndex ? 6 : 5;
        if (deviceType == ReaderInfo.DEVICE_TYPE.DEVICE_MINISMART_II || deviceType == ReaderInfo.DEVICE_TYPE.DEVICE_AUGUSTA) {
            listCount = ridListData[0] & 0xFF | (ridListData[1] & 0xFF) << 8;
            listCount /= length;
            idx = 2;
        } else if (deviceType == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ || deviceType == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB || deviceType == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V || deviceType == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V_USB || deviceType == ReaderInfo.DEVICE_TYPE.DEVICE_VENDI || deviceType == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB || deviceType == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT || deviceType == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB || deviceType == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB || deviceType == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT || deviceType == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 || deviceType == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT || deviceType == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_COM) {
            listCount = (ridListData[12] & 0xFF) << 8 | ridListData[13] & 0xFF;
            listCount /= length;
            idx = 14;
        } else {
            listCount = ridListData[0];
            idx = 1;
        }
        byte[][] ridList = new byte[listCount][length];
        int i = 0;
        while (i < listCount) {
            System.arraycopy(ridListData, idx, ridList[i], 0, length);
            idx += length;
            ++i;
        }
        return ridList;
    }

    public static byte[][] getCRL(byte[] crlData) {
        if (crlData == null || crlData.length < 9) {
            return null;
        }
        int listCount = crlData.length / 9;
        int idx = 0;
        byte[][] crlList = new byte[listCount][9];
        int i = 0;
        while (i < listCount) {
            System.arraycopy(crlData, idx, crlList[i], 0, 9);
            idx += 9;
            ++i;
        }
        return crlList;
    }

    public static String bytesToStringUTFNIO(byte[] bytes) {
        CharBuffer cBuffer = ByteBuffer.wrap(bytes).asCharBuffer();
        return cBuffer.toString();
    }

    public static String getDisplayMessage(byte[] messageCode, ResDataStruct toData) {
        byte[] displayCommand;
        byte[] display;
        if (messageCode == null || messageCode.length < 6) {
            return "";
        }
        int modeIndex = 5;
        byte languageCode = 78;
        if (deviceType == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ || deviceType == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB || deviceType == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V || deviceType == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V_USB || deviceType == ReaderInfo.DEVICE_TYPE.DEVICE_VENDI || deviceType == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB || deviceType == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT || deviceType == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB || deviceType == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB || deviceType == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT || deviceType == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800 || deviceType == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT || deviceType == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_COM) {
            display = new byte[]{97, 1};
            modeIndex = 14;
            displayCommand = new byte[2];
            System.arraycopy(messageCode, 10, displayCommand, 0, 2);
            int controlDataLen = (messageCode[12] & 0xFF) << 8 | messageCode[13] & 0xFF;
            if (messageCode.length > 22) {
                languageCode = messageCode[modeIndex] == 1 ? messageCode[22] : messageCode[20];
            }
        } else {
            display = new byte[]{73, 114, 1};
            displayCommand = new byte[3];
            System.arraycopy(messageCode, 0, displayCommand, 0, 3);
            int controlDataLen = messageCode[3] & 0xFF | (messageCode[4] & 0xFF) << 8;
            if (messageCode.length > 13) {
                languageCode = messageCode[modeIndex] == 3 ? messageCode[11] : messageCode[13];
            }
        }
        toData.resData = new byte[2];
        toData.resData[1] = languageCode;
        toData.resData[0] = languageCode == 82 ? 70 : (languageCode == 83 ? 69 : (languageCode == 72 ? 90 : 69));
        toData.settingValue = 0;
        if (Arrays.equals(displayCommand, display) && messageCode[modeIndex] == 16) {
            return "";
        }
        String message = "";
        if (messageCode.length < 16) {
            return "";
        }
        if (Arrays.equals(displayCommand, display) && messageCode[modeIndex] == 3) {
            int messageControlLen = messageCode[modeIndex + 7] & 0xFF | (messageCode[modeIndex + 8] & 0xFF) << 8;
            if (messageControlLen > 1) {
                byte[] messageControl = new byte[messageControlLen];
                System.arraycopy(messageCode, modeIndex + 9, messageControl, 0, messageControlLen);
                toData.settingValue = messageControl[1];
                message = String.valueOf(message) + Common.getMessage(languageCode, messageControlLen, messageControl);
            }
        } else if (Arrays.equals(displayCommand, display) && messageCode[modeIndex] == 1) {
            toData.timeout = messageCode[modeIndex + 3] & 0xFF | (messageCode[modeIndex + 4] & 0xFF) << 8;
            int messageControlLen = messageCode[modeIndex + 9] & 0xFF | (messageCode[modeIndex + 10] & 0xFF) << 8;
            if (messageControlLen > 1) {
                byte[] messageControl = new byte[messageControlLen];
                System.arraycopy(messageCode, modeIndex + 11, messageControl, 0, messageControlLen);
                toData.settingValue = messageControl[1];
                message = String.valueOf(message) + Common.getMessage(languageCode, messageControlLen, messageControl);
            }
        }
        return message;
    }

    public static String getMessage(byte languageCode, int messageControlLen, byte[] messageControl) {
        int index = 0;
        int lineNumIdx = 0;
        String message = "";
        while (index < messageControlLen) {
            boolean messageId = (messageControl[lineNumIdx] & 0x80) == 128;
            int lineNum = messageControl[lineNumIdx] & 0x7F;
            ++index;
            String tempStr = "";
            if (messageId) {
                if (messageControl[index] > 0 && messageControl[index] <= 111) {
                    tempStr = languageCode == 82 ? languageFR[messageControl[index]] : (languageCode == 83 ? languageSP[messageControl[index]] : (languageCode == 72 ? languageZH[messageControl[index]] : languageEN[messageControl[index]]));
                }
                index += 2;
            } else {
                tempStr = String.valueOf(tempStr) + lineNum + ". ";
                while (messageControl[index] != 28) {
                    tempStr = String.valueOf(tempStr) + (char)messageControl[index];
                    ++index;
                }
            }
            lineNumIdx = ++index;
            message = String.valueOf(message) + tempStr + "\r\n";
        }
        return message;
    }

    public static String getLCDMessage(byte[] languageCode, byte messageId) {
        String message = "";
        String tempStr = "";
        byte messageID = messageId;
        if (messageID > 0 && messageID <= 111) {
            tempStr = languageCode[1] == 82 ? languageFR[messageID] : (languageCode[1] == 83 ? languageSP[messageID] : (languageCode[1] == 72 ? languageZH[messageID] : languageEN[messageID]));
        }
        message = tempStr;
        return message;
    }

    public static int indexOf(byte[] outerArray, byte[] smallerArray) {
        int i = 0;
        while (i < outerArray.length - smallerArray.length + 1) {
            boolean found = true;
            int j = 0;
            while (j < smallerArray.length) {
                if (outerArray[i + j] != smallerArray[j]) {
                    found = false;
                    break;
                }
                ++j;
            }
            if (found) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static byte[] removeReportIds(String data) {
        if (data == null || data.length() == 0) {
            return null;
        }
        byte[] orgCmd = Common.getBytesFromHexString(data);
        byte[] tmpCmd = new byte[orgCmd.length];
        int idx = 0;
        int i = 0;
        while (i < orgCmd.length) {
            if (i % 64 != 0) {
                tmpCmd[idx] = orgCmd[i];
                ++idx;
            }
            ++i;
        }
        int length = (tmpCmd[12] & 0xFF) << 8 | tmpCmd[13] & 0xFF;
        byte[] cmd = new byte[length += 16];
        System.arraycopy(tmpCmd, 0, cmd, 0, length);
        return cmd;
    }

    public static byte[] removeReportIdsAddLength(String data) {
        if (data == null || data.length() == 0) {
            return null;
        }
        byte[] orgCmd = Common.getBytesFromHexString(data);
        byte[] tmpCmd = new byte[orgCmd.length];
        int idx = 0;
        int i = 0;
        while (i < orgCmd.length) {
            if (i % 64 != 0) {
                tmpCmd[idx] = orgCmd[i];
                ++idx;
            }
            ++i;
        }
        int length = (tmpCmd[12] & 0xFF) << 8 | tmpCmd[13] & 0xFF;
        byte[] tmp = new byte[length += 16];
        System.arraycopy(tmpCmd, 0, tmp, 0, length);
        String cmdStr = Common.base16Encode(tmp);
        byte[] cmd = Common.makeCommand(cmdStr);
        return cmd;
    }

    public static String emvErrorCodes(int val) {
        if (val == 0) {
            return "APPROVED_OFFLINE";
        }
        if (val == 1) {
            return "DECLINED_OFFLINE";
        }
        if (val == 2) {
            return "APPROVED";
        }
        if (val == 3) {
            return "DECLINED";
        }
        if (val == 4) {
            return "GO_ONLINE";
        }
        if (val == 5) {
            return "CALL_YOUR_BANK";
        }
        if (val == 6) {
            return "NOT_ACCEPTED";
        }
        if (val == 7) {
            return "USE_MAGSTRIPE";
        }
        if (val == 8) {
            return "TIME_OUT";
        }
        if (val == 16) {
            return "START_TRANS_SUCCESS";
        }
        if (val == 17) {
            return "MSR_SUCCESS";
        }
        if (val == 4097) {
            return "FILE_ARG_INVALID";
        }
        if (val == 4098) {
            return "FILE_OPEN_FAILED";
        }
        if (val == 4099) {
            return "FILE_OPERATION_FAILED";
        }
        if (val == 8193) {
            return "MEMORY_NOT_ENOUGH";
        }
        if (val == 12290) {
            return "SMARTCARD_FAIL";
        }
        if (val == 12291) {
            return "SMARTCARD_INIT_FAILED";
        }
        if (val == 12292) {
            return "FALLBACK_SITUATION";
        }
        if (val == 12293) {
            return "SMARTCARD_ABSENT";
        }
        if (val == 12294) {
            return "SMARTCARD_TIMEOUT";
        }
        if (val == 12295) {
            return "MSR_CARD_ERROR";
        }
        if (val == 12306) {
            return "MSR_CARD_ERROR_FALLBACK";
        }
        if (val == 12307) {
            return "TIMEOUT_FOR_WAITING_ICC_INSERT_OR_MSR_SWIPE_FALLBACK";
        }
        if (val == 20481) {
            return "PARSING_TAGS_FAILED";
        }
        if (val == 20482) {
            return "CARD_DATA_ELEMENT_DUPLICATE";
        }
        if (val == 20483) {
            return "DATA_FORMAT_INCORRECT";
        }
        if (val == 20484) {
            return "APP_NO_TERM";
        }
        if (val == 20485) {
            return "APP_NO_MATCHING";
        }
        if (val == 20486) {
            return "AMANDATORY_OBJECT_MISSING";
        }
        if (val == 20487) {
            return "APP_SELECTION_RETRY";
        }
        if (val == 20488) {
            return "AMOUNT_ERROR_GET";
        }
        if (val == 20489) {
            return "CARD_REJECTED";
        }
        if (val == 20496) {
            return "AIP_NOT_RECEIVED";
        }
        if (val == 20497) {
            return "AFL_NOT_RECEIVEDE";
        }
        if (val == 20498) {
            return "AFL_LEN_OUT_OF_RANGE";
        }
        if (val == 20499) {
            return "SFI_OUT_OF_RANGE";
        }
        if (val == 20500) {
            return "AFL_INCORRECT";
        }
        if (val == 20501) {
            return "EXP_DATE_INCORRECT";
        }
        if (val == 20502) {
            return "EFF_DATE_INCORRECT";
        }
        if (val == 20503) {
            return "ISS_COD_TBL_OUT_OF_RANGE";
        }
        if (val == 20504) {
            return "CRYPTOGRAM_TYPE_INCORRECT";
        }
        if (val == 20505) {
            return "PSE_BY_CARD_NOT_SUPPORTED";
        }
        if (val == 20512) {
            return "USER_LANGUAGE_SELECTED";
        }
        if (val == 20513) {
            return "SERVICE_NOT_ALLOWED";
        }
        if (val == 20514) {
            return "NO_TAG_FOUND";
        }
        if (val == 20515) {
            return "CARD_BLOCKED";
        }
        if (val == 20516) {
            return "LEN_INCORRECT";
        }
        if (val == 20517) {
            return "CARD_COM_ERROR";
        }
        if (val == 20518) {
            return "TSC_NOT_INCREASED";
        }
        if (val == 20519) {
            return "HASH_INCORRECT";
        }
        if (val == 20520) {
            return "ARC_NOT_PRESENCED";
        }
        if (val == 20521) {
            return "ARC_INVALID";
        }
        if (val == 20528) {
            return "COMM_NO_ONLINE";
        }
        if (val == 20529) {
            return "TRAN_TYPE_INCORRECT";
        }
        if (val == 20530) {
            return "APP_NO_SUPPORT";
        }
        if (val == 20531) {
            return "APP_NOT_SELECT";
        }
        if (val == 20532) {
            return "LANG_NOT_SELECT";
        }
        if (val == 20533) {
            return "TERM_DATA_NOT_PRESENCED";
        }
        if (val == 24577) {
            return "CVM_TYPE_UNKNOWN";
        }
        if (val == 24578) {
            return "CVM_AIP_NOT_SUPPORTED";
        }
        if (val == 24579) {
            return "CVM_TAG_8E_MISSING";
        }
        if (val == 24580) {
            return "CVM_TAG_8E_FORMAT_ERROR";
        }
        if (val == 24581) {
            return "CVM_CODE_IS_NOT_SUPPORTED";
        }
        if (val == 24582) {
            return "CVM_COND_CODE_IS_NOT_SUPPORTED";
        }
        if (val == 24583) {
            return "CVM_NO_MORE";
        }
        if (val == 24584) {
            return "PIN_BYPASSED_BEFORE";
        }
        return "";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EMV_LCD_DISPLAY_MODE {
        EMV_LCD_DISPLAY_MODE_CANCEL(0),
        EMV_LCD_DISPLAY_MODE_MENU(1),
        EMV_LCD_DISPLAY_MODE_PROMPT(2),
        EMV_LCD_DISPLAY_MODE_MESSAGE(3),
        EMV_LCD_DISPLAY_MODE_LANGUAGE_SELECT(8),
        EMV_LCD_DISPLAY_MODE_CLEAR_SCREEN(16);

        private int value;

        private EMV_LCD_DISPLAY_MODE(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static EMV_LCD_DISPLAY_MODE convert(byte type) {
            switch (type) {
                case 1: {
                    return EMV_LCD_DISPLAY_MODE_MENU;
                }
                case 2: {
                    return EMV_LCD_DISPLAY_MODE_PROMPT;
                }
                case 3: {
                    return EMV_LCD_DISPLAY_MODE_MESSAGE;
                }
                case 8: {
                    return EMV_LCD_DISPLAY_MODE_LANGUAGE_SELECT;
                }
                case 16: {
                    return EMV_LCD_DISPLAY_MODE_CLEAR_SCREEN;
                }
            }
            return EMV_LCD_DISPLAY_MODE_CANCEL;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EMV_TRANSACTION_STAGE {
        EMV_BEFORE_TRANSACTION,
        EMV_MIDDLE_TRANSACTION,
        EMV_AFTER_TRANSACTION;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PUSType {
        INVALID(false, "invalid", null, 0),
        BLM(true, "blm", null, 0),
        BAUD(true, "chan", null, 0),
        MSR1xx(false, "1", ReaderInfo.DEVICE_TYPE.DEVICE_UNIMAG_PRO, 1),
        MSR2xx(true, "2", ReaderInfo.DEVICE_TYPE.DEVICE_UNIMAG, 2),
        MSR3xx(true, "3", ReaderInfo.DEVICE_TYPE.DEVICE_UNIMAG, 4),
        UniPay(true, "4", ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY, 10);

        public final boolean supportsCmd;
        public final String name;
        public final ReaderInfo.DEVICE_TYPE readerType;
        public final int stateListVal;

        private PUSType(boolean supportsCmd, String name, ReaderInfo.DEVICE_TYPE readerType, int stateListVal) {
            this.supportsCmd = supportsCmd;
            this.name = name;
            this.readerType = readerType;
            this.stateListVal = stateListVal;
        }

        public static PUSType parse(byte[] resp) {
            if (resp == null || resp.length == 0) {
                return INVALID;
            }
            if (Common.containsStr(resp, "SPPMSR1")) {
                return SdkCustomization.CUST == 0 ? MSR1xx : INVALID;
            }
            if (Common.containsStr(resp, "SPPMSR2")) {
                return MSR2xx;
            }
            if (Common.containsStr(resp, "SPPMSR")) {
                return SdkCustomization.CUST == 0 ? MSR3xx : INVALID;
            }
            if (15 == resp.length && 6 == resp[0] && 86 == resp[1]) {
                return BLM;
            }
            if (1 == resp.length && 6 == resp[0]) {
                return BAUD;
            }
            if (2 == resp[0] && 3 == resp[resp.length - 1] && resp.length > 6) {
                short respLength = resp[2];
                if (resp.length == (respLength = (short)(respLength << 8 & 0xFF00 | resp[1])) + 6) {
                    if (respLength == 1 && (resp[3] == 6 || resp[3] == 21)) {
                        return BAUD;
                    }
                    int len = resp.length;
                    String ver = new String();
                    try {
                        byte[] slice = Arrays.copyOfRange(resp, 4, len - 3);
                        ver = Common.byteToString(slice);
                    }
                    catch (Exception e) {
                        return INVALID;
                    }
                    if (ver.contains("UniPay V")) {
                        return UniPay;
                    }
                }
            }
            return INVALID;
        }

        public static PUSType parseCard(byte[] resp) {
            if (resp == null || resp.length == 0) {
                return INVALID;
            }
            if (Common.containsStr(resp, "SPPMSR1")) {
                return SdkCustomization.CUST == 0 ? MSR1xx : INVALID;
            }
            if (Common.containsStr(resp, "SPPMSR2")) {
                return MSR2xx;
            }
            if (Common.containsStr(resp, "SPPMSR")) {
                return SdkCustomization.CUST == 0 ? MSR3xx : INVALID;
            }
            if (15 == resp.length && 6 == resp[0] && 86 == resp[1]) {
                return BLM;
            }
            if (1 == resp.length && 6 == resp[0]) {
                return BAUD;
            }
            if (2 == resp[0] && 3 == resp[resp.length - 1]) {
                if (resp.length > 6) {
                    short respLength = resp[2];
                    if (resp.length == (respLength = (short)(respLength << 8 & 0xFF00 | resp[1])) + 6) {
                        if (respLength == 1 && (resp[3] == 6 || resp[3] == 21)) {
                            return BAUD;
                        }
                        if (Common.containsStr(resp, "UniPay V")) {
                            return UniPay;
                        }
                    }
                }
            } else if (37 == resp[0] && 13 == resp[resp.length - 1]) {
                return UniPay;
            }
            return INVALID;
        }

        public static PUSType parse(List<byte[]> resp) {
            for (byte[] respI : resp) {
                PUSType ret = PUSType.parse(respI);
                if (ret == INVALID) continue;
                return ret;
            }
            return INVALID;
        }
    }

    public static class Response {
        public static boolean checkNGAProtocol(byte[] cmdReturn) {
            if (cmdReturn.length > 6) {
                short respLength = (short)(cmdReturn[2] & 0xFF);
                if (cmdReturn.length == (respLength = (short)(respLength << 8 & 0xFF00 | cmdReturn[1] & 0xFF)) + 6) {
                    return true;
                }
            }
            return false;
        }

        public static boolean checkUMProtocol(byte[] cmdReturn) {
            if (cmdReturn.length == 1 && (cmdReturn[0] == 6 || cmdReturn[0] == 21)) {
                return true;
            }
            return cmdReturn.length > 4 && (cmdReturn[0] == 6 || cmdReturn[0] == 21) && cmdReturn[1] == 2 && cmdReturn[cmdReturn.length - 2] == 3;
        }

        public static int checkACK(byte[] cmdReturn) {
            if (Response.checkNGAProtocol(cmdReturn)) {
                if (cmdReturn[3] == 6) {
                    return 1;
                }
                if (cmdReturn[3] == 21) {
                    return 0;
                }
            }
            return -1;
        }

        public static int checkUMACK(byte[] cmdReturn) {
            if (Response.checkUMProtocol(cmdReturn)) {
                if (cmdReturn[0] == 6) {
                    return 1;
                }
                if (cmdReturn[0] == 21) {
                    return 0;
                }
            }
            return -1;
        }

        public static int ErrorCode(byte[] buf) {
            int res = 0;
            if (buf[3] != 21) {
                return 2;
            }
            res = buf[4] * 256 + buf[5];
            return res &= 0xFFFF;
        }

        public static void responesMSRData(OnReceiverListener msgReceiver, byte[] msrCardData) {
            IDTMSRData cData = null;
            byte[] buff = msrCardData;
            byte flagCardData = buff[0];
            int len = msrCardData.length - 1;
            if (len > 10) {
                byte[] temp = new byte[len];
                System.arraycopy(buff, 1, temp, 0, len);
                cData = new IDTMSRData();
                cData.cardDataFlag = flagCardData;
                if (temp[0] == 2 && (temp[3] == -128 || temp[3] == -127 || temp[3] == -125 || temp[3] == -124 || temp[3] == -123 || temp[3] == -122 || temp[3] == -64)) {
                    Response.parseCardData(temp, cData, 0);
                } else if (temp[1] == 2 && (temp[4] == -128 || temp[4] == -127 || temp[4] == -125 || temp[4] == -124 || temp[4] == -123 || temp[4] == -122 || temp[4] == -64)) {
                    Response.parseCardDataUniPay(temp, cData);
                } else {
                    Response.parseCardClearData(temp, cData);
                }
                UMLog.i("COMMON", "BEFORE EMV LISTENER");
                if (emvListener != null) {
                    String t2data;
                    UMLog.i("COMMON", "IN EMV LISTENER");
                    if (cData.iccPresent && (t2data = cData.track2) != null && t2data.length() > 5) {
                        cData.track2 = t2data.replace("=*****", "=****2");
                    }
                    if (cData != null) {
                        emvListener.swipeMSRData(cData);
                    }
                }
                UMLog.i("COMMON", "AFTER EMV LISTENER");
                if (cData != null) {
                    IDT_Device.readyForCardSwipe = true;
                    msgReceiver.swipeMSRData(cData);
                }
            } else if (buff[0] == 122 && len == 4) {
                cData = new IDTMSRData();
                if (buff[3] == 60) {
                    cData.event = ReaderInfo.EVENT_MSR_Types.EVENT_MSR_CANCEL_KEY;
                }
                if (buff[3] == 61) {
                    cData.event = ReaderInfo.EVENT_MSR_Types.EVENT_MSR_BACKSPACE_KEY;
                }
                if (buff[3] == 62) {
                    cData.event = ReaderInfo.EVENT_MSR_Types.EVENT_MSR_ENTER_KEY;
                }
                cData.cardData = new byte[4];
                cData.encTrack1 = new byte[0];
                cData.encTrack2 = new byte[0];
                cData.encTrack3 = new byte[0];
                cData.KSN = new byte[0];
                int j = 0;
                while (j < 4) {
                    cData.cardData[j] = buff[j];
                    ++j;
                }
                if (cData != null) {
                    IDT_Device.readyForCardSwipe = true;
                    msgReceiver.swipeMSRData(cData);
                }
                if (emvListener != null) {
                    String t2data;
                    if (cData.iccPresent && (t2data = cData.track2) != null && t2data.length() > 5) {
                        cData.track2 = t2data.replace("=*****", "=****2");
                    }
                    if (cData != null) {
                        emvListener.swipeMSRData(cData);
                    }
                }
            } else if (buff[3] == 21) {
                cData = new IDTMSRData();
                cData.event = ReaderInfo.EVENT_MSR_Types.EVENT_MSR_UNKNOWN;
                cData.cardData = new byte[2];
                cData.encTrack1 = new byte[0];
                cData.encTrack2 = new byte[0];
                cData.encTrack3 = new byte[0];
                cData.KSN = new byte[0];
                cData.cardData[0] = buff[4];
                cData.cardData[1] = buff[5];
                if (cData != null) {
                    IDT_Device.readyForCardSwipe = true;
                    msgReceiver.swipeMSRData(cData);
                }
                if (emvListener != null) {
                    emvListener.swipeMSRData(cData);
                }
            }
        }

        public static void parseCardClearData(byte[] buf, IDTMSRData cData) {
            int length = buf.length;
            boolean i = false;
            cData.cardData = new byte[length];
            int subData = 0;
            if (length > 2 && buf[length - 1] == 13 && buf[length - 2] == 63) {
                subData = 2;
            }
            if (buf[0] == 0) {
                System.arraycopy(buf, 1, cData.cardData, 0, length - 1 - subData);
                cData.rawTrackData = new byte[length - 2];
                System.arraycopy(buf, 1, cData.rawTrackData, 0, length - 2);
            } else {
                System.arraycopy(buf, 0, cData.cardData, 0, length - subData);
                cData.rawTrackData = new byte[length - 1];
                System.arraycopy(buf, 0, cData.rawTrackData, 0, length - 1);
            }
            String trackData = new String(cData.cardData);
            String[] tracks = trackData.split(Pattern.quote("?"));
            if (tracks.length == 1) {
                cData.track2 = String.valueOf(tracks[0]) + "?";
                cData.track2Length = cData.track2.length();
            } else {
                cData.track1 = String.valueOf(tracks[0]) + "?";
                cData.track1Length = cData.track1.length();
                if (tracks.length > 1) {
                    cData.track2 = String.valueOf(tracks[1]) + "?";
                    cData.track2Length = cData.track2.length();
                }
                if (tracks.length > 2) {
                    cData.track3 = String.valueOf(tracks[2]) + "?";
                    cData.track3Length = cData.track3.length();
                }
            }
            cData.event = ReaderInfo.EVENT_MSR_Types.EVENT_MSR_CARD_DATA;
            cData.captureEncryptType = ReaderInfo.CAPTURE_ENCRYPT_TYPE.CAPTURE_ENCRYPT_TYPE_NONE;
        }

        public static void parseCardData(byte[] buf, IDTMSRData cData, int offset) {
            PostCardDataParse ParseData = new PostCardDataParse();
            int length = buf.length;
            int i = 0;
            cData.cardData = new byte[length];
            System.arraycopy(buf, 0, cData.cardData, 0, length);
            cData.rawTrackData = new byte[length];
            System.arraycopy(buf, 0, cData.rawTrackData, 0, length);
            cData.event = ReaderInfo.EVENT_MSR_Types.EVENT_MSR_CARD_DATA;
            int m_iTrack1 = buf[5 - offset];
            int m_iTrack2 = buf[6 - offset];
            int m_iTrack3 = buf[7 - offset];
            int m_iTrack1_A = 0;
            int m_iTrack2_A = 0;
            int m_iTrack3_A = 0;
            cData.cardType = buf[3 - offset] == -128 ? ReaderInfo.CAPTURE_ENCODE_TYPE.CAPTURE_ENCODE_TYPE_ISOABA : (buf[3 - offset] == -127 ? ReaderInfo.CAPTURE_ENCODE_TYPE.CAPTURE_ENCODE_TYPE_AAMVA : (buf[3 - offset] == -124 ? ReaderInfo.CAPTURE_ENCODE_TYPE.CAPTURE_ENCODE_TYPE_Raw : (buf[3 - offset] == -123 || buf[3 - offset] == -122 ? ReaderInfo.CAPTURE_ENCODE_TYPE.CAPTURE_ENCODE_TYPE_JisI_II : ReaderInfo.CAPTURE_ENCODE_TYPE.CAPTURE_ENCODE_TYPE_Other)));
            byte m_bCheck = buf[4 - offset];
            int b = 0;
            int b2 = 0;
            int bCode = 0;
            b = m_bCheck & 8;
            b2 = m_bCheck & 1;
            if (b == 8) {
                bCode = b2 == 1 ? (bCode |= 0) : (bCode |= 1);
            }
            b = m_bCheck & 0x10;
            b2 = m_bCheck & 2;
            if (b == 16) {
                bCode = b2 == 2 ? (bCode |= 0) : (bCode |= 2);
            }
            b = m_bCheck & 0x20;
            b2 = m_bCheck & 4;
            if (b == 32) {
                bCode = b2 == 4 ? (bCode |= 0) : (bCode |= 4);
            }
            cData.captureEncodeStatus = (byte)bCode;
            if (bCode != 0) {
                cData.event = ReaderInfo.EVENT_MSR_Types.EVENT_MSR_DATA_ERROR;
            }
            m_iTrack1_A = m_iTrack1;
            m_iTrack2_A = m_iTrack2;
            m_iTrack3_A = m_iTrack3;
            m_bCheck = buf[8 - offset];
            cData.iccPresent = (m_bCheck & 0x20) == 32;
            b = m_bCheck & 1;
            if (b != 1) {
                m_iTrack1 = 0;
            }
            if ((b = m_bCheck & 2) != 2) {
                m_iTrack2 = 0;
            }
            if ((b = m_bCheck & 4) != 4) {
                m_iTrack3 = 0;
            }
            cData.track1Length = m_iTrack1;
            cData.track2Length = m_iTrack2;
            cData.track3Length = m_iTrack3;
            if (length < 10 + m_iTrack1 + m_iTrack2 + m_iTrack3) {
                return;
            }
            byte[] m_tTrack1 = new byte[m_iTrack1];
            byte[] m_tTrack2 = new byte[m_iTrack2];
            byte[] m_tTrack3 = new byte[m_iTrack3];
            cData.track1 = "";
            cData.track2 = "";
            cData.track3 = "";
            cData.serialNumber = new byte[0];
            i = 0;
            while (i < m_iTrack1) {
                m_tTrack1[i] = buf[10 + i - offset];
                ++i;
            }
            cData.track1 = Common.byteToString(m_tTrack1);
            if (m_iTrack1 > 0) {
                if (cData.cardType == ReaderInfo.CAPTURE_ENCODE_TYPE.CAPTURE_ENCODE_TYPE_ISOABA) {
                    ParseData.parseTrack1(m_tTrack1);
                }
                if (cData.cardType == ReaderInfo.CAPTURE_ENCODE_TYPE.CAPTURE_ENCODE_TYPE_Raw) {
                    ParseData.parseAAMVATrack1(m_tTrack1);
                }
            }
            i = 0;
            while (i < m_iTrack2) {
                m_tTrack2[i] = buf[10 + m_iTrack1 + i - offset];
                ++i;
            }
            cData.track2 = Common.byteToString(m_tTrack2);
            if (m_iTrack2 > 0) {
                if (cData.cardType == ReaderInfo.CAPTURE_ENCODE_TYPE.CAPTURE_ENCODE_TYPE_ISOABA) {
                    ParseData.parseTrack2(m_tTrack2);
                }
                if (cData.cardType == ReaderInfo.CAPTURE_ENCODE_TYPE.CAPTURE_ENCODE_TYPE_Raw) {
                    ParseData.parseAAMVATrack2(m_tTrack2);
                }
            }
            i = 0;
            while (i < m_iTrack3) {
                m_tTrack3[i] = buf[10 + m_iTrack1 + m_iTrack2 + i - offset];
                ++i;
            }
            cData.track3 = Common.byteToString(m_tTrack3);
            m_bCheck = buf[8 - offset];
            b = m_bCheck & 0x10;
            cData.captureEncryptType = b == 0 ? ReaderInfo.CAPTURE_ENCRYPT_TYPE.CAPTURE_ENCRYPT_TYPE_TDES : ReaderInfo.CAPTURE_ENCRYPT_TYPE.CAPTURE_ENCRYPT_TYPE_AES;
            m_bCheck = buf[9 - offset];
            b = m_bCheck & 7;
            int m_ifLen = 10 + m_iTrack1 + m_iTrack2 + m_iTrack3;
            if (b > 0) {
                int m_iTrack1EL = 0;
                int m_iTrack2EL = 0;
                int m_iTrack3EL = 0;
                b = m_bCheck & 1;
                if (b == 1) {
                    m_iTrack1EL = cData.captureEncryptType == ReaderInfo.CAPTURE_ENCRYPT_TYPE.CAPTURE_ENCRYPT_TYPE_TDES ? (m_iTrack1_A % 8 == 0 ? m_iTrack1_A : 8 * (m_iTrack1_A / 8 + 1)) : (m_iTrack1_A % 16 == 0 ? m_iTrack1_A : 16 * (m_iTrack1_A / 16 + 1));
                }
                if ((b = m_bCheck & 2) == 2) {
                    m_iTrack2EL = cData.captureEncryptType == ReaderInfo.CAPTURE_ENCRYPT_TYPE.CAPTURE_ENCRYPT_TYPE_TDES ? (m_iTrack2_A % 8 == 0 ? m_iTrack2_A : 8 * (m_iTrack2_A / 8 + 1)) : (m_iTrack2_A % 16 == 0 ? m_iTrack2_A : 16 * (m_iTrack2_A / 16 + 1));
                }
                if ((b = m_bCheck & 4) == 4) {
                    m_iTrack3EL = cData.captureEncryptType == ReaderInfo.CAPTURE_ENCRYPT_TYPE.CAPTURE_ENCRYPT_TYPE_TDES ? (m_iTrack3_A % 8 == 0 ? m_iTrack3_A : 8 * (m_iTrack3_A / 8 + 1)) : (m_iTrack3_A % 16 == 0 ? m_iTrack3_A : 16 * (m_iTrack3_A / 16 + 1));
                }
                if (length > m_ifLen + m_iTrack1EL + m_iTrack2EL + m_iTrack3EL) {
                    cData.encTrack1 = new byte[m_iTrack1EL];
                    i = 0;
                    while (i < m_iTrack1EL) {
                        cData.encTrack1[i] = buf[m_ifLen + i - offset];
                        ++i;
                    }
                    m_ifLen += m_iTrack1EL;
                    cData.encTrack2 = new byte[m_iTrack2EL];
                    i = 0;
                    while (i < m_iTrack2EL) {
                        cData.encTrack2[i] = buf[m_ifLen + i - offset];
                        ++i;
                    }
                    m_ifLen += m_iTrack2EL;
                    cData.encTrack3 = new byte[m_iTrack3EL];
                    i = 0;
                    while (i < m_iTrack3EL) {
                        cData.encTrack3[i] = buf[m_ifLen + i - offset];
                        ++i;
                    }
                    m_ifLen += m_iTrack3EL;
                    int m_iHash1 = 0;
                    int m_iHash2 = 0;
                    int m_iHash3 = 0;
                    b = m_bCheck & 8;
                    if (b == 8) {
                        m_iHash1 = 20;
                    }
                    if ((b = m_bCheck & 0x10) == 16) {
                        m_iHash2 = 20;
                    }
                    if ((b = m_bCheck & 0x20) == 32) {
                        m_iHash3 = 20;
                    }
                    m_ifLen = m_ifLen + m_iHash1 + m_iHash2 + m_iHash3;
                    b = buf[8 - offset] & 0x80;
                    if (b == 128) {
                        byte[] slice = Arrays.copyOfRange(buf, m_ifLen - offset, m_ifLen - offset + 10);
                        cData.serialNumber = slice;
                        m_ifLen += 10;
                    } else {
                        cData.serialNumber = new byte[0];
                    }
                    b = m_bCheck & 0x80;
                    if (b == 128) {
                        if (length > m_ifLen + 10) {
                            cData.KSN = new byte[10];
                            i = 0;
                            while (i < 10) {
                                cData.KSN[i] = buf[m_ifLen + i - offset];
                                ++i;
                            }
                        } else {
                            cData.KSN = new byte[0];
                            bCode = cData.captureEncodeStatus;
                            cData.captureEncodeStatus = (byte)(bCode |= 0x40);
                        }
                    } else {
                        cData.KSN = new byte[0];
                    }
                } else {
                    cData.KSN = new byte[0];
                    cData.encTrack1 = new byte[0];
                    cData.encTrack2 = new byte[0];
                    cData.encTrack3 = new byte[0];
                    bCode = cData.captureEncodeStatus;
                    if (m_ifLen + m_iTrack1EL > length) {
                        bCode |= 8;
                    }
                    if (m_ifLen + m_iTrack1EL + m_iTrack2EL > length) {
                        bCode |= 0x10;
                    }
                    if (m_ifLen + m_iTrack1EL + m_iTrack2EL + m_iTrack3EL > length) {
                        bCode |= 0x20;
                    }
                    cData.captureEncodeStatus = (byte)bCode;
                }
            } else {
                b = buf[5] & 0x80;
                if (b == 128) {
                    byte[] slice = Arrays.copyOfRange(buf, m_ifLen - offset, m_ifLen - offset + 10);
                    cData.serialNumber = slice;
                    m_ifLen += 10;
                }
                if ((b = m_bCheck & 0x80) == 128) {
                    if (length > m_ifLen + 10) {
                        cData.KSN = new byte[10];
                        i = 0;
                        while (i < 10) {
                            cData.KSN[i] = buf[m_ifLen + i - offset];
                            ++i;
                        }
                    } else {
                        cData.KSN = new byte[0];
                        bCode = cData.captureEncodeStatus;
                        cData.captureEncodeStatus = (byte)(bCode |= 0x40);
                    }
                }
            }
            byte cfr_ignored_0 = cData.captureEncodeStatus;
        }

        public static void parseCardDataAugusta(byte[] buf, IDTMSRData cData) {
            if (buf == null || buf.length == 0) {
                return;
            }
            int dataIndex = 13;
            int lengthIdx = 7;
            if (buf.length > 10 && buf[3] != 6) {
                Common.parseCardData3in1(buf, cData);
            } else if (buf.length > 16) {
                cData.rawTrackData = new byte[buf.length - 16];
                System.arraycopy(buf, 13, cData.rawTrackData, 0, cData.rawTrackData.length);
                byte status = buf[5];
                if ((buf[status == 7 ? 7 : 8] & 0xFFFFFF80) == -128) {
                    byte[] buf1 = new byte[status == 7 ? buf.length - 4 : buf.length - 5];
                    int dataLen = buf1.length - 6;
                    buf1[0] = 2;
                    buf1[1] = (byte)(dataLen & 0xFF);
                    buf1[2] = (byte)(dataLen >> 8 & 0xFF);
                    System.arraycopy(buf, status == 7 ? 7 : 8, buf1, 3, buf1.length - 6);
                    byte[] buf2 = new byte[buf1.length - 6];
                    System.arraycopy(buf, status == 7 ? 7 : 8, buf1, 3, buf1.length - 6);
                    System.arraycopy(buf, status == 7 ? 7 : 8, buf2, 0, buf2.length);
                    String strData = Common.base16Encode(buf2);
                    String sum = Common.getSUM(strData.substring(6));
                    String lrc = Common.getLRC(strData.substring(6));
                    byte[] b = null;
                    b = Common.getBytesFromHexString(lrc);
                    buf1[buf1.length - 3] = b == null ? (byte)0 : b[0];
                    b = Common.getBytesFromHexString(sum);
                    buf1[buf1.length - 2] = b == null ? (byte)0 : b[0];
                    buf1[buf1.length - 1] = 3;
                    Common.parseCardData3in1(buf1, cData);
                } else {
                    byte[] temp;
                    if (buf[4] == 0 && buf[5] == 7) {
                        dataIndex = 14;
                        lengthIdx = 9;
                    } else if (buf[4] == 0 && buf[5] == 17) {
                        dataIndex = 15;
                        lengthIdx = 10;
                    }
                    cData.captureEncryptType = ReaderInfo.CAPTURE_ENCRYPT_TYPE.CAPTURE_ENCRYPT_TYPE_NONE;
                    cData.cardData = new byte[buf.length];
                    System.arraycopy(buf, 0, cData.cardData, 0, cData.cardData.length);
                    cData.isCTLS = false;
                    cData.track1Length = buf[lengthIdx] & 0xFF;
                    cData.track2Length = buf[lengthIdx + 1] & 0xFF;
                    cData.track3Length = buf[lengthIdx + 2] & 0xFF;
                    cData.cardDataFlag = buf[lengthIdx + 3];
                    if (cData.track1Length > 0) {
                        temp = new byte[cData.track1Length];
                        System.arraycopy(buf, dataIndex, temp, 0, cData.track1Length);
                        cData.track1 = Common.byteToString(temp);
                        if (buf[dataIndex += cData.track1Length] == 13) {
                            ++dataIndex;
                        }
                    }
                    if (cData.track2Length > 0) {
                        temp = new byte[cData.track2Length];
                        System.arraycopy(buf, dataIndex, temp, 0, cData.track2Length);
                        cData.track2 = Common.byteToString(temp);
                        String[] t2s = cData.track2.split("=");
                        if (t2s.length > 1) {
                            String tsr = t2s[1];
                            char cs = tsr.charAt(4);
                            boolean bl = cData.iccPresent = cs == '2' || cs == '6';
                        }
                        if (buf[dataIndex += cData.track2Length] == 13) {
                            ++dataIndex;
                        }
                    }
                    if (cData.track3Length > 0) {
                        temp = new byte[cData.track3Length];
                        System.arraycopy(buf, dataIndex, temp, 0, cData.track3Length);
                        cData.track3 = Common.byteToString(temp);
                    }
                }
            }
            cData.event = ReaderInfo.EVENT_MSR_Types.EVENT_MSR_CARD_DATA;
        }

        public static void parseCardDataUniPay(byte[] buf, IDTMSRData cData) {
            PostCardDataParse ParsData = new PostCardDataParse();
            int length = buf.length;
            int i = 0;
            cData.cardData = new byte[length];
            System.arraycopy(buf, 0, cData.cardData, 0, length);
            cData.rawTrackData = new byte[length];
            System.arraycopy(buf, 0, cData.rawTrackData, 0, length);
            cData.event = ReaderInfo.EVENT_MSR_Types.EVENT_MSR_CARD_DATA;
            int m_iTrack1 = buf[6];
            int m_iTrack2 = buf[7];
            int m_iTrack3 = buf[8];
            int m_iTrack1_A = 0;
            int m_iTrack2_A = 0;
            int m_iTrack3_A = 0;
            cData.cardType = buf[4] == -128 ? ReaderInfo.CAPTURE_ENCODE_TYPE.CAPTURE_ENCODE_TYPE_ISOABA : (buf[4] == -127 ? ReaderInfo.CAPTURE_ENCODE_TYPE.CAPTURE_ENCODE_TYPE_AAMVA : (buf[4] == -124 ? ReaderInfo.CAPTURE_ENCODE_TYPE.CAPTURE_ENCODE_TYPE_Raw : (buf[4] == -123 || buf[4] == -122 ? ReaderInfo.CAPTURE_ENCODE_TYPE.CAPTURE_ENCODE_TYPE_JisI_II : ReaderInfo.CAPTURE_ENCODE_TYPE.CAPTURE_ENCODE_TYPE_Other)));
            byte m_bCheck = buf[5];
            int b = 0;
            int b2 = 0;
            int bCode = 0;
            b = m_bCheck & 8;
            b2 = m_bCheck & 1;
            if (b == 8) {
                bCode = b2 == 1 ? (bCode |= 0) : (bCode |= 1);
            }
            b = m_bCheck & 0x10;
            b2 = m_bCheck & 2;
            if (b == 16) {
                bCode = b2 == 2 ? (bCode |= 0) : (bCode |= 2);
            }
            b = m_bCheck & 0x20;
            b2 = m_bCheck & 4;
            if (b == 32) {
                bCode = b2 == 4 ? (bCode |= 0) : (bCode |= 4);
            }
            cData.captureEncodeStatus = (byte)bCode;
            if (bCode != 0) {
                cData.event = ReaderInfo.EVENT_MSR_Types.EVENT_MSR_DATA_ERROR;
            }
            m_iTrack1_A = m_iTrack1;
            m_iTrack2_A = m_iTrack2;
            m_iTrack3_A = m_iTrack3;
            m_bCheck = buf[9];
            cData.iccPresent = (m_bCheck & 0x20) == 32;
            b = m_bCheck & 1;
            if (b != 1) {
                m_iTrack1 = 0;
            }
            if ((b = m_bCheck & 2) != 2) {
                m_iTrack2 = 0;
            }
            if ((b = m_bCheck & 4) != 4) {
                m_iTrack3 = 0;
            }
            cData.track1Length = m_iTrack1;
            cData.track2Length = m_iTrack2;
            cData.track3Length = m_iTrack3;
            if (length < 11 + m_iTrack1 + m_iTrack2 + m_iTrack3) {
                return;
            }
            byte[] m_tTrack1 = new byte[m_iTrack1];
            byte[] m_tTrack2 = new byte[m_iTrack2];
            byte[] m_tTrack3 = new byte[m_iTrack3];
            cData.track1 = "";
            cData.track2 = "";
            cData.track3 = "";
            cData.serialNumber = new byte[0];
            i = 0;
            while (i < m_iTrack1) {
                m_tTrack1[i] = buf[11 + i];
                ++i;
            }
            cData.track1 = Common.byteToString(m_tTrack1);
            if (m_iTrack1 > 0) {
                if (cData.cardType == ReaderInfo.CAPTURE_ENCODE_TYPE.CAPTURE_ENCODE_TYPE_ISOABA) {
                    ParsData.parseTrack1(m_tTrack1);
                }
                if (cData.cardType == ReaderInfo.CAPTURE_ENCODE_TYPE.CAPTURE_ENCODE_TYPE_Raw) {
                    ParsData.parseAAMVATrack1(m_tTrack1);
                }
            }
            i = 0;
            while (i < m_iTrack2) {
                m_tTrack2[i] = buf[11 + m_iTrack1 + i];
                ++i;
            }
            cData.track2 = Common.byteToString(m_tTrack2);
            if (m_iTrack2 > 0) {
                if (cData.cardType == ReaderInfo.CAPTURE_ENCODE_TYPE.CAPTURE_ENCODE_TYPE_ISOABA) {
                    ParsData.parseTrack2(m_tTrack2);
                }
                if (cData.cardType == ReaderInfo.CAPTURE_ENCODE_TYPE.CAPTURE_ENCODE_TYPE_Raw) {
                    ParsData.parseAAMVATrack2(m_tTrack2);
                }
            }
            i = 0;
            while (i < m_iTrack3) {
                m_tTrack3[i] = buf[11 + m_iTrack1 + m_iTrack2 + i];
                ++i;
            }
            cData.track3 = Common.byteToString(m_tTrack3);
            m_bCheck = buf[0];
            b = m_bCheck & 2;
            cData.captureEncryptType = b == 0 ? ReaderInfo.CAPTURE_ENCRYPT_TYPE.CAPTURE_ENCRYPT_TYPE_TDES : ReaderInfo.CAPTURE_ENCRYPT_TYPE.CAPTURE_ENCRYPT_TYPE_AES;
            m_bCheck = buf[10];
            b = m_bCheck & 7;
            int m_ifLen = 11 + m_iTrack1 + m_iTrack2 + m_iTrack3;
            if (b > 0) {
                int m_iTrack1EL = 0;
                int m_iTrack2EL = 0;
                int m_iTrack3EL = 0;
                b = m_bCheck & 1;
                if (b == 1) {
                    m_iTrack1EL = cData.captureEncryptType == ReaderInfo.CAPTURE_ENCRYPT_TYPE.CAPTURE_ENCRYPT_TYPE_TDES ? (m_iTrack1_A % 8 == 0 ? m_iTrack1_A : 8 * (m_iTrack1_A / 8 + 1)) : (m_iTrack1_A % 16 == 0 ? m_iTrack1_A : 16 * (m_iTrack1_A / 16 + 1));
                }
                if ((b = m_bCheck & 2) == 2) {
                    m_iTrack2EL = cData.captureEncryptType == ReaderInfo.CAPTURE_ENCRYPT_TYPE.CAPTURE_ENCRYPT_TYPE_TDES ? (m_iTrack2_A % 8 == 0 ? m_iTrack2_A : 8 * (m_iTrack2_A / 8 + 1)) : (m_iTrack2_A % 16 == 0 ? m_iTrack2_A : 16 * (m_iTrack2_A / 16 + 1));
                }
                if ((b = m_bCheck & 4) == 4) {
                    m_iTrack3EL = cData.captureEncryptType == ReaderInfo.CAPTURE_ENCRYPT_TYPE.CAPTURE_ENCRYPT_TYPE_TDES ? (m_iTrack3_A % 8 == 0 ? m_iTrack3_A : 8 * (m_iTrack3_A / 8 + 1)) : (m_iTrack3_A % 16 == 0 ? m_iTrack3_A : 16 * (m_iTrack3_A / 16 + 1));
                }
                if (length > m_ifLen + m_iTrack1EL + m_iTrack2EL + m_iTrack3EL) {
                    cData.encTrack1 = new byte[m_iTrack1EL];
                    i = 0;
                    while (i < m_iTrack1EL) {
                        cData.encTrack1[i] = buf[m_ifLen + i];
                        ++i;
                    }
                    m_ifLen += m_iTrack1EL;
                    cData.encTrack2 = new byte[m_iTrack2EL];
                    i = 0;
                    while (i < m_iTrack2EL) {
                        cData.encTrack2[i] = buf[m_ifLen + i];
                        ++i;
                    }
                    m_ifLen += m_iTrack2EL;
                    cData.encTrack3 = new byte[m_iTrack3EL];
                    i = 0;
                    while (i < m_iTrack3EL) {
                        cData.encTrack3[i] = buf[m_ifLen + i];
                        ++i;
                    }
                    m_ifLen += m_iTrack3EL;
                    int m_iHash1 = 0;
                    int m_iHash2 = 0;
                    int m_iHash3 = 0;
                    b = m_bCheck & 8;
                    if (b == 8) {
                        m_iHash1 = 20;
                    }
                    if ((b = m_bCheck & 0x10) == 16) {
                        m_iHash2 = 20;
                    }
                    if ((b = m_bCheck & 0x20) == 32) {
                        m_iHash3 = 20;
                    }
                    m_ifLen = m_ifLen + m_iHash1 + m_iHash2 + m_iHash3;
                    b = buf[9] & 0x80;
                    if (b == 128) {
                        byte[] slice = Arrays.copyOfRange(buf, m_ifLen, m_ifLen + 10);
                        cData.serialNumber = slice;
                        m_ifLen += 10;
                    } else {
                        cData.serialNumber = new byte[0];
                    }
                    b = m_bCheck & 0x80;
                    if (b == 128) {
                        if (length > m_ifLen + 10) {
                            cData.KSN = new byte[10];
                            i = 0;
                            while (i < 10) {
                                cData.KSN[i] = buf[m_ifLen + i];
                                ++i;
                            }
                        } else {
                            cData.KSN = new byte[0];
                            bCode = cData.captureEncodeStatus;
                            cData.captureEncodeStatus = (byte)(bCode |= 0x40);
                        }
                    } else {
                        cData.KSN = new byte[0];
                    }
                } else {
                    cData.KSN = new byte[0];
                    cData.encTrack1 = new byte[0];
                    cData.encTrack2 = new byte[0];
                    cData.encTrack3 = new byte[0];
                    bCode = cData.captureEncodeStatus;
                    if (m_ifLen + m_iTrack1EL > length) {
                        bCode |= 8;
                    }
                    if (m_ifLen + m_iTrack1EL + m_iTrack2EL > length) {
                        bCode |= 0x10;
                    }
                    if (m_ifLen + m_iTrack1EL + m_iTrack2EL + m_iTrack3EL > length) {
                        bCode |= 0x20;
                    }
                    cData.captureEncodeStatus = (byte)bCode;
                }
            } else {
                b = buf[8] & 0x80;
                if (b == 128) {
                    byte[] slice = Arrays.copyOfRange(buf, m_ifLen, m_ifLen + 10);
                    cData.serialNumber = slice;
                    m_ifLen += 10;
                }
                if ((b = m_bCheck & 0x80) == 128) {
                    if (length > m_ifLen + 10) {
                        cData.KSN = new byte[10];
                        i = 0;
                        while (i < 10) {
                            cData.KSN[i] = buf[m_ifLen + i];
                            ++i;
                        }
                    } else {
                        cData.KSN = new byte[0];
                        bCode = cData.captureEncodeStatus;
                        cData.captureEncodeStatus = (byte)(bCode |= 0x40);
                    }
                }
            }
            byte cfr_ignored_0 = cData.captureEncodeStatus;
        }
    }
}

