/*
 * Decompiled with CFR 0.152.
 */
package com.idtechproducts.device.audiojack.io;

import android.media.AudioTrack;
import com.idtechproducts.device.Common;
import com.idtechproducts.device.audiojack.io.PlayerAudioTrack;
import java.math.BigInteger;

public class UniPayIIICommandEncoder
extends PlayerAudioTrack {
    static final int kAUDIO_CHANNEL = 12;
    static final int kAUDIO_ENCODING = 3;

    public AudioTrack getCommandAudioTrack(byte[] commandString) {
        byte[] cmdStream;
        short outputWaveDirection = this.config.getDirectionOutputWave();
        short powerupBeforeCmd = this.config.getPowerupLastBeforeCMD();
        int outputSampleRate = 48000;
        String cmdStr = Common.getHexStringFromBytes(commandString);
        String cmdBinStringToSend = this.binStringToCmdBinString(this.hexToBin(cmdStr));
        if (commandString != null) {
            cmdStream = commandString.length == 1 && commandString[0] == 0 ? this.createCommunicationWaveForSwipe(outputWaveDirection, outputSampleRate, powerupBeforeCmd) : (commandString.length == 1 && commandString[0] == 5 ? this.createCommunicationWaveForCancelSwipe(outputWaveDirection, outputSampleRate, powerupBeforeCmd) : this.createCommunicationWave(cmdBinStringToSend, outputWaveDirection, outputSampleRate, powerupBeforeCmd));
        } else {
            return null;
        }
        AudioTrack ret = new AudioTrack(3, outputSampleRate, 12, 3, cmdStream.length, 0);
        if (ret.write(cmdStream, 0, cmdStream.length) != cmdStream.length) {
            ret.release();
            throw new RuntimeException();
        }
        if (ret.getState() != 1) {
            throw new RuntimeException();
        }
        return ret;
    }

    private byte[] createCommunicationWaveForSwipe(int outputWaveDirection, int outputFrequency, int delay) {
        int outputLengthInMs = 1000;
        int cycleLength = outputFrequency / 1000 * 2;
        int totalLength = cycleLength * outputLengthInMs;
        totalLength = totalLength / cycleLength * cycleLength;
        byte[] ret = new byte[totalLength];
        int H = -1;
        int M = -128;
        int L = 1;
        if (outputWaveDirection == 0) {
            H = 1;
            L = -1;
        }
        int i = 0;
        while (i < totalLength) {
            int j = 0;
            while (j < cycleLength) {
                if (j < cycleLength / 2) {
                    if (j == 0) {
                        ret[i + j] = M;
                        ret[i + j + 1] = M;
                    } else {
                        ret[i + j] = H;
                        ret[i + j + 1] = H;
                    }
                } else if (j == cycleLength / 2) {
                    ret[i + j] = M;
                    ret[i + j + 1] = M;
                } else {
                    ret[i + j] = L;
                    ret[i + j + 1] = L;
                }
                j += 2;
            }
            i += cycleLength;
        }
        return ret;
    }

    private byte[] createCommunicationWaveForCancelSwipe(int outputWaveDirection, int outputFrequency, int delay) {
        int cycleLength = 12;
        int totalLength = 480000;
        byte[] ret = new byte[totalLength];
        int H = -1;
        int M = -128;
        int L = 1;
        if (outputWaveDirection == 0) {
            H = 1;
            L = -1;
        }
        int i = 0;
        while (i < totalLength) {
            int j = 0;
            while (j < cycleLength) {
                if (j < cycleLength / 2) {
                    if (j == 0) {
                        ret[i + j] = M;
                        ret[i + j + 1] = M;
                    } else {
                        ret[i + j] = H;
                        ret[i + j + 1] = H;
                    }
                } else if (j == cycleLength / 2) {
                    ret[i + j] = M;
                    ret[i + j + 1] = M;
                } else {
                    ret[i + j] = L;
                    ret[i + j + 1] = L;
                }
                j += 2;
            }
            i += cycleLength;
        }
        return ret;
    }

    private byte[] createCommunicationWave(String strData, int outputWaveDirection, int outputFrequency, int delay) {
        byte H = -1;
        int M = -128;
        byte L = 1;
        if (outputWaveDirection == 0) {
            H = 1;
            L = -1;
        }
        int samplesPerMs = outputFrequency / 1000 * 2;
        int delayLength = 0;
        int squareWaveLength = samplesPerMs * 100;
        int pauseLength = samplesPerMs * 200;
        int delayEndLength = samplesPerMs * 20;
        int commandLength = strData.length() * 10 + 2 + delayEndLength;
        byte[] realBuffer = new byte[delayLength + squareWaveLength + pauseLength + commandLength];
        int i = 0;
        while (i < delayLength) {
            realBuffer[i] = M;
            ++i;
        }
        i = delayLength;
        while (i < squareWaveLength + delayLength) {
            int j = 0;
            while (j < 48) {
                if (j < 24) {
                    if (j == 0) {
                        realBuffer[i + j] = M;
                        realBuffer[i + j + 1] = M;
                    } else {
                        realBuffer[i + j] = H;
                        realBuffer[i + j + 1] = H;
                    }
                } else if (j == 24) {
                    realBuffer[i + j] = M;
                    realBuffer[i + j + 1] = M;
                } else {
                    realBuffer[i + j] = L;
                    realBuffer[i + j + 1] = L;
                }
                j += 2;
            }
            i += 48;
        }
        i = delayLength + squareWaveLength;
        while (i < delayLength + squareWaveLength + pauseLength) {
            realBuffer[i] = M;
            ++i;
        }
        byte[] actualCmd = new byte[commandLength];
        int k = 0;
        while (k < 10) {
            actualCmd[k] = H;
            ++k;
        }
        int i2 = 1;
        while (i2 < strData.length()) {
            int k2;
            if (strData.charAt(i2) == '0') {
                if (actualCmd[i2 * 10 - 1] == H) {
                    actualCmd[i2 * 10] = H;
                    actualCmd[i2 * 10 + 1] = H;
                } else if (actualCmd[i2 * 10 - 1] == L) {
                    actualCmd[i2 * 10] = M;
                    actualCmd[i2 * 10 + 1] = M;
                }
                k2 = i2 * 10 + 2;
                while (k2 < i2 * 10 + 10) {
                    actualCmd[k2] = H;
                    ++k2;
                }
            } else if (strData.charAt(i2) == '1') {
                if (actualCmd[i2 * 10 - 1] == L) {
                    actualCmd[i2 * 10] = L;
                    actualCmd[i2 * 10 + 1] = L;
                } else if (actualCmd[i2 * 10 - 1] == H) {
                    actualCmd[i2 * 10] = M;
                    actualCmd[i2 * 10 + 1] = M;
                }
                k2 = i2 * 10 + 2;
                while (k2 < i2 * 10 + 10) {
                    actualCmd[k2] = L;
                    ++k2;
                }
            }
            ++i2;
        }
        i2 = actualCmd.length - delayEndLength - 2;
        while (i2 < actualCmd.length) {
            actualCmd[i2] = L;
            ++i2;
        }
        System.arraycopy(actualCmd, 0, realBuffer, delayLength + squareWaveLength + pauseLength, commandLength);
        return realBuffer;
    }

    private String binStringToCmdBinString(String binString) {
        String result = "";
        int i = 0;
        while (i < binString.length()) {
            String str = "0";
            int j = i + 3;
            while (j >= i) {
                if (binString.charAt(j) == '0') {
                    str = String.valueOf(str) + "10";
                } else if (binString.charAt(j) == '1') {
                    str = String.valueOf(str) + "01";
                }
                --j;
            }
            str = String.valueOf(str) + "1";
            result = String.valueOf(result) + str;
            i += 4;
        }
        return result;
    }

    private String hexToBin(String s) {
        String result = "";
        int i = 0;
        while (i < s.length() / 2) {
            String singleByte = new BigInteger(s.substring(i * 2, i * 2 + 2), 16).toString(2);
            while (singleByte.length() < 8) {
                singleByte = "0" + singleByte;
            }
            result = String.valueOf(result) + singleByte;
            ++i;
        }
        return result;
    }
}

