/*
 * Decompiled with CFR 0.152.
 */
package com.idtechproducts.device.audiojack.tasks;

import android.os.Handler;
import android.os.Looper;
import com.idtechproducts.device.OnReceiverListener;
import com.idtechproducts.device.StructConfigParameters;
import com.idtechproducts.device.audiojack.ReaderCommunication;
import com.idtechproducts.device.audiojack.UMLog;
import com.idtechproducts.device.audiojack.io.IOManager;
import com.idtechproducts.device.audiojack.io.TonePlayer;
import com.idtechproducts.device.audiojack.io.ToneType;
import com.idtechproducts.device.audiojack.tasks.TaskManager;
import java.util.List;

public abstract class Task
implements IOManager.ICancel,
IOManager.ResponseProcessor,
Runnable {
    protected final ReaderCommunication _readerCommunication;
    protected OnReceiverListener _umrMsg = null;
    protected IOManager _ioManager = null;
    protected final TonePlayer _tonePlayer;
    protected StructConfigParameters _config = null;
    protected final TaskManager _taskManager;
    protected final String TAG;
    private volatile boolean a = false;
    private final Object b = new Object();
    private ToneType c;

    protected Task(TaskManager taskManager, ReaderCommunication readerCommunication) {
        this._readerCommunication = readerCommunication;
        if (this._readerCommunication != null) {
            this._umrMsg = this._readerCommunication.getIntern_uniMagReaderMsg();
            this._ioManager = this._readerCommunication.getIntern_IOManager();
            this._config = this._readerCommunication.getIntern_StructConfigParameters();
        }
        this._tonePlayer = this._ioManager != null ? this._ioManager.getTonePlayer() : null;
        this._taskManager = taskManager;
        this.TAG = String.valueOf(this.getType().name()) + "Task";
    }

    public void cancel() {
        this.a = true;
        if (this._ioManager != null) {
            this._ioManager.notifyIoManager();
        }
        Object object = this.b;
        synchronized (object) {
            this.b.notify();
            return;
        }
    }

    @Override
    public boolean isCanceled() {
        return this.a;
    }

    protected boolean safeWait(double d2) {
        long l = (long)(d2 * 1000.0);
        long l2 = System.currentTimeMillis();
        try {
            Object object = this.b;
            synchronized (object) {
                this.b.wait(l);
            }
        }
        catch (InterruptedException interruptedException) {}
        long l3 = System.currentTimeMillis();
        boolean bl = l3 - l2 < l;
        return bl;
    }

    @Override
    public boolean processResponse(List<byte[]> list) {
        return true;
    }

    @Override
    public void processSound() {
    }

    protected void tone_saveAndStop() {
        if (this._tonePlayer != null) {
            this.c = this._tonePlayer.getPlayingTone();
            this._tonePlayer.setPlayingTone(null);
        }
    }

    protected void tone_restore() {
        if (this._tonePlayer != null) {
            this._tonePlayer.setPlayingTone(this.c);
        }
    }

    protected void post(Runnable runnable) {
        Handler handler = new Handler(Looper.getMainLooper());
        handler.post(runnable);
    }

    @Override
    public void run() {
        UMLog.i(this.TAG, "started");
        if (!this.taskSetup()) {
            return;
        }
        Runnable runnable = this.taskMain();
        this.taskCleanup();
        this._taskManager.task_signalStoppedStatus();
        UMLog.i(this.TAG, "stopped");
        if (runnable != null) {
            runnable.run();
        }
    }

    public abstract TaskManager.TaskType getType();

    protected boolean taskSetup() {
        this.tone_saveAndStop();
        return true;
    }

    protected void taskCleanup() {
        if (this._ioManager != null) {
            this._ioManager.notifyTaskFinished();
        }
        UMLog.i(this.TAG, "taskCleanup ok.");
    }

    protected abstract Runnable taskMain();
}

