/********* PaymentSDKPluginIOS.m Cordova Plugin Implementation *******/

#import <Cordova/CDV.h>
#import <PaymentSDK/PaymentSDK-Swift.h>
#import <PaymentSDK/IDTechWrapper.h>
#import <Foundation/Foundation.h>
#import <Foundation/NSURLSession.h>
#import <CommonCrypto/CommonHMAC.h>

@interface PaymentSDKPluginIOS <EMVUIDelegate> : CDVPlugin{
    CDVInvokedUrlCommand* globalCallback;
    CDVInvokedUrlCommand* deviceScanCallback;
    CDVInvokedUrlCommand* deviceConnectionCallback;
    CDVInvokedUrlCommand* transactionCallback;
    CDVPluginResult* pluginResult;
    RestServiceClient* restClient;
    TransactionActionOBJC transactionAction;
    EMVTransaction* emvTransaction;
    DeviceTypeOBJC deviceType;
    NSMutableDictionary* payload;
    NSString* transactionId;
    NSString* connectingDevice;
}
@end

@implementation PaymentSDKPluginIOS

- (NSString*)setup:(NSString*) userInputs {
    @try {
        NSError* __autoreleasing  _Nullable * _Nullable jsonError = NULL;
        NSData* data = [userInputs dataUsingEncoding:NSUTF8StringEncoding];
        NSDictionary* jsonData = [NSJSONSerialization JSONObjectWithData:data options:NSJSONReadingMutableContainers error:jsonError];
        NSDictionary* header = [jsonData objectForKey:@"header"];

        NSString* validStatus = [self validateAuthParameters:header];
        if(header && [validStatus isEqual: @"success"]) {
            restClient = [[RestServiceClient alloc] initWithApiProtocol:[header valueForKey:@"protocol"] apiHostName:[header valueForKey:@"hostname"] apiEndpointPath:[header valueForKey:@"apiEndpoint"]];
            NSMutableDictionary* headerParams = [NSMutableDictionary dictionary];
            
            if ([header objectForKey:@"developerId"]) {
                [headerParams setObject:[header valueForKey:@"developerId"] forKey:@"developer-id"];
            }
            if ([header objectForKey:@"userId"]) {
                [headerParams setObject:[header valueForKey:@"userId"] forKey:@"user-id"];
            }

            if([[header valueForKey:@"authType"] isEqual: @"apikey"]) {
                if ([header objectForKey:@"userAPIKey"]) {
                    [headerParams setObject:[header valueForKey:@"userAPIKey"] forKey:@"user-api-key"];
                }
            } else if([[header valueForKey:@"authType"] isEqual: @"hmac"]) {
                NSInteger timeInSeconds = [[NSDate date] timeIntervalSince1970];
                NSString* hmacData = [NSString stringWithFormat: @"%@%@", [header valueForKey:@"userId"], [NSString stringWithFormat:@"%ld", (long)timeInSeconds]];
                NSString* userHash = [self hmacForKeyAndData:[header valueForKey:@"userHashKey"] andHmacData:hmacData];
                [headerParams setObject:userHash forKey:@"hash-key"];
                [headerParams setObject:[NSString stringWithFormat:@"%ld", (long)timeInSeconds] forKey:@"timestamp"];
            } else if([[header valueForKey:@"authType"] isEqual: @"token"]) {
                if([header objectForKey:@"accessToken"]) {
                    [headerParams setObject:[header objectForKey:@"accessToken"] forKey:@"access-token"];
                } else {
                    __block NSData *tokenData = nil;
                    dispatch_semaphore_t semaphore = dispatch_semaphore_create(0);

                    NSString* url = [NSString stringWithFormat: @"%@://%@", [header valueForKey:@"protocol"], [header valueForKey:@"hostname"]];
                    url = [url stringByAppendingString:@"/v2/token"];
                    NSMutableURLRequest *urlRequest = [[NSMutableURLRequest alloc] initWithURL:[NSURL URLWithString:url]];
                    [urlRequest setValue:@"application/json" forHTTPHeaderField:@"Content-Type"];
                    [urlRequest setValue:@"application/json" forHTTPHeaderField:@"Accept"];
                    [urlRequest setValue:[header valueForKey:@"developerId"] forHTTPHeaderField:@"developer-id"];
                    
                    NSMutableDictionary* bodyParams = [NSMutableDictionary dictionary];
                    [bodyParams setObject:[header valueForKey:@"username"] forKey:@"username"];
                    [bodyParams setObject:[header valueForKey:@"password"] forKey:@"password"];
                    [bodyParams setObject:[header valueForKey:@"domain"] forKey:@"domain"];
                    NSError *error;
                    NSData *jsonData = [NSJSONSerialization dataWithJSONObject:bodyParams
                                                                    options:0
                                                                        error:&error];
                    //create the Method "GET" or "POST"
                    [urlRequest setHTTPMethod:@"POST"];

                    //Apply the data to the body
                    [urlRequest setHTTPBody:jsonData];

                    NSURLSession *session = [NSURLSession sharedSession];
                    NSURLSessionDataTask *dataTask = [session dataTaskWithRequest:urlRequest completionHandler:^(NSData *tokenData, NSURLResponse *response, NSError *error) {
                        NSHTTPURLResponse *httpResponse = (NSHTTPURLResponse *)response;
                        NSError *parseError = nil;
                        NSDictionary *responseDictionary = [NSJSONSerialization JSONObjectWithData:tokenData options:0 error:&parseError];
                        NSDictionary *tokenObj = [responseDictionary objectForKey:@"token"];
                        NSString *tokenStr = [tokenObj objectForKey:@"token"];
                        [headerParams setObject:tokenStr forKey:@"access-token"];
                        dispatch_semaphore_signal(semaphore);
                    }];
                    [dataTask resume];
                    dispatch_semaphore_wait(semaphore, DISPATCH_TIME_FOREVER);
                }
            }

            if ([header objectForKey:@"authType"]) {
                [headerParams setObject:[header valueForKey:@"authType"] forKey:@"authType"];
            }

            [restClient setHTTPRequestHeadersWithHeaderParams:headerParams];
            transactionId = [header valueForKey:@"transactionId"];
            if ([header objectForKey:@"deviceType"]) {
                NSString* type = [header valueForKey:@"deviceType"];
                deviceType = [self getOBJCDeviceType:type];
            } else {
                deviceType = [self getOBJCDeviceType:@"IDTECH-VP3300BT"];
            }
        } else {
            return validStatus;
        }

        payload = [jsonData objectForKey:@"body"];
        if(payload) {
            NSString* action = [payload valueForKey:@"action"];
            transactionAction = [self getOBJCTransactionAction:action];
        }
        emvTransaction = [[EMVTransaction alloc] initWithRestClient:restClient];
        emvTransaction.isPluginRequest = true;
        emvTransaction.pluginDelegate  = self;
        [emvTransaction setDeviceTypeOBJCWithDeviceType:deviceType];
        return @"success";
    }
    @catch (NSException *exception) {
        NSLog(@"%@", exception.reason);
        return exception.reason;
    }
}

- (NSString*) validateAuthParameters:(NSDictionary*) header {
    if([header objectForKey:@"protocol"] && [header objectForKey:@"hostname"] && [header objectForKey:@"apiEndpoint"]) {
        if([header objectForKey:@"authType"]) {
            NSString* authType = [header valueForKey:@"authType"];
            if([authType isEqual: @"token"]) {
                if([header objectForKey:@"developerId"] && (([header objectForKey:@"username"] && [header objectForKey:@"password"] && [header objectForKey:@"domain"]) || [header objectForKey:@"accessToken"])) {
                    return @"success";
                } else {
                    return @"Invalid Auth Parameters";
                }
            } else if([authType isEqual: @"hmac"]) {
                if([header objectForKey:@"developerId"] && [header objectForKey:@"userId"] && [header objectForKey:@"userHashKey"]) {
                    return @"success";
                } else {
                    return @"Invalid Auth Parameters";
                }
            } else if([authType isEqual: @"apikey"]) {
                if([header objectForKey:@"developerId"] && [header objectForKey:@"userId"] && [header objectForKey:@"userAPIKey"]) {
                    return @"success";
                } else {
                    return @"Invalid Auth Parameters";
                }
            } else {
                NSString* returnVal = @"Invalid Auth Type - ";
                returnVal = [returnVal stringByAppendingString:authType];
                return returnVal;
            }
        }
    }
    return @"Invalid API Details";
}

- (NSString*) hmacForKeyAndData:(NSString*) key andHmacData:(NSString*) hmacData {
    const char *cKey  = [key cStringUsingEncoding:NSUTF8StringEncoding];
    const char *cData = [hmacData cStringUsingEncoding:NSUTF8StringEncoding];
    unsigned char cHMAC[CC_SHA256_DIGEST_LENGTH];
    CCHmac(kCCHmacAlgSHA256, cKey, strlen(cKey), cData, strlen(cData), cHMAC);
    NSMutableString* output = [NSMutableString stringWithCapacity:CC_SHA256_DIGEST_LENGTH * 2];

    for(int i = 0; i < CC_SHA256_DIGEST_LENGTH; i++)
        [output appendFormat:@"%02x", cHMAC[i]];
    
    NSString* returnVal = output;
    return returnVal;
}

- (void)performTransaction:(CDVInvokedUrlCommand*)command{
    NSString* arguments = [command.arguments objectAtIndex:0];
    transactionCallback = command;
    globalCallback = command;
    NSString* setupSuccess = [self setup:arguments];
    if([setupSuccess isEqual: @"success"]) {
        TransactionService* transactionService = [[TransactionService alloc] initWithRestClient:restClient];
        [transactionService processTransactionWithTransactionAction:transactionAction paramMap:payload transactionId:transactionId completion:^(NSString * responseData) {
            if (responseData != nil && [responseData length] > 0) {
                self->pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:responseData];
            } else {
                self->pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_ERROR];
            }
            [self.commandDelegate sendPluginResult:self->pluginResult callbackId:command.callbackId];
        }];
    } else {
        pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:setupSuccess];
    	[pluginResult setKeepCallbackAsBool:true];
		[self.commandDelegate sendPluginResult:pluginResult callbackId:command.callbackId];
    }
}

- (void)performEMVTransaction:(CDVInvokedUrlCommand*)command{
    transactionCallback = command;
    globalCallback = command;
    NSString* arguments = [command.arguments objectAtIndex:0];
    NSString* setupSuccess = [self setup:arguments];
    if([setupSuccess isEqual: @"success"]) {
        bool result =[emvTransaction PerformEMVSaleWithJsonPayload:payload];
        if (result) {
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"EMV Transaction Started.."];
        } else {
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_ERROR];
        }
        [pluginResult setKeepCallbackAsBool:true];
        [self.commandDelegate sendPluginResult:pluginResult callbackId:command.callbackId];
    } else {
        pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:setupSuccess];
    	[pluginResult setKeepCallbackAsBool:true];
		[self.commandDelegate sendPluginResult:pluginResult callbackId:command.callbackId];
    }
}

- (void)cancelEMVTransaction:(CDVInvokedUrlCommand*)command{
    globalCallback = command;
    bool result = [emvTransaction CancelEMVSale];
    if (result) {
        pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"EMV Transaction Cancelled."];
    } else {
        pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_ERROR];
    }
    [self.commandDelegate sendPluginResult:pluginResult callbackId:command.callbackId];
}

- (TransactionActionOBJC)getOBJCTransactionAction:(NSString*)action {
    TransactionActionOBJC transactionActionOBJC = TransactionActionOBJCNotSelected;
    if (action) {
        if([action caseInsensitiveCompare:@"sale"] == NSOrderedSame) {
            transactionActionOBJC = TransactionActionOBJCSale;
        }
        else if([action caseInsensitiveCompare:@"refund"] == NSOrderedSame) {
            transactionActionOBJC = TransactionActionOBJCRefund;
        }
        else if([action caseInsensitiveCompare:@"void"] == NSOrderedSame) {
            transactionActionOBJC = TransactionActionOBJCVoid;
        }
        else if([action caseInsensitiveCompare:@"authonly"] == NSOrderedSame) {
            transactionActionOBJC = TransactionActionOBJCAuthOnly;
        }
        else if([action caseInsensitiveCompare:@"authcomplete"] == NSOrderedSame) {
            transactionActionOBJC = TransactionActionOBJCAuthComplete;
        }
        else if([action caseInsensitiveCompare:@"authincrement"] == NSOrderedSame) {
            transactionActionOBJC = TransactionActionOBJCAuthIncrement;
        }
        else if([action caseInsensitiveCompare:@"force"] == NSOrderedSame) {
            transactionActionOBJC = TransactionActionOBJCForce;
        }
        else if([action caseInsensitiveCompare:@"tipadjust"] == NSOrderedSame) {
            transactionActionOBJC = TransactionActionOBJCTipAdjust;
        }
        else if([action caseInsensitiveCompare:@"debit"] == NSOrderedSame) {
            transactionActionOBJC = TransactionActionOBJCDebit;
        }
        else if([action caseInsensitiveCompare:@"credit"] == NSOrderedSame) {
            transactionActionOBJC = TransactionActionOBJCCredit;
        }
        else if([action caseInsensitiveCompare:@"edit"] == NSOrderedSame) {
            transactionActionOBJC = TransactionActionOBJCEdit;
        }
        else if([action caseInsensitiveCompare:@"avsonly"] == NSOrderedSame) {
            transactionActionOBJC = TransactionActionOBJCAVSOnly;
        }
        else if([action caseInsensitiveCompare:@"viewrecord"] == NSOrderedSame) {
            transactionActionOBJC = TransactionActionOBJCViewRecord;
        }
        else if([action caseInsensitiveCompare:@"viewrecordlist"] == NSOrderedSame) {
            transactionActionOBJC = TransactionActionOBJCViewRecordList;
        }
        else if([action caseInsensitiveCompare:@"getbininfo"] == NSOrderedSame) {
            transactionActionOBJC = TransactionActionOBJCGetBinInfo;
        }
        else if([action caseInsensitiveCompare:@"store"] == NSOrderedSame) {
            transactionActionOBJC = TransactionActionOBJCStore;
        }
    }
    return transactionActionOBJC;
}

- (DeviceTypeOBJC)getOBJCDeviceType:(NSString*)deviceType {
    DeviceTypeOBJC deviceTypeOBJC = DeviceTypeOBJCUNKNOWN;
    if([deviceType caseInsensitiveCompare:@"IDTECH-VP3300BT"] == NSOrderedSame) {
        deviceTypeOBJC = DeviceTypeOBJCIDTECH_VP3300BT;
    }
    else if([deviceType caseInsensitiveCompare:@"IDTECH-VP8800"] == NSOrderedSame) {
        deviceTypeOBJC = DeviceTypeOBJCIDTECH_VP8800;
    }
    return deviceTypeOBJC;
}

- (void)setDeviceType:(CDVInvokedUrlCommand*)command {
    NSString* deviceType = [command.arguments objectAtIndex:0];
    bool result = [emvTransaction setDeviceTypeOBJCWithDeviceType:[self getOBJCDeviceType:deviceType]];
    if (result) {
        self->pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"Success"];
    } else {
        self->pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_ERROR messageAsString:@"Failure"];
    }
    [self.commandDelegate sendPluginResult:pluginResult callbackId:command.callbackId];
}

- (void)scanForDevices:(CDVInvokedUrlCommand*)command {
    transactionCallback = command;
    deviceScanCallback = command;
    globalCallback = command;
    NSString* arguments = [command.arguments objectAtIndex:0];
	NSString* searchString = [command.arguments objectAtIndex:1];
	NSString* timeout =(Double) [command.arguments objectAtIndex:2];
    NSString* setupSuccess = [self setup:arguments];
    if([setupSuccess isEqual: @"success"]) {
        [emvTransaction scanForDevices searchString:searchString, timeout:timeout];
    } else {
        pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:setupSuccess];
    	[pluginResult setKeepCallbackAsBool:true];
		[self.commandDelegate sendPluginResult:pluginResult callbackId:command.callbackId];
	}
}

- (void)initialDeviceSetup:(CDVInvokedUrlCommand*)command {
    transactionCallback = command;
    globalCallback = command;
    NSString* deviceSettings = [command.arguments objectAtIndex:0];
    NSString* setupSuccess = [self setup:deviceSettings];
    if([setupSuccess isEqual: @"success"]) {
        [emvTransaction initialDeviceSetup];
    } else {
        pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:setupSuccess];
    	[pluginResult setKeepCallbackAsBool:true];
		[self.commandDelegate sendPluginResult:pluginResult callbackId:command.callbackId];
    }
}

- (void)connectDeviceByName:(CDVInvokedUrlCommand*)command {
    deviceConnectionCallback = command;
    NSString* deviceName = [command.arguments objectAtIndex:0];
    connectingDevice = deviceName;
    NSString* message = [NSString stringWithFormat:@"%@%@", @"Connecting device.. ", deviceName];
    self->pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:message];
    [self->pluginResult setKeepCallbackAsBool:true];
    [self.commandDelegate sendPluginResult:pluginResult callbackId:command.callbackId];
    [emvTransaction connectDeviceByNameWithName:deviceName];
}

- (void)deviceConnected {
    NSString* message = [NSString stringWithFormat:@"%@%@%@", @"deviceConnected!@#$", connectingDevice, @" - Connected"];
    self->pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:message];
    [self->pluginResult setKeepCallbackAsBool:true];
    [self.commandDelegate sendPluginResult:pluginResult callbackId:deviceConnectionCallback.callbackId];
}

- (void)deviceDisconnected {
    NSString* message = [NSString stringWithFormat:@"%@%@%@", @"deviceDisconnected!@#$", connectingDevice, @" - Disconnected"];
    self->pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:message];
    [self->pluginResult setKeepCallbackAsBool:true];
    [self.commandDelegate sendPluginResult:pluginResult callbackId:deviceConnectionCallback.callbackId];
}

- (void)deviceMessage:(NSString * _Null_unspecified)message {
    message = [NSString stringWithFormat:@"%@%@", @"deviceMessage!@#$", message];
    self->pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:message];
    [self->pluginResult setKeepCallbackAsBool:true];
    [self.commandDelegate sendPluginResult:pluginResult callbackId:globalCallback.callbackId];
}

- (void)deviceScanResponse:(NSString * _Null_unspecified)deviceID deviceName:(NSString * _Null_unspecified)deviceName{
    NSString* message = [NSString stringWithFormat:@"%@%@%@%@", @"deviceScanResponse!@#$",deviceID, @"!@#$", deviceName];
    self->pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:message];
    [self->pluginResult setKeepCallbackAsBool:true];
    [self.commandDelegate sendPluginResult:pluginResult callbackId:deviceScanCallback.callbackId];
}

- (void)outputLogs:(NSString * _Null_unspecified)logs{
    logs = [NSString stringWithFormat:@"%@%@", @"outputLogs!@#$", logs];
    self->pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:logs];
    [self->pluginResult setKeepCallbackAsBool:true];
    [self.commandDelegate sendPluginResult:pluginResult callbackId:globalCallback.callbackId];
}

- (void)transactionResponse:(NSString * _Null_unspecified)data{
    data = [NSString stringWithFormat:@"%@%@", @"transactionResponse!@#$", data];
    self->pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:data];
    [self->pluginResult setKeepCallbackAsBool:true];
    [self.commandDelegate sendPluginResult:pluginResult callbackId:globalCallback.callbackId];
}

- (void)disconnectDevice:(CDVInvokedUrlCommand*)command{
    globalCallback = command;
    bool result = [emvTransaction DisconnectDevice];
    if (result) {
        pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"Device Disconnected."];
    } else {
        pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_ERROR];
    }
    [self.commandDelegate sendPluginResult:pluginResult callbackId:command.callbackId];
}

- (void)setTimeouts:(CDVInvokedUrlCommand*)command{
    globalCallback = command;
    
    int idleTimeout =  [[command.arguments objectAtIndex:0] intValue];
    int sleepTimeout =  [[command.arguments objectAtIndex:1] intValue];
    
    bool result = [emvTransaction setTimeoutsWithIdleMinutes:idleTimeout sleepMinutes:sleepTimeout];
    if (result) {
        pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"Timeouts Set"];
    } else {
        pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_ERROR];
    }
    [self.commandDelegate sendPluginResult:pluginResult callbackId:command.callbackId];
}


@end
