//
//  IDTEMVData.h
//  IDTech
//
//  Created by Randy Palermo on 9/5/14.
//  Copyright (c) 2014 IDTech Products. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "IDTCommon.h"
#import "IDTMSRData.h"

/**
 * Encapsulating data class for EMV data capture
 */
@interface IDTEMVData : NSObject{
 @public
    /**
     Result Code. Uses enumeration EMV_RESULT_CODE_Types
     
     @code
     typedef enum{
     EMV_RESULT_CODE_APPROVED = 0X00,
     EMV_RESULT_CODE_DECLINED = 0X01,
     EMV_RESULT_CODE_GO_ONLINE = 0X02,
     EMV_RESULT_CODE_FAILED = 0X03,
     EMV_RESULT_CODE_SYSTEM_ERROR = 0X05,
     EMV_RESULT_CODE_NOT_ACCEPT = 0X07,
     EMV_RESULT_CODE_FALLBACK = 0X0A,
     EMV_RESULT_CODE_CANCEL = 0X0C,
     EMV_RESULT_CODE_OTHER_ERROR = 0X0F,
     EMV_RESULT_CODE_TIME_OUT = 0X0D,
     EMV_RESULT_CODE_OFFLINE_APPROVED = 0X10,
     EMV_RESULT_CODE_OFFLINE_DECLINED = 0X11,
     EMV_RESULT_CODE_REFERRAL_PROCESSING = 0X12,
     EMV_RESULT_CODE_ERROR_APP_PROCESSING = 0X13,
     EMV_RESULT_CODE_ERROR_APP_READING = 0X14,
     EMV_RESULT_CODE_ERROR_DATA_AUTH = 0X15,
     EMV_RESULT_CODE_ERROR_PROCESSING_RESTRICTIONS = 0X16,
     EMV_RESULT_CODE_ERROR_CVM_PROCESSING = 0X17,
     EMV_RESULT_CODE_ERROR_RISK_MGMT = 0X18,
     EMV_RESULT_CODE_ERROR_TERM_ACTION_ANALYSIS = 0X19,
     EMV_RESULT_CODE_ERROR_CARD_ACTION_ANALYSIS = 0X1A,
     EMV_RESULT_CODE_ERROR_APP_SELECTION_TIMEOUT = 0X1B,
     EMV_RESULT_CODE_ERROR_DATA_LEN_INCORRECT = 0X1C
     } EMV_RESULT_CODE_Types;
     @endcode
     */
    EMV_RESULT_CODE_Types  resultCode;
    /**
     Result Code. Uses enumeration EMV_RESULT_CODE_V2_Types
     
     @code
     typedef enum{
     EMV_RESULT_CODE_V2_APPROVED_OFFLINE = 0x0000,
     EMV_RESULT_CODE_V2_DECLINED_OFFLINE = 0x0001,
     EMV_RESULT_CODE_V2_APPROVED = 0x0002,
     EMV_RESULT_CODE_V2_DECLINED = 0x0003,
     EMV_RESULT_CODE_V2_GO_ONLINE = 0x0004,
     EMV_RESULT_CODE_V2_CALL_YOUR_BANK = 0x0005,
     EMV_RESULT_CODE_V2_NOT_ACCEPTED = 0x0006,
     EMV_RESULT_CODE_V2_USE_MAGSTRIPE = 0x0007,
     EMV_RESULT_CODE_V2_TIME_OUT = 0x0008,
     EMV_RESULT_CODE_V2_START_TRANS_SUCCESS = 0x0010,
     EMV_RESULT_CODE_V2_MSR_SUCCESS = 0x0011,
     EMV_RESULT_CODE_V2_FILE_ARG_INVALID = 0x1001,
     EMV_RESULT_CODE_V2_FILE_OPEN_FAILED = 0x1002,
     EMV_RESULT_CODE_V2_FILE_OPERATION_FAILED = 0X1003,
     EMV_RESULT_CODE_V2_MEMORY_NOT_ENOUGH = 0x2001,
     EMV_RESULT_CODE_V2_SMARTCARD_FAIL = 0x3001,
     EMV_RESULT_CODE_V2_SMARTCARD_INIT_FAILED = 0x3003,
     EMV_RESULT_CODE_V2_FALLBACK_SITUATION = 0x3004,
     EMV_RESULT_CODE_V2_SMARTCARD_ABSENT = 0x3005,
     EMV_RESULT_CODE_V2_SMARTCARD_TIMEOUT = 0x3006,
     EMV_RESULT_CODE_V2_MSR_CARD_ERROR = 0x3007,
     EMV_RESULT_CODE_V2_PARSING_TAGS_FAILED= 0X5001,
     EMV_RESULT_CODE_V2_CARD_DATA_ELEMENT_DUPLICATE = 0X5002,
     EMV_RESULT_CODE_V2_DATA_FORMAT_INCORRECT = 0X5003,
     EMV_RESULT_CODE_V2_APP_NO_TERM = 0X5004,
     EMV_RESULT_CODE_V2_APP_NO_MATCHING = 0X5005,
     EMV_RESULT_CODE_V2_AMANDATORY_OBJECT_MISSING = 0X5006,
     EMV_RESULT_CODE_V2_APP_SELECTION_RETRY = 0X5007,
     EMV_RESULT_CODE_V2_AMOUNT_ERROR_GET = 0X5008,
     EMV_RESULT_CODE_V2_CARD_REJECTED = 0X5009,
     EMV_RESULT_CODE_V2_AIP_NOT_RECEIVED = 0X5010,
     EMV_RESULT_CODE_V2_AFL_NOT_RECEIVEDE = 0X5011,
     EMV_RESULT_CODE_V2_AFL_LEN_OUT_OF_RANGE = 0X5012,
     EMV_RESULT_CODE_V2_SFI_OUT_OF_RANGE = 0X5013,
     EMV_RESULT_CODE_V2_AFL_INCORRECT = 0X5014,
     EMV_RESULT_CODE_V2_EXP_DATE_INCORRECT = 0X5015,
     EMV_RESULT_CODE_V2_EFF_DATE_INCORRECT = 0X5016,
     EMV_RESULT_CODE_V2_ISS_COD_TBL_OUT_OF_RANGE = 0X5017,
     EMV_RESULT_CODE_V2_CRYPTOGRAM_TYPE_INCORRECT = 0X5018,
     EMV_RESULT_CODE_V2_PSE_BY_CARD_NOT_SUPPORTED = 0X5019,
     EMV_RESULT_CODE_V2_USER_LANGUAGE_SELECTED = 0X5020,
     EMV_RESULT_CODE_V2_SERVICE_NOT_ALLOWED = 0X5021,
     EMV_RESULT_CODE_V2_NO_TAG_FOUND = 0X5022,
     EMV_RESULT_CODE_V2_CARD_BLOCKED = 0X5023,
     EMV_RESULT_CODE_V2_LEN_INCORRECT = 0X5024,
     EMV_RESULT_CODE_V2_CARD_COM_ERROR = 0X5025,
     EMV_RESULT_CODE_V2_TSC_NOT_INCREASED = 0X5026,
     EMV_RESULT_CODE_V2_HASH_INCORRECT = 0X5027,
     EMV_RESULT_CODE_V2_ARC_NOT_PRESENCED = 0X5028,
     EMV_RESULT_CODE_V2_ARC_INVALID = 0X5029,
     EMV_RESULT_CODE_V2_COMM_NO_ONLINE = 0X5030,
     EMV_RESULT_CODE_V2_TRAN_TYPE_INCORRECT = 0X5031,
     EMV_RESULT_CODE_V2_APP_NO_SUPPORT = 0X5032,
     EMV_RESULT_CODE_V2_APP_NOT_SELECT = 0X5033,
     EMV_RESULT_CODE_V2_LANG_NOT_SELECT = 0X5034,
     EMV_RESULT_CODE_V2_TERM_DATA_NOT_PRESENCED = 0X5035,
     EMV_RESULT_CODE_V2_CVM_TYPE_UNKNOWN = 0X6001,
     EMV_RESULT_CODE_V2_CVM_AIP_NOT_SUPPORTED = 0X6002,
     EMV_RESULT_CODE_V2_CVM_TAG_8E_MISSING = 0X6003,
     EMV_RESULT_CODE_V2_CVM_TAG_8E_FORMAT_ERROR = 0X6004,
     EMV_RESULT_CODE_V2_CVM_CODE_IS_NOT_SUPPORTED = 0X6005,
     EMV_RESULT_CODE_V2_CVM_COND_CODE_IS_NOT_SUPPORTED = 0X6006,
     EMV_RESULT_CODE_V2_CVM_NO_MORE = 0X6007,
     EMV_RESULT_CODE_V2_PIN_BYPASSED_BEFORE = 0X6008
     } EMV_RESULT_CODE_V2_Types;
     @endcode
     */
    EMV_RESULT_CODE_V2_Types resultCodeV2;
    bool hasAdvise; //!< TRUE if response has an Advise request
    bool hasReversal; //!< TRUE if response has reversal request
    int encryptionMode;  //!< 0 = TDES, 1 = AES
    int cardType;  //!< 0 = Contact, 1 = Contactless
    NSDictionary* unencryptedTags; //!< Unencrypted EMV Tags.  Key = tag name (NSString), Object = tag value (NSData)
    NSDictionary* encryptedTags; //!< Encrypted EMV Tags.  Key = tag name (NSString), Object = tag value (NSData)
    NSDictionary* maskedTags; //!< Encrypted EMV Tags.  Key = tag name (NSString), Object = tag value (NSData)
    NSData* KSN; //!< Key Serial Number for encrypted EMV tags
    IDTMSRData* cardData; //!< Card data returned from fallback or non-icc swipe during emv transaction
    
}

/**
 * clears all IDTEMVData properties
 */
-(void)clear;
/**
 * Singleton instance of IDTEMVData
 */
+ (IDTEMVData *)sharedController;

@property EMV_RESULT_CODE_Types resultCode;
@property EMV_RESULT_CODE_V2_Types resultCodeV2;
@property int encryptionMode;
@property int cardType;
@property bool hasAdvise;
@property bool hasReversal;
@property (nonatomic, strong) NSDictionary* unencryptedTags;
@property (nonatomic, strong) NSDictionary* encryptedTags;
@property (nonatomic, strong) NSDictionary* maskedTags;
@property (nonatomic, strong) NSData* KSN;
@property (nonatomic, strong) IDTMSRData* cardData;

@end
