//  MainActivity.java
//  Sample App for PaymentSDK
//
//  Created by Samstaurej Siddiquie on 01/10/2019.
//  Copyright © 2019 Zeamster. All rights reserved.

package com.zeamster.sampleapp;

import android.os.Bundle;

import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.Toolbar;
import androidx.drawerlayout.widget.DrawerLayout;
import androidx.navigation.NavController;
import androidx.navigation.Navigation;
import androidx.navigation.ui.AppBarConfiguration;
import androidx.navigation.ui.NavigationUI;
import androidx.recyclerview.widget.DividerItemDecoration;

import com.google.android.material.internal.NavigationMenuView;
import com.google.android.material.navigation.NavigationView;
import com.zeamster.paymentsdk.resthandler.RestServiceClient;
import com.zeamster.paymentsdk.transaction.TransactionAction;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;

public class MainActivity extends AppCompatActivity {

    public static TransactionAction transactionAction;
    public static RestServiceClient restServiceClient;
    public static String apiResponse, transactionId, transactionCategory;
    public static HashMap<String, Object> payload;
    public static HashMap<String, String> actionsMapping;
    public static LinkedList<String> allSelections, selectedSelections;

    private AppBarConfiguration mAppBarConfiguration;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
        Toolbar toolbar = findViewById(R.id.toolbar);
        setSupportActionBar(toolbar);

        DrawerLayout drawer = findViewById(R.id.drawer_layout);
        NavigationView navigationView = findViewById(R.id.nav_view);

        // This is for adding the lines in between the items in drawer
        NavigationMenuView navMenuView = (NavigationMenuView) navigationView.getChildAt(0);
        navMenuView.addItemDecoration(new DividerItemDecoration(MainActivity.this, DividerItemDecoration.VERTICAL));

        // Passing each menu ID as a set of Ids because each
        // menu should be considered as top level destinations.
        mAppBarConfiguration = new AppBarConfiguration.Builder(
                R.id.nav_home, R.id.nav_router_trans, R.id.nav_cc_trans, R.id.nav_ach_trans,
                R.id.nav_gen_trans, R.id.nav_acc_vaults)
                .setDrawerLayout(drawer)
                .build();
        NavController navController = Navigation.findNavController(this, R.id.nav_host_fragment);
        NavigationUI.setupActionBarWithNavController(this, navController, mAppBarConfiguration);
        NavigationUI.setupWithNavController(navigationView, navController);

        initializeValues();
    }

    private void initializeValues() {
        actionsMapping = new HashMap<>();
        String[] actionsMap = getResources().getStringArray(R.array.actions);
        for (String action : actionsMap) {
            String[] splitResult = action.split("\\|", 2);
            actionsMapping.put(splitResult[0], splitResult[1]);
        }
        String[] selections = getResources().getStringArray(R.array.selections);
        allSelections = new LinkedList<>();
        allSelections.addAll(Arrays.asList(selections));
    }

    // This is used to give action to the navigation drawer
    @Override
    public boolean onSupportNavigateUp() {
        NavController navController = Navigation.findNavController(this, R.id.nav_host_fragment);
        return NavigationUI.navigateUp(navController, mAppBarConfiguration)
                || super.onSupportNavigateUp();
    }
}
