/*
 * Decompiled with CFR 0.152.
 */
package com.idtechproducts.device.audiojack.tasks;

import android.os.Handler;
import android.os.Looper;
import com.idtechproducts.device.OnReceiverListener;
import com.idtechproducts.device.StructConfigParameters;
import com.idtechproducts.device.audiojack.ReaderCommunication;
import com.idtechproducts.device.audiojack.UMLog;
import com.idtechproducts.device.audiojack.io.IOManager;
import com.idtechproducts.device.audiojack.io.TonePlayer;
import com.idtechproducts.device.audiojack.io.ToneType;
import com.idtechproducts.device.audiojack.tasks.TaskManager;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Task
implements Runnable,
IOManager.ICancel,
IOManager.ResponseProcessor {
    public final ReaderCommunication _readerCommunication;
    public OnReceiverListener _umrMsg = null;
    public IOManager _ioManager = null;
    public final TonePlayer _tonePlayer;
    public StructConfigParameters _config = null;
    public final TaskManager _taskManager;
    public final String TAG;
    public volatile boolean a = false;
    public final Object b = new Object();
    public ToneType c;

    /*
     * WARNING - void declaration
     */
    public Task(TaskManager taskManager, ReaderCommunication umMan) {
        void var1_1;
        IOManager iOManager;
        umMan = this._readerCommunication = umMan;
        if (umMan != null) {
            Task task = this;
            task._umrMsg = iOManager.getIntern_uniMagReaderMsg();
            task._ioManager = task._readerCommunication.getIntern_IOManager();
            task._config = task._readerCommunication.getIntern_StructConfigParameters();
        }
        this._tonePlayer = (iOManager = this._ioManager) != null ? iOManager.getTonePlayer() : null;
        Task task = this;
        task._taskManager = var1_1;
        task.TAG = String.valueOf(this.getType().name()) + "Task";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        this.a = true;
        Object object = this._ioManager;
        if (object != null) {
            ((IOManager)object).notifyIoManager();
        }
        object = this.b;
        synchronized (object) {
            this.b.notify();
            return;
        }
    }

    @Override
    public boolean isCanceled() {
        return this.a;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public boolean safeWait(double waitLen22) {
        void var1_2;
        long waitLen22 = (long)(waitLen22 * 1000.0);
        long l2 = System.currentTimeMillis();
        Object object = this.b;
        Task task = this;
        // MONITORENTER : object
        {
            catch (InterruptedException interruptedException) {}
        }
        task.b.wait((long)var1_2);
        // MONITOREXIT : object
        if (System.currentTimeMillis() - l2 >= var1_2) return false;
        return true;
    }

    @Override
    public boolean processResponse(List<byte[]> response) {
        return true;
    }

    @Override
    public void processSound() {
    }

    public void tone_saveAndStop() {
        TonePlayer tonePlayer = this._tonePlayer;
        if (tonePlayer != null) {
            this.c = tonePlayer.getPlayingTone();
            this._tonePlayer.setPlayingTone(null);
        }
    }

    public void tone_restore() {
        TonePlayer tonePlayer = this._tonePlayer;
        if (tonePlayer != null) {
            tonePlayer.setPlayingTone(this.c);
        }
    }

    public void post(Runnable r2) {
        new Handler(Looper.getMainLooper()).post(r2);
    }

    @Override
    public void run() {
        Task task = this;
        UMLog.i(task.TAG, "started");
        if (!task.taskSetup()) {
            return;
        }
        Runnable runnable = this.taskMain();
        Task task2 = this;
        task2.taskCleanup();
        task2._taskManager.task_signalStoppedStatus();
        UMLog.i(task2.TAG, "stopped");
        if (runnable != null) {
            runnable.run();
        }
    }

    public abstract TaskManager.TaskType getType();

    public boolean taskSetup() {
        this.tone_saveAndStop();
        return true;
    }

    public void taskCleanup() {
        IOManager iOManager = this._ioManager;
        if (iOManager != null) {
            iOManager.notifyTaskFinished();
        }
        UMLog.i(this.TAG, "taskCleanup ok.");
    }

    public abstract Runnable taskMain();
}

