/*
 * Decompiled with CFR 0.152.
 */
package android_serialport_api;

import android.util.Log;
import com.idtechproducts.device.audiojack.UMLog;
import com.idtechproducts.device.rs232.RS232Controller;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class SerialPort {
    private FileDescriptor a;
    private FileInputStream b;
    private FileOutputStream c;

    static {
        try {
            System.loadLibrary("c++");
            System.loadLibrary("serial_port");
            return;
        }
        catch (SecurityException securityException) {
            String string = "SecurityException";
            UMLog.i("SerialPort", string);
            RS232Controller.libRS232Avail = false;
            return;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            String string = "UnsatisfiedLinkError";
            UMLog.i("SerialPort", string);
            RS232Controller.libRS232Avail = false;
            return;
        }
        catch (NullPointerException nullPointerException) {
            String string = "NullPointerException";
            UMLog.i("SerialPort", string);
            RS232Controller.libRS232Avail = false;
            return;
        }
    }

    public SerialPort(File file, int n, int n2) throws SecurityException, IOException {
        if (!RS232Controller.libRS232Avail) {
            return;
        }
        this.a = SerialPort.open(file.getAbsolutePath(), n, n2);
        if (this.a == null) {
            Log.e((String)"SerialPort", (String)"native open returns null");
            throw new IOException();
        }
        this.b = new FileInputStream(this.a);
        this.c = new FileOutputStream(this.a);
    }

    public InputStream getInputStream() {
        return this.b;
    }

    public OutputStream getOutputStream() {
        return this.c;
    }

    private static native FileDescriptor open(String var0, int var1, int var2);

    public native void close();
}

