/*
 * Decompiled with CFR 0.152.
 */
package com.idtechproducts.device.rs232;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.util.Log;
import android_serialport_api.SerialPort;
import com.idtechproducts.device.Common;
import com.idtechproducts.device.IDTMSRData;
import com.idtechproducts.device.IDT_Device;
import com.idtechproducts.device.ResDataStruct;
import com.idtechproducts.device.audiojack.UMLog;
import com.idtechproducts.device.rs232.IDTechRS232Msg;
import com.idtechproducts.device.rs232.RS232ControllerMsg;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;

public final class RS232Controller {
    public static boolean libRS232Avail = true;
    private SerialPort a = null;
    private InputStream b = null;
    private OutputStream c = null;
    private IDTechRS232Msg d = null;
    private RS232ControllerMsg e = null;
    private a f;
    private boolean g = false;
    private boolean h = false;
    private boolean i = false;
    private int j;
    private int k = 0;
    private b l;
    private c m = null;
    private byte[] n;
    private byte[] o;
    private Handler p = null;
    private Runnable q = new Runnable(this){
        private /* synthetic */ RS232Controller a;
        {
            this.a = rS232Controller;
        }

        @Override
        public final void run() {
            UMLog.i("SDK::RS232 Controller", "Sending attached for device_filter");
            this.a.e.onDeviceAttached();
        }
    };
    private static boolean r = false;
    private boolean s = false;
    private static int t = 0;
    private static int u = 0;

    public final void externalConnect() {
        if (IDT_Device.getUSBBypass() && this.e != null) {
            IDT_Device.allowReceiverCallback = true;
            this.e.onDeviceAttached();
        }
    }

    public final void externalDisconnect() {
        if (IDT_Device.getUSBBypass() && this.e != null) {
            this.e.onDeviceDetached();
        }
    }

    public final void externalDeviceNotFound() {
        if (IDT_Device.getUSBBypass() && this.e != null) {
            this.e.onDeviceNotFound();
        }
    }

    public RS232Controller(Context context, IDTechRS232Msg iDTechRS232Msg, RS232ControllerMsg rS232ControllerMsg, String string, String string2, int n) {
        new BroadcastReceiver(this){

            public final void onReceive(Context context, Intent intent) {
                intent.getAction();
            }
        };
        this.d = iDTechRS232Msg;
        this.e = rS232ControllerMsg;
        this.n = new byte[4096];
        this.o = new byte[4096];
        this.j = 200;
        this.p = new Handler(context.getMainLooper());
    }

    public final boolean init() {
        if (this.a()) {
            UMLog.i("SDK::RS232 Controller", "RS232 device is found.");
            return true;
        }
        UMLog.i("SDK::RS232 Controller", "RS232 device is not found.");
        this.e.onDeviceNotFound();
        return false;
    }

    public final boolean initWithThread() {
        if (r) {
            return false;
        }
        r = true;
        if (this.a()) {
            UMLog.i("SDK::RS232 Controller", "RS232 device is found.");
            UMLog.i("SDK::RS232 Controller", "Sending attached for device_filter");
            this.p.post(this.q);
            r = false;
            return true;
        }
        r = false;
        return false;
    }

    public final void startCheckingConnection() {
        if (IDT_Device.getUSBBypass()) {
            return;
        }
        UMLog.i("SDK::RS232 Controller", "SDK starts monitoring if reader is connected.");
        this.f = new a(this, 0);
        this.f.start();
    }

    public final boolean isRegistered() {
        if (IDT_Device.getUSBBypass()) {
            return true;
        }
        return this.s;
    }

    public final void registerReceiver() {
        this.s = true;
    }

    public final void unregisterReceiver() {
        if (IDT_Device.getUSBBypass()) {
            this.s = false;
            return;
        }
        UMLog.i("SDK::RS232 Controller", "A Broadcast receiver unregistered.");
        this.b();
        this.s = false;
    }

    public final boolean enableSwipe() {
        if (this.a == null || this.g) {
            return false;
        }
        UMLog.i("SDK::RS232 Controller", "SDK starts polling card data from reader.");
        if (this.l != null) {
            this.l.a();
        }
        this.l = new b(this, 0);
        this.g = true;
        this.k = 0;
        this.l.start();
        return true;
    }

    public final boolean enableListen() {
        if (this.a == null) {
            return false;
        }
        UMLog.i("SDK::RS232 Controller", "SDK starts listening card data from reader.");
        if (this.m == null) {
            this.m = new c(this, 0);
            this.m.a = true;
            this.m.start();
        }
        return true;
    }

    public final boolean disableListen() {
        UMLog.i("SDK::RS232 Controller", "SDK stops listening card data from reader.");
        if (this.m == null) {
            return false;
        }
        this.m.a = false;
        return true;
    }

    public final boolean enableRead(int n, ResDataStruct resDataStruct) {
        return true;
    }

    public final boolean readMessage(int n, long l, ResDataStruct resDataStruct, boolean bl) {
        if (this.a == null) {
            return false;
        }
        resDataStruct.resData = new byte[1];
        byte[] byArray = new byte[4096];
        int n2 = 0;
        long l2 = System.currentTimeMillis();
        while (l2 - l <= (long)(n * 1000)) {
            if (IDT_Device.isTransactionRead && (IDT_Device.emvCancelTransaction || IDT_Device.cancelTransaction)) {
                Log.i((String)"SDK::RS232 Controller", (String)"## Transaction Cancelled ");
                return true;
            }
            n2 = this.d(byArray);
            if (n2 > 0) break;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                InterruptedException interruptedException2 = interruptedException;
                interruptedException.printStackTrace();
            }
            l2 = System.currentTimeMillis();
        }
        if (l2 - l > (long)(n * 1000)) {
            return false;
        }
        if (n2 > 0) {
            resDataStruct.resData = null;
            resDataStruct.resData = new byte[n2];
            System.arraycopy(byArray, 0, resDataStruct.resData, 0, n2);
            UMLog.i("**getResponse**", Common.base16Encode(resDataStruct.resData));
            this.d.com_onReceiveMsgGetResponse(resDataStruct.resData);
            return true;
        }
        return false;
    }

    public final void disableSwipe() {
        UMLog.i("SDK::RS232 Controller", "SDK stops polling card data from reader.");
        if (this.l != null) {
            this.l.a();
        }
        this.g = false;
    }

    public final void setTimeoutOfSwipeCard(int n) {
        UMLog.i("SDK::RS232 Controller", "Timeout for card swipe changed to " + n + " seconds.");
        this.j = n;
    }

    public final void readBuffer(ResDataStruct resDataStruct) {
        int n;
        int n2;
        resDataStruct.resData = null;
        if (this.a == null || this.b == null) {
            return;
        }
        this.o = new byte[4096];
        if (this.i) {
            return;
        }
        try {
            n2 = 0;
            n = 0;
            while (n2 == 0 && n < 6) {
                n2 = this.b.available();
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {}
                ++n;
            }
            if (n >= 6) {
                return;
            }
            n2 = this.b.read(this.o);
        }
        catch (IOException iOException) {
            n2 = 0;
        }
        this.h = false;
        if (n2 > 7) {
            if (this.o[1] != 2 || this.o[4] != 6) {
                return;
            }
            n2 = -1;
            n = this.o.length - 1;
            while (n >= 0) {
                if (this.o[n] == 3) {
                    n2 = n;
                    break;
                }
                --n;
            }
            if (n2 > 7) {
                byte[] byArray = new byte[n2 + 1];
                System.arraycopy(this.o, 0, byArray, 0, n2 + 1);
                int n3 = byArray.length / 64;
                if (byArray.length % 64 != 0) {
                    ++n3;
                }
                n2 = byArray.length - n3;
                resDataStruct.resData = new byte[n2];
                n2 = 0;
                while (n2 < n3) {
                    int n4 = (n2 << 6) + 1;
                    int n5 = 63;
                    if (n2 == n3 - 1) {
                        n5 = byArray.length % 64 - 1;
                    }
                    System.arraycopy(byArray, n4, resDataStruct.resData, n2 * 63, n5);
                    ++n2;
                }
                return;
            }
            return;
        }
    }

    private boolean a() {
        if (this.a == null) {
            String string = "/dev/ttyHSL3";
            if ("/dev/ttyHSL3".length() == 0) {
                return false;
            }
            try {
                this.a = new SerialPort(new File(string), 115200, 0);
                if (!libRS232Avail) {
                    this.a = null;
                    return false;
                }
            }
            catch (SecurityException securityException) {
                this.a = null;
                return false;
            }
            catch (IOException iOException) {
                this.a = null;
                return false;
            }
            this.b = this.a.getInputStream();
            this.c = this.a.getOutputStream();
            return true;
        }
        return true;
    }

    public final byte[] PAT_wakeup_sendCommand(byte[] byArray, int n) {
        if (this.a == null || this.g) {
            UMLog.i("SDK::RS232 Controller", "Failed to send a command: ");
            this.g = false;
            return null;
        }
        try {
            Thread.sleep(10L);
        }
        catch (InterruptedException interruptedException) {
            InterruptedException interruptedException2 = interruptedException;
            interruptedException.printStackTrace();
        }
        if (byArray != null) {
            this.a(byArray, byArray.length);
        }
        try {
            Thread.sleep(10L);
        }
        catch (InterruptedException interruptedException) {
            InterruptedException interruptedException3 = interruptedException;
            interruptedException.printStackTrace();
        }
        return null;
    }

    public final byte[] sendCommand(byte[] byArray, int n) {
        long l;
        if (this.a == null || this.g) {
            UMLog.i("SDK::RS232 Controller", "Failed to send a command: ");
            this.g = false;
            return null;
        }
        try {
            Thread.sleep(0L);
        }
        catch (InterruptedException interruptedException) {
            InterruptedException interruptedException2 = interruptedException;
            interruptedException.printStackTrace();
        }
        byte[] byArray2 = new byte[4096];
        int n2 = 0;
        if (byArray != null) {
            this.a(byArray, byArray.length);
        }
        UMLog.i("**send command**", Common.base16Encode(byArray));
        long l2 = l = System.currentTimeMillis();
        try {
            Thread.sleep(0L);
        }
        catch (InterruptedException interruptedException) {
            InterruptedException interruptedException3 = interruptedException;
            interruptedException.printStackTrace();
        }
        while ((double)(l2 - l) <= Common.commandTime * 1000.0) {
            Object object;
            if (IDT_Device.getCancelTransaction()) {
                byte[] byArray3 = null;
                this.g = false;
                return byArray3;
            }
            n2 = this.a(byArray2);
            if (n2 > 0) {
                if (n2 > 8) {
                    object = "450055";
                    String string = Common.base16Encode(byArray2);
                    if (string.startsWith((String)object)) {
                        if (!IDT_Device.readyForCardSwipe) break;
                        l2 = System.currentTimeMillis();
                        n2 = 0;
                        continue;
                    }
                }
                if (n2 <= 12 || byArray2[10] == byArray[11]) break;
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {
                    object = interruptedException;
                    interruptedException.printStackTrace();
                }
                l2 = System.currentTimeMillis();
                n2 = 0;
                continue;
            }
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                object = interruptedException;
                interruptedException.printStackTrace();
            }
            l2 = System.currentTimeMillis();
        }
        if ((double)(l2 - l) > Common.commandTime * 1000.0) {
            byte[] byArray4 = new byte[1];
            byte[] byArray5 = byArray4;
            byArray4[0] = 0;
            return byArray5;
        }
        if (n2 > 0) {
            byte[] byArray6 = new byte[n2];
            System.arraycopy(byArray2, 0, byArray6, 0, n2);
            this.g = false;
            UMLog.i("**getResponse**", Common.base16Encode(byArray6));
            this.d.com_onReceiveMsgGetResponse(byArray6);
            return byArray6;
        }
        UMLog.i("**getResponse**", "NULL");
        this.g = false;
        return null;
    }

    public final byte[] sendCommandOnly(byte[] byArray, int n) {
        if (this.a == null || this.g) {
            UMLog.i("SDK::RS232 Controller", "Failed to send a command: ");
            this.g = false;
            return null;
        }
        try {
            Thread.sleep(0L);
        }
        catch (InterruptedException interruptedException) {
            InterruptedException interruptedException2 = interruptedException;
            interruptedException.printStackTrace();
        }
        if (byArray != null) {
            this.a(byArray, byArray.length);
        }
        this.g = false;
        return null;
    }

    public final byte[] sendCommandForRKI(byte[] object, int n) {
        long l;
        if (this.a == null || this.g) {
            UMLog.i("SDK::RS232 Controller", "Failed to send a command: ");
            this.g = false;
            return null;
        }
        try {
            Thread.sleep(300L);
        }
        catch (InterruptedException interruptedException) {
            InterruptedException interruptedException2 = interruptedException;
            interruptedException.printStackTrace();
        }
        byte[] byArray = new byte[1024];
        int n2 = 0;
        if (object != null) {
            this.a((byte[])object, ((byte[])object).length);
        }
        long l2 = l = System.currentTimeMillis();
        while ((double)(l2 - l) <= Common.commandTime * 1000.0) {
            n2 = this.c(byArray);
            if (n2 > 0) break;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                object = interruptedException;
                interruptedException.printStackTrace();
            }
            l2 = System.currentTimeMillis();
        }
        if (n2 > 0) {
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, 0, byArray2, 0, n2);
            this.g = false;
            UMLog.i("**getResponse**", Common.base16Encode(byArray2));
            this.d.com_onReceiveMsgGetResponse(byArray2);
            return byArray2;
        }
        this.g = false;
        return null;
    }

    public final byte[] sendCommandFw(byte[] byArray) {
        Object object;
        if (this.a == null || this.g) {
            UMLog.i("SDK::RS232 Controller", "Failed to send a command: ");
            this.g = false;
            return null;
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            object = interruptedException;
            interruptedException.printStackTrace();
        }
        byte[] byArray2 = new byte[4096];
        int n = 0;
        this.a(byArray, byArray.length);
        int n2 = 0;
        while (n2 < 5) {
            n = this.a(byArray2);
            if (n > 0) break;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                object = interruptedException;
                interruptedException.printStackTrace();
            }
            ++n2;
        }
        if (n > 0) {
            object = new byte[n];
            System.arraycopy(byArray2, 0, object, 0, n);
            this.g = false;
            return object;
        }
        this.g = false;
        return null;
    }

    private int a(byte[] byArray) {
        int n;
        block29: {
            int n2;
            int n3;
            int n4;
            int n5;
            block30: {
                if (this.a == null || this.b == null) {
                    return 0;
                }
                n = 0;
                n5 = 0;
                n4 = 0;
                Arrays.fill(this.o, (byte)0);
                byte[] byArray2 = new byte[4096];
                int n6 = 0;
                while (n4 != -1) {
                    block28: {
                        if (this.i) {
                            return 0;
                        }
                        this.h = true;
                        n3 = 0;
                        n2 = 0;
                        while (n3 == 0 && n2 < 6) {
                            n3 = this.b.available();
                            UMLog.i("SDK::RS232 Controller", "availbytes: ".concat(String.valueOf(n3)));
                            try {
                                Thread.sleep(50L);
                            }
                            catch (InterruptedException interruptedException) {}
                            ++n2;
                        }
                        if (n2 < 6) break block28;
                        return 0;
                    }
                    try {
                        Arrays.fill(byArray2, (byte)0);
                        n4 = this.b.read(byArray2);
                        String string = Common.base16Encode(byArray2);
                        UMLog.i("SDK::RS232 Controller", "res: " + n4 + "\ndata: " + string);
                    }
                    catch (IOException iOException) {
                        n4 = 0;
                    }
                    this.h = false;
                    if (n4 <= 0) continue;
                    if (n6 > 4096) break;
                    System.arraycopy(byArray2, 0, this.o, n6, n4);
                    if (n6 == 0) {
                        n5 = (this.o[13] & 0xFF) << 8 | this.o[14] & 0xFF;
                    }
                    if (n5 + 16 <= (n6 += n4)) break;
                }
                n4 = n6 / 64;
                if (!Common.isP2()) break block30;
                n5 = (this.o[13] & 0xFF) << 8 | this.o[14] & 0xFF;
                if (n4 > 0) {
                    n = n5 + 14 + 2;
                }
                if (n4 <= 0) break block29;
                n3 = 0;
                while (n3 < n4) {
                    if (n4 == 1) {
                        n2 = 1;
                        int n7 = 0;
                        while (n7 < 64) {
                            if (this.o[n7] != 0) {
                                n2 = 0;
                            }
                            ++n7;
                        }
                        if (n2 != 0) {
                            n = 0;
                            break block29;
                        }
                    }
                    if (n3 == n4 - 1) {
                        if (n > 4096) {
                            return 0;
                        }
                        if (n - n3 * 63 > 0) {
                            System.arraycopy(this.o, 1 + n3 * 64, byArray, n3 * 63, n - n3 * 63);
                        } else {
                            n = 0;
                        }
                    } else {
                        System.arraycopy(this.o, 1 + n3 * 64, byArray, n3 * 63, 63);
                    }
                    ++n3;
                }
                break block29;
            }
            if (n4 == 1) {
                n = 16;
                System.arraycopy(this.o, 1, byArray, 0, 16);
            } else if (n4 > 1) {
                n5 = (this.o[13] & 0xFF) << 8 | this.o[14] & 0xFF;
                n = n5 + 16;
                System.arraycopy(this.o, 1, byArray, 0, 14);
                n3 = n5 + 2;
                n2 = 14;
                if (this.o[74] == 68) {
                    if (n3 <= 53) {
                        System.arraycopy(this.o, 75, byArray, 14, n3);
                        return n;
                    }
                    System.arraycopy(this.o, 75, byArray, 14, 53);
                    n3 -= 53;
                    n2 += 53;
                    int n8 = 2;
                    while (n8 < n4) {
                        if (63 - n3 >= 0) {
                            System.arraycopy(this.o, 1 + n8 * 64, byArray, n2, n3);
                            break;
                        }
                        System.arraycopy(this.o, 1 + n8 * 64, byArray, n2, 63);
                        n3 -= 63;
                        n2 += 63;
                        ++n8;
                    }
                }
            }
        }
        return n;
    }

    private int b(byte[] byArray) {
        if (this.a == null || this.b == null) {
            return 0;
        }
        int n = 0;
        Arrays.fill(this.o, (byte)0);
        byte[] byArray2 = new byte[64];
        int n2 = 0;
        boolean bl = false;
        while (n != -1) {
            block13: {
                if (this.i) {
                    return 0;
                }
                this.h = true;
                n = 0;
                int n3 = 0;
                while (n == 0 && n3 < 6) {
                    n = this.b.available();
                    if (n > 0) {
                        UMLog.i("SDK::RS232 Controller", "availbytes > 0");
                    }
                    if (n == 0 && n2 > 0) {
                        bl = true;
                        break;
                    }
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException interruptedException) {}
                    ++n3;
                }
                if (bl) break;
                if (n3 < 6) break block13;
                return 0;
            }
            try {
                n = this.b.read(byArray2);
            }
            catch (IOException iOException) {
                n = 0;
            }
            this.h = false;
            if (n == 64) {
                System.arraycopy(byArray2, 1, byArray, n2, 63);
                n2 += 63;
                continue;
            }
            if (n == -1) break;
            if (n == 0 || n <= 0) continue;
            System.arraycopy(byArray2, 1, byArray, n2, n);
            n2 += n - 1;
        }
        while (n2 - 1 >= 0 && byArray[n2 - 1] == 0) {
            --n2;
        }
        return n2;
    }

    private int c(byte[] byArray) {
        int n;
        if (this.a == null || this.b == null) {
            return 0;
        }
        int n2 = 0;
        Arrays.fill(this.o, (byte)0);
        byte[] byArray2 = new byte[64];
        while (n2 != -1) {
            block10: {
                if (this.i) {
                    return 0;
                }
                this.h = true;
                n2 = 0;
                n = 0;
                while (n2 == 0 && n < 6) {
                    n2 = this.b.available();
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException interruptedException) {}
                    ++n;
                }
                if (n < 6) break block10;
                return 0;
            }
            try {
                n2 = this.b.read(byArray2);
            }
            catch (IOException iOException) {
                n2 = 0;
            }
            this.h = false;
            if (byArray2[1] == 2) break;
        }
        n2 = (byArray2[2] & 0xFF) + ((byArray2[3] & 0xFF) << 8);
        n = n2 + 6;
        n2 = 0;
        while (n2 < n) {
            byArray[n2] = byArray2[n2 + 1];
            ++n2;
        }
        return n;
    }

    private int d(byte[] byArray) {
        int n;
        int n2;
        int n3;
        byte[] byArray2;
        int n4;
        block28: {
            if (this.a == null || this.b == null) {
                return 0;
            }
            n4 = 0;
            byArray2 = new byte[64];
            if (this.i) {
                return 0;
            }
            this.h = true;
            n3 = 0;
            n2 = 0;
            while (n3 == 0 && n2 < 6) {
                n3 = this.b.available();
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {}
                ++n2;
            }
            if (n2 < 6) break block28;
            return 0;
        }
        try {
            n = this.b.read(byArray2);
        }
        catch (IOException iOException) {
            n = 0;
        }
        this.h = false;
        if (n > 0) {
            n4 = (byArray2[13] & 0xFF) << 8 | byArray2[14] & 0xFF;
            if ((n4 += 16) <= 63) {
                System.arraycopy(byArray2, 1, byArray, 0, n4);
            } else {
                block30: {
                    System.arraycopy(byArray2, 1, byArray, 0, 63);
                    n = 63;
                    while (n4 - n > 63) {
                        block29: {
                            if (this.i) {
                                return 0;
                            }
                            this.h = true;
                            try {
                                n3 = 0;
                                n2 = 0;
                                while (n3 == 0 && n2 < 6) {
                                    n3 = this.b.available();
                                    try {
                                        Thread.sleep(50L);
                                    }
                                    catch (InterruptedException interruptedException) {}
                                    ++n2;
                                }
                                if (n2 < 6) break block29;
                                return 0;
                            }
                            catch (IOException iOException) {}
                        }
                        this.b.read(byArray2);
                        this.h = false;
                        if (n + 63 > 4096) {
                            return 0;
                        }
                        System.arraycopy(byArray2, 1, byArray, n, 63);
                        n += 63;
                    }
                    if (this.i) {
                        return 0;
                    }
                    this.h = true;
                    try {
                        n3 = 0;
                        n2 = 0;
                        while (n3 == 0 && n2 < 6) {
                            n3 = this.b.available();
                            try {
                                Thread.sleep(50L);
                            }
                            catch (InterruptedException interruptedException) {}
                            ++n2;
                        }
                        if (n2 < 6) break block30;
                        return 0;
                    }
                    catch (IOException iOException) {}
                }
                this.b.read(byArray2);
                this.h = false;
                if (n4 > 4096) {
                    return 0;
                }
                System.arraycopy(byArray2, 1, byArray, n, n4 - n);
            }
        }
        return n4;
    }

    private int e(byte[] byArray) {
        int n;
        int n2;
        block20: {
            if (this.a == null || this.b == null) {
                return 0;
            }
            this.o = new byte[4096];
            if (this.i) {
                return 0;
            }
            this.h = true;
            n2 = 0;
            n = 0;
            while (n2 == 0 && n < 6) {
                n2 = this.b.available();
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {}
                ++n;
            }
            if (n < 6) break block20;
            return 0;
        }
        try {
            n = this.b.read(this.o);
        }
        catch (IOException iOException) {
            n = 0;
        }
        this.h = false;
        if (n > 0) {
            int n3;
            int n4;
            if (this.o[1] == 2 && (n4 = this.o[0] & 0xFF) == (n3 = (this.o[2] & 0xFF) + ((this.o[3] & 0xFF) << 8)) + 6 && n4 < 64) {
                n = 0;
                while (n < n4 + 1) {
                    byArray[n] = this.o[n + 1];
                    ++n;
                }
                return n4;
            }
            n4 = this.o[0] & 0xFF;
            if (n4 < 64) {
                n = 0;
                while (n < n4 + 1) {
                    byArray[n] = this.o[n + 1];
                    ++n;
                }
                return n4;
            }
            if (n4 == 191) {
                n3 = 0;
                int n5 = 0;
                n = 0;
                while (n + n5 < 4096) {
                    if ((n + n5) % 64 == 0) {
                        n4 = this.o[n + n5] & 0xFF;
                        if (n4 == 191) {
                            n3 += 63;
                        } else {
                            if (n4 < 64 && n4 > 0) {
                                n3 += n4;
                                ++n5;
                                n2 = 0;
                                while (n2 < n4) {
                                    byArray[n + n2] = this.o[n + n5 + n2];
                                    ++n2;
                                }
                                return n3;
                            }
                            if (n4 == 0) break;
                        }
                        ++n5;
                    }
                    byArray[n] = this.o[n + n5];
                    ++n;
                }
                return n3;
            }
        }
        return 0;
    }

    private boolean b() {
        this.i = true;
        do {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                InterruptedException interruptedException2 = interruptedException;
                interruptedException.printStackTrace();
            }
        } while (this.h);
        if (this.a != null) {
            this.a.close();
            this.a = null;
            this.b = null;
            this.c = null;
        }
        System.gc();
        return true;
    }

    public final int writeNothing() {
        if (this.a == null || this.c == null) {
            return 0;
        }
        if (this.i) {
            return 0;
        }
        this.h = true;
        try {
            this.c.write(null);
        }
        catch (IOException iOException) {}
        this.h = false;
        UMLog.i("**RS232 bulkTransfer**", "write res=0");
        return 0;
    }

    private int a(byte[] byArray, int n) {
        if (n <= 0) {
            return 0;
        }
        if (this.a == null || this.c == null) {
            return 0;
        }
        int n2 = 0;
        if (n > 64) {
            int n3 = (n - 1) / 63 + 1 + (n - 1);
            byte[] byArray2 = new byte[n3];
            int n4 = n3 / 64 + 1;
            int n5 = 0;
            while (n5 < n4) {
                if (n5 == n4 - 1) {
                    byArray2[n5 << 6] = 4;
                    System.arraycopy(byArray, n5 * 63 + 1, byArray2, n5 * 64 + 1, n - 1 - n5 * 63);
                } else if (n5 == 0) {
                    byArray2[0] = 2;
                    System.arraycopy(byArray, 1, byArray2, 1, 63);
                } else {
                    byArray2[n5 << 6] = 3;
                    System.arraycopy(byArray, n5 * 63 + 1, byArray2, n5 * 64 + 1, 63);
                }
                ++n5;
            }
            n5 = 0;
            while (n5 << 6 < n3) {
                byArray = new byte[64];
                if (n5 + 1 << 6 > n3) {
                    System.arraycopy(byArray2, n5 * 64, byArray, 0, n3 - (n5 << 6));
                } else {
                    System.arraycopy(byArray2, n5 * 64, byArray, 0, 64);
                }
                if (this.i) {
                    return 0;
                }
                this.h = true;
                try {
                    if (n5 + 1 << 6 > n3) {
                        this.c.write(byArray, 0, n3 - (n5 << 6));
                        n2 = n3 - (n5 << 6);
                    } else {
                        this.c.write(byArray, 0, 64);
                        n2 = 64;
                    }
                }
                catch (IOException iOException) {
                    n2 = 0;
                }
                this.h = false;
                UMLog.i("**RS232 bulkTransfer 1**", "write res=".concat(String.valueOf(n2)));
                ++n5;
            }
        } else {
            if (this.i) {
                return 0;
            }
            this.h = true;
            try {
                byArray[0] = 1;
                this.c.write(byArray, 0, n);
                n2 = n;
            }
            catch (IOException iOException) {
                n2 = 0;
            }
            this.h = false;
            UMLog.i("**USB bulkTransfer 2**", "write res=".concat(String.valueOf(n2)));
        }
        UMLog.i("**RS232 SEND**", "write res=".concat(String.valueOf(n2)));
        return n2;
    }

    private final class a
    extends Thread {
        private boolean a = false;
        private /* synthetic */ RS232Controller b;

        private a(RS232Controller rS232Controller) {
            this.b = rS232Controller;
        }

        @Override
        public final void run() {
            InterruptedException interruptedException;
            try {
                com.idtechproducts.device.rs232.RS232Controller$a.sleep(300L);
            }
            catch (InterruptedException interruptedException2) {
                interruptedException = interruptedException2;
                interruptedException2.printStackTrace();
            }
            while (!this.a) {
                if (this.b.a != null) break;
                this.a = this.b.initWithThread();
                try {
                    com.idtechproducts.device.rs232.RS232Controller$a.sleep(2000L);
                }
                catch (InterruptedException interruptedException3) {
                    interruptedException = interruptedException3;
                    interruptedException3.printStackTrace();
                }
            }
        }

        /* synthetic */ a(RS232Controller rS232Controller, byte by) {
            this(rS232Controller);
        }
    }

    private final class b
    extends Thread {
        private boolean a = false;
        private /* synthetic */ RS232Controller b;

        private b(RS232Controller rS232Controller) {
            this.b = rS232Controller;
        }

        @Override
        public final void run() {
            while (this.b.k < this.b.j && !this.a) {
                Object object;
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    InterruptedException interruptedException2 = interruptedException;
                    interruptedException.printStackTrace();
                }
                int n = this.b.e(this.b.n);
                if (n > 0) {
                    this.a = true;
                    object = new IDTMSRData();
                    byte[] byArray = new byte[n];
                    System.arraycopy(this.b.n, 0, byArray, 0, n);
                    if (byArray[0] == 2 && (byArray[3] == -128 || byArray[3] == -127 || byArray[3] == -125 || byArray[3] == -124 || byArray[3] == -123 || byArray[3] == -122 || byArray[3] == -64)) {
                        Common.Response.parseCardData(byArray, (IDTMSRData)object, 0);
                    } else if (byArray[1] == 2 && (this.b.o[4] == -128 || byArray[4] == -127 || byArray[4] == -125 || byArray[4] == -124 || byArray[4] == -123 || byArray[4] == -122 || byArray[4] == -64)) {
                        Common.Response.parseCardDataUniPay(byArray, (IDTMSRData)object);
                    } else {
                        Common.Response.parseCardClearData(byArray, (IDTMSRData)object);
                    }
                    UMLog.i("SDK::RS232 Controller", "got: " + Common.getByteArrDesc(this.b.n));
                    this.b.d.com_onReceiveMsgCardData((IDTMSRData)object);
                    break;
                }
                RS232Controller rS232Controller = this.b;
                rS232Controller.k = rS232Controller.k + 1;
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    object = interruptedException;
                    interruptedException.printStackTrace();
                }
            }
            if (this.b.k >= this.b.j) {
                b b2 = this;
                this.a = true;
                this.b.d.com_onReceiveMsgSwipeTimeout();
            }
            this.b.g = false;
            IDT_Device.isCommandRunning = false;
        }

        public final void a() {
            this.a = true;
        }

        /* synthetic */ b(RS232Controller rS232Controller, byte by) {
            this(rS232Controller);
        }
    }

    private final class c
    extends Thread {
        public boolean a = true;
        private /* synthetic */ RS232Controller b;

        private c(RS232Controller rS232Controller) {
            this.b = rS232Controller;
        }

        @Override
        public final void run() {
            byte[] byArray = new byte[4096];
            while (this.a) {
                Object object;
                Object object2;
                if (!IDT_Device.isBurstModeOn || !IDT_Device.isAutoPollOn || IDT_Device.isCommandRunning || Common.getBootLoaderMode()) {
                    try {
                        Thread.sleep(30L);
                    }
                    catch (InterruptedException interruptedException) {
                        object2 = interruptedException;
                        interruptedException.printStackTrace();
                    }
                    if (IDT_Device.isBurstModeOn || !IDT_Device.isAutoPollOn) continue;
                    try {
                        Thread.sleep(950L);
                    }
                    catch (InterruptedException interruptedException) {
                        object2 = interruptedException;
                        interruptedException.printStackTrace();
                    }
                    if (IDT_Device.isCommandRunning) continue;
                    if (IDT_Device.isMonitorCtlsData) {
                        object2 = new IDTMSRData();
                        byte[] byArray2 = Common.getByteArray("5669564F7465636832000340000096E2");
                        object = this.b.sendCommand(byArray2, 1);
                        int n = 0;
                        if (object != null && ((byte[])object).length > 13) {
                            n = ((object[12] & 0xFF) << 8) + (object[13] & 0xFF);
                        }
                        if (n > 7) {
                            Common.parseCardData3in1(object, (IDTMSRData)object2);
                            UMLog.i("listenForDataOnThread", "got: " + Common.getByteArrDesc(object));
                            this.b.d.com_onReceiveMsgCardData((IDTMSRData)object2);
                            continue;
                        }
                        ((IDTMSRData)object2).result = 61092;
                        this.b.d.com_onReceiveMsgCardData((IDTMSRData)object2);
                        continue;
                    }
                    object2 = new IDTMSRData();
                    new IDTMSRData().result = 61092;
                    this.b.d.com_onReceiveMsgCardData((IDTMSRData)object2);
                    continue;
                }
                IDT_Device.isCheckingNotification = true;
                try {
                    Thread.sleep(30L);
                }
                catch (InterruptedException interruptedException) {
                    object2 = interruptedException;
                    interruptedException.printStackTrace();
                }
                IDT_Device.isThreadReading = true;
                int n = this.b.b(byArray);
                IDT_Device.isThreadReading = false;
                if (n > 0) {
                    if (n > 12 && byArray[10] == 2 && byArray[11] == -96) {
                        IDTMSRData iDTMSRData = new IDTMSRData();
                        new IDTMSRData().result = 61088;
                        this.b.d.com_onReceiveMsgCardData(iDTMSRData);
                        try {
                            Thread.sleep(30L);
                        }
                        catch (InterruptedException interruptedException) {
                            object = interruptedException;
                            interruptedException.printStackTrace();
                        }
                        continue;
                    }
                    if (n > 12 && byArray[10] == -18 && byArray[11] == -16) {
                        IDTMSRData iDTMSRData = new IDTMSRData();
                        new IDTMSRData().result = 61168;
                        this.b.d.com_onReceiveMsgCardData(iDTMSRData);
                        try {
                            Thread.sleep(30L);
                        }
                        catch (InterruptedException interruptedException) {
                            object = interruptedException;
                            interruptedException.printStackTrace();
                        }
                        continue;
                    }
                    byte[] byArray3 = new byte[n];
                    System.arraycopy(byArray, 0, byArray3, 0, n);
                    object = new IDTMSRData();
                    Common.processCTLSData(byArray3, (IDTMSRData)object);
                    UMLog.i("listenForDataOnThread", "got: " + Common.getByteArrDesc(byArray3));
                    this.b.d.com_onReceiveMsgCardData((IDTMSRData)object);
                }
                try {
                    Thread.sleep(30L);
                }
                catch (InterruptedException interruptedException) {
                    InterruptedException interruptedException2 = interruptedException;
                    interruptedException.printStackTrace();
                }
                IDT_Device.isCheckingNotification = false;
            }
            this.b.m = null;
        }

        /* synthetic */ c(RS232Controller rS232Controller, byte by) {
            this(rS232Controller);
        }
    }
}

