/*
 * Decompiled with CFR 0.152.
 */
package com.idtechproducts.device.audiojack.tasks;

import android.media.AudioTrack;
import android.os.Build;
import com.idtechproducts.device.Common;
import com.idtechproducts.device.IDT_Device;
import com.idtechproducts.device.ReaderInfo;
import com.idtechproducts.device.StructConfigParameters;
import com.idtechproducts.device.audiojack.ReaderCommunication;
import com.idtechproducts.device.audiojack.UMLog;
import com.idtechproducts.device.audiojack.io.IOManager;
import com.idtechproducts.device.audiojack.io.ToneType;
import com.idtechproducts.device.audiojack.tasks.Task;
import com.idtechproducts.device.audiojack.tasks.TaskManager;
import java.io.File;
import java.io.IOException;
import java.util.List;

public class AutoConfigTask
extends Task {
    private final boolean a;
    private final List<StructConfigParameters> b;
    private StructConfigParameters c;
    private IDT_Device.TaskExport d;
    private static final int[] e = Build.MANUFACTURER.equalsIgnoreCase("samsung") ? new int[]{48000, 44100, 22050} : new int[]{48000, 44100, 32000, 24000, 22050};
    private final byte[] f = Common.base16Decode("023100064142434445464748494a4b4c4d4e4f505152535455565758595a6162636465666768696a6b6c6d6e6f707172737475760a2203");
    private final byte[] g = Common.base16Decode("06024142434445464748494a4b4c4d4e4f505152535455565758595a6162636465666768696a6b6c6d6e6f70717273747576030d");
    private static /* synthetic */ int[] h;

    public AutoConfigTask(TaskManager taskManager, ReaderCommunication readerCommunication, boolean bl, List<StructConfigParameters> list, IDT_Device.TaskExport taskExport) {
        super(taskManager, readerCommunication);
        this.d = taskExport;
        this.a = bl;
        this.b = list;
    }

    @Override
    protected boolean taskSetup() {
        this.tone_saveAndStop();
        if (this._ioManager != null) {
            this.c = this._ioManager.getConfigCopy();
        }
        return true;
    }

    @Override
    protected void taskCleanup() {
        if (this._ioManager != null) {
            this._ioManager.notifyTaskFinished();
            this._ioManager.setConfig(this.c);
        }
        this.tone_restore();
    }

    @Override
    public TaskManager.TaskType getType() {
        return TaskManager.TaskType.AutoConfig;
    }

    @Override
    protected Runnable taskMain() {
        int n;
        int n2;
        this.a(0);
        this._ioManager.stopRecordThread();
        StructConfigParameters structConfigParameters = null;
        if (this.b != null) {
            n2 = 0;
            n = 0;
            while (n < this.b.size()) {
                StructConfigParameters structConfigParameters2 = this.b.get(n);
                if ((this.a || structConfigParameters2.getBaudRate() == 9600) && Common.checkInputFrequencySupported(structConfigParameters2.getFrequenceInput())) {
                    if (Build.VERSION.SDK_INT == 8) {
                        structConfigParameters2.setForceHeadsetPlug((short)1);
                    }
                    int n3 = 1;
                    while (n3 >= 0) {
                        structConfigParameters2.setUseVoiceRecognition((short)n3);
                        int n4 = 1;
                        while (n4 >= 0) {
                            UMLog.i(this.TAG, "template: " + structConfigParameters2.getModelNumber() + " (vr:" + n3 + ", dir:" + n4 + ")");
                            structConfigParameters2.setDirectionOutputWave((short)n4);
                            int n5 = ++n2 * 70 / this.b.size() / 2 / 2;
                            if (n5 == 0) {
                                n5 = 1;
                            }
                            this.a(n5);
                            StructConfigParameters structConfigParameters3 = structConfigParameters2;
                            a a2 = this.a(structConfigParameters3, structConfigParameters3.getBaudRate());
                            if (a2.a) {
                                return null;
                            }
                            if (a2.b != null) {
                                structConfigParameters = a2.b;
                                break;
                            }
                            --n4;
                        }
                        if (structConfigParameters != null) break;
                        --n3;
                    }
                    if (structConfigParameters != null) break;
                }
                ++n;
            }
        }
        if (structConfigParameters == null && !Common.fastSearch) {
            structConfigParameters = new StructConfigParameters();
            if (Build.VERSION.SDK_INT == 8) {
                structConfigParameters.setForceHeadsetPlug((short)1);
            }
            boolean bl = false;
            int[] nArray = e;
            int n6 = e.length;
            n = 0;
            while (n < n6) {
                n2 = nArray[n];
                if (Common.checkInputFrequencySupported(n2)) {
                    structConfigParameters.setFrequenceInput(n2);
                    bl = true;
                    break;
                }
                ++n;
            }
            if (!bl) {
                UMLog.e(this.TAG, "aborted. Device does not support any input sampling rate");
                return null;
            }
            a a3 = this.a(structConfigParameters);
            if (a3.a) {
                return null;
            }
            structConfigParameters = a3.b;
            if (structConfigParameters != null) {
                UMLog.i(this.TAG, "output parameters found");
                a a4 = this.b(structConfigParameters);
                if (a4.a) {
                    return null;
                }
                structConfigParameters = a4.b;
            }
        }
        if (structConfigParameters != null) {
            UMLog.i(this.TAG, "profile found");
            if (this.c != null) {
                structConfigParameters.setSupportStatuses(this.c.getSupportStatuses());
            }
        }
        StructConfigParameters structConfigParameters4 = structConfigParameters;
        return new Runnable(this, structConfigParameters4){
            private /* synthetic */ AutoConfigTask a;
            private final /* synthetic */ StructConfigParameters b;
            {
                this.a = autoConfigTask;
                this.b = structConfigParameters;
            }

            @Override
            public final void run() {
                if (this.b != null) {
                    try {
                        AutoConfigTask.a(this.a, this.b);
                    }
                    catch (IOException iOException) {
                        UMLog.e(this.a.TAG, "***=== saveConfigToFile:" + iOException.toString());
                    }
                    this.a._umrMsg.autoConfigCompleted(this.b);
                    return;
                }
                this.a._ioManager.stopRecordThread();
                this.a._umrMsg.timeout(25);
            }
        };
    }

    private void a(int n) {
        this.post(new Runnable(this, n){
            private /* synthetic */ AutoConfigTask a;
            private final /* synthetic */ int b;
            {
                this.a = autoConfigTask;
                this.b = n;
            }

            @Override
            public final void run() {
                this.a._umrMsg.autoConfigProgress(this.b);
            }
        });
    }

    private a a(StructConfigParameters structConfigParameters) {
        int[] nArray;
        a a2 = new a(0);
        new a(0).a = true;
        a2.b = null;
        short[] sArray = new short[2];
        sArray[0] = 1;
        short[] sArray2 = sArray;
        if (Build.MANUFACTURER.equalsIgnoreCase("samsung")) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = 48000;
        } else {
            int[] nArray3 = new int[2];
            nArray3[0] = 24000;
            nArray = nArray3;
            nArray3[1] = 48000;
        }
        int[] nArray4 = nArray;
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        block0: while (n2 < 2) {
            structConfigParameters.setDirectionOutputWave(sArray2[n2]);
            int n3 = 0;
            while (n3 < nArray4.length) {
                if (AudioTrack.getMinBufferSize((int)nArray4[n3], (int)12, (int)3) < 0) {
                    UMLog.i(this.TAG, "skipped unsupported output sampling rate: " + nArray4[n3]);
                } else {
                    IOManager.RPDResult rPDResult;
                    structConfigParameters.setFrequenceOutput(nArray4[n3]);
                    AutoConfigTask.c(structConfigParameters);
                    UMLog.i(this.TAG, structConfigParameters.getModelNumber());
                    this._ioManager.setConfig(structConfigParameters);
                    this.a(70 + ++n * 20 / (2 * nArray4.length));
                    if (this.a) {
                        StructConfigParameters structConfigParameters2 = structConfigParameters;
                        AutoConfigTask autoConfigTask = this;
                        rPDResult = this._readerCommunication.sendCommand(Common.makeSetBaudAndLevelCommand(structConfigParameters2, structConfigParameters2.getBaudRate()), 2.0, autoConfigTask, autoConfigTask);
                    } else {
                        this._tonePlayer.setPlayingTone(ToneType.T_2400Hz);
                        AutoConfigTask autoConfigTask = this;
                        rPDResult = this._readerCommunication.sendCommand(null, 2.5, autoConfigTask, autoConfigTask);
                        this._tonePlayer.setPlayingTone(null);
                    }
                    byte[] byArray = rPDResult.isParsed() ? rPDResult.data.get(0) : new byte[1];
                    UMLog.i(this.TAG, "findParam_output:" + Common.getHexStringFromBytes(byArray));
                    if (rPDResult.isCanceledOrFailed()) {
                        return a2;
                    }
                    if (rPDResult.packetDetected) {
                        bl = true;
                        break block0;
                    }
                    if (this.safeWait(1.6)) {
                        return a2;
                    }
                }
                ++n3;
            }
            ++n2;
        }
        if (!bl) {
            a2.a = false;
            return a2;
        }
        a2.a = false;
        a2.b = structConfigParameters;
        return a2;
    }

    private a b(StructConfigParameters structConfigParameters) {
        short[] sArray;
        structConfigParameters = structConfigParameters.clone();
        a a2 = new a(0);
        new a(0).a = true;
        a2.b = null;
        UMLog.i(this.TAG, "set channel");
        int n = this.a ? 2400 : 9600;
        structConfigParameters.setBaudRate(n);
        this._ioManager.setConfig(structConfigParameters);
        if (this.a) {
            IOManager.RPDResult rPDResult;
            if (this.d.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_UNIMAG) {
                AutoConfigTask autoConfigTask = this;
                rPDResult = this._readerCommunication.sendCommand(Common.makeSetBaudCommand(structConfigParameters), 1.5, autoConfigTask, autoConfigTask);
            } else if (this.d.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_UNIJACK) {
                AutoConfigTask autoConfigTask = this;
                rPDResult = this._readerCommunication.sendCommand(Common.makeSetBaudCommandForUniJack(structConfigParameters), 1.5, autoConfigTask, autoConfigTask);
            } else {
                StructConfigParameters structConfigParameters2 = structConfigParameters;
                AutoConfigTask autoConfigTask = this;
                rPDResult = this._readerCommunication.sendCommand(Common.makeSetBaudAndLevelCommand(structConfigParameters2, structConfigParameters2.getBaudRate()), 2.5, autoConfigTask, autoConfigTask);
            }
            if (rPDResult.isCanceledOrFailed()) {
                return a2;
            }
        }
        byte[] byArray = new byte[2];
        byArray[0] = 48;
        byte[] byArray2 = byArray;
        if (Build.VERSION.SDK_INT >= 7) {
            short[] sArray2 = new short[2];
            sArray = sArray2;
            sArray2[0] = 1;
        } else {
            sArray = new short[1];
        }
        short[] sArray3 = sArray;
        int[] nArray = e;
        boolean bl = false;
        int n2 = 0;
        int n3 = 0;
        block0: while (n3 < 2) {
            structConfigParameters.setShuttleChannel(byArray2[n3]);
            UMLog.i(this.TAG, "LEVEL: " + byArray2[n3]);
            int n4 = 0;
            while (n4 < sArray3.length) {
                structConfigParameters.setUseVoiceRecognition(sArray3[n4]);
                int n5 = 0;
                while (n5 < nArray.length) {
                    if (!Common.checkInputFrequencySupported(nArray[n5])) {
                        UMLog.i(this.TAG, "skipped unsupported input sampling rate: " + nArray[n5]);
                    } else {
                        Object object;
                        structConfigParameters.setFrequenceInput(nArray[n5]);
                        AutoConfigTask.c(structConfigParameters);
                        UMLog.i(this.TAG, structConfigParameters.getModelNumber());
                        this._ioManager.setConfig(structConfigParameters);
                        this.a(90 + ++n2 * 10 / (2 * sArray3.length * nArray.length));
                        if (this.a) {
                            if (this.d.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_UNIMAG) {
                                AutoConfigTask autoConfigTask = this;
                                object = this._readerCommunication.sendCommand(Common.makeSetBaudCommand(structConfigParameters), 1.5, autoConfigTask, autoConfigTask);
                            } else if (this.d.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_UNIJACK) {
                                AutoConfigTask autoConfigTask = this;
                                object = this._readerCommunication.sendCommand(Common.makeSetBaudCommandForUniJack(structConfigParameters), 1.5, autoConfigTask, autoConfigTask);
                            } else {
                                StructConfigParameters structConfigParameters3 = structConfigParameters;
                                AutoConfigTask autoConfigTask = this;
                                object = this._readerCommunication.sendCommand(Common.makeSetBaudAndLevelCommand(structConfigParameters3, structConfigParameters3.getBaudRate()), 2.5, autoConfigTask, autoConfigTask);
                            }
                        } else {
                            this._tonePlayer.setPlayingTone(ToneType.T_2400Hz);
                            AutoConfigTask autoConfigTask = this;
                            object = this._readerCommunication.sendCommand(null, 2.5, autoConfigTask, autoConfigTask);
                            this._tonePlayer.setPlayingTone(null);
                        }
                        Object object2 = ((IOManager.RPDResult)object).isParsed() ? ((IOManager.RPDResult)object).data.get(0) : new byte[1];
                        UMLog.i(this.TAG, "findParam_output:" + Common.getHexStringFromBytes((byte[])object2));
                        if (((IOManager.RPDResult)object).isCanceledOrFailed()) {
                            return a2;
                        }
                        if (((IOManager.RPDResult)object).isParsed()) {
                            Object object3;
                            object2 = structConfigParameters;
                            object = this;
                            object2 = ((StructConfigParameters)object2).clone();
                            a a3 = new a(0);
                            new a(0).a = true;
                            a3.b = null;
                            if (((AutoConfigTask)object).a) {
                                a a4 = super.a((StructConfigParameters)object2, 4800);
                                if (a4.a) {
                                    object3 = a3;
                                } else if (a4.b != null) {
                                    a4 = super.a((StructConfigParameters)object2, 9600);
                                    if (a4.a) {
                                        object3 = a3;
                                    } else {
                                        ((StructConfigParameters)object2).setBaudRate(a4.b != null ? 9600 : 4800);
                                        a3.b = object2;
                                        a3.a = false;
                                        object3 = a3;
                                    }
                                } else {
                                    object3 = a4 = super.a((StructConfigParameters)object2, 2400);
                                }
                            } else {
                                object3 = object = super.a((StructConfigParameters)object2, 9600);
                            }
                            if (((a)object3).a) {
                                return a2;
                            }
                            if (((a)object).b != null) {
                                structConfigParameters = ((a)object).b;
                                AutoConfigTask.c(structConfigParameters);
                                UMLog.i(this.TAG, "found stable profile: " + structConfigParameters.getModelNumber());
                                bl = true;
                                break block0;
                            }
                        }
                        if (this.safeWait(1.6)) {
                            return a2;
                        }
                    }
                    ++n5;
                }
                ++n4;
            }
            ++n3;
        }
        if (!bl) {
            a2.a = false;
            return a2;
        }
        a2.a = false;
        a2.b = structConfigParameters;
        return a2;
    }

    private Boolean a() {
        UMLog.i(this.TAG, "helper_isLongCmdSupported 1");
        if (!this.a) {
            return Boolean.FALSE;
        }
        ReaderInfo.DEVICE_TYPE dEVICE_TYPE = this.d.getReaderType();
        switch (AutoConfigTask.b()[dEVICE_TYPE.ordinal()]) {
            case 2: 
            case 8: 
            case 14: {
                return Boolean.FALSE;
            }
            case 3: 
            case 4: 
            case 5: {
                return Boolean.TRUE;
            }
        }
        return Boolean.FALSE;
    }

    private a a(StructConfigParameters structConfigParameters, int n) {
        structConfigParameters = structConfigParameters.clone();
        a a2 = new a(0);
        new a(0).a = true;
        a2.b = null;
        this._ioManager.setConfig(structConfigParameters);
        Boolean bl = this.a();
        if (this.a) {
            IOManager.RPDResult rPDResult;
            UMLog.i(this.TAG, "Stability test: for baud: ".concat(String.valueOf(n)));
            structConfigParameters.setBaudRate(n);
            this._ioManager.setConfig(structConfigParameters);
            if (this.d.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_UNIMAG) {
                AutoConfigTask autoConfigTask = this;
                rPDResult = this._readerCommunication.sendCommand(Common.makeSetBaudCommand(structConfigParameters), 1.5, autoConfigTask, autoConfigTask);
            } else if (this.d.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_UNIJACK) {
                AutoConfigTask autoConfigTask = this;
                rPDResult = this._readerCommunication.sendCommand(Common.makeSetBaudCommandForUniJack(structConfigParameters), 1.5, autoConfigTask, autoConfigTask);
            } else if (this.d.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ || this.d.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V) {
                StructConfigParameters structConfigParameters2 = structConfigParameters;
                AutoConfigTask autoConfigTask = this;
                rPDResult = this._readerCommunication.sendCommand(Common.makeSetBaudAndLevelCommand(structConfigParameters2, structConfigParameters2.getBaudRate()), 1.5, autoConfigTask, autoConfigTask);
            } else {
                StructConfigParameters structConfigParameters3 = structConfigParameters;
                AutoConfigTask autoConfigTask = this;
                rPDResult = this._readerCommunication.sendCommand(Common.makeSetBaudAndLevelCommand(structConfigParameters3, structConfigParameters3.getBaudRate()), 2.5, autoConfigTask, autoConfigTask);
            }
            if (rPDResult.isCanceledOrFailed()) {
                return a2;
            }
        } else {
            structConfigParameters.setBaudRate(9600);
            this._ioManager.setConfig(structConfigParameters);
            if (this.safeWait(2.0)) {
                return a2;
            }
        }
        int n2 = 1;
        while (n2 <= 3) {
            Object object;
            UMLog.i(this.TAG, "Stability test: trial ".concat(String.valueOf(n2)));
            short s = 200;
            if (this._config != null) {
                s = this._config.getPowerupLastBeforeCMD();
            }
            structConfigParameters.setPowerupLastBeforeCMD(s);
            this._ioManager.setConfig(structConfigParameters);
            if (this.d.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_UNIMAG) {
                AutoConfigTask autoConfigTask = this;
                object = this._readerCommunication.sendCommand(Common.base16Decode("0252200373"), 2.5, autoConfigTask, autoConfigTask);
            } else if (this.d.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ || this.d.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V) {
                object = Common.packageCommandForVendi("5669564F74656368320018010000B3CD");
                AutoConfigTask autoConfigTask = this;
                object = this._readerCommunication.sendCommand(Common.getBytesFromHexString((String)object), 2.0, autoConfigTask, autoConfigTask);
            } else {
                AutoConfigTask autoConfigTask = this;
                object = this._readerCommunication.sendCommand(Common.makeCommand("7D4600", s), 2.0, autoConfigTask, autoConfigTask);
            }
            if (((IOManager.RPDResult)object).isCanceledOrFailed()) {
                return a2;
            }
            boolean bl2 = this.a && bl.booleanValue() ? (this.d.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_UNIMAG ? ((IOManager.RPDResult)object).isParsed() && ((IOManager.RPDResult)object).matches(this.g) : ((IOManager.RPDResult)object).isParsed() && ((IOManager.RPDResult)object).matches(this.f)) : ((IOManager.RPDResult)object).isParsed();
            if (!bl2) {
                UMLog.i(this.TAG, "Stability test: failed");
                a2.b = null;
                a2.a = false;
                return a2;
            }
            if (this.safeWait(1.0)) {
                return a2;
            }
            ++n2;
        }
        UMLog.i(this.TAG, "Stability test: passed");
        a2.b = structConfigParameters;
        a2.a = false;
        return a2;
    }

    private static void c(StructConfigParameters structConfigParameters) {
        String string = "<outDir=" + structConfigParameters.getDirectionOutputWave() + ",psamp=" + structConfigParameters.getFrequenceOutput() + ",baud=" + structConfigParameters.getBaudRate() + ",rsamp=" + structConfigParameters.getFrequenceInput() + ",vr=" + structConfigParameters.getUseVoiceRecognition() + (structConfigParameters.getShuttleChannel() != 48 ? ",shuttleChannel" : "") + ">";
        structConfigParameters.setModelNumber(string);
    }

    static /* synthetic */ void a(AutoConfigTask object, StructConfigParameters object2) throws IOException {
        object = object2;
        object2 = Common.getDir_externalOrSandbox(IDT_Device.context);
        UMLog.open((File)object2, "AutoConfig");
        UMLog.i("AutoConfig", ((StructConfigParameters)object).toXMLString());
        UMLog.close();
    }

    private static /* synthetic */ int[] b() {
        if (h != null) {
            return h;
        }
        int[] nArray = new int[ReaderInfo.DEVICE_TYPE.values().length];
        try {
            nArray[ReaderInfo.DEVICE_TYPE.DEVICE_AUGUSTA.ordinal()] = 13;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ReaderInfo.DEVICE_TYPE.DEVICE_BTMAG.ordinal()] = 12;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ReaderInfo.DEVICE_TYPE.DEVICE_BTPAY.ordinal()] = 10;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ReaderInfo.DEVICE_TYPE.DEVICE_BTPAY_USB.ordinal()] = 11;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ReaderInfo.DEVICE_TYPE.DEVICE_KIOSK_III.ordinal()] = 16;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ReaderInfo.DEVICE_TYPE.DEVICE_MINISMART_II.ordinal()] = 7;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT.ordinal()] = 25;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB.ordinal()] = 24;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ReaderInfo.DEVICE_TYPE.DEVICE_PIP_READER.ordinal()] = 17;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ReaderInfo.DEVICE_TYPE.DEVICE_SECUREMAG.ordinal()] = 27;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ReaderInfo.DEVICE_TYPE.DEVICE_SECUREMAG_KB.ordinal()] = 28;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ReaderInfo.DEVICE_TYPE.DEVICE_UNIJACK.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ReaderInfo.DEVICE_TYPE.DEVICE_UNIMAG.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ReaderInfo.DEVICE_TYPE.DEVICE_UNIMAG_PRO.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V.ordinal()] = 14;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V_USB.ordinal()] = 15;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_USB.ordinal()] = 6;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ReaderInfo.DEVICE_TYPE.DEVICE_UNKNOWN.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ReaderInfo.DEVICE_TYPE.DEVICE_VENDI.ordinal()] = 18;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ReaderInfo.DEVICE_TYPE.DEVICE_VP2000.ordinal()] = 23;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ.ordinal()] = 8;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB.ordinal()] = 9;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT.ordinal()] = 20;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB.ordinal()] = 21;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_COM.ordinal()] = 22;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB.ordinal()] = 19;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ReaderInfo.DEVICE_TYPE.DEVICE_VP8800.ordinal()] = 26;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT.ordinal()] = 29;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        h = nArray;
        return nArray;
    }

    private static final class a {
        public boolean a;
        public StructConfigParameters b;

        private a() {
        }

        /* synthetic */ a(byte by) {
            this();
        }
    }
}

