/*
 * Decompiled with CFR 0.152.
 */
package com.zeamster.paymentsdk.transaction;

import android.app.Activity;
import com.idtechproducts.device.IDT_VP3300;
import com.idtechproducts.device.ReaderInfo;
import com.zeamster.paymentsdk.resthandler.HttpMethod;
import com.zeamster.paymentsdk.resthandler.RestServiceClient;
import com.zeamster.paymentsdk.service.IDTECHBLEService;
import com.zeamster.paymentsdk.service.PaymentMethod;
import com.zeamster.paymentsdk.transaction.EncryptionFormat;
import com.zeamster.paymentsdk.transaction.EntryModeId;
import com.zeamster.paymentsdk.transaction.ICallbackEMV;
import com.zeamster.paymentsdk.transaction.ICallbackTransaction;
import com.zeamster.paymentsdk.transaction.Transaction;
import com.zeamster.paymentsdk.transaction.TransactionAction;
import java.util.HashMap;

public class EMVTransaction
extends Transaction
implements ICallbackTransaction {
    public IDTECHBLEService a;
    public TransactionAction b;
    public HashMap<String, Object> c;

    public EMVTransaction(RestServiceClient restServiceClient, ICallbackEMV callbackEMV, Activity context, ReaderInfo.DEVICE_TYPE deviceType) {
        super(restServiceClient);
        this.a = new IDTECHBLEService(callbackEMV, context, deviceType);
    }

    public boolean isPluginRequest() {
        return this.a.isPluginRequest();
    }

    public void isPluginRequest(boolean pluginRequest) {
        this.a.isPluginRequest(pluginRequest);
    }

    public IDTECHBLEService getIdTechBLEService() {
        return this.a;
    }

    public ReaderInfo.DEVICE_TYPE getDeviceType() {
        return this.a.getDeviceType();
    }

    public void setDeviceType(ReaderInfo.DEVICE_TYPE deviceType) {
        this.a.setDeviceType(deviceType);
    }

    public IDT_VP3300 getIdt_vp3300() {
        return this.a.getIdt_vp3300();
    }

    public void scanForDevices() {
        this.scanForDevices(0L);
    }

    public void scanForDevices(long timeout) {
        this.scanForDevices("*", timeout);
    }

    public void scanForDevices(String searchString, long timeout) {
        this.a.scanForDevices(searchString, timeout);
    }

    public void stopScanForDevices() {
        this.a.stopScanForDevices();
    }

    public boolean connectDeviceByName(String deviceName) {
        return this.a.connectDeviceByName(deviceName);
    }

    public boolean connectDeviceByAddress(String address) {
        return this.a.connectDeviceByAddress(address);
    }

    public void performEMVSale(TransactionAction transactionAction, HashMap<String, Object> payload) {
        this.a.setCallbackTransaction(this);
        this.b = transactionAction;
        this.c = payload;
        this.a.startEMVTransaction();
    }

    public void cancelEMVSale() {
        this.a.cancelEMVTransaction();
    }

    public void performMSRSale(TransactionAction transactionAction, HashMap<String, Object> payload) {
        this.a.setCallbackTransaction(this);
        this.b = transactionAction;
        this.c = payload;
        this.a.startMSRTransaction();
    }

    public void cancelMSRSale() {
        this.a.cancelMSRSwipe();
    }

    public void performRefund(HashMap<String, Object> payload) {
        EMVTransaction eMVTransaction = this;
        eMVTransaction.restServiceClient.setRequestBody(this.convertToTransactionPayload(payload));
        eMVTransaction.perform(HttpMethod.POST);
    }

    public void performAuthOnly(HashMap<String, Object> payload) {
        EMVTransaction eMVTransaction = this;
        eMVTransaction.restServiceClient.setRequestBody(this.convertToTransactionPayload(payload));
        eMVTransaction.perform(HttpMethod.POST);
    }

    public void performAVSOnly(HashMap<String, Object> payload) {
        EMVTransaction eMVTransaction = this;
        eMVTransaction.restServiceClient.setRequestBody(this.convertToTransactionPayload(payload));
        eMVTransaction.perform(HttpMethod.POST);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void call(Object type, Object data, Object ksn) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (type != null && var1_1.toString().equalsIgnoreCase("MSR")) {
            EMVTransaction eMVTransaction = this;
            eMVTransaction.c.remove("emv_request");
            eMVTransaction.c.put("e_format", EncryptionFormat.IDTECH.toString().toLowerCase());
            eMVTransaction.c.put("entry_mode_id", EntryModeId.Swiped.getName());
            eMVTransaction.c.put("e_track_data", var2_2.toString());
        } else if (var1_1 != null && var1_1.toString().equalsIgnoreCase("EMV")) {
            EMVTransaction eMVTransaction = this;
            eMVTransaction.c.remove("e_track_data");
            eMVTransaction.c.put("e_format", EncryptionFormat.IDTECH_EMV.toString().toLowerCase());
            eMVTransaction.c.put("entry_mode_id", EntryModeId.ChipCardRead.getName());
            eMVTransaction.c.put("emv_request", var2_2.toString() + "DF7906313230303338");
        }
        EMVTransaction eMVTransaction = this;
        eMVTransaction.c.put("payment_method", PaymentMethod.CC.name().toLowerCase());
        eMVTransaction.c.put("action", this.b.name().toLowerCase());
        eMVTransaction.c.put("e_serial_number", var3_3.toString());
        EMVTransaction eMVTransaction2 = this;
        eMVTransaction.restServiceClient.setRequestBody(eMVTransaction2.convertToTransactionPayload(eMVTransaction2.c));
        eMVTransaction.perform(HttpMethod.POST);
    }

    public void runInitialDeviceSetup(String deviceSettings) {
        this.a.runInitialSetup(deviceSettings);
    }

    public void clearLog() {
        this.a.clearLog();
    }
}

