/*
 * Decompiled with CFR 0.152.
 */
package com.idtechproducts.device;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PostCardDataParse {
    public String firstName = "";
    public String middleInitial = "";
    public String suffix = "";
    public String surname = "";
    public String title = "";
    public String serviceCode = "";
    public String accountNumber = "";
    public String expirationDate = "";
    public String cardHolderName = "";
    public String firstCardNum = "";
    public String lastCardNum = "";
    public String redactedNum = "";
    public String track1DiscretionaryData = "";
    public String track2DiscretionaryData = "";

    public boolean parseTrack1(byte[] t1) {
        if (t1 == null) {
            return false;
        }
        String s = new String(t1);
        Pattern p = Pattern.compile("%?[B\\*]([0-9\\*]{1,19})\\^(.{2,26})\\^([0-9\\*]{4})(.{3})(.*)\\?");
        Pattern p1 = Pattern.compile("[B\\*]([0-9\\*]{1,19})\\^(.{2,26})\\^([0-9\\*]{4})(.{3})(.*)");
        Matcher m = p.matcher(s);
        Matcher m1 = p1.matcher(s);
        if (m.find()) {
            String name;
            if (s.charAt(1) != '*' && s.charAt(1) != 'B') {
                return false;
            }
            String[] ss = new String[m.groupCount()];
            int i = 1;
            while (i <= m.groupCount()) {
                ss[i - 1] = m.group(i);
                ++i;
            }
            if (ss[0].length() < 12 || ss[0].length() > 19) {
                return false;
            }
            this.accountNumber = ss[0];
            this.cardHolderName = name = ss[1];
            this.nameParse(name);
            this.expirationDate = ss[2];
            this.serviceCode = ss[3];
            this.firstCardNum = this.accountNumber.substring(0, 6);
            int lenAcc = this.accountNumber.length();
            this.lastCardNum = this.accountNumber.substring(lenAcc - 4, lenAcc);
            this.track1DiscretionaryData = ss[4];
            this.redactedNum = this.accountNumber;
            return true;
        }
        if (m1.find()) {
            String name;
            if (s.charAt(0) != '*' && s.charAt(0) != 'B') {
                return false;
            }
            String[] ss = new String[m1.groupCount()];
            int i = 1;
            while (i <= m1.groupCount()) {
                ss[i - 1] = m1.group(i);
                ++i;
            }
            if (ss[0].length() < 12 || ss[0].length() > 19) {
                return false;
            }
            this.accountNumber = ss[0];
            this.cardHolderName = name = ss[1];
            this.nameParse(name);
            this.expirationDate = ss[2];
            this.serviceCode = ss[3];
            this.firstCardNum = this.accountNumber.substring(0, 6);
            int lenAcc = this.accountNumber.length();
            this.lastCardNum = this.accountNumber.substring(lenAcc - 4, lenAcc);
            this.track1DiscretionaryData = ss[4];
            this.redactedNum = this.accountNumber;
            return true;
        }
        return false;
    }

    public boolean parseTrack2(byte[] t2) {
        if (t2 == null) {
            return false;
        }
        String s = new String(t2);
        if (s.length() < 20) {
            return false;
        }
        Pattern p = Pattern.compile(";?([0-9\\*]{1,19})=([0-9\\*]{4})(.{3})(.*)\\?");
        Pattern p1 = Pattern.compile("([0-9\\*]{1,19})=([0-9\\*]{4})(.{3})(.*)");
        Matcher m = p.matcher(s);
        Matcher m1 = p1.matcher(s);
        if (m.find()) {
            String[] ss = new String[m.groupCount()];
            int i = 1;
            while (i <= m.groupCount()) {
                ss[i - 1] = m.group(i);
                ++i;
            }
            if (ss[0].length() < 12 || ss[0].length() > 19) {
                return false;
            }
            this.accountNumber = ss[0];
            this.firstCardNum = this.accountNumber.substring(0, 6);
            int lenAcc = this.accountNumber.length();
            this.lastCardNum = this.accountNumber.substring(lenAcc - 4, lenAcc);
            this.expirationDate = ss[1];
            this.serviceCode = ss[2];
            this.track2DiscretionaryData = ss[3];
            this.redactedNum = this.accountNumber;
            return true;
        }
        if (m1.find()) {
            String[] ss = new String[m1.groupCount()];
            int i = 1;
            while (i <= m1.groupCount()) {
                ss[i - 1] = m1.group(i);
                ++i;
            }
            if (ss[0].length() < 12 || ss[0].length() > 19) {
                return false;
            }
            this.accountNumber = ss[0];
            this.firstCardNum = this.accountNumber.substring(0, 6);
            int lenAcc = this.accountNumber.length();
            this.lastCardNum = this.accountNumber.substring(lenAcc - 4, lenAcc);
            this.expirationDate = ss[1];
            this.serviceCode = ss[2];
            this.track2DiscretionaryData = ss[3];
            this.redactedNum = this.accountNumber;
            return true;
        }
        return false;
    }

    public boolean parseAAMVATrack1(byte[] t1) {
        if (t1 == null) {
            return false;
        }
        String s = new String(t1);
        if (s.length() < 20) {
            return false;
        }
        String name = new String("");
        Pattern p = Pattern.compile("[/^]+");
        String[] result = p.split(s);
        Pattern p2 = Pattern.compile("[/$]+");
        String[] result2 = p2.split(result[1]);
        int len = result2.length;
        int j = 0;
        while (j < len) {
            name = String.valueOf(name) + result2[j];
            name = String.valueOf(name) + " ";
            ++j;
        }
        this.cardHolderName = name;
        return true;
    }

    public boolean parseAAMVATrack2(byte[] t2) {
        if (t2 == null) {
            return false;
        }
        String s = new String(t2);
        if (s.length() < 20) {
            return false;
        }
        Pattern p = Pattern.compile(";?([0-9\\*]{1,19})=([0-9\\*]{4})(.{8})(.*)\\?");
        Pattern p1 = Pattern.compile("([0-9\\*]{1,19})=([0-9\\*]{4})(.{8})(.*)");
        Matcher m = p.matcher(s);
        Matcher m1 = p1.matcher(s);
        if (m.find()) {
            String[] ss = new String[m.groupCount()];
            int i = 1;
            while (i <= m.groupCount()) {
                ss[i - 1] = m.group(i);
                ++i;
            }
            if (ss[0].length() < 12 || ss[0].length() > 19) {
                return false;
            }
            String rNumber = ss[0];
            this.expirationDate = ss[1];
            int lenAcc = rNumber.length();
            rNumber = rNumber.substring(6, lenAcc);
            String rNumber2 = ss[3];
            int lenAcc2 = rNumber2.length();
            lenAcc = rNumber.length();
            if (lenAcc2 > 0 && lenAcc > 12) {
                rNumber = String.valueOf(rNumber) + rNumber2;
                byte[] tNum = new byte[lenAcc += lenAcc2];
                int x = 0;
                while (x < lenAcc - 4) {
                    tNum[x] = 42;
                    ++x;
                }
                String firstrNum = new String(tNum);
                String lastrNum = rNumber.substring(lenAcc - 4, lenAcc);
                this.redactedNum = String.valueOf(firstrNum) + lastrNum;
            } else {
                byte[] tNum = new byte[lenAcc];
                int x = 0;
                while (x < lenAcc - 4) {
                    tNum[x] = 42;
                    ++x;
                }
                String firstrNum = new String(tNum);
                String lastrNum = rNumber.substring(lenAcc - 4, lenAcc);
                this.redactedNum = String.valueOf(firstrNum) + lastrNum;
            }
            return true;
        }
        if (m1.find()) {
            String[] ss = new String[m1.groupCount()];
            int i = 1;
            while (i <= m1.groupCount()) {
                ss[i - 1] = m1.group(i);
                ++i;
            }
            if (ss[0].length() < 12 || ss[0].length() > 19) {
                return false;
            }
            String rNumber = ss[0];
            this.expirationDate = ss[1];
            int lenAcc = rNumber.length();
            rNumber = rNumber.substring(6, lenAcc);
            String rNumber2 = ss[3];
            int lenAcc2 = rNumber2.length();
            lenAcc = rNumber.length();
            if (lenAcc2 > 0 && lenAcc > 12) {
                rNumber = String.valueOf(rNumber) + rNumber2;
                byte[] tNum = new byte[lenAcc += lenAcc2];
                int x = 0;
                while (x < lenAcc - 4) {
                    tNum[x] = 42;
                    ++x;
                }
                String firstrNum = new String(tNum);
                String lastrNum = rNumber.substring(lenAcc - 4, lenAcc);
                this.redactedNum = String.valueOf(firstrNum) + lastrNum;
            } else {
                byte[] tNum = new byte[lenAcc];
                int x = 0;
                while (x < lenAcc - 4) {
                    tNum[x] = 42;
                    ++x;
                }
                String firstrNum = new String(tNum);
                String lastrNum = rNumber.substring(lenAcc - 4, lenAcc);
                this.redactedNum = String.valueOf(firstrNum) + lastrNum;
            }
            return true;
        }
        return false;
    }

    private void nameParse(String str) {
        if (str == null || str.length() == 0) {
            return;
        }
        int format = 32;
        int i = 0;
        while (i < str.length()) {
            if (str.charAt(i) == '/') {
                format = 47;
                break;
            }
            ++i;
        }
        try {
            switch (format) {
                case 32: {
                    this.nameParseSpace(str);
                    break;
                }
                case 47: {
                    this.nameParseSlash(str);
                    break;
                }
            }
        }
        catch (IndexOutOfBoundsException e) {
            System.err.println("warning: name parse get fail");
        }
    }

    private void nameParseSpace(String str) throws IndexOutOfBoundsException {
        int i;
        String part = str.trim();
        int n = part.length() - 1;
        while (n >= 0) {
            if (part.charAt(n) == ' ') {
                ++n;
                break;
            }
            --n;
        }
        if (n > 0) {
            if (part.length() - n <= 2) {
                i = n;
                while (i < part.length()) {
                    this.suffix = String.valueOf(this.suffix) + part.charAt(i);
                    ++i;
                }
                --n;
            } else {
                n = part.length();
            }
        } else {
            n = part.length();
        }
        part = part.substring(0, n);
        n = part.length();
        i = n - 1;
        while (i >= 0) {
            if (part.charAt(i) == ' ') {
                ++i;
                break;
            }
            --i;
        }
        if (i > 0) {
            this.surname = part.substring(i);
            this.surname = this.surname.trim();
            part = part.substring(0, i);
        }
        part = part.trim();
        n = part.length() - 1;
        while (n > 0) {
            if (part.charAt(n) == ' ') {
                ++n;
                break;
            }
            --n;
        }
        if (part.length() - n == 1) {
            this.middleInitial = String.valueOf(this.middleInitial) + part.charAt(n);
            part = part.substring(0, n);
            part = part.trim();
        }
        this.firstName = part.trim();
    }

    private void nameParseSlash(String str) throws IndexOutOfBoundsException {
        String fpart = "";
        String bpart = "";
        int i = 0;
        while (i < str.length()) {
            if (str.charAt(i) == '/') {
                ++i;
                break;
            }
            fpart = String.valueOf(fpart) + str.charAt(i);
            ++i;
        }
        while (i < str.length()) {
            bpart = String.valueOf(bpart) + str.charAt(i);
            ++i;
        }
        fpart.trim();
        int n = fpart.length() - 1;
        while (n >= 0) {
            if (fpart.charAt(n) == ' ') {
                ++n;
                break;
            }
            --n;
        }
        if (n > 0) {
            if (fpart.length() - 1 - n <= 2) {
                i = n;
                while (i < fpart.length()) {
                    this.suffix = String.valueOf(this.suffix) + fpart.charAt(i);
                    ++i;
                }
            } else {
                n = fpart.length();
            }
        } else {
            n = fpart.length();
        }
        i = 0;
        while (i < n) {
            this.surname = String.valueOf(this.surname) + fpart.charAt(i);
            ++i;
        }
        this.surname = this.surname.trim();
        n = bpart.length() - 1;
        while (n >= 0) {
            if (bpart.charAt(n) == '.') break;
            --n;
        }
        if (n > 0) {
            i = n + 1;
            while (i < bpart.length()) {
                this.title = String.valueOf(this.title) + bpart.charAt(i);
                ++i;
            }
            bpart = bpart.substring(0, n);
        }
        n = bpart.length() - 1;
        while (n >= 0) {
            if (bpart.charAt(n) == ' ') break;
            --n;
        }
        if (n > 0 && bpart.length() - 1 - n > 0) {
            this.middleInitial = String.valueOf(this.middleInitial) + bpart.charAt(n + 1);
            bpart = bpart.substring(0, n);
        }
        this.firstName = bpart.trim();
    }
}

