//  HeaderInformationFragment.java
//  Sample App for PaymentSDK
//
//  Created by Samstaurej Siddiquie on 01/10/2019.
//  Copyright © 2019 Zeamster. All rights reserved.

package com.zeamster.sampleapp;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.EditText;
import android.widget.Spinner;
import android.widget.TextView;
import android.widget.Toast;

import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentTransaction;

import com.zeamster.paymentsdk.resthandler.ICallback;
import com.zeamster.paymentsdk.resthandler.RestServiceClient;

import java.util.HashMap;


public class HeaderInformationFragment extends Fragment implements View.OnClickListener, ICallback {

    private EditText hostnameControl, apiEndpointControl, userIdControl, userApiKeyControl, developerIdControl, transactionIdControl;
    private Spinner protocolControl;
    private TextView errorMessage;

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container,
                             Bundle savedInstanceState) {

        View view = inflater.inflate(R.layout.fragment_header_information, container, false);

        String[] items = getResources().getStringArray(R.array.protocols);
        Spinner dropdown = view.findViewById(R.id.protocol);
        ArrayAdapter<String> adapter = new ArrayAdapter<>(getActivity(), android.R.layout.simple_spinner_dropdown_item, items);
        dropdown.setAdapter(adapter);

        Button btnNext = view.findViewById(R.id.btnNext);
        btnNext.setOnClickListener(this);

        protocolControl = view.findViewById(R.id.protocol);
        hostnameControl = view.findViewById(R.id.hostname);
        apiEndpointControl = view.findViewById(R.id.apiEndpoint);
        userIdControl = view.findViewById(R.id.userId);
        userApiKeyControl = view.findViewById(R.id.userApiKey);
        developerIdControl = view.findViewById(R.id.developerId);
        transactionIdControl = view.findViewById(R.id.transactionId);
        errorMessage = view.findViewById(R.id.errorMsg);

        // leaving these values as default values, user can change these values on ui while screen pops up
        hostnameControl.setText("api.sandbox.zeamster.com");
        apiEndpointControl.setText("/devices/idtechinitialize");
        userIdControl.setText("11e9b20cb6c0fd9088e3e131");
        userApiKeyControl.setText("11e9e43b4b27348a85079a0b");
        developerIdControl.setText("MmkUgjqv");

        return view;
    }

    @Override
    public void onClick(View view) {

        if (view.getId() == R.id.btnNext) {

            if (userIdControl.getText().toString().isEmpty() || userApiKeyControl.getText().toString().isEmpty() || developerIdControl.getText().toString().isEmpty()) {
                errorMessage.setText("User Id, User API Id and Developer Id are required fields.");
            } else {

                String protocol = "", hostname = "", apiEndpoint = "", userId = "", userApiKey = "", developerId = "";

                protocol = protocolControl.getSelectedItem().toString().toLowerCase();
                if (protocol.isEmpty()) {
                    protocol = "https";
                }

                hostname = hostnameControl.getText().toString().toLowerCase();
                if (hostname.isEmpty()) {
                    hostname = "api.sandbox.zeamster.com";
                }

                apiEndpoint = apiEndpointControl.getText().toString().toLowerCase();
                if (apiEndpoint.isEmpty()) {
                    if (MainActivity.transactionCategory.equalsIgnoreCase("ROUTER")) {
                        apiEndpoint = "/v2/routertransactions";
                    } else if (MainActivity.transactionCategory.equalsIgnoreCase("VAULTS")) {
                        apiEndpoint = "/v2/routeraccountvaults";
                    } else {
                        apiEndpoint = "/devices/idtechinitialize";
                    }
                }

                userId = userIdControl.getText().toString();
                userApiKey = userApiKeyControl.getText().toString();
                developerId = developerIdControl.getText().toString();
                MainActivity.transactionId = transactionIdControl.getText().toString();

                try {
                    MainActivity.restServiceClient = new RestServiceClient(protocol, hostname, apiEndpoint, this);
                } catch (Exception ex) {
                    Toast.makeText(getActivity(), ex.getMessage(), Toast.LENGTH_LONG).show();
                }

                HashMap<String, String> requestHeader = new HashMap<>();
                requestHeader.put("developer-id", developerId);
                requestHeader.put("user-id", userId);
                requestHeader.put("user-api-key", userApiKey);
                requestHeader.put("Accept", "application/json");
                MainActivity.restServiceClient.setRequestHeader(requestHeader);
                MainActivity.apiResponse = "";

                FragmentTransaction fr = getFragmentManager().beginTransaction();
                fr.replace(R.id.nav_host_fragment, new TransactionInputsFragment());
                fr.addToBackStack(null);
                fr.commit();
            }
        }
    }

    @Override
    public void onSuccess(String response) {
        MainActivity.apiResponse = response;
        switchToResponseView();
    }

    @Override
    public void onFailure(String response) {
        MainActivity.apiResponse = response;
        switchToResponseView();
    }

    private void switchToResponseView() {
        FragmentTransaction fr = getFragmentManager().beginTransaction();
        fr.replace(R.id.nav_host_fragment, new TransactionResponseFragment());
        fr.addToBackStack(null);
        fr.commit();
    }
}
