/*
 * Decompiled with CFR 0.152.
 */
package com.idtechproducts.device.bluetooth;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCallback;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import android.bluetooth.BluetoothGattService;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.util.Log;
import com.idtechproducts.device.Common;
import com.idtechproducts.device.IDTMSRData;
import com.idtechproducts.device.IDT_Device;
import com.idtechproducts.device.ReaderInfo;
import com.idtechproducts.device.ResDataStruct;
import com.idtechproducts.device.audiojack.UMLog;
import com.idtechproducts.device.bluetooth.BluetoothControllerMsg;
import com.idtechproducts.device.bluetooth.IDTechBluetoothMsg;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.UUID;

public class BluetoothLEController
extends Activity {
    public static int device_BLE_Type = 2;
    public static final UUID SPS_CHARAC = UUID.fromString("00002A80-0000-1000-8000-00805f9b34fb");
    public static final UUID CCC = UUID.fromString("00002902-0000-1000-8000-00805f9b34fb");
    public static UUID SERVICE_ISSC_PROPRIETARY = UUID.fromString("49535343-FE7D-4AE5-8FA9-9FAFD205E455");
    public static UUID CHR_ISSC_READ = UUID.fromString("49535343-1E4D-4BD9-BA61-23C647249616");
    public static UUID CHR_ISSC_WRITE = UUID.fromString("49535343-8841-43F4-A8D4-ECBE34729BB3");
    public static UUID CHR_ISSC_WRITE_VP3320 = UUID.fromString("49535343-6DAA-4D02-ABF6-19569ACA69FE");
    public static final int ENABLE_NOTIFICATION_VALUE = 22919;
    public static final int DISABLE_NOTIFICATION_VALUE = 22920;
    public static UUID SERVICE_ISSC_PROPRIETARY_LERD = UUID.fromString("01fffee7-ba5e-f4ee-5ca1-eb1e5e4b1ce0");
    public static UUID CHR_ISSC_READ_LERD = UUID.fromString("01fffec6-ba5e-f4ee-5ca1-eb1e5e4b1ce0");
    public static UUID CHR_ISSC_WRITE_LERD = UUID.fromString("01fffec8-ba5e-f4ee-5ca1-eb1e5e4b1ce0");
    private static final String TAG = "BTLE_Controller";
    private static BluetoothDevice btleDevice = null;
    private static boolean connection = false;
    private Context ctx = null;
    private static IDTechBluetoothMsg _msg = null;
    private BluetoothControllerMsg _btMsg = null;
    private CheckDeviceThread checkThread;
    private BroadcastReceiver btleReceiver = null;
    private listenForDataOnThread listenThread;
    private static boolean btleEnabled = false;
    private boolean waitingForResult = false;
    private int swipeTimeoutSec;
    private SwipeDataReceiver swipeThread;
    private byte[] swipeBuffer;
    private BluetoothGatt mGatt = null;
    private Object mutexNotifyDataReady = new Object();
    private List<byte[]> responseResults = new ArrayList<byte[]>();
    private List<byte[]> responseFrame = new ArrayList<byte[]>();
    private BluetoothGattCharacteristic characteristic = null;
    private boolean dataAvailable = false;
    private Object mutexNotifyConnection = new Object();
    private BluetoothGattService proprietary = null;
    private BluetoothGattCharacteristic mTransRead = null;
    private BluetoothGattCharacteristic mTransWrite = null;
    private Runnable enableNotifyHandler = new Runnable(){

        public void run() {
            Log.i((String)BluetoothLEController.TAG, (String)"@@ delayed to enableNotification");
            BluetoothLEController.this.enableNotification();
            BluetoothLEController.this.connectionDone();
        }
    };
    boolean characteristicChanged = false;
    private final BluetoothGattCallback gattCallback = new BluetoothGattCallback(){

        public void onConnectionStateChange(final BluetoothGatt gatt, final int status, final int newState) {
            super.onConnectionStateChange(gatt, status, newState);
            new Thread(new Runnable(){

                public void run() {
                    Log.i((String)"onConnectionStateChange", (String)("Status: " + status));
                    switch (newState) {
                        case 2: {
                            Log.i((String)"gattCallback", (String)"STATE_CONNECTED");
                            connection = false;
                            (this).BluetoothLEController.this.isConnectionDone = false;
                            gatt.discoverServices();
                            BluetoothLEController.this.responseResults.clear();
                            break;
                        }
                        case 0: {
                            Log.e((String)"gattCallback", (String)"STATE_DISCONNECTED");
                            connection = false;
                            if (device_BLE_Type == 1 && !IDT_Device.btleFirstConnect && !IDT_Device.btleFirstBypass || device_BLE_Type == 2) {
                                _msg.bt_onReceiveMsgDisconnected();
                            }
                            if (BluetoothLEController.this.mGatt != null) {
                                BluetoothLEController.this.mGatt.close();
                                BluetoothLEController.this.mGatt = null;
                            }
                            if (!IDT_Device.btleFirstBypass) break;
                            boolean bFindPairedDevice = false;
                            BluetoothAdapter mBluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
                            Set pairedDevices = mBluetoothAdapter.getBondedDevices();
                            String target = btleDevice.getName();
                            for (BluetoothDevice bt : pairedDevices) {
                                if (!bt.getName().equals(target)) continue;
                                bFindPairedDevice = true;
                            }
                            if (!bFindPairedDevice) break;
                            IDT_Device.btleFirstBypass = false;
                            BluetoothLEController.this.connectToDevice(btleDevice);
                            break;
                        }
                        default: {
                            Log.e((String)"gattCallback", (String)"STATE_OTHER");
                        }
                    }
                }
            }).start();
        }

        public void onServicesDiscovered(final BluetoothGatt gatt, final int status) {
            super.onServicesDiscovered(gatt, status);
            new Thread(new Runnable(){

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public void run() {
                    if (device_BLE_Type == 1) {
                        List services = gatt.getServices();
                        Log.i((String)"onServicesDiscovered", (String)services.toString());
                        boolean done = false;
                        for (BluetoothGattService service : services) {
                            BluetoothLEController.this.characteristic = service.getCharacteristic(SPS_CHARAC);
                            if (BluetoothLEController.this.characteristic == null) continue;
                            Log.i((String)BluetoothLEController.TAG, (String)"##Got characteristic");
                            boolean ret = BluetoothLEController.this.mGatt.setCharacteristicNotification(BluetoothLEController.this.characteristic, true);
                            if (!ret) {
                                Log.i((String)BluetoothLEController.TAG, (String)"##Could not set characteristic");
                                continue;
                            }
                            BluetoothGattDescriptor descriptor = BluetoothLEController.this.characteristic.getDescriptor(CCC);
                            descriptor.setValue(BluetoothGattDescriptor.ENABLE_NOTIFICATION_VALUE);
                            ret = BluetoothLEController.this.mGatt.writeDescriptor(descriptor);
                            if (!ret) break;
                            done = true;
                            break;
                        }
                        if (BluetoothLEController.this.characteristic == null) {
                            Log.i((String)BluetoothLEController.TAG, (String)"##Could not get characteristic");
                        }
                        if (done) {
                            BluetoothLEController.this.connectionDone();
                        }
                        if (IDT_Device.btleFirstConnect) {
                            IDT_Device.btleFirstConnect = false;
                            return;
                        } else {
                            IDT_Device.btleReConnect = true;
                            _msg.bt_onReceiveMsgConnected();
                        }
                        return;
                    }
                    if (device_BLE_Type != 2) return;
                    boolean bFlag = false;
                    Log.i((String)"@@@@onServicesDiscovered", (String)("Status: " + status));
                    if (status != 0) return;
                    if (BluetoothLEController.this.proprietary == null) {
                        BluetoothLEController.this.proprietary = BluetoothLEController.this.mGatt.getService(SERVICE_ISSC_PROPRIETARY);
                    }
                    if (BluetoothLEController.this.proprietary != null) {
                        if (BluetoothLEController.this.mTransWrite == null) {
                            BluetoothLEController.this.mTransWrite = BluetoothLEController.this.proprietary.getCharacteristic(CHR_ISSC_WRITE_VP3320);
                        }
                        if (BluetoothLEController.this.mTransWrite == null) {
                            BluetoothLEController.this.mTransWrite = BluetoothLEController.this.proprietary.getCharacteristic(CHR_ISSC_WRITE);
                        }
                        if (BluetoothLEController.this.mTransRead == null) {
                            BluetoothLEController.this.mTransRead = BluetoothLEController.this.proprietary.getCharacteristic(CHR_ISSC_READ);
                        }
                        Log.i((String)BluetoothLEController.TAG, (String)String.format("@@found BM71 Tx:%b, Rx:%b, ", BluetoothLEController.this.mTransRead != null, BluetoothLEController.this.mTransWrite != null));
                        if (BluetoothLEController.this.mTransRead != null && BluetoothLEController.this.mTransWrite != null) {
                            try {
                                Thread.sleep(500L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            bFlag = true;
                            BluetoothLEController.this.enableNotification();
                            BluetoothLEController.this.connectionDone();
                            if (IDT_Device.btleFirstConnect) {
                                IDT_Device.btleFirstBypass = true;
                                IDT_Device.btleFirstConnect = false;
                            } else {
                                if (BluetoothLEController.this.mGatt == null) {
                                    BluetoothLEController.this.proprietary = null;
                                    BluetoothLEController.this.mTransWrite = null;
                                    BluetoothLEController.this.mTransRead = null;
                                    return;
                                }
                                IDT_Device.btleReConnect = true;
                                _msg.bt_onReceiveMsgConnected();
                            }
                        }
                    }
                    if (BluetoothLEController.this.proprietary == null) {
                        Log.i((String)BluetoothLEController.TAG, (String)"##BM71, Could not get characteristic");
                        bFlag = false;
                    }
                    if (bFlag) return;
                    BluetoothLEController.this.proprietary = BluetoothLEController.this.mGatt.getService(SERVICE_ISSC_PROPRIETARY_LERD);
                    if (BluetoothLEController.this.proprietary != null) {
                        if (BluetoothLEController.this.mTransWrite == null) {
                            BluetoothLEController.this.mTransWrite = BluetoothLEController.this.proprietary.getCharacteristic(CHR_ISSC_WRITE_LERD);
                        }
                        if (BluetoothLEController.this.mTransRead == null) {
                            BluetoothLEController.this.mTransRead = BluetoothLEController.this.proprietary.getCharacteristic(CHR_ISSC_READ_LERD);
                        }
                        Log.i((String)BluetoothLEController.TAG, (String)String.format("@@found Lerda Tx:%b, Rx:%b, ", BluetoothLEController.this.mTransWrite != null, BluetoothLEController.this.mTransRead != null));
                        if (BluetoothLEController.this.mTransWrite == null || BluetoothLEController.this.mTransRead == null) return;
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        BluetoothLEController.this.enableNotification();
                        BluetoothLEController.this.connectionDone();
                        _msg.bt_onReceiveMsgConnected();
                        if (IDT_Device.btleFirstConnect) {
                            IDT_Device.btleFirstBypass = true;
                            IDT_Device.btleFirstConnect = false;
                            return;
                        } else {
                            IDT_Device.btleReConnect = true;
                            _msg.bt_onReceiveMsgConnected();
                        }
                        return;
                    }
                    if (BluetoothLEController.this.proprietary != null) return;
                    Log.i((String)BluetoothLEController.TAG, (String)"## Lerda , Could not get characteristic");
                }
            }).start();
        }

        public void onCharacteristicWrite(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic, int status) {
            Log.i((String)BluetoothLEController.TAG, (String)("##Write = " + Common.getHexStringFromBytes(characteristic.getValue())));
        }

        public void onDescriptorWrite(BluetoothGatt gatt, BluetoothGattDescriptor descriptor, int status) {
            Log.i((String)BluetoothLEController.TAG, (String)("onDescriptorWrite " + status));
        }

        public void onCharacteristicRead(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic, int status) {
            Log.i((String)BluetoothLEController.TAG, (String)("##Read = " + Common.getHexStringFromBytes(characteristic.getValue())));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onCharacteristicChanged(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic) {
            if (characteristic.getValue() == null) {
                Log.i((String)BluetoothLEController.TAG, (String)"##Data Received from BLE = NULL");
            } else {
                Log.i((String)BluetoothLEController.TAG, (String)("##Data Received from BLE = " + Common.getHexStringFromBytes(characteristic.getValue())));
            }
            2 var3_3 = this;
            synchronized (var3_3) {
                byte[] value = characteristic.getValue();
                if (value == null) {
                    Log.i((String)BluetoothLEController.TAG, (String)"## DATA Null - Exiting routine");
                    return;
                }
                if (value.length == 0) {
                    Log.i((String)BluetoothLEController.TAG, (String)"## DATA Length = 0 - Exiting routine");
                    return;
                }
                if (device_BLE_Type == 2 && value.length > 3 && value[0] == 86 && value[1] == 105 && value[2] == 86) {
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                BluetoothLEController.this.characteristicChanged = true;
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                Log.i((String)BluetoothLEController.TAG, (String)("## Adding data to buffer = " + Common.getHexStringFromBytes(value)));
                BluetoothLEController.this.addReceivedData(value);
            }
        }
    };
    boolean startFrame = false;
    byte[] resData;
    boolean isConnectionDone = false;
    private boolean registered = false;
    public boolean cancelFlag = false;
    boolean inLoop = false;
    public static final int WRITE_TYPE_DEFAULT = 2;

    public BluetoothLEController(Context context, IDTechBluetoothMsg msg, BluetoothControllerMsg msg2) {
        this.ctx = context;
        _msg = msg;
        this._btMsg = msg2;
        this.swipeBuffer = new byte[1024];
        this.swipeTimeoutSec = 200;
    }

    public static boolean isBTEnabled() {
        return btleEnabled;
    }

    public boolean isConnected() {
        return connection;
    }

    public void setConnected(boolean connected) {
        connection = connected;
    }

    public static void setBluetoothDevice(BluetoothDevice btleDev) {
        btleDevice = btleDev;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean initWithThread() {
        if (connection) {
            return true;
        }
        if (btleDevice == null) {
            return false;
        }
        this.connectToDevice(btleDevice);
        if (this.mutexNotifyConnection == null) return true;
        Object object = this.mutexNotifyConnection;
        synchronized (object) {
            try {
                int i = 0;
                while (i < 100) {
                    this.mutexNotifyConnection.wait(100L);
                    if (connection) break;
                    ++i;
                }
                if (i != 100) return true;
                return false;
            }
            catch (InterruptedException ie) {
                return false;
            }
        }
    }

    private void enableNotification() {
        Log.i((String)TAG, (String)"##enableNotification");
        boolean set = false;
        if (this.mGatt == null) {
            Log.i((String)TAG, (String)("mGatt == null, set mTransRead notification:" + set));
            return;
        }
        this.mGatt.setCharacteristicNotification(this.mTransRead, true);
        Log.i((String)TAG, (String)("set mTransRead notification:" + set));
        for (BluetoothGattDescriptor dp : this.mTransRead.getDescriptors()) {
            dp.setValue(BluetoothGattDescriptor.ENABLE_NOTIFICATION_VALUE);
            boolean success = this.mGatt.writeDescriptor(dp);
            Log.i((String)TAG, (String)("writing enable descriptor:" + success));
        }
    }

    public void connectToDevice(BluetoothDevice device) {
        if (this.mGatt == null) {
            this.mGatt = device.connectGatt(this.ctx, false, this.gattCallback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addReceivedData(byte[] response) {
        if (response != null && response.length > 10 && response[10] == 97) {
            int test = 0;
            ++test;
        }
        if (this.mutexNotifyDataReady != null) {
            if (response == null || this.responseResults == null) {
                return true;
            }
            Object object = this.mutexNotifyDataReady;
            synchronized (object) {
                this.responseResults.add(response);
                int size = this.responseResults.size();
                int totalCount = 0;
                int i = 0;
                while (i < size) {
                    totalCount += this.responseResults.get(i).length;
                    ++i;
                }
                this.resData = new byte[totalCount];
                totalCount = 0;
                i = 0;
                while (i < size) {
                    System.arraycopy(this.responseResults.get(i), 0, this.resData, totalCount, this.responseResults.get(i).length);
                    totalCount += this.responseResults.get(i).length;
                    ++i;
                }
                if (totalCount >= 14 && this.resData[0] == 86) {
                    int dataLen = (this.resData[12] & 0xFF) << 8 | this.resData[13] & 0xFF;
                    int framelLen = 14 + dataLen + 2;
                    Log.d((String)TAG, (String)("## totalCount = " + totalCount + " , frameLen = " + framelLen));
                    if (totalCount >= framelLen) {
                        if (totalCount == framelLen) {
                            this.responseFrame.add(this.resData);
                            this.responseResults.clear();
                            Log.d((String)TAG, (String)"## ---notifyAll-----##");
                            this.dataAvailable = true;
                            this.mutexNotifyDataReady.notifyAll();
                        } else {
                            byte[] frameData = new byte[framelLen];
                            System.arraycopy(this.resData, 0, frameData, 0, framelLen);
                            this.responseFrame.add(frameData);
                            int redundantLen = totalCount - framelLen;
                            byte[] redundant = new byte[redundantLen];
                            System.arraycopy(this.resData, framelLen, redundant, 0, redundantLen);
                            this.responseResults.clear();
                            this.responseResults.add(redundant);
                            Log.d((String)TAG, (String)"## ---notifyAll-----##");
                            this.dataAvailable = true;
                            this.mutexNotifyDataReady.notifyAll();
                        }
                    }
                } else {
                    this.characteristicChanged = false;
                    listenForBLEDataOnThread listenThread = new listenForBLEDataOnThread();
                    listenThread.start();
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connectionDone() {
        if (this.mutexNotifyConnection != null) {
            Object object = this.mutexNotifyConnection;
            synchronized (object) {
                connection = true;
                this.isConnectionDone = true;
                this.mutexNotifyConnection.notifyAll();
            }
        }
    }

    public void startCheckingConnection() {
        UMLog.i(TAG, "SDK starts monitoring if reader is connected.");
        this.checkThread = new CheckDeviceThread();
        this.checkThread.start();
    }

    public boolean isRegistered() {
        return this.registered;
    }

    @SuppressLint(value={"InlinedApi"})
    public void registerReceiver() {
        UMLog.i(TAG, "Register a Broadcast receiver to get BluetoothDevice.ACTION_FOUND.");
        this.btleReceiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                String action = intent.getAction();
                if (!"android.bluetooth.device.action.FOUND".equals(action)) {
                    if ("android.bluetooth.device.action.ACL_CONNECTED".equals(action)) {
                        while (!BluetoothLEController.this.isConnectionDone) {
                            try {
                                Thread.sleep(50L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                        _msg.bt_onReceiveMsgConnected();
                    } else if ("android.bluetooth.device.action.ACL_DISCONNECTED".equals(action)) {
                        connection = false;
                        BluetoothLEController.this.isConnectionDone = false;
                        _msg.bt_onReceiveMsgDisconnected();
                    }
                }
            }
        };
        IntentFilter filter = new IntentFilter("android.bluetooth.device.action.FOUND");
        this.ctx.registerReceiver(this.btleReceiver, filter);
        this.registered = true;
    }

    public void unregisterReceiver() {
        UMLog.i(TAG, "A Broadcast receiver unregistered.");
        this.ctx.unregisterReceiver(this.btleReceiver);
        this.close();
        this.registered = false;
    }

    public boolean enableSwipe() {
        return connection && !this.waitingForResult;
    }

    public boolean enableListen() {
        if (!connection) {
            return false;
        }
        UMLog.i(TAG, "SDK starts listening card data from reader.");
        this.listenThread = new listenForDataOnThread();
        this.listenThread.isRunning = true;
        this.listenThread.start();
        return true;
    }

    public boolean disableListen() {
        if (this.listenThread == null) {
            return false;
        }
        this.listenThread.isRunning = false;
        return true;
    }

    public boolean enableRead(int timeout, ResDataStruct respData) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read_autoPoll(byte[] buff) {
        if (this.mutexNotifyDataReady != null) {
            Object object = this.mutexNotifyDataReady;
            synchronized (object) {
                block14: {
                    block13: {
                        block12: {
                            this.mutexNotifyDataReady.wait(400L);
                            if (!IDT_Device.isBurstModeOn || !IDT_Device.isAutoPollOn || !IDT_Device.isCommandRunning) break block12;
                            return 0;
                        }
                        if (this.dataAvailable) break block13;
                        return 0;
                    }
                    this.dataAvailable = false;
                    if (this.responseFrame.size() > 0) break block14;
                    Log.i((String)TAG, (String)"## No Resp ");
                    return 0;
                }
                try {
                    int size = this.responseFrame.size();
                    int totalCount = 0;
                    int i = size - 1;
                    while (i < size) {
                        totalCount += this.responseFrame.get(i).length;
                        ++i;
                    }
                    totalCount = 0;
                    i = size - 1;
                    while (i < size) {
                        System.arraycopy(this.responseFrame.get(i), 0, buff, totalCount, this.responseFrame.get(i).length);
                        totalCount += this.responseFrame.get(i).length;
                        ++i;
                    }
                    this.responseFrame.clear();
                    Log.i((String)TAG, (String)("## Resp = " + Common.getHexStringFromBytes(buff)));
                    if (buff[10] == 97) {
                        int temp = 1;
                        ++temp;
                    }
                    return totalCount;
                }
                catch (InterruptedException ie) {
                    return 0;
                }
            }
        }
        return 0;
    }

    public boolean readMessage(int timeout, long startTime, ResDataStruct respData, boolean ignoreLCDMsg) {
        if (!connection) {
            return false;
        }
        this.dataAvailable = false;
        respData.resData = new byte[1];
        byte[] buff = new byte[4096];
        int res = 0;
        long timelimit = (long)(timeout * 1000) - (System.currentTimeMillis() - startTime);
        this.responseFrame.clear();
        if (ignoreLCDMsg && Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT) {
            int idx;
            while (true) {
                if ((timelimit = (long)(timeout * 1000) - (System.currentTimeMillis() - startTime)) <= 0L) {
                    return false;
                }
                if (IDT_Device.isTransactionRead && (IDT_Device.emvCancelTransaction || IDT_Device.cancelTransaction)) {
                    return false;
                }
                res = this.read(buff, timelimit);
                if (res <= 0) continue;
                idx = 0;
                while (res - idx > 13 && buff[10 + idx] == 97 && buff[11 + idx] == 1) {
                    int dataLen = (buff[12 + idx] & 0xFF) << 8 | buff[13 + idx] & 0xFF;
                    byte[] theData = new byte[dataLen + 16];
                    System.arraycopy(buff, idx, theData, 0, theData.length);
                    _msg.bt_onReceiveMsgLCD(theData);
                    idx += dataLen + 16;
                }
                if (res != idx) break;
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                res = 0;
            }
            respData.resData = null;
            respData.resData = new byte[res - idx];
            System.arraycopy(buff, idx, respData.resData, 0, respData.resData.length);
            UMLog.i("**getResponse**", Common.base16Encode(respData.resData));
            _msg.bt_onReceiveMsgGetResponse(respData.resData);
            return true;
        }
        res = this.read(buff, timelimit);
        if (res > 0) {
            respData.resData = null;
            respData.resData = new byte[res];
            System.arraycopy(buff, 0, respData.resData, 0, res);
            UMLog.i("**getResponse**", Common.base16Encode(respData.resData));
            _msg.bt_onReceiveMsgGetResponse(respData.resData);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int read(byte[] buff, long timeLimit) {
        if (this.mutexNotifyDataReady == null) {
            return 0;
        }
        Object object = this.mutexNotifyDataReady;
        synchronized (object) {
            try {
                long times = timeLimit / (long)(device_BLE_Type == 1 ? 100 : 20);
                if (timeLimit % (long)(device_BLE_Type == 1 ? 100 : 20) != 0L) {
                    ++times;
                }
                if (times < 1L) {
                    times = 1L;
                }
                long i = 0L;
                while (i < times) {
                    if (this.cancelFlag) {
                        this.cancelFlag = false;
                        this.writeRXCharacteristic_try3times(Common.grsiP2Command((byte)5, (byte)1, new byte[0]));
                    }
                    if (IDT_Device.isTransactionRead && (IDT_Device.emvCancelTransaction || IDT_Device.cancelTransaction)) {
                        Log.i((String)TAG, (String)"## Transaction Cancelled ");
                        return 0;
                    }
                    this.mutexNotifyDataReady.wait(device_BLE_Type == 1 ? 100 : 20);
                    if (this.dataAvailable) {
                        this.dataAvailable = false;
                        break;
                    }
                    ++i;
                }
                if (this.responseFrame.size() <= 0) {
                    Log.i((String)TAG, (String)"## No Resp ");
                    return 0;
                }
                int size = this.responseFrame.size();
                int totalCount = 0;
                int i2 = 0;
                while (i2 < size) {
                    totalCount += this.responseFrame.get(i2).length;
                    ++i2;
                }
                totalCount = 0;
                i2 = 0;
                while (i2 < size) {
                    System.arraycopy(this.responseFrame.get(i2), 0, buff, totalCount, this.responseFrame.get(i2).length);
                    totalCount += this.responseFrame.get(i2).length;
                    ++i2;
                }
                Log.i((String)TAG, (String)("## Resp = " + Common.getHexStringFromBytes(buff)));
                if (buff[10] == 97) {
                    int temp = 1;
                    ++temp;
                }
                return totalCount;
            }
            catch (InterruptedException ie) {
                return 0;
            }
        }
    }

    public void disableSwipe() {
        UMLog.i(TAG, "disableSwipe SDK stops polling card data from reader.");
        if (this.swipeThread != null) {
            this.swipeThread.close();
        }
        this.waitingForResult = false;
    }

    public boolean isSwipeEnabled() {
        return this.waitingForResult;
    }

    public void setTimeoutOfSwipeCard(int timeoutInSec) {
        UMLog.i(TAG, "Timeout for card swipe changed to " + timeoutInSec + " seconds.");
        this.swipeTimeoutSec = timeoutInSec;
    }

    public int cancelTransaction() {
        if (!this.inLoop) {
            return 10;
        }
        this.cancelFlag = true;
        return 0;
    }

    public byte[] sendCommand(byte[] command, int timeout) {
        if (!connection || this.waitingForResult) {
            UMLog.i(TAG, "Failed to send a command: ");
            this.waitingForResult = false;
            return null;
        }
        long startTime = System.currentTimeMillis();
        if (timeout == 0) {
            timeout = 3;
        }
        byte[] responseData = null;
        byte[] buff = new byte[4096];
        int res = 0;
        this.responseResults.clear();
        this.responseFrame.clear();
        boolean bSd = this.writeRXCharacteristic_try3times(command);
        if (!bSd) {
            UMLog.e(TAG, "Failed to write the command.");
            return null;
        }
        this.dataAvailable = false;
        try {
            Thread.sleep(300L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.inLoop = false;
        this.cancelFlag = false;
        if (Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT) {
            block13: {
                int idx;
                while (true) {
                    long timelimit;
                    this.inLoop = true;
                    if (this.cancelFlag) {
                        this.cancelFlag = false;
                        this.writeRXCharacteristic_try3times(Common.grsiP2Command((byte)5, (byte)1, new byte[0]));
                    }
                    if ((timelimit = (long)((timeout + 2) * 1000) - (System.currentTimeMillis() - startTime)) <= 0L) break block13;
                    res = this.read(buff, timelimit);
                    if (res <= 0) continue;
                    idx = 0;
                    while (res - idx > 13 && buff[10 + idx] != command[10]) {
                        int dataLen = (buff[12 + idx] & 0xFF) << 8 | buff[13 + idx] & 0xFF;
                        idx += dataLen + 16;
                    }
                    if (res != idx) break;
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    res = 0;
                }
                responseData = null;
                responseData = new byte[res - idx];
                System.arraycopy(buff, idx, responseData, 0, responseData.length);
                UMLog.i("**getResponse**", Common.base16Encode(responseData));
                _msg.bt_onReceiveMsgGetResponse(responseData);
                this.inLoop = false;
                return responseData;
            }
            this.inLoop = false;
        } else {
            long timelimit = (long)((timeout + 2) * 1000) - (System.currentTimeMillis() - startTime);
            this.inLoop = true;
            this.cancelFlag = false;
            res = this.read(buff, timelimit);
            this.inLoop = false;
            if (res > 0) {
                responseData = null;
                responseData = new byte[res];
                System.arraycopy(buff, 0, responseData, 0, res);
                this.waitingForResult = false;
                UMLog.i("**getResponse**", Common.base16Encode(responseData));
                _msg.bt_onReceiveMsgGetResponse(responseData);
                return responseData;
            }
        }
        this.waitingForResult = false;
        return null;
    }

    public byte[] sendCommandOnly(byte[] command, int timeout) {
        if (!connection || this.waitingForResult) {
            UMLog.i(TAG, "Failed to send a command: ");
            this.waitingForResult = false;
            return null;
        }
        if (timeout == 0) {
            timeout = 3;
        }
        this.responseResults.clear();
        this.responseFrame.clear();
        boolean bSd = this.writeRXCharacteristic_try3times(command);
        if (!bSd) {
            UMLog.e(TAG, "Failed to write the command.");
            return null;
        }
        this.waitingForResult = false;
        return null;
    }

    public byte[] sendCommandForRKI(byte[] command, int timeout) {
        if (!connection || this.waitingForResult) {
            UMLog.i(TAG, "Failed to send a command: ");
            this.waitingForResult = false;
            return null;
        }
        long startTime = System.currentTimeMillis();
        if (timeout == 0) {
            timeout = 5;
        }
        byte[] responseData = null;
        byte[] buff = new byte[2048];
        int res = 0;
        this.responseResults.clear();
        this.responseFrame.clear();
        boolean bSd = this.writeRXCharacteristic_try3times(command);
        if (!bSd) {
            UMLog.e(TAG, "Failed to write the command.");
            return null;
        }
        this.dataAvailable = false;
        try {
            Thread.sleep(300L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        long timelimit = (long)(timeout * 1000) - (System.currentTimeMillis() - startTime);
        res = this.read(buff, timelimit);
        if (res > 0) {
            responseData = null;
            responseData = new byte[res];
            System.arraycopy(buff, 0, responseData, 0, res);
            this.waitingForResult = false;
            UMLog.i("**getResponse**", Common.base16Encode(responseData));
            _msg.bt_onReceiveMsgGetResponse(responseData);
            return responseData;
        }
        this.waitingForResult = false;
        return null;
    }

    public void writeRXCharacteristic(byte[] command) {
        block18: {
            block17: {
                if (command == null) {
                    return;
                }
                if (device_BLE_Type != 1) break block17;
                if (this.characteristic == null) {
                    Log.i((String)TAG, (String)"Characteristic not available!");
                    return;
                }
                int LEN_SLICE = 20;
                int len = command.length;
                int count = len / LEN_SLICE;
                int mod = len % LEN_SLICE;
                if (mod > 0) {
                    ++count;
                } else if (mod == 0 && len == LEN_SLICE) {
                    count = 1;
                }
                Log.d((String)TAG, (String)("CMD =" + Common.getHexStringFromBytes(command)));
                int i = 0;
                while (i < count) {
                    int length = LEN_SLICE;
                    if (i == count - 1 && mod > 0) {
                        length = mod;
                    }
                    byte[] oneByte = new byte[length];
                    System.arraycopy(command, i * LEN_SLICE, oneByte, 0, length);
                    Log.d((String)TAG, (String)("Send " + i + " =" + Common.getHexStringFromBytes(oneByte)));
                    this.characteristic.setValue(oneByte);
                    boolean status = this.mGatt.writeCharacteristic(this.characteristic);
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    Log.d((String)TAG, (String)("write TXchar - status=" + status));
                    ++i;
                }
                break block18;
            }
            if (device_BLE_Type != 2) break block18;
            if (this.mTransWrite == null) {
                Log.i((String)TAG, (String)"Characteristic not available!");
                return;
            }
            int LEN_SLICE = 150;
            int len = command.length;
            int count = len / LEN_SLICE;
            int mod = len % LEN_SLICE;
            if (mod > 0) {
                ++count;
            } else if (mod == 0 && len == LEN_SLICE) {
                count = 1;
            }
            Log.d((String)TAG, (String)("CMD =" + Common.getHexStringFromBytes(command)));
            int i = 0;
            while (i < count) {
                int length = LEN_SLICE;
                if (i == count - 1 && mod > 0) {
                    length = mod;
                }
                byte[] oneByte = new byte[length];
                System.arraycopy(command, i * LEN_SLICE, oneByte, 0, length);
                Log.d((String)TAG, (String)("Send " + i + " =" + Common.getHexStringFromBytes(oneByte)));
                this.mTransWrite.setValue(oneByte);
                boolean status = this.mGatt.writeCharacteristic(this.mTransWrite);
                try {
                    Thread.sleep(150L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                Log.d((String)TAG, (String)("write TXchar - status=" + status));
                ++i;
            }
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean writeRXCharacteristic_try3times(byte[] command) {
        if (command == null) {
            return false;
        }
        if (this.mGatt == null) {
            Log.e((String)TAG, (String)"mGatt not available!");
            return false;
        }
        try {
            if (device_BLE_Type == 1) {
                if (this.characteristic == null) {
                    Log.e((String)TAG, (String)"Characteristic not available!");
                    return false;
                }
                int LEN_SLICE = 20;
                int len = command.length;
                int count = len / LEN_SLICE;
                int mod = len % LEN_SLICE;
                if (mod > 0) {
                    ++count;
                } else if (mod == 0 && len == LEN_SLICE) {
                    count = 1;
                }
                Log.d((String)TAG, (String)("CMD =" + Common.getHexStringFromBytes(command)));
                int i = 0;
                while (i < count) {
                    int length = LEN_SLICE;
                    if (i == count - 1 && mod > 0) {
                        length = mod;
                    }
                    byte[] oneByte = new byte[length];
                    System.arraycopy(command, i * LEN_SLICE, oneByte, 0, length);
                    Log.d((String)TAG, (String)("Send " + i + " =" + Common.getHexStringFromBytes(oneByte)));
                    this.characteristic.setValue(oneByte);
                    boolean status = false;
                    int k = 0;
                    while (k < 3) {
                        status = this.mGatt.writeCharacteristic(this.characteristic);
                        if (status) break;
                        try {
                            Thread.sleep(50L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        ++k;
                    }
                    if (!status) {
                        Log.e((String)TAG, (String)"Send 3 times, all failed!");
                        return false;
                    }
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    Log.d((String)TAG, (String)("write TXchar - status=" + status));
                    ++i;
                }
                return true;
            }
            if (device_BLE_Type == 2) {
                if (this.mTransWrite == null) {
                    Log.e((String)TAG, (String)"Characteristic not available!");
                    return false;
                }
                int LEN_SLICE = 150;
                int len = command.length;
                int count = len / LEN_SLICE;
                int mod = len % LEN_SLICE;
                if (mod > 0) {
                    ++count;
                } else if (mod == 0 && len == LEN_SLICE) {
                    count = 1;
                }
                Log.d((String)TAG, (String)("CMD =" + Common.getHexStringFromBytes(command)));
                int i = 0;
                while (i < count) {
                    int length = LEN_SLICE;
                    if (i == count - 1 && mod > 0) {
                        length = mod;
                    }
                    byte[] oneByte = new byte[length];
                    System.arraycopy(command, i * LEN_SLICE, oneByte, 0, length);
                    Log.d((String)TAG, (String)("Send " + i + " =" + Common.getHexStringFromBytes(oneByte)));
                    this.mTransWrite.setValue(oneByte);
                    boolean status = false;
                    int k = 0;
                    while (k < 3) {
                        status = this.mGatt.writeCharacteristic(this.mTransWrite);
                        if (status) break;
                        try {
                            Thread.sleep(150L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        ++k;
                    }
                    if (!status) {
                        Log.e((String)TAG, (String)"Send 3 times, all failed!");
                        return false;
                    }
                    try {
                        Thread.sleep(150L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    Log.d((String)TAG, (String)("write TXchar - status=" + status));
                    ++i;
                }
                return true;
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String asciiBytesToString(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return "";
        }
        char[] result = new char[bytes.length];
        int i = 0;
        while (i < bytes.length) {
            result[i] = (char)bytes[i];
            ++i;
        }
        return new String(result);
    }

    public byte[] sendCommandFw(byte[] command) {
        return null;
    }

    public int readMSR(byte[] data) {
        if (!connection) {
            return 0;
        }
        return 0;
    }

    public boolean close() {
        if (connection) {
            this.cancel();
            connection = false;
            btleDevice = null;
        }
        System.gc();
        return true;
    }

    public void cancel() {
        if (this.mGatt == null) {
            return;
        }
        if (Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT) {
            this.connectionDone();
            try {
                Thread.sleep(60L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.mGatt.close();
        this.mGatt = null;
        connection = false;
    }

    private class CheckDeviceThread
    extends Thread {
        boolean res = false;

        private CheckDeviceThread() {
        }

        public void run() {
            try {
                CheckDeviceThread.sleep(300L);
            }
            catch (InterruptedException e1) {
                e1.printStackTrace();
            }
            while (!this.res) {
                this.res = BluetoothLEController.this.initWithThread();
                try {
                    CheckDeviceThread.sleep(2000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private class SwipeDataReceiver
    extends Thread {
        private SwipeDataReceiver() {
        }

        public void run() {
        }

        public void close() {
        }
    }

    private class listenForBLEDataOnThread
    extends Thread {
        private listenForBLEDataOnThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            long startTime = System.currentTimeMillis();
            while (System.currentTimeMillis() - startTime < 300L) {
                try {
                    Thread.sleep(30L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!BluetoothLEController.this.characteristicChanged) continue;
                BluetoothLEController.this.characteristicChanged = false;
                return;
            }
            if (BluetoothLEController.this.mutexNotifyDataReady != null) {
                Object object = BluetoothLEController.this.mutexNotifyDataReady;
                synchronized (object) {
                    BluetoothLEController.this.responseFrame.add(BluetoothLEController.this.resData);
                    BluetoothLEController.this.responseResults.clear();
                    Log.d((String)BluetoothLEController.TAG, (String)"## ---notifyAll-----##");
                    BluetoothLEController.this.dataAvailable = true;
                    BluetoothLEController.this.mutexNotifyDataReady.notifyAll();
                }
            }
        }
    }

    private class listenForDataOnThread
    extends Thread {
        public boolean isRunning = true;

        private listenForDataOnThread() {
        }

        public void run() {
            byte[] tmp = new byte[2048];
            while (this.isRunning) {
                if (!IDT_Device.isBurstModeOn || !IDT_Device.isAutoPollOn || IDT_Device.isCommandRunning) {
                    IDTMSRData card;
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    if (IDT_Device.isBurstModeOn || !IDT_Device.isAutoPollOn || Common.getDeviceType() != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT && Common.getDeviceType() != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT && Common.getDeviceType() != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT) continue;
                    try {
                        Thread.sleep(900L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    if (IDT_Device.isCommandRunning) continue;
                    if (Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT) {
                        if (IDT_Device.isMonitorCtlsData) {
                            card = new IDTMSRData();
                            byte[] command = Common.getByteArray("5669564F7465636832000340000096E2");
                            byte[] data = BluetoothLEController.this.sendCommand(command, 1);
                            int len = 0;
                            if (data != null && data.length > 13) {
                                len = (data[12] & 0xFF) * 256 + (data[13] & 0xFF);
                            }
                            if (len > 7) {
                                Common.parseCardData3in1(data, card);
                                UMLog.i("listenForDataOnThread", "got: " + Common.getByteArrDesc(data));
                                _msg.bt_onReceiveMsgCardData(card);
                                continue;
                            }
                            card.result = 61092;
                            _msg.bt_onReceiveMsgCardData(card);
                            continue;
                        }
                        card = new IDTMSRData();
                        card.result = 61092;
                        _msg.bt_onReceiveMsgCardData(card);
                        continue;
                    }
                    card = new IDTMSRData();
                    card.result = 61092;
                    _msg.bt_onReceiveMsgCardData(card);
                    continue;
                }
                IDT_Device.isCheckingNotification = true;
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                int length = BluetoothLEController.this.read_autoPoll(tmp);
                if (length > 0) {
                    if (Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT) {
                        if (length > 12 && tmp[10] == 97 && tmp[11] == 1) {
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                            continue;
                        }
                    } else if (Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT) {
                        IDTMSRData card;
                        if (length > 12 && tmp[10] == 2 && tmp[11] == -96) {
                            card = new IDTMSRData();
                            card.result = 61088;
                            _msg.bt_onReceiveMsgCardData(card);
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                            continue;
                        }
                        if (length > 12 && tmp[10] == -18 && tmp[11] == -16) {
                            card = new IDTMSRData();
                            card.result = 61168;
                            _msg.bt_onReceiveMsgCardData(card);
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                            continue;
                        }
                    }
                    byte[] data = new byte[length];
                    System.arraycopy(tmp, 0, data, 0, length);
                    IDTMSRData card = new IDTMSRData();
                    Common.processCTLSData(data, card);
                    UMLog.i("listenForDataOnThread", "got: " + Common.base16Encode(data));
                    _msg.bt_onReceiveMsgCardData(card);
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                IDT_Device.isCheckingNotification = false;
            }
            BluetoothLEController.this.listenThread = null;
        }
    }
}

