/*
 * Decompiled with CFR 0.152.
 */
package com.idtechproducts.device.audiojack.tasks;

import com.idtechproducts.device.Common;
import com.idtechproducts.device.ResDataStruct;
import com.idtechproducts.device.StructConfigParameters;
import com.idtechproducts.device.audiojack.ReaderCommunication;
import com.idtechproducts.device.audiojack.UMLog;
import com.idtechproducts.device.audiojack.tasks.Task;
import com.idtechproducts.device.audiojack.tasks.TaskManager;
import com.idtechproducts.device.audiojack.tools.FirmwareUpdateTool;
import com.idtechproducts.device.audiojack.tools.FirmwareUpdateToolMsg;

public class FwUpdateTaskUniPay
extends Task {
    private FirmwareUpdateTool.FMStruct fmStruct;
    private FirmwareUpdateToolMsg fwUpdateMsg;
    StructConfigParameters _config;

    public FwUpdateTaskUniPay(TaskManager taskManager, ReaderCommunication umMan, StructConfigParameters config, FirmwareUpdateToolMsg umtMsg, FirmwareUpdateTool.FMStruct fmFile) {
        super(taskManager, umMan);
        this.fwUpdateMsg = umtMsg;
        this.fmStruct = fmFile;
        this._config = config;
    }

    public TaskManager.TaskType getType() {
        return TaskManager.TaskType.FwUpdate;
    }

    protected Runnable taskMain() {
        this.fwUpdateMsg.onReceiveMsgUpdateFirmwareProgress(0);
        ResDataStruct respData = new ResDataStruct();
        TaskManager.TaskStartRet ret = this._taskManager.task_start_command_for_fw(Common.makeCommand("78467A495246570000000000000000", this._config.getPowerupLastBeforeCMD()), respData);
        if (ret != TaskManager.TaskStartRet.SUCCESS) {
            return new Runnable(){

                public void run() {
                    UMLog.i(FwUpdateTaskUniPay.this.TAG, "notify failed to enter BLM");
                    FwUpdateTaskUniPay.this.fwUpdateMsg.onReceiveMsgUpdateFirmwareResult(302);
                }
            };
        }
        if (respData.resData[3] != 6) {
            return new Runnable(){

                public void run() {
                    UMLog.i(FwUpdateTaskUniPay.this.TAG, "notify failed to enter BLM (NON-ACK)");
                    FwUpdateTaskUniPay.this.fwUpdateMsg.onReceiveMsgUpdateFirmwareResult(302);
                }
            };
        }
        UMLog.i(this.TAG, "enter bootloader command succeeded");
        this.fwUpdateMsg.onReceiveMsgUpdateFirmwareProgress(1);
        ret = this._taskManager.task_start_command_for_fw(Common.makeCommand("420000" + Common.base16Encode(this.fmStruct.getBlock(0)), this._config.getPowerupLastBeforeCMD()), respData);
        if (ret != TaskManager.TaskStartRet.SUCCESS) {
            return new Runnable(){

                public void run() {
                    UMLog.i(FwUpdateTaskUniPay.this.TAG, "notify failed firmware update (Block #0)");
                    FwUpdateTaskUniPay.this.fwUpdateMsg.onReceiveMsgUpdateFirmwareResult(303);
                }
            };
        }
        if (respData.resData[3] != 6) {
            return new Runnable(){

                public void run() {
                    UMLog.i(FwUpdateTaskUniPay.this.TAG, "notify failed firmware update (Block #0)");
                    FwUpdateTaskUniPay.this.fwUpdateMsg.onReceiveMsgUpdateFirmwareResult(303);
                }
            };
        }
        UMLog.i(this.TAG, "Block #0 sent successfully.");
        int curBlock = 0;
        while (curBlock < this.fmStruct.N) {
            int currentProgress = (curBlock + 2) * 100 / (this.fmStruct.N + 3);
            this.fwUpdateMsg.onReceiveMsgUpdateFirmwareProgress(currentProgress);
            final int blockNumber = curBlock + 1;
            byte[] command = new byte[1027];
            command[0] = 66;
            command[1] = (byte)blockNumber;
            command[2] = 0;
            System.arraycopy(this.fmStruct.getBlock(blockNumber), 0, command, 3, 1024);
            ret = this._taskManager.task_start_command_for_fw(Common.makeCommand(Common.getHexStringFromBytes(command), this._config.getPowerupLastBeforeCMD()), respData);
            if (ret != TaskManager.TaskStartRet.SUCCESS) {
                return new Runnable(){

                    public void run() {
                        UMLog.i(FwUpdateTaskUniPay.this.TAG, "notify failed firmware update (Block #" + blockNumber + "-0)");
                        FwUpdateTaskUniPay.this.fwUpdateMsg.onReceiveMsgUpdateFirmwareResult(303);
                    }
                };
            }
            if (respData.resData[3] != 6) {
                return new Runnable(){

                    public void run() {
                        UMLog.i(FwUpdateTaskUniPay.this.TAG, "notify failed firmware update (Block #" + blockNumber + "-0)");
                        FwUpdateTaskUniPay.this.fwUpdateMsg.onReceiveMsgUpdateFirmwareResult(303);
                    }
                };
            }
            UMLog.i(this.TAG, "Block #" + blockNumber + "-0 sent successfully.");
            command = new byte[1027];
            command[0] = 66;
            command[1] = (byte)blockNumber;
            command[2] = 1;
            System.arraycopy(this.fmStruct.getBlock(blockNumber), 1024, command, 3, 1024);
            ret = this._taskManager.task_start_command_for_fw(Common.makeCommand(Common.getHexStringFromBytes(command), this._config.getPowerupLastBeforeCMD()), respData);
            if (ret != TaskManager.TaskStartRet.SUCCESS) {
                return new Runnable(){

                    public void run() {
                        UMLog.i(FwUpdateTaskUniPay.this.TAG, "notify failed firmware update (Block #" + blockNumber + "-1)");
                        FwUpdateTaskUniPay.this.fwUpdateMsg.onReceiveMsgUpdateFirmwareResult(303);
                    }
                };
            }
            if (respData.resData[3] != 6) {
                return new Runnable(){

                    public void run() {
                        UMLog.i(FwUpdateTaskUniPay.this.TAG, "notify failed firmware update (Block #" + blockNumber + "-1)");
                        FwUpdateTaskUniPay.this.fwUpdateMsg.onReceiveMsgUpdateFirmwareResult(303);
                    }
                };
            }
            UMLog.i(this.TAG, "Block #" + blockNumber + "-1 sent successfully.");
            command = new byte[259];
            command[0] = 66;
            command[1] = (byte)blockNumber;
            command[2] = 2;
            System.arraycopy(this.fmStruct.getBlock(blockNumber), 2048, command, 3, 256);
            ret = this._taskManager.task_start_command_for_fw(Common.makeCommand(Common.getHexStringFromBytes(command), this._config.getPowerupLastBeforeCMD()), respData);
            if (ret != TaskManager.TaskStartRet.SUCCESS) {
                return new Runnable(){

                    public void run() {
                        UMLog.i(FwUpdateTaskUniPay.this.TAG, "notify failed firmware update (Block #" + blockNumber + "-2)");
                        FwUpdateTaskUniPay.this.fwUpdateMsg.onReceiveMsgUpdateFirmwareResult(303);
                    }
                };
            }
            if (respData.resData[3] != 6) {
                return new Runnable(){

                    public void run() {
                        UMLog.i(FwUpdateTaskUniPay.this.TAG, "notify failed firmware update (Block #" + blockNumber + "-2)");
                        FwUpdateTaskUniPay.this.fwUpdateMsg.onReceiveMsgUpdateFirmwareResult(303);
                    }
                };
            }
            UMLog.i(this.TAG, "Block #" + blockNumber + "-2 sent successfully.");
            ++curBlock;
        }
        int currentProgress = (this.fmStruct.N + 2) * 100 / (this.fmStruct.N + 3);
        this.fwUpdateMsg.onReceiveMsgUpdateFirmwareProgress(currentProgress);
        byte[] checksumCommand = new byte[259];
        checksumCommand[0] = 66;
        checksumCommand[1] = -1;
        checksumCommand[2] = -1;
        System.arraycopy(this.fmStruct.blockN, 0, checksumCommand, 3, 256);
        ret = this._taskManager.task_start_command_for_fw(Common.makeCommand(Common.getHexStringFromBytes(checksumCommand), this._config.getPowerupLastBeforeCMD()), respData);
        if (ret != TaskManager.TaskStartRet.SUCCESS) {
            return new Runnable(){

                public void run() {
                    UMLog.i(FwUpdateTaskUniPay.this.TAG, "notify failed firmware update (checksum block)");
                    FwUpdateTaskUniPay.this.fwUpdateMsg.onReceiveMsgUpdateFirmwareResult(304);
                }
            };
        }
        if (respData.resData[3] != 6) {
            return new Runnable(){

                public void run() {
                    UMLog.i(FwUpdateTaskUniPay.this.TAG, "notify failed firmware update ((checksum block))");
                    FwUpdateTaskUniPay.this.fwUpdateMsg.onReceiveMsgUpdateFirmwareResult(304);
                }
            };
        }
        UMLog.i(this.TAG, "Checksum block sent successfully.");
        return new Runnable(){

            public void run() {
                UMLog.i(FwUpdateTaskUniPay.this.TAG, "notify finished successfully");
                FwUpdateTaskUniPay.this.fwUpdateMsg.onReceiveMsgUpdateFirmwareResult(301);
            }
        };
    }
}

