/*
 * Decompiled with CFR 0.152.
 */
package com.zeamster.paymentsdk.service;

import android.app.Activity;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.le.BluetoothLeScanner;
import android.bluetooth.le.ScanCallback;
import android.bluetooth.le.ScanResult;
import android.content.Context;
import android.os.Handler;
import android.util.Log;
import androidx.core.app.ActivityCompat;
import com.idtechproducts.device.Common;
import com.idtechproducts.device.IDTEMVData;
import com.idtechproducts.device.IDTMSRData;
import com.idtechproducts.device.IDT_VP3300;
import com.idtechproducts.device.OnReceiverListener;
import com.idtechproducts.device.ReaderInfo;
import com.idtechproducts.device.ResDataStruct;
import com.idtechproducts.device.StructConfigParameters;
import com.idtechproducts.device.bluetooth.BluetoothLEController;
import com.zeamster.paymentsdk.R;
import com.zeamster.paymentsdk.transaction.ICallbackEMV;
import com.zeamster.paymentsdk.transaction.ICallbackTransaction;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class IDTECHBLEService
implements OnReceiverListener {
    private static final int MY_PERMISSIONS_REQUEST_READ_CONTACTS = 3300;
    private static final int DEFAULT_TIMEOUT = 10000;
    private final int EMV_TIMEOUT = 90;
    private String btleDeviceAddress = "";
    private String btleDeviceName = "";
    private String message = "";
    private String log = "";
    private boolean btleDeviceRegistered;
    private boolean isReaderConnected = false;
    private IDT_VP3300 idt_vp3300;
    private ScanCallback scanCallback;
    private BluetoothAdapter mBtAdapter;
    private BluetoothLeScanner bluetoothLeScanner;
    private ArrayList<String> deviceNames = new ArrayList();
    private ArrayList<BluetoothDevice> discoveredDevices = new ArrayList();
    private ArrayList<Integer> scanErrorCodes = new ArrayList();
    private Handler handler = new Handler();
    private ReaderInfo.DEVICE_TYPE deviceType;
    private ICallbackEMV callback;
    private Activity context;
    private boolean isPluginRequest;
    private ICallbackTransaction callbackTransaction;
    private Map<String, byte[]> finalTransactionTags;
    public boolean isRefund;
    public String logsDATA = "";
    private String deviceSerialNumber = "";
    private String deviceEMVKernelVersion = "";
    private String deviceCTLSEMVKernelVersion = "";
    public boolean isNonTechnicalFallback = false;

    public IDTECHBLEService(ICallbackEMV callbackEMV, Activity context, ReaderInfo.DEVICE_TYPE deviceType) {
        this.callback = callbackEMV;
        this.context = context;
        this.deviceType = deviceType;
        this.createDeviceInstance();
    }

    public ICallbackTransaction getCallbackTransaction() {
        return this.callbackTransaction;
    }

    public void setCallbackTransaction(ICallbackTransaction callbackTransaction) {
        this.callbackTransaction = callbackTransaction;
    }

    public boolean isPluginRequest() {
        return this.isPluginRequest;
    }

    public void isPluginRequest(boolean pluginRequest) {
        this.isPluginRequest = pluginRequest;
    }

    public ReaderInfo.DEVICE_TYPE getDeviceType() {
        return this.deviceType;
    }

    public void setDeviceType(ReaderInfo.DEVICE_TYPE deviceType) {
        this.deviceType = deviceType;
    }

    public IDT_VP3300 getIdt_vp3300() {
        return this.idt_vp3300;
    }

    public ArrayList<Integer> getScanErrorCodes() {
        return this.scanErrorCodes;
    }

    private void createDeviceInstance() {
        switch (this.deviceType) {
            case DEVICE_VP3300_BT: {
                if (this.idt_vp3300 != null) {
                    this.idt_vp3300.unregisterListen();
                    this.idt_vp3300.release();
                    this.idt_vp3300 = null;
                    this.btleDeviceRegistered = false;
                }
                this.idt_vp3300 = new IDT_VP3300((OnReceiverListener)this, (Context)this.context);
                this.idt_vp3300.device_setDeviceType(this.deviceType);
                this.idt_vp3300.registerListen();
            }
        }
        this.loadXMLfile();
    }

    private void loadXMLfile() {
        String fileNameWithPath = this.getConfigurationFileFromRaw();
        if (!this.isFileExist(fileNameWithPath)) {
            fileNameWithPath = null;
        }
        this.idt_vp3300.config_setXMLFileNameWithPath(fileNameWithPath);
        Log.d((String)"Demo Info >>>>>", (String)"loadingConfigurationXMLFile begin.");
        this.idt_vp3300.config_loadingConfigurationXMLFile(true);
    }

    private String getConfigurationFileFromRaw() {
        return this.getXMLFileFromRaw("idt_unimagcfg_default.xml", R.raw.idt_unimagcfg_default);
    }

    private String getXMLFileFromRaw(String fileName, int res) {
        String fileNameWithPath = null;
        fileNameWithPath = fileName;
        try {
            InputStream in = this.context.getResources().openRawResource(res);
            int length = in.available();
            byte[] buffer = new byte[length];
            in.read(buffer);
            in.close();
            this.context.deleteFile(fileNameWithPath);
            FileOutputStream fout = this.context.openFileOutput(fileNameWithPath, 0);
            fout.write(buffer);
            fout.close();
            File fileDir = this.context.getFilesDir();
            fileNameWithPath = fileDir.getParent() + File.separator + fileDir.getName();
            fileNameWithPath = fileNameWithPath + File.separator + fileName;
        }
        catch (Exception e) {
            e.printStackTrace();
            fileNameWithPath = null;
        }
        return fileNameWithPath;
    }

    private boolean isFileExist(String path) {
        if (path == null) {
            return false;
        }
        File file = new File(path);
        return file.exists();
    }

    public ArrayList<String> scanForDevices(final String searchString, long timeout) {
        this.scanCallback = new ScanCallback(){

            public void onScanResult(int callbackType, ScanResult result) {
                if (searchString.equalsIgnoreCase("*") || result.getDevice().getName() != null && result.getDevice().getName().startsWith(searchString) || result.getDevice().getAddress() != null && result.getDevice().getAddress().startsWith(searchString)) {
                    for (BluetoothDevice bluetoothDevice : IDTECHBLEService.this.discoveredDevices) {
                        if (!bluetoothDevice.getAddress().contentEquals(result.getDevice().getAddress())) continue;
                        return;
                    }
                    IDTECHBLEService.this.discoveredDevices.add(result.getDevice());
                    if (result.getDevice().getName() != null && !result.getDevice().getName().isEmpty()) {
                        IDTECHBLEService.this.deviceNames.add(result.getDevice().getName());
                    } else {
                        IDTECHBLEService.this.deviceNames.add(result.getDevice().getAddress());
                    }
                    IDTECHBLEService.this.callback.deviceScanResponse(result.getDevice().getAddress(), result.getDevice().getName());
                }
            }

            public void onBatchScanResults(List<ScanResult> results) {
                for (ScanResult scanResult : results) {
                    this.onScanResult(1, scanResult);
                }
            }

            public void onScanFailed(int errorCode) {
                IDTECHBLEService.this.scanErrorCodes.add(errorCode);
            }
        };
        if (timeout < 10000L) {
            timeout = 10000L;
        }
        this.scanLeDevice(timeout);
        return this.deviceNames;
    }

    private void scanLeDevice(long timeout) {
        if (this.mBtAdapter == null) {
            this.mBtAdapter = BluetoothAdapter.getDefaultAdapter();
        }
        if (this.mBtAdapter != null) {
            this.bluetoothLeScanner = this.mBtAdapter.getBluetoothLeScanner();
            if (this.bluetoothLeScanner != null) {
                if (!this.isPluginRequest()) {
                    ActivityCompat.requestPermissions((Activity)this.context, (String[])new String[]{"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION"}, (int)3300);
                }
                this.handler.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        IDTECHBLEService.this.bluetoothLeScanner.stopScan(IDTECHBLEService.this.scanCallback);
                        IDTECHBLEService.this.callback.deviceScanCompleted();
                    }
                }, timeout);
                this.bluetoothLeScanner.startScan(this.scanCallback);
            } else {
                this.callback.deviceScanCompleted();
            }
        } else {
            this.callback.deviceScanCompleted();
        }
    }

    public void stopScanForDevices() {
        if (this.bluetoothLeScanner != null) {
            this.bluetoothLeScanner.stopScan(this.scanCallback);
        }
    }

    public boolean connectDeviceByAddress(String deviceAddress) {
        BluetoothDevice bluetoothDevice;
        if (this.idt_vp3300 != null && this.btleDeviceRegistered) {
            this.idt_vp3300.unregisterListen();
            this.btleDeviceRegistered = false;
        }
        if (deviceAddress != null && !deviceAddress.isEmpty() && deviceAddress.length() == 17 && deviceAddress.charAt(2) == ':' && deviceAddress.charAt(5) == ':' && deviceAddress.charAt(8) == ':' && deviceAddress.charAt(11) == ':' && deviceAddress.charAt(14) == ':' && (bluetoothDevice = this.getDeviceByAddress(deviceAddress)) != null) {
            BluetoothLEController.setBluetoothDevice((BluetoothDevice)bluetoothDevice);
            this.btleDeviceAddress = deviceAddress;
            String string = this.btleDeviceName = bluetoothDevice.getName() != null ? bluetoothDevice.getName() : "";
            if (!this.btleDeviceRegistered) {
                this.idt_vp3300.registerListen();
                this.btleDeviceRegistered = true;
            }
            return true;
        }
        return false;
    }

    public boolean connectDeviceByName(String deviceName) {
        BluetoothDevice bluetoothDevice;
        if (this.idt_vp3300 != null && this.btleDeviceRegistered) {
            this.idt_vp3300.unregisterListen();
            this.btleDeviceRegistered = false;
        }
        if (deviceName != null && !deviceName.isEmpty() && (bluetoothDevice = this.getDeviceByName(deviceName)) != null) {
            BluetoothLEController.setBluetoothDevice((BluetoothDevice)bluetoothDevice);
            this.btleDeviceName = deviceName;
            String string = this.btleDeviceAddress = bluetoothDevice.getAddress() != null ? bluetoothDevice.getAddress() : "";
            if (!this.btleDeviceRegistered) {
                this.idt_vp3300.registerListen();
                this.btleDeviceRegistered = true;
            }
            return true;
        }
        return false;
    }

    public boolean disconnectDevice() {
        if (this.idt_vp3300 != null && this.btleDeviceRegistered) {
            this.idt_vp3300.unregisterListen();
            this.btleDeviceRegistered = false;
            this.idt_vp3300.device_disconnectBLE();
            this.deviceDisconnected();
        }
        return true;
    }

    private BluetoothDevice getDeviceByName(String name) {
        for (BluetoothDevice bluetoothDevice : this.discoveredDevices) {
            if (bluetoothDevice.getName() == null || !bluetoothDevice.getName().equalsIgnoreCase(name)) continue;
            return bluetoothDevice;
        }
        return null;
    }

    private BluetoothDevice getDeviceByAddress(String address) {
        for (BluetoothDevice bluetoothDevice : this.discoveredDevices) {
            if (bluetoothDevice.getAddress() == null || !bluetoothDevice.getAddress().equalsIgnoreCase(address)) continue;
            return bluetoothDevice;
        }
        return null;
    }

    public String getConnectedDeviceAndStatus() {
        String device = "UNKNOWN";
        if (this.btleDeviceName != null && !this.btleDeviceName.isEmpty()) {
            device = this.btleDeviceName;
        } else if (this.btleDeviceAddress != null && !this.btleDeviceAddress.isEmpty()) {
            device = this.btleDeviceAddress;
        }
        String status = "DISCONNECTED";
        if (this.isReaderConnected) {
            status = "CONNECTED";
        }
        return status + " - " + device;
    }

    public void clearLog() {
        this.log = "";
    }

    public void runInitialSetup(JSONObject jsonObject) {
        this.message = "Running initial device setup..";
        this.log = "";
        this.sendResponse();
        try {
            if (jsonObject.has("general_configuration")) {
                JSONObject generalConf = jsonObject.getJSONObject("general_configuration");
                if (generalConf.has("terminal_ics_type")) {
                    this.setTerminalMajorConfiguration(generalConf.getString("terminal_ics_type"));
                }
                if (generalConf.has("terminal_data")) {
                    this.setTerminalData(generalConf.getString("terminal_data"));
                }
                if (generalConf.has("crl")) {
                    this.setCRLData(generalConf.getString("crl"));
                }
                if (generalConf.has("contact")) {
                    this.setContactSettings(generalConf.getJSONObject("contact"));
                }
                if (generalConf.has("contactless")) {
                    this.setContactlessSettings(generalConf.getJSONObject("contactless"));
                }
            }
        }
        catch (JSONException ex) {
            this.log = ex.getMessage();
        }
        this.message = "Initial device setup completed.";
        this.sendResponse();
    }

    private void setContactlessSettings(JSONObject contactless) throws JSONException {
        if (contactless.has("capk")) {
            this.setCTLSCAPKData(contactless.getJSONArray("capk"));
        }
        if (contactless.has("aids")) {
            this.setCTLSAIDData(contactless.getJSONArray("aids"));
        }
        if (contactless.has("configuration_groups")) {
            this.setCTLSGroupData(contactless.getJSONArray("configuration_groups"));
        }
    }

    private void setCTLSGroupData(JSONArray configuration_groups) throws JSONException {
        this.message = "Setting Configuration Group Data";
        this.sendResponse();
        for (int i = 0; i < configuration_groups.length(); ++i) {
            JSONObject group = configuration_groups.getJSONObject(i);
            ResDataStruct resDataStruct = new ResDataStruct();
            int groupID = group.getInt("group");
            byte[] key = Common.getBytesFromHexString((String)("FFE4010" + String.valueOf(groupID) + group.getString("data")));
            int n = this.idt_vp3300.ctls_setConfigurationGroup(key, resDataStruct);
        }
    }

    private void setCTLSAIDData(JSONArray aidData) throws JSONException {
        this.message = "Setting Contactless AID Data";
        this.sendResponse();
        for (int i = 0; i < aidData.length(); ++i) {
            JSONObject aid = aidData.getJSONObject(i);
            String aidHexString = aid.getString("name");
            String tlvHexString = aid.getString("value");
            byte[] TLV = Common.getBytesFromHexString((String)tlvHexString);
            ResDataStruct resDataStruct = new ResDataStruct();
            int n = this.idt_vp3300.ctls_setApplicationData(TLV, resDataStruct);
        }
    }

    private void setCTLSCAPKData(JSONArray capkData) throws JSONException {
        this.message = "Setting Contactless CAPK Data";
        this.sendResponse();
        for (int i = 0; i < capkData.length(); ++i) {
            ResDataStruct resDataStruct = new ResDataStruct();
            JSONObject capk = capkData.getJSONObject(i);
            String capkFile = capk.getString("name") + capk.getString("hash_algorithm") + capk.getString("encryption_algorithm") + capk.getString("hash_value") + capk.getString("exponent") + capk.getString("modulus_length") + capk.getString("modulus");
            byte[] key = Common.getBytesFromHexString((String)capkFile);
            int n = this.idt_vp3300.ctls_setCAPK(key, resDataStruct);
        }
    }

    private void setContactSettings(JSONObject contact) throws JSONException {
        if (contact.has("capk")) {
            this.setCAPKData(contact.getJSONArray("capk"));
        }
        if (contact.has("aid")) {
            this.setAIDData(contact.getJSONArray("aid"));
        }
    }

    private void setTerminalMajorConfiguration(String terminalKernelConfig) {
        this.message = "Setting Terminal Major Configuration";
        this.sendResponse();
        if (terminalKernelConfig == null || terminalKernelConfig.isEmpty()) {
            this.log = "Invalid Terminal Major Configuration Data!";
            this.sendResponse();
        } else {
            int n = this.idt_vp3300.emv_setTerminalMajorConfiguration(Integer.parseInt(terminalKernelConfig.substring(0, 1)));
        }
    }

    private void setTerminalData(String terminalData) {
        this.message = "Setting Terminal Data";
        this.sendResponse();
        if (terminalData == null || terminalData.isEmpty()) {
            this.log = "Invalid Terminal data.";
            this.sendResponse();
        } else {
            ResDataStruct resDataStruct = new ResDataStruct();
            byte[] TLV = Common.getBytesFromHexString((String)terminalData);
            int n = this.idt_vp3300.emv_setTerminalData(TLV, resDataStruct);
        }
    }

    private void setAIDData(JSONArray aidData) throws JSONException {
        this.message = "Setting Contact AID Data";
        this.sendResponse();
        for (int i = 0; i < aidData.length(); ++i) {
            JSONObject aid = aidData.getJSONObject(i);
            String aidHexString = aid.getString("name");
            String tlvHexString = aid.getString("value");
            byte[] TLV = Common.getBytesFromHexString((String)tlvHexString);
            ResDataStruct resDataStruct = new ResDataStruct();
            int n = this.idt_vp3300.emv_setApplicationData(aidHexString, TLV, resDataStruct);
        }
    }

    private void setCAPKData(JSONArray capkData) throws JSONException {
        this.message = "Setting Contact CAPK Data";
        this.sendResponse();
        for (int i = 0; i < capkData.length(); ++i) {
            ResDataStruct resDataStruct = new ResDataStruct();
            JSONObject capk = capkData.getJSONObject(i);
            String capkFile = capk.getString("name") + capk.getString("hash_algorithm") + capk.getString("encryption_algorithm") + capk.getString("hash_value") + capk.getString("exponent") + capk.getString("modulus_length") + capk.getString("modulus");
            byte[] key = Common.getBytesFromHexString((String)capkFile);
            int n = this.idt_vp3300.emv_setCAPK(key, resDataStruct);
        }
    }

    private void setCRLData(String crlData) {
        this.message = "Setting CRL Data";
        this.sendResponse();
        if (crlData == null || crlData.isEmpty()) {
            this.log = "Invalid CRL data.";
        } else {
            ResDataStruct resDataStruct = new ResDataStruct();
            crlData = crlData.replaceAll(",", "");
            byte[] crlList = Common.getBytesFromHexString((String)crlData);
            int n = this.idt_vp3300.emv_setCRL(crlList, resDataStruct);
        }
    }

    private void sendResponse() {
        Thread thread = new Thread(){

            @Override
            public void run() {
                IDTECHBLEService.this.callback.deviceMessage(IDTECHBLEService.this.message);
                IDTECHBLEService.this.callback.outputLogs(IDTECHBLEService.this.log);
            }
        };
        thread.start();
    }

    public HashMap<String, Object> getDeviceSettings() {
        HashMap<String, Object> deviceSettings = new HashMap<String, Object>();
        HashMap<String, Object> generalConfig = new HashMap<String, Object>();
        deviceSettings.put("serial_number", this.getSerialNumber());
        deviceSettings.put("firmware_version", this.getFirmwareDetail());
        generalConfig.put("terminal_ics_type", "");
        generalConfig.put("terminal_data", this.getTerminalData());
        generalConfig.put("crl", this.getCRLData());
        generalConfig.put("contact", this.getContactSettings());
        generalConfig.put("contactless", this.getContactlessSettings());
        deviceSettings.put("general_configuration", generalConfig);
        return deviceSettings;
    }

    private Object getContactlessSettings() {
        HashMap contactlessSettings = new HashMap();
        contactlessSettings.put("configuration_groups", this.getContactlessGroups());
        contactlessSettings.put("capk", this.getContactlessCAPKSettings());
        contactlessSettings.put("aid", new ArrayList());
        return contactlessSettings;
    }

    private Object getContactSettings() {
        HashMap<String, ArrayList> contactSettings = new HashMap<String, ArrayList>();
        contactSettings.put("aid", this.getContactAIDSettings());
        contactSettings.put("capk", this.getContactCAPKSettings());
        return contactSettings;
    }

    private Object getCRLData() {
        this.message = "Getting CRL Data";
        this.sendResponse();
        ResDataStruct resData = new ResDataStruct();
        int ret = this.idt_vp3300.emv_retrieveCRL(resData);
        if (ret == 0 && resData.resData != null) {
            return Common.getHexStringFromBytes((byte[])resData.resData);
        }
        return "";
    }

    private String getFirmwareDetail() {
        this.message = "Getting Firmware";
        this.sendResponse();
        StringBuilder sb = new StringBuilder();
        int ret = this.idt_vp3300.device_getFirmwareVersion(sb);
        if (ret == 0 && sb != null) {
            return sb.toString();
        }
        return "";
    }

    private String getSerialNumber() {
        StringBuilder sb = new StringBuilder();
        String serialNumber = "";
        int ret = this.idt_vp3300.config_getSerialNumber(sb);
        if (ret == 0 && sb != null) {
            serialNumber = sb.toString();
            if (serialNumber.length() > 8) {
                serialNumber = serialNumber.substring(serialNumber.length() - 8);
            }
            return serialNumber;
        }
        return "";
    }

    private ArrayList getContactAIDSettings() {
        this.message = "Getting Contact AID Settings";
        this.sendResponse();
        ArrayList aidList = new ArrayList();
        ResDataStruct resData = new ResDataStruct();
        int ret = this.idt_vp3300.emv_retrieveAidList(resData);
        if (ret == 0 && resData.stringArray != null) {
            for (String aidName : resData.stringArray) {
                ResDataStruct aidData = new ResDataStruct();
                int retVal = this.idt_vp3300.emv_retrieveApplicationData(aidName, aidData);
                if (retVal != 0 || aidData.resData == null) continue;
                HashMap<String, String> aidMap = new HashMap<String, String>();
                aidMap.put("name", aidName);
                aidMap.put("value", Common.getHexStringFromBytes((byte[])aidData.resData));
                aidList.add(aidMap);
            }
        }
        return aidList;
    }

    private ArrayList getContactlessAIDSettings() {
        this.message = "Getting Contactless AID Settings";
        this.sendResponse();
        ArrayList aidList = new ArrayList();
        ResDataStruct resData = new ResDataStruct();
        int ret = this.idt_vp3300.ctls_retrieveAidList(resData);
        if (ret == 0 && resData.stringArray != null) {
            for (String aidName : resData.stringArray) {
                ResDataStruct aidData = new ResDataStruct();
                int retVal = this.idt_vp3300.ctls_retrieveApplicationData(aidName, aidData);
                if (retVal != 0 || aidData.resData == null) continue;
                HashMap<String, String> aidMap = new HashMap<String, String>();
                aidMap.put("name", aidName);
                aidMap.put("value", Common.getHexStringFromBytes((byte[])aidData.resData));
                aidList.add(aidMap);
            }
        }
        return aidList;
    }

    private ArrayList getContactCAPKSettings() {
        this.message = "Getting Contact CAPK Settings";
        this.sendResponse();
        ArrayList capkList = new ArrayList();
        ResDataStruct resData = new ResDataStruct();
        int ret = this.idt_vp3300.emv_retrieveCAPKList(resData);
        if (ret == 0 && resData.resData != null) {
            String capkDataStr = Common.getHexStringFromBytes((byte[])resData.resData);
            for (int start = 0; start < capkDataStr.length(); start += 12) {
                String capkName = capkDataStr.substring(start, Math.min(capkDataStr.length(), start + 12));
                ResDataStruct capkData = new ResDataStruct();
                int retVal = this.idt_vp3300.emv_retrieveCAPK(Common.getBytesFromHexString((String)capkName), capkData);
                if (retVal != 0 || capkData.resData == null) continue;
                String capkFile = Common.getHexStringFromBytes((byte[])capkData.resData);
                HashMap<String, String> capkMap = new HashMap<String, String>();
                capkMap.put("name", capkFile.substring(0, 12));
                capkMap.put("hash_algorithm", capkFile.substring(12, 14));
                capkMap.put("encryption_algorithm", capkFile.substring(14, 16));
                capkMap.put("hash_value", capkFile.substring(16, 56));
                capkMap.put("exponent", capkFile.substring(56, 64));
                capkMap.put("modulus_length", capkFile.substring(64, 68));
                capkMap.put("modulus", capkFile.substring(68));
                capkList.add(capkMap);
            }
        }
        return capkList;
    }

    private ArrayList getContactlessCAPKSettings() {
        this.message = "Getting Contactless CAPK Settings";
        this.sendResponse();
        ArrayList capkList = new ArrayList();
        ResDataStruct resData = new ResDataStruct();
        int ret = this.idt_vp3300.ctls_retrieveCAPKList(resData);
        this.log = "Getting CAPK List: " + this.idt_vp3300.device_getResponseCodeString(ret) + "\n";
        this.sendResponse();
        if (ret == 0 && resData.resData != null) {
            String capkDataStr = Common.getHexStringFromBytes((byte[])resData.resData);
            for (int start = 0; start < capkDataStr.length(); start += 12) {
                String capkName = capkDataStr.substring(start, Math.min(capkDataStr.length(), start + 12));
                ResDataStruct capkData = new ResDataStruct();
                int retVal = this.idt_vp3300.ctls_retrieveCAPK(Common.getBytesFromHexString((String)capkName), capkData);
                if (retVal != 0 || capkData.resData == null) continue;
                String capkFile = Common.getHexStringFromBytes((byte[])capkData.resData);
                HashMap<String, String> capkMap = new HashMap<String, String>();
                capkMap.put("name", capkName);
                capkMap.put("hash_algorithm", capkFile.substring(0, 2));
                capkMap.put("encryption_algorithm", capkFile.substring(2, 4));
                capkMap.put("hash_value", capkFile.substring(4, 44));
                capkMap.put("exponent", capkFile.substring(44, 52));
                capkMap.put("modulus_length", capkFile.substring(52, 56));
                capkMap.put("modulus", capkFile.substring(56));
                capkList.add(capkMap);
            }
        }
        return capkList;
    }

    private ArrayList getContactlessGroups() {
        this.message = "Getting Configuration Groups";
        this.sendResponse();
        ArrayList groupList = new ArrayList();
        for (int groupID = 0; groupID < 4; ++groupID) {
            ResDataStruct groupData = new ResDataStruct();
            int retVal = this.idt_vp3300.ctls_getConfigurationGroup(groupID, groupData);
            if (retVal != 0 || groupData.resData == null) continue;
            HashMap<String, Object> groupMap = new HashMap<String, Object>();
            groupMap.put("group", groupID);
            groupMap.put("data", Common.getHexStringFromBytes((byte[])groupData.resData));
            groupList.add(groupMap);
        }
        return groupList;
    }

    private String getTerminalData() {
        this.message = "Getting Terminal data";
        this.sendResponse();
        ResDataStruct resData = new ResDataStruct();
        int ret = this.idt_vp3300.emv_retrieveTerminalData(resData);
        if (ret == 0) {
            return Common.getHexStringFromBytes((byte[])resData.resData);
        }
        return "";
    }

    private String getEMVKernelVersion() {
        String completeCommand = "2907";
        ResDataStruct resultData = new ResDataStruct();
        String kernelVersion = "";
        int ret = this.idt_vp3300.device_sendDataCommand(completeCommand, true, "", resultData);
        if (ret == 0 && resultData.resData != null) {
            kernelVersion = Common.getHexStringFromBytes((byte[])resultData.resData);
            return kernelVersion;
        }
        return "";
    }

    private String getCTLSEMVKernelVersion() {
        String completeCommand = "0920";
        ResDataStruct resultData = new ResDataStruct();
        String kernelVersion = "";
        int ret = this.idt_vp3300.device_sendDataCommand(completeCommand, true, "", resultData);
        if (ret == 0 && resultData.resData != null) {
            kernelVersion = Common.getHexStringFromBytes((byte[])resultData.resData);
            return kernelVersion;
        }
        return "";
    }

    public void startEMVTransaction(double amount) {
        byte[] inputTags;
        int responseCode;
        this.message = "EMV Tramsaction Starting\n";
        this.sendResponse();
        this.deviceSerialNumber = this.getSerialNumber();
        this.deviceEMVKernelVersion = this.getEMVKernelVersion();
        this.deviceCTLSEMVKernelVersion = this.getCTLSEMVKernelVersion();
        this.finalTransactionTags = null;
        this.isNonTechnicalFallback = false;
        int type = 0;
        IDT_VP3300.emv_setAutoAuthenticateTransaction((boolean)false);
        IDT_VP3300.emv_setAutoCompleteTransaction((boolean)false);
        IDT_VP3300.emv_allowFallback((boolean)true);
        if (this.isRefund) {
            type = 32;
        }
        this.message = (responseCode = this.idt_vp3300.device_startTransaction(amount, 0.0, type, 90, inputTags = Common.hexStringToByteArray((String)"DFEF7E085004500550325033"), false)) == 61027 ? "SDK is doing EMV task.\n" : "EMV Transaction started\n";
        this.sendResponse();
    }

    public void completeEMVTransaction() {
        Map retrievedTags = null;
        this.idt_vp3300.emv_retrieveTransactionResult(new byte[5], retrievedTags);
        this.idt_vp3300.emv_completeTransaction(false, new byte[5], new byte[5], new byte[5], new byte[5]);
        this.message = "EMV Transaction Completed.\n";
        this.sendResponse();
    }

    public void cancelEMVTransaction() {
        this.sendResponse();
        int responseCode = this.idt_vp3300.device_cancelTransaction();
        if (responseCode == 0) {
            this.message = "EMV Transaction Cancelled\n";
        }
        this.sendResponse();
    }

    public void swipeMSRData(IDTMSRData idtmsrData) {
        if (idtmsrData != null && idtmsrData.unencryptedTags != null && idtmsrData.unencryptedTags.containsKey("9F39") && Common.getHexStringFromBytes((byte[])((byte[])idtmsrData.unencryptedTags.get("9F39"))).equalsIgnoreCase("07") && this.isRefund) {
            byte[] data;
            this.message = "Tap Read Successfully";
            this.log = this.log + "\nUnencrypted Tags/API Input Transaction Tags:\r\n";
            Set keys = idtmsrData.unencryptedTags.keySet();
            StringBuilder sb = new StringBuilder();
            StringBuilder unencryptedTags = new StringBuilder();
            for (String key : keys) {
                sb.append(key).append(": ");
                data = (byte[])idtmsrData.unencryptedTags.get(key);
                String value = Common.getHexStringFromBytes((byte[])data);
                sb.append(value).append("\r\n");
                String length = String.format("%02x", value.length() / 2);
                unencryptedTags.append(key).append(length).append(value);
            }
            this.log = this.log + sb.toString() + "\r\n";
            this.sendResponse();
            String KSN = "";
            data = null;
            if (idtmsrData.unencryptedTags.containsKey("FFEE12")) {
                data = (byte[])idtmsrData.unencryptedTags.get("FFEE12");
            } else if (idtmsrData.unencryptedTags.containsKey("DFEE12 ")) {
                data = (byte[])idtmsrData.unencryptedTags.get("DFEE12");
            }
            if (data != null) {
                KSN = Common.getHexStringFromBytes((byte[])data);
            }
            this.callbackTransaction.call("EMVTap", unencryptedTags.toString(), KSN, this.deviceSerialNumber, this.deviceCTLSEMVKernelVersion, false);
        } else if (idtmsrData != null && idtmsrData.unencryptedTags != null && idtmsrData.unencryptedTags.containsKey("9F39") && !Common.getHexStringFromBytes((byte[])((byte[])idtmsrData.unencryptedTags.get("9F39"))).equalsIgnoreCase("07")) {
            this.message = idtmsrData.cardData[0] != 1 && idtmsrData.track1Length == 0 && idtmsrData.track2Length == 0 && idtmsrData.track3Length == 0 ? "Swipe data didn't read correctly" : "Swipe Read Successfully";
            this.log = Common.parse_MSRData((ReaderInfo.DEVICE_TYPE)this.idt_vp3300.device_getDeviceType(), (IDTMSRData)idtmsrData);
            this.sendResponse();
            String DFEE23 = "";
            Boolean isFallback = false;
            Boolean isTapCardData = false;
            if (idtmsrData != null && idtmsrData.unencryptedTags != null) {
                byte[] data = (byte[])idtmsrData.unencryptedTags.get("DFEE23");
                DFEE23 = Common.getHexStringFromBytes((byte[])data);
                byte[] fallback = (byte[])idtmsrData.unencryptedTags.get("9F39");
                String fallbackStr = Common.getHexStringFromBytes((byte[])fallback);
                if (fallbackStr.equalsIgnoreCase("80")) {
                    byte[] tagValue;
                    String nonTechFallbackTagValue;
                    isFallback = true;
                    if (idtmsrData.unencryptedTags.containsKey("DFEE25") && (nonTechFallbackTagValue = Common.getHexStringFromBytes((byte[])(tagValue = (byte[])idtmsrData.unencryptedTags.get("DFEE25")))).equalsIgnoreCase("0011")) {
                        this.isNonTechnicalFallback = true;
                    }
                }
            }
            StringBuilder KSN = new StringBuilder();
            if (idtmsrData != null && idtmsrData.KSN != null && idtmsrData.KSN.length > 0) {
                for (int i = 0; i < idtmsrData.KSN.length; ++i) {
                    KSN.append(String.format(Locale.US, "%02x", idtmsrData.KSN[i]));
                }
            }
            this.callbackTransaction.call("MSR", DFEE23, KSN.toString(), this.deviceSerialNumber, this.deviceEMVKernelVersion, isFallback);
        }
    }

    public void lcdDisplay(int mode, String[] lines, int timeout) {
        if (mode == 1) {
            this.idt_vp3300.emv_lcdControlResponse((byte)mode, (byte)1);
        } else if (mode == 8) {
            this.idt_vp3300.emv_lcdControlResponse((byte)mode, (byte)1);
        } else {
            this.message = lines[0];
            if (!this.message.contains("DECLINED")) {
                this.callback.deviceMessage(this.message);
            }
        }
    }

    public void lcdDisplay(int i, String[] strings, int i1, byte[] bytes, byte b) {
    }

    public void ctlsEvent(byte b, byte b1, byte b2) {
    }

    public void emvTransactionData(IDTEMVData idtEMVData) {
        Set<Object> keys;
        this.log = this.log + "\r\nEMV Transaction Data Response:\r\n";
        this.log = this.log + "\r\n" + Common.emvErrorCodes((int)idtEMVData.result) + "\r\n\n";
        if (idtEMVData.result == 16) {
            this.log = this.log + "\nStart Transaction Response:\r\n";
        } else if (idtEMVData.result == 4) {
            this.log = this.log + "\r\nAuthentication Response:\r\n";
        } else if (idtEMVData.result == 2 || idtEMVData.result == 3) {
            this.log = this.log + "\r\nComplete Transaction Response:\r\n\n";
            this.message = "COMPLETED";
        } else if (idtEMVData.result == 9) {
            this.log = this.log + "\r\nCaptured Contactless Transaction Response:\r\n";
            this.message = "COMPLETED";
        } else {
            this.log = this.log + "\r\n" + this.idt_vp3300.device_getResponseCodeString(idtEMVData.result) + "\r\n";
            this.log = this.log + "\r\nUnhandled Transaction Response.\r\n";
        }
        if (idtEMVData.unencryptedTags != null && !idtEMVData.unencryptedTags.isEmpty()) {
            this.log = this.log + "\nUnencrypted Tags:\r\n";
            Set keys2 = idtEMVData.unencryptedTags.keySet();
            StringBuilder sb = new StringBuilder();
            StringBuilder stringBuilder = new StringBuilder();
            for (Object key : keys2) {
                sb.append((String)key).append(": ");
                byte[] byArray = (byte[])idtEMVData.unencryptedTags.get(key);
                String value = Common.getHexStringFromBytes((byte[])byArray);
                sb.append(value).append("\r\n");
            }
            this.log = this.log + sb.toString() + "\r\n";
        }
        this.sendResponse();
        if (idtEMVData.result == 16) {
            this.finalTransactionTags = idtEMVData.unencryptedTags;
            int keys2 = this.idt_vp3300.emv_authenticateTransaction(null);
        } else if (idtEMVData.result == 4) {
            keys = idtEMVData.unencryptedTags.keySet();
            for (String string : keys) {
                this.finalTransactionTags.put(string, (byte[])idtEMVData.unencryptedTags.get(string));
            }
            byte[] response = new byte[]{48, 48};
            int n = this.idt_vp3300.emv_completeTransaction(false, response, null, null, null);
        } else if (idtEMVData.result == 2 || idtEMVData.result == 3 || idtEMVData.result == 9) {
            byte[] data;
            String string;
            if (this.finalTransactionTags == null) {
                this.finalTransactionTags = new HashMap<String, byte[]>();
            }
            keys = idtEMVData.unencryptedTags.keySet();
            boolean isCorrect9F27Found = false;
            if (this.finalTransactionTags.containsKey("9F27") && (string = Common.getHexStringFromBytes((byte[])this.finalTransactionTags.get("9F27"))).equals("80")) {
                isCorrect9F27Found = true;
            }
            for (String string2 : keys) {
                if (isCorrect9F27Found && (string2.equals("9F27") || string2.equals("9F26") || string2.equals("9F36"))) continue;
                this.finalTransactionTags.put(string2, (byte[])idtEMVData.unencryptedTags.get(string2));
            }
            this.log = this.log + "\nAPI Input Transaction Tags:\r\n";
            keys = this.finalTransactionTags.keySet();
            StringBuilder stringBuilder = new StringBuilder();
            StringBuilder stringBuilder2 = new StringBuilder();
            for (String string3 : keys) {
                stringBuilder.append(string3).append(": ");
                data = this.finalTransactionTags.get(string3);
                String value = Common.getHexStringFromBytes((byte[])data);
                stringBuilder.append(value).append("\r\n");
                String length = String.format("%02x", value.length() / 2);
                stringBuilder2.append(string3).append(length).append(value);
            }
            this.log = this.log + stringBuilder.toString();
            this.sendResponse();
            String KSN = "";
            data = null;
            if (this.finalTransactionTags.containsKey("FFEE12")) {
                data = this.finalTransactionTags.get("FFEE12");
            } else if (this.finalTransactionTags.containsKey("DFEE12 ")) {
                data = this.finalTransactionTags.get("DFEE12");
            }
            if (data != null) {
                KSN = Common.getHexStringFromBytes((byte[])data);
            }
            if (idtEMVData.result == 9) {
                this.callbackTransaction.call("EMVTap", stringBuilder2.toString(), KSN, this.deviceSerialNumber, this.deviceCTLSEMVKernelVersion, false);
            } else {
                this.callbackTransaction.call("EMVChip", stringBuilder2.toString(), KSN, this.deviceSerialNumber, this.deviceEMVKernelVersion, false);
            }
        } else if (idtEMVData.result == 1) {
            this.message = "DECLINED  Please try another card.\r\n";
            this.sendResponse();
        } else {
            this.sendResponse();
            this.cancelEMVTransaction();
        }
    }

    public void deviceConnected() {
        this.isReaderConnected = true;
        this.callback.deviceConnected(this.getConnectedDeviceAndStatus());
    }

    public void deviceDisconnected() {
        this.isReaderConnected = false;
        this.callback.deviceDisconnected(this.getConnectedDeviceAndStatus());
    }

    public void timeout(int i) {
    }

    public void autoConfigCompleted(StructConfigParameters structConfigParameters) {
    }

    public void autoConfigProgress(int i) {
    }

    public void msgRKICompleted(String s) {
    }

    public void ICCNotifyInfo(byte[] bytes, String s) {
    }

    public void msgBatteryLow() {
    }

    public void LoadXMLConfigFailureInfo(int i, String s) {
    }

    public void msgToConnectDevice() {
    }

    public void msgAudioVolumeAjustFailed() {
    }

    public void dataInOutMonitor(byte[] bytes, boolean b) {
        this.logsDATA = b ? this.logsDATA + "IN: " + Common.getHexStringFromBytes((byte[])bytes) + " @@ " : this.logsDATA + "OUT: " + Common.getHexStringFromBytes((byte[])bytes) + " @@ ";
    }
}

