/*
 * Decompiled with CFR 0.152.
 */
package com.idtechproducts.device.audiojack.tasks;

import com.idtechproducts.device.Common;
import com.idtechproducts.device.IDT_Device;
import com.idtechproducts.device.ReaderInfo;
import com.idtechproducts.device.StructConfigParameters;
import com.idtechproducts.device.audiojack.ReaderCommunication;
import com.idtechproducts.device.audiojack.UMLog;
import com.idtechproducts.device.audiojack.io.IOManager;
import com.idtechproducts.device.audiojack.io.ToneType;
import com.idtechproducts.device.audiojack.tasks.Task;
import com.idtechproducts.device.audiojack.tasks.TaskManager;
import java.util.List;

public class ConnectTask
extends Task {
    public final boolean d;
    public IDT_Device.TaskExport e;
    public Common.PUSType f;

    public ConnectTask(TaskManager umMan, ReaderCommunication readerCommunication, boolean connectWithCmd, IDT_Device.TaskExport taskExport) {
        super(umMan, readerCommunication);
        this.d = connectWithCmd;
        this.e = taskExport;
    }

    public ConnectTask(TaskManager umMan, ReaderCommunication readerCommunication, Common.PUSType pus) {
        super(umMan, readerCommunication);
        this.d = false;
        this.e = null;
        this.f = pus;
    }

    public TaskManager.TaskType getType() {
        return TaskManager.TaskType.Connect;
    }

    public void taskCleanup() {
        IOManager this_ = ((Task)((Object)this_))._ioManager;
        if (this_ != null) {
            this_.notifyTaskFinished();
        }
    }

    public Runnable taskMain() {
        if (this.f != null) {
            ConnectTask connectTask = this;
            UMLog.i(connectTask.TAG, "connected " + this.f.name);
            if (connectTask._config.getVolumeLevelAdjust() > 1) {
                this._ioManager.setDeviceMediaVolumeToMaxMinusArg(1);
            }
            final Common.PUSType pUSType = this.f;
            return new Runnable(){

                public void run() {
                    ReaderInfo.DEVICE_TYPE dEVICE_TYPE = pUSType.readerType;
                    if (dEVICE_TYPE != null) {
                        ConnectTask.this._readerCommunication.readerType_set(dEVICE_TYPE);
                    }
                    Common.coverAllBaudRate = false;
                    ConnectTask.this._readerCommunication.cxn_setConnected(ToneType.T_2000Hz);
                    Common.beginTimeEachCmd = Common.getCurrentTime();
                }
            };
        }
        final Common.PUSType pUSType = null;
        Common.beginTimeEachCmd = Common.getCurrentTime();
        if (this.e.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_UNKNOWN) {
            ConnectTask connectTask = this;
            connectTask.e.setReaderType(ReaderInfo.DEVICE_TYPE.DEVICE_UNIMAG);
            connectTask._ioManager.resetPlayer();
        }
        if (this.e.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ || this.e.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V) {
            List<byte[]> list = Common.packageCommandForVendi("5669564F7465636832000501000092EF");
            ConnectTask connectTask = this;
            if ((list = this._readerCommunication.sendCommand(Common.getBytesFromHexString((String)((Object)list)), 1.5, connectTask, connectTask)) != null && (list = ((IOManager.RPDResult)((Object)list)).data) != null) {
                list.clear();
            }
            list = Common.packageCommandForVendi("5669564F7465636832002C01000100380D");
            ConnectTask connectTask2 = this;
            list = this._readerCommunication.sendCommand(Common.getBytesFromHexString((String)((Object)list)), 1.5, connectTask2, connectTask2);
            IDT_Device.isPassthroughModeOn = false;
            if (list != null && (list = ((IOManager.RPDResult)((Object)list)).data) != null) {
                list.clear();
            }
        }
        int n2 = 1;
        while (true) {
            block26: {
                block24: {
                    Object object;
                    block25: {
                        if (n2 > 6) break block24;
                        if (n2 == 6 && this.e.getReaderType() != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ && this.e.getReaderType() != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V) {
                            ConnectTask connectTask = this;
                            UMLog.i(connectTask.TAG, "Connect Task: changing output wave direction");
                            object = connectTask._config;
                            short s2 = (short)(((StructConfigParameters)object).getDirectionOutputWave() != 1 ? 1 : 0);
                            ((StructConfigParameters)object).setDirectionOutputWave(s2);
                            this._ioManager.setConfig(this._config);
                        }
                        if (!this.d) break block25;
                        ConnectTask connectTask = this;
                        UMLog.i(connectTask.TAG, "set baud rate and channel level. baudrate = " + this._config.getBaudRate() + " , level = " + this._config.getShuttleChannel());
                        if (connectTask.e.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_UNIMAG) {
                            ConnectTask connectTask3 = this;
                            UMLog.i(connectTask3.TAG, "Try to connect for UNIMAG with " + this._config.getBaudRate() + " baud rate");
                            ConnectTask connectTask4 = this;
                            object = connectTask3._readerCommunication.connect(Common.makeSetBaudCommand(this._config), 1.5, connectTask4, connectTask4);
                        } else if (this.e.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_UNIJACK) {
                            ConnectTask connectTask5 = this;
                            UMLog.i(connectTask5.TAG, "Try to connect for UNIJACK with " + this._config.getBaudRate() + " baud rate");
                            ConnectTask connectTask6 = this;
                            object = connectTask5._readerCommunication.connect(Common.makeSetBaudCommandForUniJack(this._config), 1.0, connectTask6, connectTask6);
                        } else if (this.e.getReaderType() != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ && this.e.getReaderType() != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V) {
                            ConnectTask connectTask7 = this;
                            UMLog.i(connectTask7.TAG, "Try to connect for UNIPAY with " + this._config.getBaudRate() + " baud rate");
                            StructConfigParameters structConfigParameters = this._config;
                            ConnectTask connectTask8 = this;
                            object = connectTask7._readerCommunication.connect(Common.makeSetBaudAndLevelCommand(structConfigParameters, structConfigParameters.getBaudRate()), 3.0, connectTask8, connectTask8);
                        } else {
                            List<byte[]> list;
                            ConnectTask connectTask9 = this;
                            UMLog.i(connectTask9.TAG, "Try to connect for VP3300 AJ with " + this._config.getBaudRate() + " baud rate");
                            StructConfigParameters structConfigParameters = this._config;
                            ConnectTask connectTask10 = this;
                            object = connectTask9._readerCommunication.connect(Common.makeSetBaudAndLevelCommand(structConfigParameters, structConfigParameters.getBaudRate()), 1.5, connectTask10, connectTask10);
                            if (object != null && (list = ((IOManager.RPDResult)object).data) != null && list.size() > 0 && ((IOManager.RPDResult)object).data.get(0) != null && Common.getHexStringFromBytes(((IOManager.RPDResult)object).data.get(0)).equalsIgnoreCase("5669564F74656368320030000000480E")) {
                                UMLog.i(this.TAG, "connected");
                                return new Runnable(){

                                    public void run() {
                                        ConnectTask.this._readerCommunication.cxn_setConnected(null);
                                    }
                                };
                            }
                        }
                        if (((IOManager.RPDResult)object).isCanceledOrFailed()) {
                            return null;
                        }
                        if (!((IOManager.RPDResult)object).isParsed() || (pUSType = Common.PUSType.parse(((IOManager.RPDResult)object).data)) == Common.PUSType.INVALID) break block26;
                        break block24;
                    }
                    ConnectTask connectTask = this;
                    UMLog.i(connectTask.TAG, "tone");
                    connectTask._tonePlayer.setPlayingTone(ToneType.T_2400Hz);
                    connectTask._ioManager.setDeviceMediaVolumeToMax();
                    ConnectTask connectTask11 = this;
                    object = connectTask._readerCommunication.sendCommand(null, 2.0, connectTask11, connectTask11);
                    this._tonePlayer.setPlayingTone(null);
                    if (((IOManager.RPDResult)object).isCanceledOrFailed()) {
                        return null;
                    }
                    if (!((IOManager.RPDResult)object).isParsed() || (pUSType = Common.PUSType.parse(((IOManager.RPDResult)object).data)) == Common.PUSType.INVALID) break block26;
                }
                if (this.isCanceled()) {
                    return null;
                }
                if (pUSType != null && this.e.getReaderType() != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ && this.e.getReaderType() != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V) {
                    ConnectTask connectTask = this;
                    UMLog.i(connectTask.TAG, "connected " + pUSType.name);
                    if (connectTask._config.getVolumeLevelAdjust() > 1) {
                        this._ioManager.setDeviceMediaVolumeToMaxMinusArg(1);
                    }
                    return new Runnable(){

                        public void run() {
                            ReaderInfo.DEVICE_TYPE dEVICE_TYPE = pUSType.readerType;
                            if (dEVICE_TYPE != null) {
                                ConnectTask.this._readerCommunication.readerType_set(dEVICE_TYPE);
                            }
                            Common.coverAllBaudRate = false;
                            ConnectTask.this._readerCommunication.cxn_setConnected(ToneType.T_2000Hz);
                            Common.beginTimeEachCmd = Common.getCurrentTime();
                        }
                    };
                }
                UMLog.i(this.TAG, "timed out");
                return new Runnable(){

                    public void run() {
                        Common.beginTimeEachCmd = Common.getCurrentTime();
                        ConnectTask.this._umrMsg.timeout(23);
                    }
                };
            }
            if (this.safeWait(0.4)) {
                return null;
            }
            ++n2;
        }
    }
}

