/*
 * Decompiled with CFR 0.152.
 */
package com.idtechproducts.device.bluetooth;

import android.content.Context;
import com.idtechproducts.device.Common;
import com.idtechproducts.device.IDT_Device;
import com.idtechproducts.device.ReaderInfo;
import com.idtechproducts.device.ResDataStruct;
import com.idtechproducts.device.audiojack.UMLog;
import com.idtechproducts.device.audiojack.tools.FirmwareUpdateTool;
import com.idtechproducts.device.audiojack.tools.FirmwareUpdateToolMsg;
import com.idtechproducts.device.bluetooth.BluetoothController;
import com.idtechproducts.device.bluetooth.BluetoothControllerMsg;
import com.idtechproducts.device.bluetooth.IDTechBluetoothMsg;

public class IDTechBluetooth {
    private static final String SDK_VER_STRING = "ID TECH Bluetooth SDK Ver 1.0";
    private static final String TAG = "SDK::BT";
    private final IDTechBluetoothMsg _msg;
    private BluetoothController _bt = null;
    private Context _context;
    private volatile boolean _state_isConnected;
    private IDT_Device.TaskExport _taskExport;

    public IDTechBluetooth(IDTechBluetoothMsg callback, Context context, IDT_Device.TaskExport taskExport) {
        this._msg = callback;
        this._context = context;
        this._state_isConnected = false;
        this._taskExport = taskExport;
        switch (this._taskExport.getReaderType()) {
            default: 
        }
        this._bt = new BluetoothController(context, this._msg, new BluetoothControllerMsgImpl());
    }

    public BluetoothController getBluetoothController() {
        return this._bt;
    }

    public static String getSDKVersionInfo() {
        return SDK_VER_STRING;
    }

    public void registerListen() {
        if (!this._bt.isRegistered()) {
            this._bt.registerReceiver();
        }
        if (this._bt.initWithThread()) {
            this._state_isConnected = true;
            if (Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_BTPAY) {
                this._taskExport.setReaderType(ReaderInfo.DEVICE_TYPE.DEVICE_BTPAY);
            } else if (Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_BTMAG) {
                this._taskExport.setReaderType(ReaderInfo.DEVICE_TYPE.DEVICE_BTMAG);
            }
        }
    }

    public void unregisterListen() {
        if (this._bt.isRegistered()) {
            this._bt.unregisterReceiver();
        }
    }

    public boolean isReaderConnected() {
        return this._bt.isConnected();
    }

    public byte[] sendCommand(String cmd, int timeout) {
        if (!this._state_isConnected) {
            return null;
        }
        this._bt.disableSwipe();
        byte[] command = Common.makeCommand(cmd);
        UMLog.i("**sendCommand**", String.valueOf(Common.base16Encode(command)) + " timeout: " + timeout);
        return this._bt.sendCommand(command, timeout);
    }

    public byte[] sendCommandOnly(String cmd, int timeout) {
        if (!this._state_isConnected) {
            return null;
        }
        this._bt.disableSwipe();
        byte[] command = Common.makeCommand(cmd);
        UMLog.i("**sendCommand**", String.valueOf(Common.base16Encode(command)) + " timeout: " + timeout);
        return this._bt.sendCommandOnly(command, timeout);
    }

    private byte[] sendCommandFw(String cmd) {
        if (!this._state_isConnected) {
            return null;
        }
        byte[] command = Common.makeCommand(cmd);
        return this._bt.sendCommandFw(command);
    }

    public boolean startSwipeCard() {
        UMLog.i(TAG, "To enable Swipe...");
        if (!this._state_isConnected) {
            IDT_Device.isCommandRunning = false;
            return false;
        }
        return this._bt.enableSwipe();
    }

    public boolean startReadCard(int timeout, ResDataStruct respData) {
        UMLog.i(TAG, "To enable Swipe...");
        if (!this._state_isConnected) {
            return false;
        }
        return this._bt.enableRead(timeout, respData);
    }

    public boolean readMessage(int timeout, long startTime, ResDataStruct respData) {
        UMLog.i(TAG, "To read message...");
        if (!this._state_isConnected) {
            return false;
        }
        return this._bt.readMessage(timeout, startTime, respData);
    }

    public void stopSwipeCard() {
        UMLog.i(TAG, "To disable Swipe...");
        this._bt.disableSwipe();
    }

    public boolean setTimeoutOfSwipeCard(int timeoutValue) {
        this._bt.setTimeoutOfSwipeCard(timeoutValue);
        return true;
    }

    public boolean enterBootloader() {
        if (this._bt == null) {
            return false;
        }
        byte[] ret = this.sendCommand("78467A495246570000000000000000", 30);
        if (ret != null) {
            UMLog.w(TAG, "RET: " + Common.base16Encode(ret));
            return ret[3] == 6;
        }
        return false;
    }

    public boolean updateFirmware(FirmwareUpdateToolMsg _umtMsg, FirmwareUpdateTool.FMStruct fmFile) {
        if (this._bt == null) {
            return false;
        }
        FwUpdateThread fwThread = new FwUpdateThread(fmFile, _umtMsg);
        fwThread.start();
        return true;
    }

    private static String getSUM(String strData) {
        String strLRC = null;
        byte[] toCharArray = Common.getByteArray(strData);
        byte[] sum = new byte[]{toCharArray[0]};
        int i = 1;
        while (i < toCharArray.length) {
            sum[0] = (byte)(sum[0] + toCharArray[i]);
            ++i;
        }
        strLRC = Common.getHexStringFromBytes(sum);
        return strLRC;
    }

    public static String getLRC(String strData) {
        String strLRC = null;
        byte[] toCharArray = Common.getByteArray(strData);
        byte[] lrc = new byte[]{toCharArray[0]};
        int i = 1;
        while (i < toCharArray.length) {
            lrc[0] = (byte)(lrc[0] ^ toCharArray[i]);
            ++i;
        }
        strLRC = Common.getHexStringFromBytes(lrc);
        return strLRC;
    }

    private class BluetoothControllerMsgImpl
    implements BluetoothControllerMsg {
        private BluetoothControllerMsgImpl() {
        }

        public void onDeviceAttached() {
            if (IDTechBluetooth.this._bt.initWithThread()) {
                IDTechBluetooth.this._state_isConnected = true;
                if (IDTechBluetooth.this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_BTPAY) {
                    IDTechBluetooth.this._taskExport.setReaderType(ReaderInfo.DEVICE_TYPE.DEVICE_BTPAY);
                } else if (IDTechBluetooth.this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_BTMAG) {
                    IDTechBluetooth.this._taskExport.setReaderType(ReaderInfo.DEVICE_TYPE.DEVICE_BTMAG);
                }
            }
        }

        public void onDeviceDetached() {
            IDTechBluetooth.this._state_isConnected = false;
            IDTechBluetooth.this._msg.bt_onReceiveMsgDisconnected();
            if (IDTechBluetooth.this._bt != null) {
                IDTechBluetooth.this._bt.startCheckingConnection();
            }
        }

        public void onDeviceNotFound() {
            if (IDTechBluetooth.this._bt != null) {
                IDTechBluetooth.this._bt.startCheckingConnection();
            }
        }
    }

    private class FwUpdateThread
    extends Thread {
        FirmwareUpdateTool.FMStruct fmFile;
        FirmwareUpdateToolMsg _umtMsg;

        public FwUpdateThread(FirmwareUpdateTool.FMStruct fm, FirmwareUpdateToolMsg msg) {
            this.fmFile = fm;
            this._umtMsg = msg;
        }

        public void run() {
            this._umtMsg.onReceiveMsgUpdateFirmwareProgress(0);
            this._umtMsg.onReceiveMsgUpdateFirmwareProgress(1);
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            byte[] ret = IDTechBluetooth.this.sendCommandFw("420000" + Common.base16Encode(this.fmFile.getBlock(0)));
            if (ret == null) {
                UMLog.i(IDTechBluetooth.TAG, "notify failed firmware update (Block #0)");
                this._umtMsg.onReceiveMsgUpdateFirmwareResult(303);
                return;
            }
            if (ret[3] != 6) {
                UMLog.i(IDTechBluetooth.TAG, "notify failed firmware update (Block #0)");
                this._umtMsg.onReceiveMsgUpdateFirmwareResult(303);
                return;
            }
            UMLog.i(IDTechBluetooth.TAG, "Block #0 sent successfully.");
            int curBlock = 0;
            while (curBlock < this.fmFile.N) {
                int currentProgress = (curBlock + 2) * 100 / (this.fmFile.N + 3);
                this._umtMsg.onReceiveMsgUpdateFirmwareProgress(currentProgress);
                int blockNumber = curBlock + 1;
                byte[] command = new byte[1027];
                command[0] = 66;
                command[1] = (byte)blockNumber;
                command[2] = 0;
                System.arraycopy(this.fmFile.getBlock(blockNumber), 0, command, 3, 1024);
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                ret = IDTechBluetooth.this.sendCommandFw(Common.getHexStringFromBytes(command));
                if (ret == null) {
                    UMLog.i(IDTechBluetooth.TAG, "notify failed firmware update (Block #" + blockNumber + "-0)");
                    this._umtMsg.onReceiveMsgUpdateFirmwareResult(303);
                } else if (ret[3] != 6) {
                    UMLog.i(IDTechBluetooth.TAG, "notify failed firmware update (Block #" + blockNumber + "-0)");
                    this._umtMsg.onReceiveMsgUpdateFirmwareResult(303);
                } else {
                    UMLog.i(IDTechBluetooth.TAG, "Block #" + blockNumber + "-0 sent successfully.");
                }
                command = new byte[1027];
                command[0] = 66;
                command[1] = (byte)blockNumber;
                command[2] = 1;
                System.arraycopy(this.fmFile.getBlock(blockNumber), 1024, command, 3, 1024);
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                ret = IDTechBluetooth.this.sendCommandFw(Common.getHexStringFromBytes(command));
                if (ret == null) {
                    UMLog.i(IDTechBluetooth.TAG, "notify failed firmware update (Block #" + blockNumber + "-1)");
                    this._umtMsg.onReceiveMsgUpdateFirmwareResult(303);
                } else if (ret[3] != 6) {
                    UMLog.i(IDTechBluetooth.TAG, "notify failed firmware update (Block #" + blockNumber + "-1)");
                    this._umtMsg.onReceiveMsgUpdateFirmwareResult(303);
                } else {
                    UMLog.i(IDTechBluetooth.TAG, "Block #" + blockNumber + "-1 sent successfully.");
                }
                command = new byte[259];
                command[0] = 66;
                command[1] = (byte)blockNumber;
                command[2] = 2;
                System.arraycopy(this.fmFile.getBlock(blockNumber), 2048, command, 3, 256);
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                ret = IDTechBluetooth.this.sendCommandFw(Common.getHexStringFromBytes(command));
                if (ret == null) {
                    UMLog.i(IDTechBluetooth.TAG, "notify failed firmware update (Block #" + blockNumber + "-2)");
                    this._umtMsg.onReceiveMsgUpdateFirmwareResult(303);
                } else if (ret[3] != 6) {
                    UMLog.i(IDTechBluetooth.TAG, "notify failed firmware update (Block #" + blockNumber + "-2)");
                    this._umtMsg.onReceiveMsgUpdateFirmwareResult(303);
                } else {
                    UMLog.i(IDTechBluetooth.TAG, "Block #" + blockNumber + "-2 sent successfully.");
                }
                ++curBlock;
            }
            int currentProgress = (this.fmFile.N + 2) * 100 / (this.fmFile.N + 3);
            this._umtMsg.onReceiveMsgUpdateFirmwareProgress(currentProgress);
            byte[] checksumCommand = new byte[259];
            checksumCommand[0] = 66;
            checksumCommand[1] = -1;
            checksumCommand[2] = -1;
            System.arraycopy(this.fmFile.blockN, 0, checksumCommand, 3, 256);
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            ret = IDTechBluetooth.this.sendCommandFw(Common.base16Encode(checksumCommand));
            if (ret == null) {
                UMLog.i(IDTechBluetooth.TAG, "notify failed firmware update (checksum block)");
                this._umtMsg.onReceiveMsgUpdateFirmwareResult(304);
            } else if (ret[3] != 6) {
                UMLog.i(IDTechBluetooth.TAG, "notify failed firmware update ((checksum block))");
                this._umtMsg.onReceiveMsgUpdateFirmwareResult(304);
            } else {
                UMLog.i(IDTechBluetooth.TAG, "Checksum block sent successfully.");
                UMLog.i(IDTechBluetooth.TAG, "notify finished successfully");
                this._umtMsg.onReceiveMsgUpdateFirmwareResult(301);
            }
        }
    }
}

