/*
 * Decompiled with CFR 0.152.
 */
package com.idtechproducts.device.bluetooth;

import android.content.Context;
import android.os.Handler;
import com.idtechproducts.device.Common;
import com.idtechproducts.device.IDT_Device;
import com.idtechproducts.device.ReaderInfo;
import com.idtechproducts.device.ResDataStruct;
import com.idtechproducts.device.audiojack.UMLog;
import com.idtechproducts.device.audiojack.tools.FirmwareUpdateTool;
import com.idtechproducts.device.audiojack.tools.FirmwareUpdateToolMsg;
import com.idtechproducts.device.bluetooth.BluetoothControllerMsg;
import com.idtechproducts.device.bluetooth.BluetoothLEController;
import com.idtechproducts.device.bluetooth.IDTechBluetoothMsg;

public class IDTechBluetoothLE {
    private static final String SDK_VER_STRING = "ID TECH Bluetooth SDK Ver 1.0";
    private static final String TAG = "SDK::BTLE";
    private final IDTechBluetoothMsg _msg;
    private BluetoothLEController _btle = null;
    private Context _context;
    private volatile boolean _state_isConnected;
    private IDT_Device.TaskExport _taskExport;
    int cnt = 0;

    public IDTechBluetoothLE(IDTechBluetoothMsg callback, Context context, IDT_Device.TaskExport taskExport) {
        this._msg = callback;
        this._context = context;
        this._state_isConnected = false;
        this._taskExport = taskExport;
        switch (this._taskExport.getReaderType()) {
            default: 
        }
        this._btle = new BluetoothLEController(context, this._msg, new BluetoothControllerMsgImpl());
    }

    public static String getSDKVersionInfo() {
        return SDK_VER_STRING;
    }

    public void registerListen() {
        if (!this._btle.isRegistered()) {
            this._btle.registerReceiver();
        }
        if (this._btle.initWithThread()) {
            this._state_isConnected = true;
            if (Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT) {
                this._taskExport.setReaderType(ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT);
            } else if (Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT) {
                this._taskExport.setReaderType(ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT);
            } else if (Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT) {
                this._taskExport.setReaderType(ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT);
            }
            this._msg.bt_onReceiveMsgConnected();
        }
    }

    public void registerListen(Handler handler) {
        if (!this._btle.isRegistered()) {
            this._btle.registerReceiver(handler);
        }
        if (this._btle.initWithThread()) {
            this._state_isConnected = true;
            if (Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT) {
                this._taskExport.setReaderType(ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT);
            } else if (Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT) {
                this._taskExport.setReaderType(ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT);
            } else if (Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT) {
                this._taskExport.setReaderType(ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT);
            }
            this._msg.bt_onReceiveMsgConnected();
        }
    }

    public void unregisterListen() {
        if (this._btle.isRegistered()) {
            this._btle.unregisterReceiver();
        }
    }

    public boolean isReaderConnected() {
        return this._btle.isConnected();
    }

    public BluetoothLEController getBluetoothController() {
        return this._btle;
    }

    public byte[] sendCommand(String cmd, int timeout) {
        if (!this._state_isConnected) {
            return null;
        }
        this._btle.disableSwipe();
        byte[] command = Common.makeCommand(cmd);
        UMLog.i("**sendCommand**", String.valueOf(Common.base16Encode(command)) + " timeout: " + timeout + " cnt: " + this.cnt);
        ++this.cnt;
        byte[] response = null;
        int retry = IDT_Device.bleRetryCount;
        if (retry < 1) {
            retry = 1;
        }
        boolean doLoop = true;
        int counter = 0;
        while (doLoop) {
            doLoop = false;
            UMLog.i("sendCommand", "counter: " + ++counter);
            response = this._btle.sendCommand(command, timeout);
            if (response == null || response.length <= 11 || response[11] != 4 || counter >= retry) continue;
            doLoop = true;
        }
        return response;
    }

    public byte[] sendCommandOnly(String cmd, int timeout) {
        if (!this._state_isConnected) {
            return null;
        }
        this._btle.disableSwipe();
        byte[] command = Common.makeCommand(cmd);
        UMLog.i("**sendCommand**", String.valueOf(Common.base16Encode(command)) + " timeout: " + timeout);
        return this._btle.sendCommandOnly(command, timeout);
    }

    private byte[] sendCommandFw(String cmd) {
        if (!this._state_isConnected) {
            return null;
        }
        byte[] command = Common.makeCommand(cmd);
        return this._btle.sendCommandFw(command);
    }

    public boolean startSwipeCard() {
        UMLog.i(TAG, "To enable Swipe...");
        if (!this._state_isConnected) {
            IDT_Device.isCommandRunning = false;
            return false;
        }
        return this._btle.enableSwipe();
    }

    public boolean startListenCard() {
        UMLog.i(TAG, "To enable Listen...");
        if (!this._state_isConnected) {
            return false;
        }
        return this._btle.enableListen();
    }

    public boolean stopListenCard() {
        UMLog.i(TAG, "To disable Listen...");
        return this._btle.disableListen();
    }

    public void setConnected(boolean connected) {
        this._btle.setConnected(connected);
    }

    public boolean startReadCard(int timeout, ResDataStruct respData) {
        UMLog.i(TAG, "To enable Swipe...");
        if (!this._state_isConnected) {
            return false;
        }
        return this._btle.enableRead(timeout, respData);
    }

    public boolean readMessage(int timeout, long startTime, ResDataStruct respData, boolean ignoreLCDMsg) {
        UMLog.i(TAG, "To read message...");
        if (!this._state_isConnected) {
            return false;
        }
        boolean value = this._btle.readMessage(timeout, startTime, respData, ignoreLCDMsg);
        return value;
    }

    public byte[] sendCommandForRKI(String cmd, int timeout) {
        if (!this._state_isConnected) {
            return null;
        }
        this._btle.disableSwipe();
        byte[] command = IDTechBluetoothLE.makeCommandForRKI(cmd);
        UMLog.i("**sendCommandForRKI**", String.valueOf(Common.base16Encode(command)) + " timeout: " + timeout);
        return this._btle.sendCommand(command, timeout);
    }

    private static byte[] makeCommandForRKI(String commandBodyData) {
        if (commandBodyData == null) {
            return null;
        }
        String sum = IDTechBluetoothLE.getSUM(commandBodyData);
        String lrc = IDTechBluetoothLE.getLRC(commandBodyData);
        short length = (short)(commandBodyData.length() / 2);
        byte[] lowHigh = new byte[2];
        byte[] cmdLen = new byte[1];
        lowHigh[0] = (byte)(length & 0xFF);
        lowHigh[1] = (byte)(length >> 8 & 0xFF);
        cmdLen[0] = lowHigh[0];
        String lengthCommand = Common.getHexStringFromBytes(lowHigh);
        String commandData = "02" + lengthCommand + commandBodyData + lrc + sum + "03";
        return Common.getByteArray(commandData);
    }

    public void stopSwipeCard() {
        UMLog.i(TAG, "To disable Swipe...");
        this._btle.disableSwipe();
    }

    public boolean setTimeoutOfSwipeCard(int timeoutValue) {
        this._btle.setTimeoutOfSwipeCard(timeoutValue);
        return true;
    }

    public boolean enterBootloader() {
        if (this._btle == null) {
            return false;
        }
        byte[] ret = this.sendCommand("78467A495246570000000000000000", 30);
        if (ret != null) {
            UMLog.w(TAG, "RET: " + Common.base16Encode(ret));
            return ret[3] == 6;
        }
        return false;
    }

    public boolean updateFirmware(FirmwareUpdateToolMsg _umtMsg, FirmwareUpdateTool.FMStruct fmFile) {
        if (this._btle == null) {
            return false;
        }
        FwUpdateThread fwThread = new FwUpdateThread(fmFile, _umtMsg);
        fwThread.start();
        return true;
    }

    private static String getSUM(String strData) {
        String strLRC = null;
        byte[] toCharArray = Common.getByteArray(strData);
        byte[] sum = new byte[]{toCharArray[0]};
        int i = 1;
        while (i < toCharArray.length) {
            sum[0] = (byte)(sum[0] + toCharArray[i]);
            ++i;
        }
        strLRC = Common.getHexStringFromBytes(sum);
        return strLRC;
    }

    public static String getLRC(String strData) {
        String strLRC = null;
        byte[] toCharArray = Common.getByteArray(strData);
        byte[] lrc = new byte[]{toCharArray[0]};
        int i = 1;
        while (i < toCharArray.length) {
            lrc[0] = (byte)(lrc[0] ^ toCharArray[i]);
            ++i;
        }
        strLRC = Common.getHexStringFromBytes(lrc);
        return strLRC;
    }

    private class BluetoothControllerMsgImpl
    implements BluetoothControllerMsg {
        private BluetoothControllerMsgImpl() {
        }

        public void onDeviceAttached() {
            if (IDTechBluetoothLE.this._btle.initWithThread()) {
                IDTechBluetoothLE.this._state_isConnected = true;
                if (IDTechBluetoothLE.this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT) {
                    IDTechBluetoothLE.this._taskExport.setReaderType(ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT);
                } else if (IDTechBluetoothLE.this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT) {
                    IDTechBluetoothLE.this._taskExport.setReaderType(ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT);
                } else if (IDTechBluetoothLE.this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT) {
                    IDTechBluetoothLE.this._taskExport.setReaderType(ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT);
                }
            }
        }

        public void onDeviceDetached() {
            IDTechBluetoothLE.this._state_isConnected = false;
            IDTechBluetoothLE.this._msg.bt_onReceiveMsgDisconnected();
            if (IDTechBluetoothLE.this._btle != null) {
                IDTechBluetoothLE.this._btle.startCheckingConnection();
            }
        }

        public void onDeviceNotFound() {
            if (IDTechBluetoothLE.this._btle != null) {
                IDTechBluetoothLE.this._btle.startCheckingConnection();
            }
        }
    }

    private class FwUpdateThread
    extends Thread {
        FirmwareUpdateTool.FMStruct fmFile;
        FirmwareUpdateToolMsg _umtMsg;

        public FwUpdateThread(FirmwareUpdateTool.FMStruct fm, FirmwareUpdateToolMsg msg) {
            this.fmFile = fm;
            this._umtMsg = msg;
        }

        public void run() {
            this._umtMsg.onReceiveMsgUpdateFirmwareProgress(0);
            this._umtMsg.onReceiveMsgUpdateFirmwareProgress(1);
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            byte[] ret = IDTechBluetoothLE.this.sendCommandFw("420000" + Common.base16Encode(this.fmFile.getBlock(0)));
            if (ret == null) {
                UMLog.i(IDTechBluetoothLE.TAG, "notify failed firmware update (Block #0)");
                this._umtMsg.onReceiveMsgUpdateFirmwareResult(303);
                return;
            }
            if (ret[3] != 6) {
                UMLog.i(IDTechBluetoothLE.TAG, "notify failed firmware update (Block #0)");
                this._umtMsg.onReceiveMsgUpdateFirmwareResult(303);
                return;
            }
            UMLog.i(IDTechBluetoothLE.TAG, "Block #0 sent successfully.");
            int curBlock = 0;
            while (curBlock < this.fmFile.N) {
                int currentProgress = (curBlock + 2) * 100 / (this.fmFile.N + 3);
                this._umtMsg.onReceiveMsgUpdateFirmwareProgress(currentProgress);
                int blockNumber = curBlock + 1;
                byte[] command = new byte[1027];
                command[0] = 66;
                command[1] = (byte)blockNumber;
                command[2] = 0;
                System.arraycopy(this.fmFile.getBlock(blockNumber), 0, command, 3, 1024);
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                ret = IDTechBluetoothLE.this.sendCommandFw(Common.getHexStringFromBytes(command));
                if (ret == null) {
                    UMLog.i(IDTechBluetoothLE.TAG, "notify failed firmware update (Block #" + blockNumber + "-0)");
                    this._umtMsg.onReceiveMsgUpdateFirmwareResult(303);
                } else if (ret[3] != 6) {
                    UMLog.i(IDTechBluetoothLE.TAG, "notify failed firmware update (Block #" + blockNumber + "-0)");
                    this._umtMsg.onReceiveMsgUpdateFirmwareResult(303);
                } else {
                    UMLog.i(IDTechBluetoothLE.TAG, "Block #" + blockNumber + "-0 sent successfully.");
                }
                command = new byte[1027];
                command[0] = 66;
                command[1] = (byte)blockNumber;
                command[2] = 1;
                System.arraycopy(this.fmFile.getBlock(blockNumber), 1024, command, 3, 1024);
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                ret = IDTechBluetoothLE.this.sendCommandFw(Common.getHexStringFromBytes(command));
                if (ret == null) {
                    UMLog.i(IDTechBluetoothLE.TAG, "notify failed firmware update (Block #" + blockNumber + "-1)");
                    this._umtMsg.onReceiveMsgUpdateFirmwareResult(303);
                } else if (ret[3] != 6) {
                    UMLog.i(IDTechBluetoothLE.TAG, "notify failed firmware update (Block #" + blockNumber + "-1)");
                    this._umtMsg.onReceiveMsgUpdateFirmwareResult(303);
                } else {
                    UMLog.i(IDTechBluetoothLE.TAG, "Block #" + blockNumber + "-1 sent successfully.");
                }
                command = new byte[259];
                command[0] = 66;
                command[1] = (byte)blockNumber;
                command[2] = 2;
                System.arraycopy(this.fmFile.getBlock(blockNumber), 2048, command, 3, 256);
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                ret = IDTechBluetoothLE.this.sendCommandFw(Common.getHexStringFromBytes(command));
                if (ret == null) {
                    UMLog.i(IDTechBluetoothLE.TAG, "notify failed firmware update (Block #" + blockNumber + "-2)");
                    this._umtMsg.onReceiveMsgUpdateFirmwareResult(303);
                } else if (ret[3] != 6) {
                    UMLog.i(IDTechBluetoothLE.TAG, "notify failed firmware update (Block #" + blockNumber + "-2)");
                    this._umtMsg.onReceiveMsgUpdateFirmwareResult(303);
                } else {
                    UMLog.i(IDTechBluetoothLE.TAG, "Block #" + blockNumber + "-2 sent successfully.");
                }
                ++curBlock;
            }
            int currentProgress = (this.fmFile.N + 2) * 100 / (this.fmFile.N + 3);
            this._umtMsg.onReceiveMsgUpdateFirmwareProgress(currentProgress);
            byte[] checksumCommand = new byte[259];
            checksumCommand[0] = 66;
            checksumCommand[1] = -1;
            checksumCommand[2] = -1;
            System.arraycopy(this.fmFile.blockN, 0, checksumCommand, 3, 256);
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            ret = IDTechBluetoothLE.this.sendCommandFw(Common.base16Encode(checksumCommand));
            if (ret == null) {
                UMLog.i(IDTechBluetoothLE.TAG, "notify failed firmware update (checksum block)");
                this._umtMsg.onReceiveMsgUpdateFirmwareResult(304);
            } else if (ret[3] != 6) {
                UMLog.i(IDTechBluetoothLE.TAG, "notify failed firmware update ((checksum block))");
                this._umtMsg.onReceiveMsgUpdateFirmwareResult(304);
            } else {
                UMLog.i(IDTechBluetoothLE.TAG, "Checksum block sent successfully.");
                UMLog.i(IDTechBluetoothLE.TAG, "notify finished successfully");
                this._umtMsg.onReceiveMsgUpdateFirmwareResult(301);
            }
        }
    }
}

