/*
 * Decompiled with CFR 0.152.
 */
package com.zeamster.paymentsdk.resthandler;

import android.net.Uri;
import android.os.Handler;
import android.os.HandlerThread;
import com.zeamster.paymentsdk.resthandler.ICallback;
import com.zeamster.paymentsdk.resthandler.ResponseType;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class RestServiceClient {
    private static final int SUCCESS_GET_PUT = 200;
    private static final int SUCCESS_POST = 201;
    private static final String CHARSET = "charset";
    private static final int CONNECT_TIMEOUT = 60000;
    private static final int READ_TIMEOUT = 300000;
    private String protocol;
    private String hostname;
    private String apiEndpoint;
    private String apiEndpointExtension = "";
    private String urlString;
    private HttpsURLConnection httpsURLConnection;
    private HashMap<String, String> errors = new HashMap();
    private HashMap<String, String> queryParams = new HashMap();
    private HashMap<String, String> requestHeader = new HashMap();
    private HashMap<String, Object> requestBody = new HashMap();
    private ICallback callback;

    public RestServiceClient(String protocol, String hostname, String apiEndpoint, ICallback callback) throws Exception {
        if (!this.generateURL(protocol, hostname, apiEndpoint)) {
            throw new Exception(this.getErrorResponse());
        }
        this.callback = callback;
    }

    public String getApiEndpoint() {
        return this.apiEndpoint;
    }

    public void setCallback(ICallback callback) {
        this.callback = callback;
    }

    public void addError(String summary, String details) {
        this.errors.put(summary, details);
    }

    public void setQueryParams(HashMap<String, String> queryParams) {
        this.queryParams = queryParams;
    }

    public void setRequestHeader(HashMap<String, String> requestHeader) {
        this.requestHeader = requestHeader;
    }

    public void setRequestBody(HashMap<String, Object> requestBody) {
        this.requestBody = requestBody;
    }

    public HttpsURLConnection getHttpsURLConnection() {
        return this.httpsURLConnection;
    }

    public void setHttpsURLConnection(HttpsURLConnection httpsURLConnection) {
        this.httpsURLConnection = httpsURLConnection;
    }

    private boolean generateURL(String protocol, String hostname, String apiEndpoint) {
        boolean isURLInputsValid = true;
        try {
            if (protocol != null && !protocol.trim().isEmpty()) {
                this.protocol = protocol.trim();
            } else {
                isURLInputsValid = false;
                this.errors.put("protocol", "Protocol can not be empty.");
            }
            if (hostname != null && !hostname.trim().isEmpty()) {
                this.hostname = hostname.trim();
            } else {
                isURLInputsValid = false;
                this.errors.put("hostname", "Hostname can not be empty.");
            }
            if (apiEndpoint != null && !apiEndpoint.trim().isEmpty()) {
                this.apiEndpoint = apiEndpoint.trim().toLowerCase();
            } else {
                isURLInputsValid = false;
                this.errors.put("apiEndpoint", "API Endpoint can not be empty.");
            }
            if (isURLInputsValid) {
                Uri.Builder builder = new Uri.Builder();
                builder.scheme(protocol).authority(hostname).path(apiEndpoint);
                this.urlString = builder.build().toString();
                return true;
            }
        }
        catch (Exception ex) {
            this.addError(ex.getClass().getName(), ex.getMessage());
        }
        return false;
    }

    public void addApiEndpointExtension(String apiEndpointExtension) {
        if (apiEndpointExtension != null && !apiEndpointExtension.trim().isEmpty()) {
            this.apiEndpointExtension = this.apiEndpointExtension + (apiEndpointExtension.startsWith("/") ? apiEndpointExtension : "/" + apiEndpointExtension);
        }
    }

    private boolean appendQueryParams() {
        try {
            Uri.Builder builder = Uri.parse((String)this.urlString).buildUpon();
            for (Map.Entry<String, String> entry : this.queryParams.entrySet()) {
                builder.appendQueryParameter(entry.getKey(), entry.getValue());
            }
            Uri uri = builder.build();
            if (uri != null) {
                this.urlString = uri.toString();
                return true;
            }
        }
        catch (Exception ex) {
            this.addError(ex.getClass().getName(), ex.getMessage());
        }
        return false;
    }

    private boolean createConnection() {
        if (this.urlString != null && !this.urlString.trim().isEmpty()) {
            if (this.apiEndpointExtension != null && !this.apiEndpointExtension.trim().isEmpty()) {
                this.urlString = this.urlString + this.apiEndpointExtension;
            }
            if (this.queryParams != null && this.queryParams.size() != 0 && !this.appendQueryParams()) {
                return false;
            }
            try {
                URL url = new URL(this.urlString);
                this.httpsURLConnection = (HttpsURLConnection)url.openConnection();
                this.httpsURLConnection.setConnectTimeout(60000);
                this.httpsURLConnection.setReadTimeout(300000);
                this.httpsURLConnection.setUseCaches(false);
                return true;
            }
            catch (MalformedURLException ex) {
                this.addError(ex.getClass().getName(), ex.getMessage());
            }
            catch (IOException ex) {
                this.addError(ex.getClass().getName(), ex.getMessage());
            }
            catch (Exception ex) {
                this.addError(ex.getClass().getName(), ex.getMessage());
            }
        } else {
            this.addError("urlString", "Empty URL Connection String can not be used to create the connection.");
        }
        return false;
    }

    private boolean addRequestHeader() {
        try {
            this.httpsURLConnection.setRequestProperty("Content-Type", "application/json;charset=UTF-8");
            for (String key : this.requestHeader.keySet()) {
                this.httpsURLConnection.setRequestProperty(key, this.requestHeader.get(key));
            }
            return true;
        }
        catch (Exception ex) {
            this.addError(ex.getClass().getName(), ex.getMessage());
            return false;
        }
    }

    private boolean addRequestBody() {
        try {
            JSONObject jsonObject = new JSONObject(this.requestBody);
            this.httpsURLConnection.setDoOutput(true);
            OutputStream outputStream = this.httpsURLConnection.getOutputStream();
            DataOutputStream writer = new DataOutputStream(outputStream);
            writer.writeBytes(jsonObject.toString());
            writer.flush();
            writer.close();
            outputStream.close();
            return true;
        }
        catch (IOException ex) {
            this.addError(ex.getClass().getName(), ex.getMessage());
        }
        catch (Exception ex) {
            this.addError(ex.getClass().getName(), ex.getMessage());
        }
        return false;
    }

    private boolean sendRequestData() {
        boolean isHeaderSet = true;
        boolean isBodySet = true;
        boolean isBodyMapSet = true;
        if (this.httpsURLConnection != null) {
            if (this.requestHeader != null && this.requestHeader.size() != 0) {
                isHeaderSet = this.addRequestHeader();
            }
            if (this.requestBody != null && this.requestBody.size() != 0) {
                isBodySet = this.addRequestBody();
            }
        }
        return isHeaderSet && isBodySet && isBodyMapSet;
    }

    private String getContentType() {
        try {
            String httpsContentType = this.httpsURLConnection.getContentType();
            if (httpsContentType != null && !httpsContentType.trim().isEmpty()) {
                String[] typeParameters;
                for (String parameter : typeParameters = httpsContentType.split(";")) {
                    String[] keyValue = parameter.split("=");
                    if (!keyValue[0].trim().equals(CHARSET)) continue;
                    return keyValue[1].trim();
                }
            }
        }
        catch (Exception ex) {
            this.addError(ex.getClass().getName(), ex.getMessage());
        }
        return Charset.defaultCharset().name();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readResponse(ResponseType responseType) {
        StringBuilder responseStrBuilder = new StringBuilder();
        InputStream stream = null;
        BufferedInputStream bufferedInputStream = null;
        BufferedReader bufferedReader = null;
        try {
            String line;
            stream = responseType.equals((Object)ResponseType.ERROR) ? this.httpsURLConnection.getErrorStream() : this.httpsURLConnection.getInputStream();
            bufferedInputStream = new BufferedInputStream(stream);
            String contentType = this.getContentType();
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)bufferedInputStream, Charset.forName(contentType)));
            while ((line = bufferedReader.readLine()) != null) {
                responseStrBuilder.append(line);
            }
        }
        catch (IOException ex) {
            this.addError(ex.getClass().getName(), ex.getMessage());
        }
        catch (Exception ex) {
            this.addError(ex.getClass().getName(), ex.getMessage());
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
                if (bufferedInputStream != null) {
                    bufferedInputStream.close();
                }
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException ex) {
                this.addError(ex.getClass().getName(), ex.getMessage());
            }
            catch (Exception ex) {
                this.addError(ex.getClass().getName(), ex.getMessage());
            }
        }
        return responseStrBuilder.toString();
    }

    public String getErrorResponse() {
        JSONObject errorPayload = new JSONObject();
        try {
            JSONObject errorsJson = new JSONObject();
            for (Map.Entry<String, String> map : this.errors.entrySet()) {
                JSONArray errorArray = new JSONArray();
                if (map.getValue() != null) {
                    errorArray.put((Object)map.getValue());
                }
                if (map.getKey() == null) continue;
                errorsJson.put(map.getKey(), (Object)errorArray);
            }
            errorPayload.put("errors", (Object)errorsJson);
        }
        catch (JSONException ex) {
            this.addError(((Object)((Object)ex)).getClass().getName(), ex.getMessage());
        }
        catch (Exception ex) {
            this.addError(ex.getClass().getName(), ex.getMessage());
        }
        return errorPayload.toString();
    }

    private boolean isSuccess() {
        boolean isSuccess = false;
        try {
            int responseCode = this.httpsURLConnection.getResponseCode();
            if (responseCode == 200 || responseCode == 201) {
                isSuccess = true;
            } else {
                String responseMessage = this.httpsURLConnection.getResponseMessage();
                String errorDetails = this.readResponse(ResponseType.ERROR);
                this.addError(responseMessage, errorDetails);
            }
        }
        catch (IOException ex) {
            this.addError(ex.getClass().getName(), ex.getMessage());
        }
        catch (Exception ex) {
            this.addError(ex.getClass().getName(), ex.getMessage());
        }
        return isSuccess;
    }

    public void submit(final String requestMethod) {
        this.errors.clear();
        try {
            HandlerThread handlerThread = new HandlerThread("URLConnection");
            handlerThread.start();
            Handler handler = new Handler(handlerThread.getLooper());
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        if (!RestServiceClient.this.createConnection()) {
                            RestServiceClient.this.callback.onFailure(RestServiceClient.this.getErrorResponse());
                        }
                        RestServiceClient.this.httpsURLConnection.setRequestMethod(requestMethod);
                        if (!RestServiceClient.this.sendRequestData()) {
                            RestServiceClient.this.callback.onFailure(RestServiceClient.this.getErrorResponse());
                        }
                        RestServiceClient.this.httpsURLConnection.connect();
                        if (RestServiceClient.this.isSuccess()) {
                            RestServiceClient.this.callback.onSuccess(RestServiceClient.this.readResponse(ResponseType.SUCCESS));
                            return;
                        }
                    }
                    catch (ProtocolException ex) {
                        RestServiceClient.this.addError(ex.getClass().getName(), ex.getMessage());
                    }
                    catch (IOException ex) {
                        RestServiceClient.this.addError(ex.getClass().getName(), ex.getMessage());
                    }
                    catch (Exception ex) {
                        RestServiceClient.this.addError(ex.getClass().getName(), ex.getMessage());
                    }
                    finally {
                        RestServiceClient.this.httpsURLConnection.disconnect();
                    }
                    RestServiceClient.this.callback.onFailure(RestServiceClient.this.getErrorResponse());
                }
            };
            handler.post(runnable);
        }
        catch (Exception ex) {
            this.addError(ex.getClass().getName(), ex.getMessage());
            this.callback.onFailure(this.getErrorResponse());
        }
    }
}

