//
//  EMVTransactionViewController.swift
//  SampleApp
//
//  Created by Ajeet Singh on 14/10/19.
//  Copyright © 2019 None. All rights reserved.
//

import UIKit
import PaymentSDK

class EMVTransactionViewController: UIViewController, EMVUIDelegate {

    @IBOutlet weak var status: UILabel!
    @IBOutlet weak var lcdDisplay: UILabel!
    @IBOutlet weak var btnScan: UIButton!
    @IBOutlet weak var logsView: UITextView!
    @IBOutlet weak var btnChipTransaction: UIButton!
    @IBOutlet weak var btnSwipeTransaction: UIButton!
    @IBOutlet weak var btnCompleteTransaction: UIButton!
    
    var transactionHeaderDict : [String : String]!
    var transactionParamDict : [String : String]!
    var transactionAction :TransactionActionType!
    var emvTransaction: EMVTransaction!
    var connectedDevice: String = ""
    
    override func viewDidLoad() {
        super.viewDidLoad()
        initRestClient(initCall: false)
    }
    
    @IBAction func doScan(_ sender: Any) {
        emvTransaction.scanForDevices()
    }
    
    @IBAction func doChip(_ sender: Any) {
        initRestClient(initCall: false);

        emvTransaction.PerformEMVSale(jsonPayload: transactionParamDict)
    }
    
    @IBAction func cancelTreansaction(_ sender: Any) {
         emvTransaction.DisconnectDevice()    }
    
    @IBAction func doInitialSetup(_ sender: Any) {
        initRestClient(initCall: true);
        emvTransaction.initialDeviceSetup()
    }
    @IBAction func clearLogs(_ sender: Any) {
        DispatchQueue.main.async {
            self.logsView.text = ""
        }
    }
    
    func initRestClient(initCall: Bool) {
        guard let apiProtocol = transactionHeaderDict["API-Protocol"] else { return }
        guard let  apiHostName = transactionHeaderDict["API-Host-Name"] else { return }
        guard let apiEndpointPath = transactionHeaderDict["API-Endpoint-Path"] else {return}
        
        let restClientService = RestServiceClient(apiProtocol:apiProtocol as! String, apiHostName:apiHostName as! String, apiEndpointPath: initCall ? "/devices/idtechinitialize" : apiEndpointPath as! String)
        if(restClientService.setHTTPRequestHeaders(headerParams: transactionHeaderDict as NSDictionary)) {
            emvTransaction = EMVTransaction(restClient: restClientService)
            emvTransaction.delegate = self
            emvTransaction.setDeviceType(type: DeviceType.IDTECH_VP3300BT)
        }
    }
    
    func deviceMessage(message: String!) {
        DispatchQueue.main.async {
            self.lcdDisplay.text = message
        }
    }
    
    func deviceScanResponse(deviceID: String!, deviceName: String!) {
        self.connectedDevice = deviceName
        emvTransaction.connectDeviceByName(name: deviceName)
    }
    
    func deviceConnected() {
        DispatchQueue.main.async {
            self.status.text = self.connectedDevice + " Connected"
            self.status.backgroundColor = UIColor.green
        }
    }
    
    func deviceDisconnected() {
        DispatchQueue.main.async {
            self.status.text = "Disconnected"
            self.status.backgroundColor = UIColor.red
        }
    }
    
    func outputLogs(logs: String!) {
        DispatchQueue.main.async {
            self.logsView.text += "\n" + logs
        }
    }
    
    func transactionResponse(data: String!) {
        DispatchQueue.main.async {
            self.logsView.text += "\n Transaction Response: \n" + data
        }
    }
}
