//
//  MagtekWrapper.h
//  PaymentSDK
//
//  Created by Ajeet Singh on 11/10/21.
//  Copyright © 2021 Zeamster. All rights reserved.
//

#ifndef MagtekWrapper_h
#define MagtekWrapper_h

#import "MTSCRA.h"
#import "EMVTransactionDelegate.h"
#import "PluginDelegate.h"
#import "HexUtil.h"
#import "NSObject+TLVParser.h"

@interface MagtekWrapper : NSObject<MTSCRAEventDelegate> {
    // Delegate to respond back
    id <EMVTransactionDelegate> _delegate;
    id <PluginDelegate> _pluginDelegate;
 }

@property (nonatomic,strong) id delegate;
@property (nonatomic,strong) id pluginDelegate;
@property (nonatomic) Boolean isRefund;
@property (nonatomic) Boolean isNonTechnicalFallback;
@property (nonatomic) NSMutableDictionary *finalTransactionTags;
@property (nonatomic) NSString *deviceKSN;
@property (nonatomic) NSString* searchDeviceName;

- (instancetype)initWithValue: (NSString*) str;
- (void)startScanIDynamo;
- (void)startScanTDynamo;
- (void) connectFirstDevice;
- (void) connectDeviceByName:(NSString *)deviceName;
- (void)rescan;
- (Boolean) startEMVTransaction:(double) amount;
- (Boolean) cancelEMVTransaction;
- (Boolean) disconnectDevice;

@property (nonatomic, strong) MTSCRA* lib;
@property (nonatomic, strong) NSMutableArray* deviceList;
@end

#endif /* MagtekWrapper_h */
